/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.server.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import de.markusbordihn.easynpc.commands.Command;
import de.markusbordihn.easynpc.commands.arguments.EasyNPCArgument;
import de.markusbordihn.easynpc.commands.arguments.EntityTypeArgument;
import de.markusbordihn.easynpc.commands.suggestion.RenderTypeSuggestions;
import de.markusbordihn.easynpc.data.render.RenderType;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.handler.RenderHandler;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_2168;
import net.minecraft.class_2170;

public class RenderCommand
extends Command {
    private RenderCommand() {
    }

    public static ArgumentBuilder<class_2168, ?> register() {
        return ((LiteralArgumentBuilder)class_2170.method_9247((String)"render").requires(commandSource -> commandSource.method_9259(0))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"set").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"type").requires(commandSourceStack -> commandSourceStack.method_9259(0))).then(class_2170.method_9244((String)"npc_target", (ArgumentType)EasyNPCArgument.npc()).then(class_2170.method_9244((String)"type", (ArgumentType)StringArgumentType.string()).suggests(RenderTypeSuggestions::suggest).executes(context -> RenderCommand.setRenderType((class_2168)context.getSource(), EasyNPCArgument.getEntityWithAccess((CommandContext<class_2168>)context, "npc_target"), RenderType.get(StringArgumentType.getString((CommandContext)context, (String)"type")))))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"entity").requires(commandSourceStack -> commandSourceStack.method_9259(0))).then(class_2170.method_9244((String)"npc_target", (ArgumentType)EasyNPCArgument.npc()).then(class_2170.method_9244((String)"entity", (ArgumentType)EntityTypeArgument.entityType()).executes(context -> RenderCommand.setRenderEntityType((class_2168)context.getSource(), EasyNPCArgument.getEntityWithAccess((CommandContext<class_2168>)context, "npc_target"), EntityTypeArgument.getEntityType((CommandContext<class_2168>)context, "entity")))))));
    }

    private static int setRenderType(class_2168 context, EasyNPC<?> easyNPC, RenderType renderType) {
        if (easyNPC == null || renderType == null) {
            return 0;
        }
        if (!RenderHandler.setRenderType(easyNPC, renderType)) {
            return RenderCommand.sendFailureMessage(context, "Failed to set render type " + renderType + " for EasyNPC " + easyNPC);
        }
        return RenderCommand.sendSuccessMessage(context, "Set render type " + renderType + " for EasyNPC " + easyNPC);
    }

    private static int setRenderEntityType(class_2168 context, EasyNPC<?> easyNPC, class_1299<? extends class_1297> entityType) {
        if (easyNPC == null || entityType == null) {
            return 0;
        }
        if (!RenderHandler.setRenderEntity(easyNPC, entityType)) {
            return RenderCommand.sendFailureMessage(context, "Failed to set render entity " + entityType + " for EasyNPC " + easyNPC);
        }
        return RenderCommand.sendSuccessMessage(context, "Set render entity " + entityType + " for EasyNPC with UUID " + easyNPC.getUUID());
    }
}

