/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.server.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import de.markusbordihn.easynpc.commands.Command;
import de.markusbordihn.easynpc.commands.arguments.EasyNPCArgument;
import de.markusbordihn.easynpc.commands.suggestion.SoundTypeSuggestions;
import de.markusbordihn.easynpc.data.sound.SoundDataSet;
import de.markusbordihn.easynpc.data.sound.SoundType;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.SoundData;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2232;
import net.minecraft.class_2321;
import net.minecraft.class_2960;

public class SoundCommand
extends Command {
    private SoundCommand() {
    }

    public static ArgumentBuilder<class_2168, ?> register() {
        return ((LiteralArgumentBuilder)class_2170.method_9247((String)"sound").requires(cs -> cs.method_9259(0))).then(class_2170.method_9247((String)"set").then(class_2170.method_9244((String)"npc_target", (ArgumentType)EasyNPCArgument.npc()).then(class_2170.method_9244((String)"type", (ArgumentType)StringArgumentType.string()).suggests(SoundTypeSuggestions::suggest).then(class_2170.method_9244((String)"sound", (ArgumentType)class_2232.method_9441()).suggests(class_2321.field_10934).executes(context -> SoundCommand.setSoundType((class_2168)context.getSource(), EasyNPCArgument.getEntityWithAccess((CommandContext<class_2168>)context, "npc_target"), SoundType.get(StringArgumentType.getString((CommandContext)context, (String)"type")), class_2232.method_9443((CommandContext)context, (String)"sound")))))));
    }

    private static int setSoundType(class_2168 context, EasyNPC<?> easyNPC, SoundType soundType, class_2960 sound) {
        if (easyNPC == null || soundType == null || sound == null) {
            return 0;
        }
        SoundData<?> soundData = easyNPC.getEasyNPCSoundData();
        if (soundData == null) {
            return SoundCommand.sendFailureMessageNoSoundData(context, easyNPC);
        }
        SoundDataSet soundDataSet = soundData.getSoundDataSet();
        if (soundDataSet == null) {
            return SoundCommand.sendFailureMessageNoSoundDataSet(context, easyNPC);
        }
        soundDataSet.addSound(soundType, sound);
        soundData.refreshSoundDataSet();
        return SoundCommand.sendSuccessMessage(context, "Sound type " + soundType + " for EasyNPC " + easyNPC.getUUID() + " was set to " + sound + " !");
    }
}

