/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.server.commands.objectives;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import de.markusbordihn.easynpc.commands.Command;
import de.markusbordihn.easynpc.commands.arguments.EasyNPCArgument;
import de.markusbordihn.easynpc.data.objective.ObjectiveDataEntry;
import de.markusbordihn.easynpc.data.objective.ObjectiveGroup;
import de.markusbordihn.easynpc.data.objective.ObjectiveType;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.ObjectiveData;
import de.markusbordihn.easynpc.entity.easynpc.data.OwnerData;
import net.minecraft.class_1297;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_3222;

public class FollowObjective
extends Command {
    private static final String OBJECTIVE_NAME = "follow";

    private FollowObjective() {
    }

    public static ArgumentBuilder<class_2168, ?> registerSet() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)OBJECTIVE_NAME).then(class_2170.method_9247((String)ObjectiveType.FOLLOW_OWNER.getFriendlyName()).executes(context -> FollowObjective.setFollowOwner((class_2168)context.getSource(), EasyNPCArgument.getEntityWithAccess((CommandContext<class_2168>)context, "npc_target"))))).then(class_2170.method_9247((String)ObjectiveType.FOLLOW_PLAYER.getFriendlyName()).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(context -> FollowObjective.setFollowPlayer((class_2168)context.getSource(), EasyNPCArgument.getEntityWithAccess((CommandContext<class_2168>)context, "npc_target"), class_2186.method_9315((CommandContext)context, (String)"player")))))).then(class_2170.method_9247((String)ObjectiveType.FOLLOW_ENTITY_BY_UUID.getFriendlyName()).then(class_2170.method_9244((String)"entity", (ArgumentType)class_2186.method_9309()).executes(context -> FollowObjective.setFollowEntity((class_2168)context.getSource(), EasyNPCArgument.getEntityWithAccess((CommandContext<class_2168>)context, "npc_target"), class_2186.method_9313((CommandContext)context, (String)"entity")))));
    }

    public static ArgumentBuilder<class_2168, ?> registerList() {
        return class_2170.method_9247((String)OBJECTIVE_NAME).executes(context -> FollowObjective.list((class_2168)context.getSource(), EasyNPCArgument.getEntityWithAccess((CommandContext<class_2168>)context, "npc_target")));
    }

    public static ArgumentBuilder<class_2168, ?> registerRemove() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)OBJECTIVE_NAME).then(class_2170.method_9247((String)ObjectiveType.FOLLOW_OWNER.getFriendlyName()).executes(context -> FollowObjective.removeFollowObjective((class_2168)context.getSource(), EasyNPCArgument.getEntityWithAccess((CommandContext<class_2168>)context, "npc_target"), ObjectiveType.FOLLOW_OWNER)))).then(class_2170.method_9247((String)ObjectiveType.FOLLOW_PLAYER.getFriendlyName()).executes(context -> FollowObjective.removeFollowObjective((class_2168)context.getSource(), EasyNPCArgument.getEntityWithAccess((CommandContext<class_2168>)context, "npc_target"), ObjectiveType.FOLLOW_PLAYER)))).then(class_2170.method_9247((String)ObjectiveType.FOLLOW_ENTITY_BY_UUID.getFriendlyName()).executes(context -> FollowObjective.removeFollowObjective((class_2168)context.getSource(), EasyNPCArgument.getEntityWithAccess((CommandContext<class_2168>)context, "npc_target"), ObjectiveType.FOLLOW_ENTITY_BY_UUID)));
    }

    public static int removeFollowObjective(class_2168 context, EasyNPC<?> easyNPC, ObjectiveType objectiveType) {
        ObjectiveData<?> objectiveData = FollowObjective.getFollowObjectiveData(context, easyNPC);
        if (objectiveData == null || objectiveType == null) {
            return 0;
        }
        if (!objectiveData.removeCustomObjective(objectiveType)) {
            return FollowObjective.sendFailureMessage(context, "Error removing follow objective " + objectiveType + " for " + easyNPC);
        }
        return FollowObjective.sendSuccessMessage(context, "Removed follow objective " + objectiveType + " for " + easyNPC);
    }

    public static int list(class_2168 context, EasyNPC<?> easyNPC) {
        ObjectiveData<?> objectiveData = FollowObjective.getFollowObjectiveData(context, easyNPC);
        if (objectiveData == null) {
            return 0;
        }
        FollowObjective.sendSuccessMessage(context, "Follow objectives for " + easyNPC + ":");
        objectiveData.getObjectiveEntry(ObjectiveType.FOLLOW_OWNER).ifPresent(objective -> FollowObjective.sendSuccessMessage(context, "> " + objective.getType() + ": " + objective.getTargetOwnerUUID()));
        objectiveData.getObjectiveEntry(ObjectiveType.FOLLOW_PLAYER).ifPresent(objective -> FollowObjective.sendSuccessMessage(context, "> " + objective.getType() + ": " + objective.getTargetPlayerName()));
        objectiveData.getObjectiveEntry(ObjectiveType.FOLLOW_ENTITY_BY_UUID).ifPresent(objective -> FollowObjective.sendSuccessMessage(context, "> " + objective.getType() + ": " + objective.getTargetEntityUUID()));
        return 1;
    }

    public static int setFollowOwner(class_2168 context, EasyNPC<?> easyNPC) {
        ObjectiveData<?> objectiveData = FollowObjective.getObjectiveData(context, easyNPC);
        if (objectiveData == null) {
            return 0;
        }
        OwnerData<?> ownerData = easyNPC.getEasyNPCOwnerData();
        if (ownerData == null || !ownerData.hasOwner() || ownerData.method_6139() == null) {
            return FollowObjective.sendFailureMessageNoOwnerData(context, easyNPC);
        }
        ObjectiveDataEntry objectiveDataEntry = new ObjectiveDataEntry(ObjectiveType.FOLLOW_OWNER);
        objectiveDataEntry.setTargetOwnerUUID(ownerData.method_6139());
        if (!objectiveData.addOrUpdateCustomObjective(objectiveDataEntry)) {
            return FollowObjective.sendFailureMessage(context, "Error adding or updating follow owner objective!");
        }
        return FollowObjective.sendSuccessMessage(context, "Follow owner objective added for " + easyNPC);
    }

    public static int setFollowPlayer(class_2168 context, EasyNPC<?> easyNPC, class_3222 serverPlayer) {
        ObjectiveData<?> objectiveData = FollowObjective.getObjectiveData(context, easyNPC);
        if (objectiveData == null || serverPlayer == null) {
            return 0;
        }
        ObjectiveDataEntry objectiveDataEntry = new ObjectiveDataEntry(ObjectiveType.FOLLOW_PLAYER);
        objectiveDataEntry.setTargetPlayerName(serverPlayer.method_5477().getString());
        if (!objectiveData.addOrUpdateCustomObjective(objectiveDataEntry)) {
            return FollowObjective.sendFailureMessage(context, "Error adding or updating follow player objective!");
        }
        return FollowObjective.sendSuccessMessage(context, "Follow player " + serverPlayer.method_5477().getString() + " objective added for " + easyNPC);
    }

    public static int setFollowEntity(class_2168 context, EasyNPC<?> easyNPC, class_1297 entity) {
        ObjectiveData<?> objectiveData = FollowObjective.getObjectiveData(context, easyNPC);
        if (objectiveData == null || entity == null) {
            return 0;
        }
        if (entity.method_5667().equals(easyNPC.getUUID())) {
            return FollowObjective.sendFailureMessage(context, "Error adding follow entity objective for itself!");
        }
        ObjectiveDataEntry objectiveDataEntry = new ObjectiveDataEntry(ObjectiveType.FOLLOW_ENTITY_BY_UUID);
        objectiveDataEntry.setTargetEntityUUID(entity.method_5667());
        if (!objectiveData.addOrUpdateCustomObjective(objectiveDataEntry)) {
            return FollowObjective.sendFailureMessage(context, "Error adding or updating follow player objective!");
        }
        return FollowObjective.sendSuccessMessage(context, "Follow entity " + entity.method_5477().getString() + " objective added for " + easyNPC);
    }

    private static ObjectiveData<?> getObjectiveData(class_2168 context, EasyNPC<?> easyNPC) {
        ObjectiveData<?> objectiveData = easyNPC.getEasyNPCObjectiveData();
        if (objectiveData == null || !objectiveData.hasObjectives()) {
            FollowObjective.sendFailureMessageNoObjectiveData(context, easyNPC);
            return null;
        }
        return objectiveData;
    }

    private static ObjectiveData<?> getFollowObjectiveData(class_2168 context, EasyNPC<?> easyNPC) {
        ObjectiveData<?> objectiveData = FollowObjective.getObjectiveData(context, easyNPC);
        if (objectiveData == null) {
            return null;
        }
        if (!objectiveData.hasObjectives(ObjectiveGroup.FOLLOW)) {
            FollowObjective.sendFailureMessageNoObjectiveData(context, easyNPC, OBJECTIVE_NAME);
            return null;
        }
        return objectiveData;
    }
}

