/*
 * Decompiled with CFR 0.152.
 */
package fzzyhmstrs.emi_enchanting;

import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.Widget;
import dev.emi.emi.api.widget.WidgetHolder;
import fzzyhmstrs.emi_enchanting.EmiClientPlugin;
import fzzyhmstrs.emi_enchanting.EmiEnchanting;
import fzzyhmstrs.emi_enchanting.widget.PageWidget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class EnchantmentRecipe
implements EmiRecipe {
    private final class_1887 enchantment;
    private final List<EmiStack> bookStacks;
    private final List<EmiIngredient> inputs;
    private final List<PageWidget> pageWidgets;
    private int currentPage = 0;
    private final int maxPage;

    public EnchantmentRecipe(Collection<class_1799> books, class_1887 enchantment, Map<class_1887, Collection<class_1799>> enchantMap) {
        this.enchantment = enchantment;
        List<EmiStack> bookStacks = books.stream().map(EmiStack::of).toList();
        EmiIngredient books1 = EmiIngredient.of(bookStacks);
        this.bookStacks = bookStacks;
        List validItems = List.of(new ArrayList(), new ArrayList(), new ArrayList(), new ArrayList(), new ArrayList(), new ArrayList(), new ArrayList(), new ArrayList());
        int counter = 0;
        for (class_1792 item : class_7923.field_41178) {
            if (!enchantment.method_8192(new class_1799((class_1935)item))) continue;
            ((List)validItems.get(counter % 8)).add(EmiStack.of((class_1935)item));
            ++counter;
        }
        List<EmiIngredient> validItems1 = validItems.stream().map(EmiIngredient::of).toList();
        HashMap<class_1887, EmiIngredient> exclusions = new HashMap<class_1887, EmiIngredient>();
        for (Map.Entry<class_1887, Collection<class_1799>> entry : enchantMap.entrySet()) {
            if (entry.getKey().method_8188(enchantment) || entry.getKey() == enchantment) continue;
            List<EmiStack> stacks = entry.getValue().stream().map(EmiStack::of).toList();
            exclusions.put(entry.getKey(), EmiIngredient.of(stacks));
        }
        ArrayList<EmiIngredient> inputs = new ArrayList<EmiIngredient>();
        inputs.add(books1);
        inputs.addAll(validItems1);
        inputs.addAll(exclusions.values());
        this.inputs = inputs;
        class_5250 curse = class_2561.method_43469((String)"emi_enchanting.curse", (Object[])new Object[]{enchantment.method_8195() ? class_2561.method_43471((String)"emi_enchanting.yes_bad") : class_2561.method_43471((String)"emi_enchanting.no_bad")});
        class_5250 treasure = class_2561.method_43469((String)"emi_enchanting.treasure", (Object[])new Object[]{enchantment.method_8193() ? class_2561.method_43471((String)"emi_enchanting.yes_bad") : class_2561.method_43471((String)"emi_enchanting.no_bad")});
        class_5250 tradeable = class_2561.method_43469((String)"emi_enchanting.tradeable", (Object[])new Object[]{enchantment.method_25949() ? class_2561.method_43471((String)"emi_enchanting.yes_good") : class_2561.method_43471((String)"emi_enchanting.no_good")});
        class_5250 random = class_2561.method_43469((String)"emi_enchanting.random", (Object[])new Object[]{enchantment.method_25950() ? class_2561.method_43471((String)"emi_enchanting.yes_good") : class_2561.method_43471((String)"emi_enchanting.no_good")});
        class_5250 maxLvl = class_2561.method_43469((String)"emi_enchanting.maxLvl", (Object[])new Object[]{class_2561.method_43470((String)String.valueOf(enchantment.method_8183())).method_27692(class_124.field_1074)});
        String descLangKey = enchantment.method_8184() + ".desc";
        class_5250 descText = class_2561.method_43471((String)descLangKey);
        ArrayList<PageWidget> widgets = new ArrayList<PageWidget>();
        PageWidget firstPage = new PageWidget(0, 0, 144, 124);
        firstPage.addSlot(books1, 0, 0);
        firstPage.addText((class_2561)enchantment.method_8179(1).method_27662().method_27692(class_124.field_1074), 22, 2, 0, false);
        firstPage.addText((class_2561)curse, 0, 20, 0, false);
        firstPage.addText((class_2561)treasure, 0, 31, 0, false);
        firstPage.addText((class_2561)tradeable, 0, 42, 0, false);
        firstPage.addText((class_2561)random, 0, 53, 0, false);
        firstPage.addText((class_2561)maxLvl, 0, 64, 0, false);
        firstPage.addText((class_2561)class_2561.method_43471((String)"emi_enchanting.valid_items"), 0, 82, 0, false);
        for (int i = 0; i < 8; ++i) {
            if (((List)validItems.get(i)).isEmpty()) continue;
            firstPage.addSlot(validItems1.get(i), i * 18, 92);
        }
        if (!exclusions.isEmpty() || !Objects.equals(descText.getString(), descLangKey)) {
            firstPage.addButton(0, 112, 12, 12, 0, 0, () -> true, (mouseX, mouseY, button) -> this.previous());
            firstPage.addButton(132, 112, 12, 12, 12, 0, () -> true, (mouseX, mouseY, button) -> this.next());
        }
        firstPage.setActive(true);
        widgets.add(firstPage);
        if (!Objects.equals(descText.getString(), descLangKey)) {
            PageWidget descriptionPage = new PageWidget(0, 0, 144, 124);
            descriptionPage.addText((class_2561)class_2561.method_43471((String)"emi_enchanting.description"), 2, 2, 0, false);
            List descriptionLines = class_310.method_1551().field_1772.method_1728((class_5348)descText.method_27692(class_124.field_1056), 140);
            int y = 16;
            for (class_5481 text : descriptionLines) {
                descriptionPage.addText(text, 2, y, 0, false);
                y += 11;
            }
            descriptionPage.addButton(0, 112, 12, 12, 0, 0, () -> true, (mouseX, mouseY, button) -> this.previous());
            descriptionPage.addButton(132, 112, 12, 12, 12, 0, () -> true, (mouseX, mouseY, button) -> this.next());
            widgets.add(descriptionPage);
        }
        int exclusionsIndex = 0;
        List exclusionsList = exclusions.entrySet().stream().toList();
        while (exclusionsIndex < exclusions.size()) {
            PageWidget exclusionPage = new PageWidget(0, 0, 144, 124);
            exclusionPage.addText((class_2561)class_2561.method_43471((String)"emi_enchanting.exclusions"), 0, 0, 0, false);
            for (int i = 0; i < 5; ++i) {
                int y = 14 + 20 * i;
                exclusionPage.addSlot((EmiIngredient)((Map.Entry)exclusionsList.get(exclusionsIndex)).getValue(), 0, y);
                exclusionPage.addText((class_2561)((class_1887)((Map.Entry)exclusionsList.get(exclusionsIndex)).getKey()).method_8179(1).method_27662().method_27692(class_124.field_1074), 20, y, 0, false);
                if (++exclusionsIndex >= exclusionsList.size()) break;
            }
            exclusionPage.addButton(0, 112, 12, 12, 0, 0, () -> true, (mouseX, mouseY, button) -> this.previous());
            exclusionPage.addButton(132, 112, 12, 12, 12, 0, () -> true, (mouseX, mouseY, button) -> this.next());
            widgets.add(exclusionPage);
        }
        this.pageWidgets = widgets;
        this.maxPage = this.pageWidgets.size() - 1;
    }

    private void previous() {
        for (PageWidget widget : this.pageWidgets) {
            widget.setActive(false);
        }
        --this.currentPage;
        if (this.currentPage < 0) {
            this.currentPage = this.maxPage;
        }
        this.pageWidgets.get(this.currentPage).setActive(true);
    }

    private void next() {
        for (PageWidget widget : this.pageWidgets) {
            widget.setActive(false);
        }
        ++this.currentPage;
        if (this.currentPage > this.maxPage) {
            this.currentPage = 0;
        }
        this.pageWidgets.get(this.currentPage).setActive(true);
    }

    public EmiRecipeCategory getCategory() {
        return EmiClientPlugin.ENCHANTING_CATEGORY;
    }

    @Nullable
    public class_2960 getId() {
        class_2960 id = class_7923.field_41176.method_10221((Object)this.enchantment);
        if (id == null) {
            return null;
        }
        return new class_2960(EmiEnchanting.MOD_ID, "/" + id.method_42094() + "/enchanting_info");
    }

    public List<EmiIngredient> getInputs() {
        return this.inputs;
    }

    public List<EmiIngredient> getCatalysts() {
        return super.getCatalysts();
    }

    public List<EmiStack> getOutputs() {
        return this.bookStacks;
    }

    public int getDisplayWidth() {
        return 144;
    }

    public int getDisplayHeight() {
        return 124;
    }

    public void addWidgets(WidgetHolder widgets) {
        for (PageWidget widget : this.pageWidgets) {
            widgets.add((Widget)widget);
        }
    }

    public boolean supportsRecipeTree() {
        return false;
    }

    public boolean hideCraftable() {
        return super.hideCraftable();
    }
}

