/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_texture_features.config.screens.skin;

import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.class_1011;
import net.minecraft.class_1046;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_640;
import traben.entity_texture_features.ETF;
import traben.entity_texture_features.config.screens.skin.ETFScreenOldCompat;
import traben.entity_texture_features.features.ETFManager;
import traben.entity_texture_features.utils.ETFUtils2;

public class ETFConfigScreenSkinToolOutcome
extends ETFScreenOldCompat {
    private final boolean didSucceed;
    private final class_1011 skin;

    protected ETFConfigScreenSkinToolOutcome(class_437 parent, boolean success, class_1011 skin) {
        super("config.entity_texture_features.player_skin_editor.print_skin.result", parent, false);
        this.didSucceed = success;
        this.skin = skin;
    }

    public static boolean uploadSkin(boolean skinType) {
        try {
            if ("127.0.0.1".equals(InetAddress.getLocalHost().getHostAddress())) {
                return false;
            }
            String auth = class_310.method_1551().method_1548().method_1674();
            Path skinPath = Path.of(ETF.getConfigDirectory().toFile().getParent(), "ETF_player_skin_printout.png");
            String boundary = UUID.randomUUID().toString();
            byte[] fileBytes = Files.readAllBytes(skinPath);
            String bodyStart = "--" + boundary + "\r\nContent-Disposition: form-data; name=\"variant\"\r\n\r\n" + (skinType ? "classic" : "slim") + "\r\n--" + boundary + "\r\nContent-Disposition: form-data; name=\"file\"; filename=\"skin.png\"\r\nContent-Type: image/png\r\n\r\n";
            String bodyEnd = "\r\n--" + boundary + "--\r\n";
            byte[] requestBody = ETFConfigScreenSkinToolOutcome.concat(bodyStart.getBytes(), fileBytes, bodyEnd.getBytes());
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create("https://api.minecraftservices.com/minecraft/profile/skins")).header("Authorization", "Bearer " + auth).header("Content-Type", "multipart/form-data; boundary=" + boundary).POST(HttpRequest.BodyPublishers.ofByteArray(requestBody)).build();
            HttpClient client = HttpClient.newHttpClient();
            HttpResponse<Void> response = client.send(request, HttpResponse.BodyHandlers.discarding());
            return response.statusCode() == 200;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private static byte[] concat(byte[] ... parts) {
        int len = 0;
        for (byte[] p : parts) {
            len += p.length;
        }
        byte[] out = new byte[len];
        int pos = 0;
        for (byte[] p : parts) {
            System.arraycopy(p, 0, out, pos, p.length);
            pos += p.length;
        }
        return out;
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        this.method_37063((class_364)this.getETFButton((int)((double)this.field_22789 * 0.55), (int)((double)this.field_22790 * 0.9), (int)((double)this.field_22789 * 0.2), 20, class_5244.field_24334, button -> Objects.requireNonNull(this.field_22787).method_1507(this.parent)));
        if (this.didSucceed) {
            this.method_37063((class_364)this.getETFButton((int)((double)this.field_22789 * 0.15), (int)((double)this.field_22790 * 0.6), (int)((double)this.field_22789 * 0.7), 20, ETF.getTextFromTranslation("config.entity_texture_features.player_skin_editor.print_skin.open"), button -> {
                try {
                    assert (ETF.getConfigDirectory() != null);
                    Path outputDirectory = Path.of(ETF.getConfigDirectory().toFile().getParent(), new String[0]);
                    class_156.method_668().method_672(outputDirectory.toFile());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }));
            this.method_37063((class_364)this.getETFButton((int)((double)this.field_22789 * 0.15), (int)((double)this.field_22790 * 0.4), (int)((double)this.field_22789 * 0.7), 20, ETF.getTextFromTranslation("config.entity_texture_features.player_skin_editor.upload_skin"), button -> {
                boolean changeSuccess;
                String skinTypeData;
                class_640 playerListEntry;
                if (class_310.method_1551().field_1724 == null) {
                    return;
                }
                boolean skinType = true;
                if (class_310.method_1551().method_1562() != null && (playerListEntry = class_310.method_1551().method_1562().method_2871(class_310.method_1551().field_1724.method_5667())) != null && (skinTypeData = ((MinecraftProfileTexture)class_310.method_1551().method_1582().method_4654(playerListEntry.method_2966()).get(MinecraftProfileTexture.Type.SKIN)).getMetadata("model")) != null) {
                    skinType = !"slim".equals(skinTypeData);
                }
                button.method_25355(ETF.getTextFromTranslation("config.entity_texture_features.player_skin_editor.upload_skin_v2." + ((changeSuccess = ETFConfigScreenSkinToolOutcome.uploadSkin(skinType)) ? "success" : "fail")));
                if (changeSuccess) {
                    class_1046 skinfile = (class_1046)class_310.method_1551().method_1582().field_5304.method_34590(class_310.method_1551().field_1724.method_3117(), null);
                    try {
                        assert (skinfile.field_5210 != null);
                        this.skin.method_4325(skinfile.field_5210);
                    }
                    catch (IOException e) {
                        ETFUtils2.logError(ETF.getTextFromTranslation("config.entity_texture_features.player_skin_editor.upload_skin.success_local_fail").getString(), true);
                    }
                    if (class_310.method_1551().field_1724 != null) {
                        ETFManager.getInstance().PLAYER_TEXTURE_MAP.removeEntryOnly(class_310.method_1551().field_1724.method_5667());
                    }
                } else {
                    ETFUtils2.logError("Failed to change in-game skin correctly, you might need to restart to see all the uploaded changes in-game", true);
                }
                button.field_22763 = false;
            }));
        }
    }

    @Override
    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        String[] strings = ETF.getTextFromTranslation("config.entity_texture_features.player_skin_editor.print_skin.result." + (this.didSucceed ? "success" : "fail")).getString().split("\n");
        ArrayList<class_2561> lines = new ArrayList<class_2561>();
        for (String str : strings) {
            lines.add(class_2561.method_30163((String)str.strip()));
        }
        int i = 0;
        for (class_2561 txt : lines) {
            context.method_35719(this.field_22793, txt.method_30937(), (int)((double)this.field_22789 * 0.5), (int)((double)this.field_22790 * 0.3) + i, 0xFFFFFF);
            i += txt.getString().isBlank() ? 5 : 10;
        }
    }
}

