/*
 * Decompiled with CFR 0.152.
 */
package com.magistuarmory.client.render;

import com.magistuarmory.api.item.ModItemsProvider;
import com.magistuarmory.block.ModBlockEntityTypes;
import com.magistuarmory.client.render.fabric.ModRenderImpl;
import com.magistuarmory.client.render.model.ModModels;
import com.magistuarmory.client.render.model.item.MedievalShieldModel;
import com.magistuarmory.client.render.tileentity.HeraldryItemStackRenderer;
import com.magistuarmory.client.render.tileentity.PaviseBlockRenderer;
import com.magistuarmory.item.IHasModelProperty;
import com.magistuarmory.item.MedievalShieldItem;
import com.magistuarmory.item.armor.ArmorType;
import com.magistuarmory.item.armor.MedievalArmorItem;
import dev.architectury.injectables.annotations.ExpectPlatform;
import dev.architectury.registry.client.rendering.BlockEntityRendererRegistry;
import dev.architectury.registry.client.rendering.ColorHandlerRegistry;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1309;
import net.minecraft.class_1738;
import net.minecraft.class_1741;
import net.minecraft.class_1768;
import net.minecraft.class_1792;
import net.minecraft.class_1935;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import net.minecraft.class_3879;
import net.minecraft.class_5601;
import net.minecraft.class_5617;
import net.minecraft.class_572;

@Environment(value=EnvType.CLIENT)
public class ModRender {
    public static class_572<class_1309> INNER_ARMOR = null;
    public static class_572<class_1309> OUTER_ARMOR = null;
    public static Map<class_2960, class_572<class_1309>> ARMOR_MODELS_CACHE = new HashMap<class_2960, class_572<class_1309>>();
    public static Map<class_2960, class_3879> SHIELD_MODELS_CACHE = new HashMap<class_2960, class_3879>();

    public static void setup(ModItemsProvider content) {
        for (RegistrySupplier<? extends class_1792> registrySupplier : content.dyeableItems) {
            ColorHandlerRegistry.registerItemColors((stack, i) -> i > 0 ? -1 : ((class_1768)stack.method_7909()).method_7800(stack), (class_1935[])new class_1935[]{(class_1935)registrySupplier.get()});
        }
        for (RegistrySupplier registrySupplier : content.items) {
            Object object = registrySupplier.get();
            if (!(object instanceof IHasModelProperty)) continue;
            IHasModelProperty havingproperty = (IHasModelProperty)object;
            havingproperty.registerModelProperty();
        }
        ModRender.setupPlatform(content);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void setupPlatform(ModItemsProvider content) {
        ModRenderImpl.setupPlatform(content);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void registerModelsLoadListener(ModItemsProvider content) {
        ModRenderImpl.registerModelsLoadListener(content);
    }

    public static void registerRenderers() {
        BlockEntityRendererRegistry.register((class_2591)((class_2591)ModBlockEntityTypes.PAVISE.get()), PaviseBlockRenderer::new);
    }

    public static void loadModels(ModItemsProvider content, class_5617.class_5618 context) {
        OUTER_ARMOR = new class_572(context.method_32167(ModModels.DEFAULT_ARMOR_LOCATION));
        INNER_ARMOR = new class_572(context.method_32167(ModModels.DEFAULT_LEGGINGS_LOCATION));
        for (RegistrySupplier<? extends MedievalShieldItem> registrySupplier : content.shieldItems) {
            ModRender.loadShieldModel(context, (MedievalShieldItem)registrySupplier.get());
        }
        for (RegistrySupplier registrySupplier : content.armorItems) {
            ModRender.loadArmorModel(context, (MedievalArmorItem)registrySupplier.get());
        }
    }

    public static void loadShieldModel(class_5617.class_5618 context, MedievalShieldItem shield) {
        if (!shield.is3d()) {
            return;
        }
        class_2960 location = shield.getLocation();
        class_3879 model = SHIELD_MODELS_CACHE.computeIfAbsent(location, k -> new MedievalShieldModel(context.method_32167(ModModels.createLocation(location))));
        shield.getRenderer().setModel(model);
    }

    public static void loadArmorModel(class_5617.class_5618 context, MedievalArmorItem armor) {
        class_1741 class_17412 = armor.method_7686();
        if (class_17412 instanceof ArmorType) {
            ArmorType armortype = (ArmorType)class_17412;
            Optional<class_5601> location = armortype.getModelLocation();
            class_572 model = location.map(l -> ARMOR_MODELS_CACHE.computeIfAbsent(l.method_35743(), k -> new class_572(context.method_32167(l)))).orElseGet(() -> armor.method_48398() == class_1738.class_8051.field_41936 ? INNER_ARMOR : OUTER_ARMOR);
            armor.setModel((class_572<class_1309>)model);
        }
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static HeraldryItemStackRenderer createHeraldryItemStackRenderer(String id, class_2960 location) {
        void var1_1;
        return ModRenderImpl.createHeraldryItemStackRenderer(id, (class_2960)var1_1);
    }
}

