/*
 * Decompiled with CFR 0.152.
 */
package com.magistuarmory.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.magistuarmory.EpicKnights;
import com.magistuarmory.effects.LacerationEffect;
import com.magistuarmory.item.IHasModelProperty;
import com.magistuarmory.item.ModItemTier;
import com.magistuarmory.item.WeaponType;
import com.magistuarmory.network.PacketLongReachAttack;
import com.magistuarmory.util.CombatHelper;
import com.magistuarmory.util.ModDamageSources;
import dev.architectury.registry.item.ItemPropertiesRegistry;
import java.util.List;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1310;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1819;
import net.minecraft.class_1829;
import net.minecraft.class_1832;
import net.minecraft.class_1836;
import net.minecraft.class_1839;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5134;
import net.minecraft.class_5819;
import net.minecraft.class_8111;
import org.jetbrains.annotations.NotNull;

public class MedievalWeaponItem
extends class_1829
implements IHasModelProperty {
    private final Multimap<class_1320, class_1322> defaultModifiers;
    private final Multimap<class_1320, class_1322> decreasedModifiers;
    public final WeaponType type;
    protected final float attackDamage;
    protected final float attackSpeed;
    private final float decreasedAttackDamage;
    private final float decreasedAttackSpeed;
    private boolean isSilver = false;
    private float silverAttackDamage = 0.0f;
    private boolean blockingPriority = false;

    public MedievalWeaponItem(class_1792.class_1793 properties, ModItemTier material, WeaponType type) {
        super((class_1832)material, (int)CombatHelper.getBaseAttackDamage(material, type), CombatHelper.getBaseAttackSpeed(material, type), properties.method_7895(type.getDurability(material)));
        this.type = type;
        this.attackDamage = CombatHelper.getBaseAttackDamage(material, type);
        this.attackSpeed = CombatHelper.getBaseAttackSpeed(material, type);
        this.decreasedAttackDamage = CombatHelper.getDecreasedAttackDamage(this.attackDamage, type);
        this.decreasedAttackSpeed = CombatHelper.getDecreasedAttackSpeed(this.attackSpeed, type);
        if (material.equals(ModItemTier.SILVER)) {
            this.isSilver = true;
            this.silverAttackDamage = CombatHelper.getSilverAttackDamage(material, type);
        }
        this.defaultModifiers = this.getDefaultAttributeModifiersBuilder().build();
        this.decreasedModifiers = this.getDecreasedAttributeModifiersBuilder().build();
    }

    public ImmutableMultimap.Builder<class_1320, class_1322> getDefaultAttributeModifiersBuilder() {
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)class_5134.field_23721, (Object)new class_1322(field_8006, "Weapon modifier", (double)this.attackDamage, class_1322.class_1323.field_6328));
        builder.put((Object)class_5134.field_23723, (Object)new class_1322(field_8001, "Weapon modifier", (double)this.attackSpeed, class_1322.class_1323.field_6328));
        return builder;
    }

    public ImmutableMultimap.Builder<class_1320, class_1322> getDecreasedAttributeModifiersBuilder() {
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)class_5134.field_23721, (Object)new class_1322(field_8006, "Weapon modifier", (double)this.decreasedAttackDamage, class_1322.class_1323.field_6328));
        builder.put((Object)class_5134.field_23723, (Object)new class_1322(field_8001, "Weapon modifier", (double)this.decreasedAttackSpeed, class_1322.class_1323.field_6328));
        return builder;
    }

    public boolean onAttackClickEntity(class_1799 stack, class_1657 player, class_1297 entity) {
        if (!this.isLong()) {
            return true;
        }
        if (entity != player && entity != player.method_5854()) {
            PacketLongReachAttack.sendToServer(entity.method_5628());
        }
        player.method_7350();
        return false;
    }

    public Multimap<class_1320, class_1322> getAttributeModifiers(class_1799 stack, @NotNull class_1304 slot) {
        return this.getAttributeModifiers(this.hasTwoHandedPenalty(stack), slot);
    }

    public Multimap<class_1320, class_1322> getAttributeModifiers(boolean decreased, @NotNull class_1304 slot) {
        return slot == class_1304.field_6173 && decreased ? this.decreasedModifiers : this.method_7844(slot);
    }

    @NotNull
    public Multimap<class_1320, class_1322> method_7844(class_1304 slot) {
        return slot == class_1304.field_6173 ? this.defaultModifiers : super.method_7844(slot);
    }

    public void method_7888(class_1799 stack, class_1937 level, class_1297 entity, int i, boolean selected) {
        if (entity instanceof class_1309) {
            boolean flag;
            class_1309 livingentity = (class_1309)entity;
            boolean bl = flag = this.type.getTwoHanded() > 0 && !livingentity.method_6079().method_7909().equals(class_1802.field_8162);
            if (this.hasTwoHandedPenalty(stack) != flag) {
                this.setTwoHandedPenalty(stack, flag);
            }
            if (this.canBlock()) {
                this.blockingPriority = !(livingentity.method_6047().method_7909() instanceof class_1819) && !(livingentity.method_6079().method_7909() instanceof class_1819);
            }
        }
        super.method_7888(stack, level, entity, i, selected);
    }

    public boolean onHurtEntity(class_1282 source, class_1309 victim, float damage) {
        float attackscale;
        class_1297 class_12972;
        if (victim.method_37908().method_8608() || ModDamageSources.isAdditional(source) || !((class_12972 = source.method_5529()) instanceof class_1309)) {
            return true;
        }
        class_1309 attacker = (class_1309)class_12972;
        class_1297 class_12973 = source.method_5529();
        if (class_12973 instanceof class_1309) {
            class_1309 livingentity = (class_1309)class_12973;
            v0 = damage / this.getAttackDamage(livingentity.method_6047());
        } else {
            v0 = attackscale = 1.0f;
        }
        if (this.type.isHalberd() && victim.method_5765() && (float)victim.method_37908().method_8409().method_43048(20) * attackscale >= 14.0f) {
            victim.method_5848();
        }
        boolean flag = false;
        if (this.isSilver()) {
            flag = this.dealSilverDamage(source, attacker, victim, damage, attackscale);
        }
        if (!flag && this.type.getArmorPiercing() != 0 && victim.method_6096() > 0) {
            flag = this.dealArmorPiercingDamage(source, attacker, victim, damage);
        }
        if (this.type.isFlamebladed()) {
            LacerationEffect.apply(source, victim, damage * attackscale);
        }
        return flag;
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 level, List<class_2561> tooltip, class_1836 flag) {
        if (this.isSilver) {
            tooltip.add((class_2561)class_2561.method_43469((String)"silvertools.hurt", (Object[])new Object[]{Float.valueOf(this.silverAttackDamage)}).method_27692(class_124.field_1060));
        }
        if (this.type.isFlamebladed()) {
            tooltip.add((class_2561)class_2561.method_43471((String)"flamebladed.hurt").method_27692(class_124.field_1078));
        }
        if (this.type.isHalberd()) {
            tooltip.add((class_2561)class_2561.method_43471((String)"halberd.hurt").method_27692(class_124.field_1078));
        }
        if (this.type.getArmorPiercing() != 0) {
            tooltip.add((class_2561)class_2561.method_43469((String)"armorpiercing", (Object[])new Object[]{this.type.getArmorPiercing()}).method_27692(class_124.field_1078));
        }
        if (this.isLong()) {
            tooltip.add((class_2561)class_2561.method_43469((String)"bonusattackreach", (Object[])new Object[]{Float.valueOf(this.type.getBonusAttackReach())}).method_27692(class_124.field_1078));
        }
        if (this.type.getTwoHanded() == 1) {
            tooltip.add((class_2561)class_2561.method_43471((String)"twohandedi").method_27692(class_124.field_1078));
        } else if (this.type.getTwoHanded() > 1) {
            tooltip.add((class_2561)class_2561.method_43471((String)"twohandedii").method_27692(class_124.field_1078));
        }
        if (this.canBlock()) {
            tooltip.add((class_2561)class_2561.method_43469((String)"maxdamageblock", (Object[])new Object[]{Float.valueOf(this.getMaxBlockDamage())}).method_27692(class_124.field_1078));
        }
        tooltip.add((class_2561)class_2561.method_43469((String)"kgweight", (Object[])new Object[]{Float.valueOf(this.getWeight())}).method_27692(class_124.field_1078));
        if (this.hasTwoHandedPenalty(stack)) {
            tooltip.add((class_2561)class_2561.method_43471((String)"twohandedpenalty_1").method_27692(class_124.field_1061));
            tooltip.add((class_2561)class_2561.method_43471((String)"twohandedpenalty_2").method_27692(class_124.field_1061));
        }
        super.method_7851(stack, level, tooltip, flag);
    }

    public void setTwoHandedPenalty(class_1799 stack, boolean b) {
        class_2487 nbt = stack.method_7948();
        nbt.method_10569("twoHandedPenalty", b ? this.type.getTwoHanded() : 0);
        stack.method_7980(nbt);
    }

    public boolean hasTwoHandedPenalty(class_1799 stack) {
        class_2487 nbt;
        if (stack.method_7985() && (nbt = stack.method_7969()).method_10545("twoHandedPenalty")) {
            return nbt.method_10550("twoHandedPenalty") > 0;
        }
        return false;
    }

    public float getAttackDamage(class_1799 stack) {
        return this.hasTwoHandedPenalty(stack) ? this.attackDamage : this.decreasedAttackDamage;
    }

    public float getAttackSpeed(class_1799 stack) {
        return this.hasTwoHandedPenalty(stack) ? this.attackSpeed : this.decreasedAttackSpeed;
    }

    public float method_8020() {
        return this.attackDamage;
    }

    public float getAttackReach(float baseReach) {
        return baseReach + this.getBonusAttackReach();
    }

    public float getBonusAttackReach() {
        return EpicKnights.BC_or_EF_installed ? 0.0f : this.type.getBonusAttackReach();
    }

    public boolean isLong() {
        return (double)this.getBonusAttackReach() > 0.0;
    }

    @Deprecated(forRemoval=true)
    public float getSilverDamage(class_1799 stack, float damage) {
        return this.silverAttackDamage * damage / this.getAttackDamage(stack);
    }

    public float getMaxBlockDamage() {
        return this.type.getMaxBlockDamage();
    }

    public float getWeight() {
        return this.type.getWeight();
    }

    public boolean isSilver() {
        return this.isSilver;
    }

    public boolean canBlock(class_1657 player) {
        return player.method_7261(0.0f) == 1.0f && this.canBlock();
    }

    public boolean canBlock() {
        return this.type.canBlock();
    }

    boolean haveBlocked(class_5819 rand, class_1282 source) {
        return !source.method_48790() && (float)rand.method_43048(18) > this.getWeight();
    }

    public class_1271<class_1799> method_7836(class_1937 level, class_1657 player, class_1268 hand) {
        if (this.canBlock(player) && this.blockingPriority) {
            class_1799 stack = player.method_5998(hand);
            player.method_6019(hand);
            return class_1271.method_22428((Object)stack);
        }
        return super.method_7836(level, player, hand);
    }

    public int method_7881(class_1799 stack) {
        return this.canBlock() ? (int)(500.0f / this.getWeight()) : 0;
    }

    public class_1839 method_7853(class_1799 stack) {
        return this.canBlock() && this.blockingPriority ? class_1839.field_8949 : super.method_7853(stack);
    }

    public void onBlocked(class_1799 stack, float damage, class_1309 victim, class_1282 source) {
        if (!this.canBlock() || ModDamageSources.isAdditional(source)) {
            return;
        }
        class_1297 attacker = source.method_5529();
        float f = CombatHelper.getArmorPiercingFactor(attacker);
        if (source.method_49708(class_8111.field_42332) || source.method_49708(class_8111.field_42331)) {
            victim.method_5643(ModDamageSources.additional(), damage);
        } else if (!this.haveBlocked(victim.method_37908().method_8409(), source)) {
            victim.method_5643(ModDamageSources.additional(), damage);
        } else if (damage > this.getMaxBlockDamage()) {
            f *= 1.5f;
            float damage1 = damage - this.getMaxBlockDamage();
            victim.method_5643(ModDamageSources.additional(), damage1);
        }
        stack.method_7956((int)(f * damage), victim, entity -> entity.method_20235(class_1304.field_6173));
    }

    public boolean dealSilverDamage(class_1282 source, class_1309 attacker, class_1309 victim, float damage, float attackscale) {
        if (victim.method_6046().equals(class_1310.field_6289)) {
            victim.method_5643(ModDamageSources.silverAttack((class_1297)attacker), CombatHelper.getDamageAfterAbsorb(source, victim, this.silverAttackDamage) * attackscale + damage);
            return true;
        }
        return false;
    }

    public boolean dealArmorPiercingDamage(class_1282 source, class_1309 attacker, class_1309 victim, float damage) {
        float afterabsorb = CombatHelper.getDamageAfterAbsorb(source, victim, damage);
        afterabsorb = Math.max(afterabsorb - victim.method_6067(), 0.0f);
        float pierced = Math.max((float)this.type.getArmorPiercing() / 100.0f * (damage - afterabsorb), 0.0f);
        victim.method_5643(ModDamageSources.armorPiercing((class_1297)attacker), damage + pierced);
        return true;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void registerModelProperty() {
        if (this.canBlock()) {
            ItemPropertiesRegistry.register((class_1935)this, (class_2960)new class_2960("blocking"), (stack, level, entity, i) -> entity != null && entity.method_6115() && entity.method_6030() == stack ? 1.0f : 0.0f);
        }
    }
}

