/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.placebo.json;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.placebo.codec.PlaceboCodecs;
import dev.shadowsoffire.placebo.util.StepFunction;
import java.lang.reflect.Type;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_2960;
import net.minecraft.class_5819;
import net.minecraft.class_7923;

public record ChancedEffectInstance(float chance, class_1291 effect, StepFunction amplifier, boolean ambient, boolean visible) {
    public static Codec<ChancedEffectInstance> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)PlaceboCodecs.nullableField(Codec.floatRange((float)0.0f, (float)1.0f), "chance", Float.valueOf(1.0f)).forGetter(ChancedEffectInstance::chance), (App)class_7923.field_41174.method_39673().fieldOf("effect").forGetter(ChancedEffectInstance::effect), (App)PlaceboCodecs.nullableField(StepFunction.CODEC, "amplifier", StepFunction.constant(0.0f)).forGetter(ChancedEffectInstance::amplifier), (App)PlaceboCodecs.nullableField(Codec.BOOL, "ambient", true).forGetter(ChancedEffectInstance::ambient), (App)PlaceboCodecs.nullableField(Codec.BOOL, "visible", false).forGetter(ChancedEffectInstance::visible)).apply((Applicative)inst, ChancedEffectInstance::new));
    public static Codec<ChancedEffectInstance> CONSTANT_CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.unit((Object)Float.valueOf(1.0f)).optionalFieldOf("chance", (Object)Float.valueOf(1.0f)).forGetter(a -> Float.valueOf(1.0f)), (App)class_7923.field_41174.method_39673().fieldOf("effect").forGetter(ChancedEffectInstance::effect), (App)PlaceboCodecs.nullableField(Codec.intRange((int)0, (int)255), "amplifier", 0).xmap(i -> StepFunction.constant(i.intValue()), sf -> (int)sf.min()).forGetter(ChancedEffectInstance::amplifier), (App)PlaceboCodecs.nullableField(Codec.BOOL, "ambient", true).forGetter(ChancedEffectInstance::ambient), (App)PlaceboCodecs.nullableField(Codec.BOOL, "visible", false).forGetter(ChancedEffectInstance::visible)).apply((Applicative)inst, ChancedEffectInstance::new));

    public class_1293 create(class_5819 rand, int duration) {
        return new class_1293(this.effect, duration, this.amplifier.getInt(rand.method_43057()), this.ambient, this.visible);
    }

    public class_1293 createDeterministic(int duration) {
        return new class_1293(this.effect, duration, this.amplifier.getInt(0.0f), this.ambient, this.visible);
    }

    @Deprecated(forRemoval=true)
    public static class Deserializer
    implements JsonDeserializer<ChancedEffectInstance> {
        public ChancedEffectInstance deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            boolean visible;
            JsonObject obj = json.getAsJsonObject();
            float chance = obj.get("chance").getAsFloat();
            String _effect = obj.get("effect").getAsString();
            class_1291 effect = (class_1291)class_7923.field_41174.method_10223(new class_2960(_effect));
            if (effect == null) {
                throw new JsonParseException("Attempted to construct a ChancedEffectInstance with invalid effect: " + _effect);
            }
            boolean ambient = obj.has("ambient") ? obj.get("ambient").getAsBoolean() : true;
            boolean bl = visible = obj.has("visible") ? obj.get("visible").getAsBoolean() : false;
            if (obj.has("amplifier")) {
                int max;
                JsonObject range = obj.get("amplifier").getAsJsonObject();
                int min = range.get("min").getAsInt();
                StepFunction func = min == (max = range.get("max").getAsInt()) ? StepFunction.constant(min) : new StepFunction(min, max - min, 1.0f);
                return new ChancedEffectInstance(chance, effect, func, ambient, visible);
            }
            return new ChancedEffectInstance(chance, effect, StepFunction.constant(0.0f), ambient, visible);
        }
    }
}

