/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.placebo.json;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.placebo.Placebo;
import dev.shadowsoffire.placebo.codec.PlaceboCodecs;
import dev.shadowsoffire.placebo.util.StepFunction;
import java.lang.reflect.Type;
import java.util.UUID;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_5819;
import net.minecraft.class_7923;

public record RandomAttributeModifier(class_1320 attribute, class_1322.class_1323 op, StepFunction value, UUID id) {
    public static Codec<RandomAttributeModifier> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)class_7923.field_41190.method_39673().fieldOf("attribute").forGetter(a -> a.attribute), (App)PlaceboCodecs.enumCodec(class_1322.class_1323.class).fieldOf("operation").forGetter(a -> a.op), (App)StepFunction.CODEC.fieldOf("value").forGetter(a -> a.value)).apply((Applicative)inst, RandomAttributeModifier::new));
    public static Codec<RandomAttributeModifier> CONSTANT_CODEC = RecordCodecBuilder.create(inst -> inst.group((App)class_7923.field_41190.method_39673().fieldOf("attribute").forGetter(a -> a.attribute), (App)PlaceboCodecs.enumCodec(class_1322.class_1323.class).fieldOf("operation").forGetter(a -> a.op), (App)StepFunction.CONSTANT_CODEC.fieldOf("value").forGetter(a -> a.value)).apply((Applicative)inst, RandomAttributeModifier::new));

    public RandomAttributeModifier(class_1320 attribute, class_1322.class_1323 op, StepFunction value) {
        this(attribute, op, value, UUID.randomUUID());
    }

    public void apply(class_5819 rand, class_1309 entity) {
        if (entity == null) {
            throw new RuntimeException("Attempted to apply a random attribute modifier to a null entity!");
        }
        class_1322 modif = this.create(rand);
        class_1324 inst = entity.method_5996(this.attribute);
        if (inst == null) {
            Placebo.LOGGER.trace(String.format("Attempted to apply a random attribute modifier to an entity (%s) that does not have that attribute (%s)!", class_1299.method_5890((class_1299)entity.method_5864()), class_7923.field_41190.method_10221((Object)this.attribute)));
            return;
        }
        if (inst.method_6199(modif.method_6189()) == null) {
            inst.method_26837(modif);
        } else {
            Placebo.LOGGER.warn(String.format("Duplicate attribute modifier detected! Entity: %s, Attribute: %s, Modifier: %s", class_1299.method_5890((class_1299)entity.method_5864()), class_7923.field_41190.method_10221((Object)this.attribute), modif.method_6189()));
        }
    }

    public class_1322 create(class_5819 rand) {
        return new class_1322(this.id, "placebo_random_modifier_" + this.attribute.method_26830(), (double)this.value.get(rand.method_43057()), this.op);
    }

    public class_1322 create(String name, class_5819 rand) {
        return new class_1322(name, (double)this.value.get(rand.method_43057()), this.op);
    }

    public class_1322 createDeterministic() {
        return new class_1322(this.id, "placebo_random_modifier_" + this.attribute.method_26830(), (double)this.value.min(), this.op);
    }

    public class_1322 createDeterministic(String name) {
        return new class_1322(this.id, name, (double)this.value.min(), this.op);
    }

    public class_1320 getAttribute() {
        return this.attribute;
    }

    public class_1322.class_1323 getOp() {
        return this.op;
    }

    public StepFunction getValue() {
        return this.value;
    }

    public static class Deserializer
    implements JsonDeserializer<RandomAttributeModifier>,
    JsonSerializer<RandomAttributeModifier> {
        public RandomAttributeModifier deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext ctx) throws JsonParseException {
            StepFunction value;
            JsonObject obj = json.getAsJsonObject();
            String _attribute = obj.get("attribute").getAsString();
            class_1322.class_1323 op = (class_1322.class_1323)ctx.deserialize(obj.get("operation"), class_1322.class_1323.class);
            if (obj.get("value").isJsonObject()) {
                JsonObject valueObj = class_3518.method_15296((JsonObject)obj, (String)"value");
                value = (StepFunction)ctx.deserialize((JsonElement)valueObj, StepFunction.class);
            } else {
                float v = class_3518.method_15259((JsonObject)obj, (String)"value");
                value = new StepFunction(v, 1, 0.0f);
            }
            class_1320 attribute = (class_1320)class_7923.field_41190.method_10223(new class_2960(_attribute));
            if (attribute == null || value == null || op == null) {
                throw new JsonParseException("Attempted to deserialize invalid RandomAttributeModifier: " + json.toString());
            }
            return new RandomAttributeModifier(attribute, op, value);
        }

        public JsonElement serialize(RandomAttributeModifier src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject obj = new JsonObject();
            obj.addProperty("attribute", class_7923.field_41190.method_10221((Object)src.attribute).toString());
            obj.addProperty("operation", src.op.name());
            StepFunction range = src.value;
            if (range.min() == range.max()) {
                obj.addProperty("value", (Number)Float.valueOf(range.min()));
            } else {
                obj.add("value", context.serialize((Object)src.value));
            }
            return obj;
        }
    }
}

