/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.element.elements.animationcontroller;

import de.keksuccino.fancymenu.customization.element.AbstractElement;
import de.keksuccino.fancymenu.customization.element.anchor.ElementAnchorPoint;
import de.keksuccino.fancymenu.customization.element.elements.animationcontroller.AnimationControllerElement;
import de.keksuccino.fancymenu.customization.element.elements.animationcontroller.AnimationKeyframe;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnimationControllerHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Map<String, AnimationState> RUNNING_ANIMATIONS = new HashMap<String, AnimationState>();
    private static final List<String> ANIMATED_MEMORY = new ArrayList<String>();
    private static final List<String> FINISHED_ANIMATIONS = new ArrayList<String>();

    public static boolean applyAnimation(@NotNull AnimationControllerElement controller, @Nullable AbstractElement targetElement) {
        AnimationState state;
        if (targetElement == null || !controller.shouldRender()) {
            return false;
        }
        String targetId = targetElement.getInstanceIdentifier();
        List<AnimationKeyframe> keyframes = controller.getKeyframes();
        if (keyframes.isEmpty()) {
            return true;
        }
        if (!ANIMATED_MEMORY.contains(targetId)) {
            ANIMATED_MEMORY.add(targetId);
        }
        if (!RUNNING_ANIMATIONS.containsKey(targetId)) {
            state = new AnimationState(keyframes, System.currentTimeMillis(), targetElement, controller);
            RUNNING_ANIMATIONS.put(targetId, state);
        } else {
            state = RUNNING_ANIMATIONS.get(targetId);
            state.targetElement = targetElement;
        }
        state.storeOriginalProperties();
        return true;
    }

    public static void tick() {
        Iterator<Map.Entry<String, AnimationState>> it = RUNNING_ANIMATIONS.entrySet().iterator();
        long currentTime = System.currentTimeMillis();
        while (it.hasNext()) {
            Map.Entry<String, AnimationState> entry = it.next();
            AnimationState state = entry.getValue();
            state.controller.shouldRender();
            long elapsedTime = currentTime - state.startTime;
            AnimationKeyframe current = null;
            AnimationKeyframe next = null;
            AnimationKeyframe lastKeyframe = state.keyframes.get(state.keyframes.size() - 1);
            AnimationKeyframe firstKeyframe = state.keyframes.get(0);
            if (state.controller.loop && elapsedTime > lastKeyframe.timestamp) {
                long loopDuration = lastKeyframe.timestamp;
                long timeIntoLoop = elapsedTime % loopDuration;
                if (timeIntoLoop < firstKeyframe.timestamp) {
                    current = lastKeyframe;
                    next = firstKeyframe;
                    float progress = (float)timeIntoLoop / (float)firstKeyframe.timestamp;
                    if (!state.controller.ignorePosition) {
                        if (!state.controller.offsetMode) {
                            state.targetElement.posOffsetX = (int)AnimationControllerHandler.lerp(current.posOffsetX, next.posOffsetX, progress);
                            state.targetElement.posOffsetY = (int)AnimationControllerHandler.lerp(current.posOffsetY, next.posOffsetY, progress);
                        } else {
                            state.targetElement.animatedOffsetX = (int)AnimationControllerHandler.lerp(current.posOffsetX, next.posOffsetX, progress);
                            state.targetElement.animatedOffsetY = (int)AnimationControllerHandler.lerp(current.posOffsetY, next.posOffsetY, progress);
                        }
                    }
                    if (!state.controller.ignoreSize) {
                        state.targetElement.baseWidth = (int)AnimationControllerHandler.lerp(current.baseWidth, next.baseWidth, progress);
                        state.targetElement.baseHeight = (int)AnimationControllerHandler.lerp(current.baseHeight, next.baseHeight, progress);
                    }
                    if (state.controller.offsetMode || state.controller.ignorePosition) continue;
                    state.targetElement.anchorPoint = next.anchorPoint;
                    state.targetElement.stickyAnchor = next.stickyAnchor;
                    continue;
                }
                elapsedTime = timeIntoLoop;
            }
            for (int i = 0; i < state.keyframes.size() - 1; ++i) {
                AnimationKeyframe k1 = state.keyframes.get(i);
                AnimationKeyframe k2 = state.keyframes.get(i + 1);
                if (elapsedTime < k1.timestamp || elapsedTime >= k2.timestamp) continue;
                current = k1;
                next = k2;
                break;
            }
            if (current != null && next != null) {
                float progress = (float)(elapsedTime - current.timestamp) / (float)(next.timestamp - current.timestamp);
                if (!state.controller.ignorePosition) {
                    if (!state.controller.offsetMode) {
                        state.targetElement.posOffsetX = (int)AnimationControllerHandler.lerp(current.posOffsetX, next.posOffsetX, progress);
                        state.targetElement.posOffsetY = (int)AnimationControllerHandler.lerp(current.posOffsetY, next.posOffsetY, progress);
                    } else {
                        state.targetElement.animatedOffsetX = (int)AnimationControllerHandler.lerp(current.posOffsetX, next.posOffsetX, progress);
                        state.targetElement.animatedOffsetY = (int)AnimationControllerHandler.lerp(current.posOffsetY, next.posOffsetY, progress);
                    }
                }
                if (!state.controller.ignoreSize) {
                    state.targetElement.baseWidth = (int)AnimationControllerHandler.lerp(current.baseWidth, next.baseWidth, progress);
                    state.targetElement.baseHeight = (int)AnimationControllerHandler.lerp(current.baseHeight, next.baseHeight, progress);
                }
                if (!state.controller.offsetMode && !state.controller.ignorePosition) {
                    state.targetElement.anchorPoint = next.anchorPoint;
                    state.targetElement.stickyAnchor = next.stickyAnchor;
                }
            }
            if ((state.controller.loop || elapsedTime <= lastKeyframe.timestamp) && state.controller.shouldRender()) continue;
            if (!state.controller.offsetMode) {
                state.targetElement.posOffsetX = state.originalPosOffsetX;
                state.targetElement.posOffsetY = state.originalPosOffsetY;
                state.targetElement.baseWidth = state.originalBaseWidth;
                state.targetElement.baseHeight = state.originalBaseHeight;
                state.targetElement.anchorPoint = state.originalAnchorPoint;
                state.targetElement.stickyAnchor = state.originalStickyAnchor;
            }
            state.targetElement.animatedOffsetX = 0;
            state.targetElement.animatedOffsetY = 0;
            it.remove();
            if (!state.controller.shouldRender()) continue;
            FINISHED_ANIMATIONS.add(state.targetElement.getInstanceIdentifier());
        }
    }

    private static float lerp(float a, float b, float t) {
        return a + (b - a) * t;
    }

    public static void stopAnimation(@NotNull String targetElementId) {
        RUNNING_ANIMATIONS.remove(targetElementId);
    }

    public static void stopAllAnimations() {
        RUNNING_ANIMATIONS.clear();
    }

    public static void clearMemory() {
        ANIMATED_MEMORY.clear();
        FINISHED_ANIMATIONS.clear();
    }

    public static boolean wasAnimatedInThePast(@NotNull String targetElementId) {
        return ANIMATED_MEMORY.contains(targetElementId);
    }

    public static boolean isAnimating(@NotNull String targetElementId) {
        return RUNNING_ANIMATIONS.containsKey(targetElementId);
    }

    public static boolean isFinished(@NotNull String targetElementId) {
        return FINISHED_ANIMATIONS.contains(targetElementId);
    }

    protected static class AnimationState {
        protected List<AnimationKeyframe> keyframes;
        protected long startTime;
        protected AbstractElement targetElement;
        protected AnimationControllerElement controller;
        protected int originalPosOffsetX;
        protected int originalPosOffsetY;
        protected int originalBaseWidth;
        protected int originalBaseHeight;
        protected ElementAnchorPoint originalAnchorPoint;
        protected boolean originalStickyAnchor;

        protected AnimationState(List<AnimationKeyframe> keyframes, long startTime, AbstractElement targetElement, AnimationControllerElement controller) {
            this.keyframes = keyframes;
            this.startTime = startTime;
            this.targetElement = targetElement;
            this.controller = controller;
        }

        protected void storeOriginalProperties() {
            this.originalPosOffsetX = this.targetElement.posOffsetX;
            this.originalPosOffsetY = this.targetElement.posOffsetY;
            this.originalBaseWidth = this.targetElement.baseWidth;
            this.originalBaseHeight = this.targetElement.baseHeight;
            this.originalAnchorPoint = this.targetElement.anchorPoint;
            this.originalStickyAnchor = this.targetElement.stickyAnchor;
        }
    }
}

