/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.element.elements.video.mcef;

import de.keksuccino.fancymenu.customization.element.AbstractElement;
import de.keksuccino.fancymenu.customization.element.ElementBuilder;
import de.keksuccino.fancymenu.customization.element.SerializedElement;
import de.keksuccino.fancymenu.customization.element.elements.video.mcef.MCEFVideoEditorElement;
import de.keksuccino.fancymenu.customization.element.elements.video.mcef.MCEFVideoElement;
import de.keksuccino.fancymenu.customization.layout.editor.LayoutEditorScreen;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.resource.ResourceSource;
import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_3419;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MCEFVideoElementBuilder
extends ElementBuilder<MCEFVideoElement, MCEFVideoEditorElement> {
    private static final Logger LOGGER = LogManager.getLogger();

    public MCEFVideoElementBuilder() {
        super("video_mcef");
    }

    @Override
    @NotNull
    public MCEFVideoElement buildDefaultInstance() {
        MCEFVideoElement i = new MCEFVideoElement(this);
        i.baseWidth = 400;
        i.baseHeight = 200;
        return i;
    }

    @Override
    public MCEFVideoElement deserializeElement(@NotNull SerializedElement serialized) {
        MCEFVideoElement element = this.buildDefaultInstance();
        String source = serialized.getValue("source");
        element.rawVideoUrlSource = source != null ? ResourceSource.of(source) : null;
        element.loop = this.deserializeBoolean(element.loop, serialized.getValue("loop"));
        element.volume = this.deserializeNumber(Float.class, Float.valueOf(element.volume), serialized.getValue("volume")).floatValue();
        String soundSource = serialized.getValue("sound_source");
        if (soundSource != null) {
            element.soundSource = Objects.requireNonNullElse(MCEFVideoElementBuilder.getSoundSourceByName(soundSource), class_3419.field_15250);
        }
        return element;
    }

    @Override
    protected SerializedElement serializeElement(@NotNull MCEFVideoElement element, @NotNull SerializedElement serializeTo) {
        if (element.rawVideoUrlSource != null) {
            serializeTo.putProperty("source", element.rawVideoUrlSource.getSerializationSource());
        }
        serializeTo.putProperty("loop", "" + element.loop);
        serializeTo.putProperty("volume", "" + element.volume);
        serializeTo.putProperty("sound_source", element.soundSource.method_14840());
        return serializeTo;
    }

    @Override
    @NotNull
    public MCEFVideoEditorElement wrapIntoEditorElement(@NotNull MCEFVideoElement element, @NotNull LayoutEditorScreen editor) {
        return new MCEFVideoEditorElement(element, editor);
    }

    @Override
    @NotNull
    public class_2561 getDisplayName(@Nullable AbstractElement element) {
        return class_2561.method_43471((String)"fancymenu.elements.video_mcef");
    }

    @Override
    @Nullable
    public class_2561[] getDescription(@Nullable AbstractElement element) {
        return LocalizationUtils.splitLocalizedLines("fancymenu.elements.video_mcef.desc", new String[0]);
    }

    @Nullable
    protected static class_3419 getSoundSourceByName(@NotNull String name) {
        for (class_3419 source : class_3419.values()) {
            if (!source.method_14840().equals(name)) continue;
            return source;
        }
        return null;
    }
}

