/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.layout.editor.buddy.animation;

import de.keksuccino.fancymenu.customization.layout.editor.buddy.Buddy;
import de.keksuccino.fancymenu.util.MathUtils;
import java.util.function.Predicate;
import net.minecraft.class_2960;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnimationState {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final class_2960 TEXTURE_ATLAS = new class_2960("fancymenu", "textures/buddy/buddy_atlas.png");
    public static final int SPRITE_WIDTH = 32;
    public static final int SPRITE_HEIGHT = 32;
    public static final int ATLAS_COLUMNS = 4;
    public static final int ATLAS_ROWS = 18;
    private final String name;
    private final int atlasIndex;
    private final AnimationSpeedSupplier animationSpeed;
    private final boolean allowsMovement;
    private final boolean allowsHopping;
    private final Predicate<Buddy> activationCondition;
    private final Predicate<Buddy> preventionCondition;
    private final int priority;
    private final boolean isTemporaryState;
    private final int minDuration;
    private final int maxDuration;
    private final DurationRandomizer durationRandomizer;
    @NotNull
    private final WalkingSpeedSupplier walkingSpeed;
    private final boolean lockStateUntilFinished;
    private final boolean ignoresLockedState;
    private final long cooldown;
    @Nullable
    private final StateEndAction onDeactivate;
    private long lastCountdownTriggerTime = -1L;

    private AnimationState(@NotNull String name, int atlasIndex, @NotNull AnimationSpeedSupplier animationSpeed, boolean allowsMovement, boolean allowsHopping, @NotNull Predicate<Buddy> activationCondition, @NotNull Predicate<Buddy> preventionCondition, int priority, boolean isTemporaryState, int minDuration, int maxDuration, @NotNull DurationRandomizer durationRandomizer, @NotNull WalkingSpeedSupplier walkingSpeed, boolean lockStateUntilFinished, boolean ignoresLockedState, long cooldown, @Nullable StateEndAction onDeactivate) {
        this.name = name;
        this.atlasIndex = atlasIndex;
        this.animationSpeed = animationSpeed;
        this.allowsMovement = allowsMovement;
        this.allowsHopping = allowsHopping;
        this.activationCondition = activationCondition;
        this.preventionCondition = preventionCondition;
        this.priority = priority;
        this.isTemporaryState = isTemporaryState;
        this.minDuration = minDuration;
        this.maxDuration = maxDuration;
        this.durationRandomizer = durationRandomizer;
        this.walkingSpeed = walkingSpeed;
        this.lockStateUntilFinished = lockStateUntilFinished;
        this.ignoresLockedState = ignoresLockedState;
        this.cooldown = cooldown;
        this.onDeactivate = onDeactivate;
    }

    public boolean canActivate(Buddy buddy) {
        if (!this.activationCondition.test(buddy)) {
            return false;
        }
        if (this.preventionCondition.test(buddy)) {
            return false;
        }
        long now = System.currentTimeMillis();
        if (this.cooldown > 0L && this.lastCountdownTriggerTime + this.cooldown > now) {
            LOGGER.debug("State on cooldown! Will not activate: " + this.getName());
            return false;
        }
        return true;
    }

    public void onActivate(Buddy buddy) {
        LOGGER.debug("Activating state: {}", (Object)this.name);
        buddy.resetAnimationFrame();
        if (this.isTemporaryState) {
            buddy.setCurrentStateDuration(Math.min(this.maxDuration, Math.max(this.minDuration, this.getRandomizedDuration(buddy))));
        }
        this.lastCountdownTriggerTime = System.currentTimeMillis();
    }

    public void onDeactivate(Buddy buddy) {
        LOGGER.debug("Deactivating state: {}", (Object)this.name);
        if (this.onDeactivate != null) {
            this.onDeactivate.onDeactivate(buddy, this);
        }
    }

    public String getName() {
        return this.name;
    }

    public int getAtlasIndex() {
        return this.atlasIndex;
    }

    public int getAnimationSpeed(@NotNull Buddy buddy) {
        return this.animationSpeed.speed(buddy, this);
    }

    public boolean allowsMovement() {
        return this.allowsMovement;
    }

    public boolean allowsHopping() {
        return this.allowsHopping;
    }

    public int getPriority() {
        return this.priority;
    }

    public boolean isTemporaryState() {
        return this.isTemporaryState;
    }

    public int getMinDuration() {
        return this.minDuration;
    }

    public int getMaxDuration() {
        return this.maxDuration;
    }

    public int getRandomizedDuration(Buddy buddy) {
        return this.durationRandomizer.randomize(buddy, this);
    }

    public int getCurrentWalkingSpeed(@NotNull Buddy buddy) {
        return this.walkingSpeed.speed(buddy, this);
    }

    public boolean shouldLockStateUntilFinished() {
        return this.lockStateUntilFinished;
    }

    public boolean shouldIgnoreLockedState() {
        return this.ignoresLockedState;
    }

    public long getCooldown() {
        return this.cooldown;
    }

    public String toString() {
        return this.name;
    }

    @FunctionalInterface
    public static interface AnimationSpeedSupplier {
        public int speed(Buddy var1, AnimationState var2);
    }

    @FunctionalInterface
    public static interface DurationRandomizer {
        public int randomize(Buddy var1, AnimationState var2);
    }

    @FunctionalInterface
    public static interface WalkingSpeedSupplier {
        public int speed(Buddy var1, AnimationState var2);
    }

    @FunctionalInterface
    public static interface StateEndAction {
        public void onDeactivate(Buddy var1, AnimationState var2);
    }

    public static class Builder {
        private final String name;
        private final int atlasIndex;
        private AnimationSpeedSupplier animationSpeed = (buddy, state) -> 5;
        private boolean allowsMovement = true;
        private boolean allowsHopping = true;
        private Predicate<Buddy> activationCondition = buddy -> true;
        private Predicate<Buddy> preventionCondition = buddy -> false;
        private int priority = 0;
        private boolean isTemporaryState = false;
        private int minDuration = 60;
        private int maxDuration = 60;
        private DurationRandomizer durationRandomizer = (buddy, state) -> MathUtils.getRandomNumberInRange((int)state.minDuration, (int)state.maxDuration);
        private WalkingSpeedSupplier walkingSpeed = (buddy, state) -> 2;
        private boolean lockStateUntilFinished = false;
        private boolean ignoresLockedState = false;
        private long cooldown = 0L;
        @Nullable
        private StateEndAction onDeactivate = null;

        public Builder(String name, int atlasIndex) {
            this.name = name;
            this.atlasIndex = atlasIndex;
        }

        public Builder animationSpeed(@NotNull AnimationSpeedSupplier animationSpeed) {
            this.animationSpeed = animationSpeed;
            return this;
        }

        public Builder allowsMovement(boolean allowsMovement) {
            this.allowsMovement = allowsMovement;
            return this;
        }

        public Builder allowsHopping(boolean allowsHopping) {
            this.allowsHopping = allowsHopping;
            return this;
        }

        public Builder activationCondition(@NotNull Predicate<Buddy> activationCondition) {
            this.activationCondition = activationCondition;
            return this;
        }

        public Builder preventionCondition(@NotNull Predicate<Buddy> preventionCondition) {
            this.preventionCondition = preventionCondition;
            return this;
        }

        public Builder priority(int priority) {
            this.priority = priority;
            return this;
        }

        public Builder temporaryState(boolean isTemporary) {
            this.isTemporaryState = isTemporary;
            return this;
        }

        public Builder duration(int minDuration, int maxDuration) {
            this.minDuration = Math.max(0, minDuration);
            this.maxDuration = Math.max(0, maxDuration);
            if (this.minDuration > this.maxDuration) {
                this.minDuration = this.maxDuration;
            }
            return this;
        }

        public Builder durationRandomizer(@NotNull DurationRandomizer durationRandomizer) {
            this.durationRandomizer = durationRandomizer;
            return this;
        }

        public Builder walkingSpeed(@NotNull WalkingSpeedSupplier walkingSpeed) {
            this.walkingSpeed = walkingSpeed;
            return this;
        }

        public Builder lockStateUntilFinished(boolean lock) {
            this.lockStateUntilFinished = lock;
            return this;
        }

        public Builder ignoresLockedState(boolean ignoresLockedState) {
            this.ignoresLockedState = ignoresLockedState;
            return this;
        }

        public Builder cooldown(long cooldownMillis) {
            this.cooldown = cooldownMillis;
            return this;
        }

        public Builder onDeactivate(StateEndAction onDeactivate) {
            this.onDeactivate = onDeactivate;
            return this;
        }

        public AnimationState build() {
            return new AnimationState(this.name, this.atlasIndex, this.animationSpeed, this.allowsMovement, this.allowsHopping, this.activationCondition, this.preventionCondition, this.priority, this.isTemporaryState, this.minDuration, this.maxDuration, this.durationRandomizer, this.walkingSpeed, this.lockStateUntilFinished, this.ignoresLockedState, this.cooldown, this.onDeactivate);
        }
    }
}

