/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.loadingrequirement.requirements;

import de.keksuccino.fancymenu.customization.loadingrequirement.LoadingRequirement;
import de.keksuccino.fancymenu.customization.loadingrequirement.internal.LoadingRequirementInstance;
import de.keksuccino.fancymenu.platform.Services;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.rendering.ui.UIBase;
import de.keksuccino.fancymenu.util.rendering.ui.screen.CellScreen;
import de.keksuccino.fancymenu.util.rendering.ui.screen.StringBuilderScreen;
import de.keksuccino.fancymenu.util.rendering.ui.screen.texteditor.TextEditorFormattingRule;
import de.keksuccino.fancymenu.util.rendering.ui.widget.editbox.EditBoxSuggestions;
import de.keksuccino.konkrete.Konkrete;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.class_1074;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import org.jetbrains.annotations.NotNull;

public class IsModLoadedRequirement
extends LoadingRequirement {
    public IsModLoadedRequirement() {
        super("fancymenu_loading_requirement_is_mod_loaded");
    }

    @Override
    public boolean hasValue() {
        return true;
    }

    @Override
    public boolean isRequirementMet(@Nullable String value) {
        List<String> l;
        if (value != null && !(l = this.parseStrings(value)).isEmpty()) {
            for (String s : l) {
                if (!(s.equalsIgnoreCase("optifine") ? !Konkrete.isOptifineLoaded : !Services.PLATFORM.isModLoaded(s))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected List<String> parseStrings(String value) {
        ArrayList<String> l = new ArrayList<String>();
        if (value != null) {
            if (value.contains(",")) {
                l.addAll(Arrays.asList(value.replace(" ", "").split(",")));
            } else {
                l.add(value.replace(" ", ""));
            }
        }
        return l;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return class_1074.method_4662((String)"fancymenu.helper.editor.items.visibilityrequirements.modloaded", (Object[])new Object[0]);
    }

    @Override
    public List<String> getDescription() {
        return Arrays.asList(LocalizationUtils.splitLocalizedStringLines("fancymenu.helper.editor.items.visibilityrequirements.modloaded.desc", new String[0]));
    }

    @Override
    public String getCategory() {
        return null;
    }

    @Override
    public String getValueDisplayName() {
        return "";
    }

    @Override
    public String getValuePreset() {
        return "optifine";
    }

    @Override
    public List<TextEditorFormattingRule> getValueFormattingRules() {
        return null;
    }

    @Override
    public void editValue(@NotNull class_437 parentScreen, @NotNull LoadingRequirementInstance requirementInstance) {
        IsModLoadedValueConfigScreen s = new IsModLoadedValueConfigScreen(Objects.requireNonNullElse(requirementInstance.value, ""), callback -> {
            if (callback != null) {
                requirementInstance.value = callback;
            }
            class_310.method_1551().method_1507(parentScreen);
        });
        class_310.method_1551().method_1507((class_437)s);
    }

    public static class IsModLoadedValueConfigScreen
    extends StringBuilderScreen {
        @NotNull
        protected String modId;
        protected CellScreen.TextInputCell modIdCell;
        protected EditBoxSuggestions modIdSuggestions;

        protected IsModLoadedValueConfigScreen(@NotNull String value, @NotNull Consumer<String> callback) {
            super((class_2561)class_2561.method_43471((String)"fancymenu.helper.editor.items.visibilityrequirements.modloaded.valuename"), callback);
            this.modId = value;
        }

        @Override
        protected void initCells() {
            this.addSpacerCell(20);
            String id = this.getModIdString();
            this.addLabelCell((class_2561)class_2561.method_43471((String)"fancymenu.loading_requirements.is_mod_loaded.mod_id"));
            this.modIdCell = this.addTextInputCell(null, true, true).setText(id);
            this.modIdSuggestions = EditBoxSuggestions.createWithCustomSuggestions(this, this.modIdCell.editBox, EditBoxSuggestions.SuggestionsRenderPosition.ABOVE_EDIT_BOX, Services.PLATFORM.getLoadedModIds());
            UIBase.applyDefaultWidgetSkinTo(this.modIdSuggestions);
            this.modIdCell.editBox.method_1863(s -> this.modIdSuggestions.method_23934());
            this.addSpacerCell(20);
        }

        @Override
        public void method_25394(class_332 graphics, int mouseX, int mouseY, float partial) {
            super.method_25394(graphics, mouseX, mouseY, partial);
            this.modIdSuggestions.method_23923(graphics, mouseX, mouseY);
        }

        @Override
        public boolean method_25404(int $$0, int $$1, int $$2) {
            if (this.modIdSuggestions.method_23924($$0, $$1, $$2)) {
                return true;
            }
            return super.method_25404($$0, $$1, $$2);
        }

        public boolean method_25401(double $$0, double $$1, double $$2) {
            if (this.modIdSuggestions.method_23921($$2)) {
                return true;
            }
            return super.method_25401($$0, $$1, $$2);
        }

        public boolean method_25402(double $$0, double $$1, int $$2) {
            if (this.modIdSuggestions.method_23922($$0, $$1, $$2)) {
                return true;
            }
            return super.method_25402($$0, $$1, $$2);
        }

        @Override
        @NotNull
        public String buildString() {
            return this.getModIdString();
        }

        @NotNull
        protected String getModIdString() {
            if (this.modIdCell != null) {
                return this.modIdCell.getText();
            }
            return this.modId;
        }
    }
}

