/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.util.mcef;

import com.cinemamod.mcef.MCEF;
import com.cinemamod.mcef.MCEFBrowser;
import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.fancymenu.util.mcef.ActionBridge;
import de.keksuccino.fancymenu.util.mcef.BrowserFrameTexture;
import de.keksuccino.fancymenu.util.mcef.BrowserHandler;
import de.keksuccino.fancymenu.util.mcef.BrowserLoadEventListenerManager;
import de.keksuccino.fancymenu.util.rendering.ui.FancyMenuUiComponent;
import de.keksuccino.fancymenu.util.rendering.ui.UIBase;
import de.keksuccino.fancymenu.util.rendering.ui.widget.NavigatableWidget;
import java.io.Closeable;
import java.io.IOException;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import net.minecraft.class_1044;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3419;
import net.minecraft.class_6382;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WrappedMCEFBrowser
extends class_339
implements Closeable,
NavigatableWidget,
FancyMenuUiComponent {
    protected static final Logger LOGGER = LogManager.getLogger();
    protected static final ScheduledExecutorService EXECUTOR = Executors.newSingleThreadScheduledExecutor();
    protected final MCEFBrowser browser;
    protected final class_310 minecraft = class_310.method_1551();
    protected boolean browserFocused = false;
    protected boolean interactable = true;
    protected float opacity = 1.0f;
    protected boolean autoHandle = true;
    protected volatile float volume = 1.0f;
    protected volatile boolean fullscreenAllVideos = false;
    protected volatile boolean autoPlayAllVideosOnLoad = true;
    protected volatile boolean muteAllMediaOnLoad = false;
    protected volatile boolean loopAllVideos = false;
    protected volatile boolean hideVideoControls = false;
    protected final UUID genericIdentifier = UUID.randomUUID();
    protected final class_2960 frameLocation = new class_2960("fancymenu", "mcef_browser_frame_texture_" + this.genericIdentifier.toString().toLowerCase().replace("-", ""));
    protected final BrowserFrameTexture frameTexture = new BrowserFrameTexture(-1);
    private volatile boolean initialized = false;

    @NotNull
    public static WrappedMCEFBrowser build(@NotNull String url, boolean transparent, boolean autoHandle, @Nullable Consumer<Boolean> loadListener) {
        WrappedMCEFBrowser b = new WrappedMCEFBrowser(url, transparent, loadListener);
        b.autoHandle = autoHandle;
        return b;
    }

    @NotNull
    public static WrappedMCEFBrowser build(@NotNull String url, boolean transparent, boolean autoHandle, int x, int y, int width, int height, @Nullable Consumer<Boolean> loadListener) {
        WrappedMCEFBrowser b = WrappedMCEFBrowser.build(url, transparent, autoHandle, loadListener);
        b.setSize(width, height);
        b.method_48229(x, y);
        return b;
    }

    protected WrappedMCEFBrowser(@NotNull String url, boolean transparent, @Nullable Consumer<Boolean> loadListener) {
        super(0, 0, 0, 0, (class_2561)class_2561.method_43473());
        ActionBridge.initialize();
        MCEF.getClient().addLoadHandler(BrowserLoadEventListenerManager.getInstance().getGlobalHandler());
        this.browser = MCEF.createBrowser((String)url, (boolean)transparent);
        String browserId = this.getIdentifier();
        BrowserLoadEventListenerManager.getInstance().registerListenerForBrowser(this, success -> {
            if (success.booleanValue()) {
                this.initialized = true;
                this.applyInitialSettings();
                this.injectJavaScriptAPI();
            } else {
                LOGGER.error("[FANCYMENU] WrappedMCEFBrowser browser page failed to load (ID: {})", (Object)browserId, (Object)new Exception());
                this.initialized = false;
            }
        });
        if (loadListener != null) {
            BrowserLoadEventListenerManager.getInstance().registerListenerForBrowser(this, loadListener);
        }
        this.setVolume(this.volume);
        this.setSize(200, 200);
        this.method_48229(0, 0);
        this.frameTexture.setId(this.browser.getRenderer().getTextureID());
        class_310.method_1551().method_1531().method_4616(this.frameLocation, (class_1044)this.frameTexture);
    }

    protected void applyInitialSettings() {
        this.setVolume(this.volume);
        this.setLoopAllVideos(this.loopAllVideos);
        this.setHideVideoControls(this.hideVideoControls);
        this.setAutoPlayAllVideosOnLoad(this.autoPlayAllVideosOnLoad);
        this.setMuteAllMediaOnLoad(this.muteAllMediaOnLoad);
    }

    protected void injectJavaScriptAPI() {
        try {
            LOGGER.info("[FANCYMENU] Injecting FancyMenu JavaScript API into browser (ID: {})", (Object)this.getIdentifier());
            EXECUTOR.schedule(() -> {
                try {
                    this.browser.executeJavaScript(ActionBridge.JAVASCRIPT_API, this.browser.getURL(), 0);
                    LOGGER.info("[FANCYMENU] JavaScript API injection completed for browser (ID: {})", (Object)this.getIdentifier());
                }
                catch (Exception ex) {
                    LOGGER.error("[FANCYMENU] Failed to inject JavaScript API into browser", (Throwable)ex);
                }
            }, 500L, TimeUnit.MILLISECONDS);
        }
        catch (Exception ex) {
            LOGGER.error("[FANCYMENU] Failed to schedule JavaScript API injection", (Throwable)ex);
        }
    }

    protected void method_48579(@NotNull class_332 graphics, int mouseX, int mouseY, float partial) {
        try {
            this.frameTexture.setId(this.browser.getRenderer().getTextureID());
            if (this.autoHandle) {
                BrowserHandler.notifyHandler(this.genericIdentifier.toString(), this);
            }
            RenderSystem.enableBlend();
            graphics.method_51422(1.0f, 1.0f, 1.0f, this.opacity);
            graphics.method_25290(this.frameLocation, this.method_46426(), this.method_46427(), 0.0f, 0.0f, this.method_25368(), this.method_25364(), this.method_25368(), this.method_25364());
            graphics.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
        }
        catch (Exception ex) {
            LOGGER.error("[FANCYMENU] Failed to render MCEFBrowser!", (Throwable)ex);
        }
    }

    public void onVolumeUpdated(@NotNull class_3419 soundSource, float newVolume) {
        this.setVolume(this.volume);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.method_25405(mouseX, mouseY) && this.interactable) {
            this.browserFocused = true;
            this.browser.sendMousePress(this.convertMouseX(mouseX), this.convertMouseY(mouseY), button);
            this.browser.setFocus(true);
        } else {
            this.browserFocused = false;
        }
        return false;
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (this.interactable) {
            this.browser.sendMouseRelease(this.convertMouseX(mouseX), this.convertMouseY(mouseY), button);
            this.browser.setFocus(true);
        }
        return false;
    }

    public void method_16014(double mouseX, double mouseY) {
        if (!this.interactable) {
            return;
        }
        this.browser.sendMouseMove(this.convertMouseX(mouseX), this.convertMouseY(mouseY));
    }

    public boolean method_25401(double mouseX, double mouseY, double scrollY) {
        if (this.method_25405(mouseX, mouseY) && this.interactable) {
            this.browser.sendMouseWheel(this.convertMouseX(mouseX), this.convertMouseY(mouseY), scrollY, 0);
            this.browser.setFocus(true);
        }
        return false;
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.interactable && this.browserFocused) {
            this.browser.sendKeyPress(keyCode, (long)scanCode, modifiers);
            this.browser.setFocus(true);
        }
        return false;
    }

    public boolean method_16803(int keyCode, int scanCode, int modifiers) {
        if (this.interactable && this.browserFocused) {
            this.browser.sendKeyRelease(keyCode, (long)scanCode, modifiers);
            this.browser.setFocus(true);
        }
        return false;
    }

    public boolean method_25400(char codePoint, int modifiers) {
        if (this.interactable && this.browserFocused) {
            if (codePoint == '\u0000') {
                return true;
            }
            this.browser.sendKeyTyped(codePoint, modifiers);
            this.browser.setFocus(true);
        }
        return false;
    }

    public boolean method_25405(double mouseX, double mouseY) {
        return UIBase.isXYInArea(mouseX, mouseY, (double)this.method_46426(), (double)this.method_46427(), (double)this.method_25368(), (double)this.method_25364());
    }

    protected void method_47399(@NotNull class_6382 narrationElementOutput) {
    }

    public void method_48229(int x, int y) {
        super.method_48229(x, y);
    }

    public void setSize(int width, int height) {
        this.field_22758 = width;
        this.field_22759 = height;
        this.browser.resize(this.convertWidth(width), this.convertHeight(height));
    }

    public void method_25358(int width) {
        this.field_22758 = width;
        this.setSize(this.field_22758, this.field_22759);
    }

    public void setHeight(int height) {
        this.field_22759 = height;
        this.setSize(this.field_22758, this.field_22759);
    }

    protected int convertMouseX(double mouseX) {
        return (int)((mouseX - (double)this.method_46426()) * this.minecraft.method_22683().method_4495());
    }

    protected int convertMouseY(double mouseY) {
        return (int)((mouseY - (double)this.method_46427()) * this.minecraft.method_22683().method_4495());
    }

    protected int convertWidth(double width) {
        return (int)(width * this.minecraft.method_22683().method_4495());
    }

    protected int convertHeight(double height) {
        return (int)(height * this.minecraft.method_22683().method_4495());
    }

    public void setVolume(float volume) {
        this.volume = volume;
        if (this.initialized) {
            String code = "document.querySelectorAll('audio, video').forEach(el => el.volume = " + this.getActualVolume() + ");";
            this.browser.executeJavaScript(code, this.browser.getURL(), 0);
        }
    }

    public float getVolume() {
        return this.volume;
    }

    public float getActualVolume() {
        float actualVolume = this.volume;
        float soundSourceVolume = class_310.method_1551().field_1690.method_1630(class_3419.field_15250);
        return actualVolume *= soundSourceVolume;
    }

    public void setInteractable(boolean interactable) {
        this.interactable = interactable;
        if (!this.interactable) {
            this.browser.setFocus(false);
            this.browserFocused = false;
        }
    }

    public boolean isInteractable() {
        return this.interactable;
    }

    public void setAutoHandle(boolean autoHandle) {
        this.autoHandle = autoHandle;
    }

    public boolean isAutoHandle() {
        return this.autoHandle;
    }

    public void setFullscreenAllVideos(boolean fullscreenAllVideos) {
        this.fullscreenAllVideos = fullscreenAllVideos;
        if (this.initialized) {
            String code = "document.querySelectorAll('video').forEach(video => {\n    if (video.requestFullscreen) {\n        video.requestFullscreen().catch(err => console.error('Fullscreen error:', err));\n    } else if (video.webkitRequestFullscreen) { // Safari compatibility\n        video.webkitRequestFullscreen().catch(err => console.error('Fullscreen error (webkit):', err));\n    } else if (video.msRequestFullscreen) { // IE/Edge compatibility\n        video.msRequestFullscreen().catch(err => console.error('Fullscreen error (ms):', err));\n    }\n});\n";
            if (this.fullscreenAllVideos) {
                this.browser.executeJavaScript(code, this.browser.getURL(), 0);
            }
        }
    }

    public boolean isFullscreenAllVideos() {
        return this.fullscreenAllVideos;
    }

    public void setAutoPlayAllVideosOnLoad(boolean autoPlayAllVideosOnLoad) {
        this.autoPlayAllVideosOnLoad = autoPlayAllVideosOnLoad;
        if (this.initialized) {
            String code = "document.querySelectorAll('video').forEach(video => {\n    video.play(); // Start playing the video\n});\n";
            if (this.autoPlayAllVideosOnLoad) {
                this.browser.executeJavaScript(code, this.browser.getURL(), 0);
            }
        }
    }

    public boolean isAutoPlayAllVideosOnLoad() {
        return this.autoPlayAllVideosOnLoad;
    }

    public void setMuteAllMediaOnLoad(boolean muteAllMediaOnLoad) {
        this.muteAllMediaOnLoad = muteAllMediaOnLoad;
        if (this.initialized) {
            String code = "document.querySelectorAll('audio, video').forEach(media => {\n    media.muted = %muted%; // Mute media\n});\n".replace("%muted%", "" + this.muteAllMediaOnLoad);
            this.browser.executeJavaScript(code, this.browser.getURL(), 0);
        }
    }

    public boolean isMuteAllMediaOnLoad() {
        return this.muteAllMediaOnLoad;
    }

    public void setLoopAllVideos(boolean loopAllVideos) {
        this.loopAllVideos = loopAllVideos;
        if (this.initialized) {
            String code = "document.querySelectorAll('video').forEach(video => {\n    video.loop = %loop%; // Set video to loop\n});\n".replace("%loop%", "" + this.loopAllVideos);
            this.browser.executeJavaScript(code, this.browser.getURL(), 0);
        }
    }

    public boolean isLoopAllVideos() {
        return this.loopAllVideos;
    }

    public void setHideVideoControls(boolean hideVideoControls) {
        this.hideVideoControls = hideVideoControls;
        if (this.initialized) {
            String codeRemove = "document.querySelectorAll('video').forEach(video => {\n    // Multiple methods to ensure controls are hidden\n    video.removeAttribute('controls');\n    video.setAttribute('nocontrols', '');\n    video.setAttribute('controlslist', 'nodownload nofullscreen noremoteplayback');\n    video.controls = false;\n\n    // Add style to hide controls\n    const style = document.createElement('style');\n    style.textContent = `\n        video::-webkit-media-controls,\n        video::-webkit-media-controls-enclosure,\n        video::-webkit-media-controls-panel,\n        video::-webkit-media-controls-panel-container,\n        video::-webkit-media-controls-play-button,\n        video::-webkit-media-controls-overlay-play-button {\n            display: none !important;\n            opacity: 0 !important;\n            pointer-events: none !important;\n        }\n    `;\n    if (!document.head.querySelector('style#hide-video-controls')) {\n        style.id = 'hide-video-controls';\n        document.head.appendChild(style);\n    }\n});\n";
            String codeAdd = "document.querySelectorAll('video').forEach(video => {\n    if (!video.hasAttribute('controls')) {\n        video.setAttribute('controls', 'controls'); // Add controls\n    }\n    video.removeAttribute('nocontrols');\n    // Remove style if it exists\n    const style = document.head.querySelector('style#hide-video-controls');\n    if (style) {\n        document.head.removeChild(style);\n    }\n});\n";
            this.browser.executeJavaScript(this.hideVideoControls ? codeRemove : codeAdd, this.browser.getURL(), 0);
        }
    }

    public boolean isHideVideoControls() {
        return this.hideVideoControls;
    }

    public void goBack() {
        if (this.browser.canGoBack()) {
            this.browser.goBack();
        }
        if (this.initialized) {
            this.setVolume(this.volume);
            BrowserLoadEventListenerManager.getInstance().registerListenerForBrowser(this, success -> {
                if (success.booleanValue()) {
                    this.injectJavaScriptAPI();
                }
            });
        }
    }

    public void goForward() {
        if (this.browser.canGoForward()) {
            this.browser.goForward();
        }
        if (this.initialized) {
            this.setVolume(this.volume);
            BrowserLoadEventListenerManager.getInstance().registerListenerForBrowser(this, success -> {
                if (success.booleanValue()) {
                    this.injectJavaScriptAPI();
                }
            });
        }
    }

    public String getUrl() {
        return this.browser.getURL();
    }

    public void setUrl(@NotNull String url) {
        this.browser.loadURL(url);
        BrowserLoadEventListenerManager.getInstance().registerListenerForBrowser(this, success -> {
            if (success.booleanValue()) {
                this.injectJavaScriptAPI();
            }
        });
    }

    public void reload() {
        this.browser.reload();
        if (this.initialized) {
            this.setVolume(this.volume);
            BrowserLoadEventListenerManager.getInstance().registerListenerForBrowser(this, success -> {
                if (success.booleanValue()) {
                    this.injectJavaScriptAPI();
                }
            });
        }
    }

    public void setOpacity(float opacity) {
        this.opacity = opacity;
    }

    @NotNull
    public MCEFBrowser getBrowser() {
        return this.browser;
    }

    public String getIdentifier() {
        return this.genericIdentifier.toString();
    }

    @NotNull
    public class_2960 getFrameLocation() {
        this.frameTexture.setId(this.browser.getRenderer().getTextureID());
        if (this.autoHandle) {
            BrowserHandler.notifyHandler(this.genericIdentifier.toString(), this);
        }
        return this.frameLocation;
    }

    @Override
    public boolean isFocusable() {
        return false;
    }

    @Override
    public void setFocusable(boolean focusable) {
    }

    @Override
    public boolean isNavigatable() {
        return false;
    }

    @Override
    public void setNavigatable(boolean navigatable) {
    }

    @Override
    public void close() throws IOException {
        if (this.browser != null) {
            BrowserLoadEventListenerManager.getInstance().unregisterAllListenersForBrowser(this.getIdentifier());
            this.browser.close(true);
        }
        class_310.method_1551().method_1531().method_4615(this.frameLocation);
    }
}

