/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.util.rendering.text.markdown;

import de.keksuccino.fancymenu.util.rendering.text.markdown.MarkdownRenderer;
import de.keksuccino.fancymenu.util.rendering.text.markdown.MarkdownTextFragment;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_332;
import net.minecraft.class_4068;
import org.jetbrains.annotations.NotNull;

public class MarkdownTextLine
implements class_4068 {
    public MarkdownRenderer parent;
    public float offsetX;
    public float offsetY;
    public boolean containsMultilineCodeBlockFragments = false;
    @NotNull
    public MarkdownRenderer.MarkdownLineAlignment alignment = MarkdownRenderer.MarkdownLineAlignment.LEFT;
    public boolean bulletListItemStartLine = false;
    public final Map<MarkdownTextFragment.CodeBlockContext, SingleLineCodeBlockPart> singleLineCodeBlockStartEndPairs = new HashMap<MarkdownTextFragment.CodeBlockContext, SingleLineCodeBlockPart>();
    public final List<MarkdownTextFragment> fragments = new ArrayList<MarkdownTextFragment>();

    public MarkdownTextLine(@NotNull MarkdownRenderer parent) {
        this.parent = parent;
    }

    public void method_25394(@NotNull class_332 graphics, int mouseX, int mouseY, float partial) {
        this.onRender(graphics, mouseX, mouseY, partial, true);
    }

    protected void onRender(class_332 graphics, int mouseX, int mouseY, float partial, boolean shouldRender) {
        float textX = this.parent.x + this.offsetX;
        for (MarkdownTextFragment f : this.fragments) {
            f.x = textX;
            f.y = this.parent.y + this.offsetY;
            if (shouldRender) {
                f.method_25394(graphics, mouseX, mouseY, partial);
            }
            textX += f.getRenderWidth();
        }
    }

    public void prepareLine() {
        this.prepareFragments();
        this.onRender(null, 0, 0, 0.0f, false);
    }

    public void prepareFragments() {
        this.containsMultilineCodeBlockFragments = false;
        this.singleLineCodeBlockStartEndPairs.clear();
        this.alignment = MarkdownRenderer.MarkdownLineAlignment.LEFT;
        this.bulletListItemStartLine = false;
        for (MarkdownTextFragment f : this.fragments) {
            f.parentLine = this;
            f.startOfRenderLine = false;
            f.autoLineBreakAfter = false;
            if (f.codeBlockContext != null && !f.codeBlockContext.singleLine) {
                this.containsMultilineCodeBlockFragments = true;
            }
            if (f.codeBlockContext == null || !f.codeBlockContext.singleLine || this.singleLineCodeBlockStartEndPairs.containsKey(f.codeBlockContext)) continue;
            SingleLineCodeBlockPart part = new SingleLineCodeBlockPart();
            part.start = f;
            int index = f.codeBlockContext.codeBlockFragments.indexOf(f);
            if (index < 0) continue;
            List<MarkdownTextFragment> subList = f.codeBlockContext.codeBlockFragments.subList(index, f.codeBlockContext.codeBlockFragments.size());
            for (MarkdownTextFragment cf : subList) {
                if (!this.fragments.contains(cf)) break;
                if (cf == f) continue;
                part.end = cf;
            }
            if (part.end == null) {
                part.end = f;
            }
            this.singleLineCodeBlockStartEndPairs.put(f.codeBlockContext, part);
        }
        if (!this.fragments.isEmpty()) {
            MarkdownTextFragment first = this.fragments.get(0);
            MarkdownTextFragment last = this.fragments.get(this.fragments.size() - 1);
            this.alignment = first.alignment;
            this.bulletListItemStartLine = first.bulletListItemStart;
            first.startOfRenderLine = true;
            boolean bl = last.autoLineBreakAfter = !last.naturalLineBreakAfter;
            if (last.isTable()) {
                last.autoLineBreakAfter = false;
            }
        }
    }

    public float getLineWidth() {
        float f = 0.0f;
        MarkdownTextFragment last = null;
        for (MarkdownTextFragment frag : this.fragments) {
            f += frag.getRenderWidth();
            last = frag;
        }
        if (last != null && last.text.endsWith(" ")) {
            f -= (float)this.parent.font.method_1727(" ") * last.getScale();
        }
        if (f < 0.0f) {
            f = 0.0f;
        }
        return f;
    }

    public float getLineHeight() {
        float f = 0.0f;
        for (MarkdownTextFragment frag : this.fragments) {
            if (!(frag.getRenderHeight() > f)) continue;
            f = frag.getRenderHeight();
        }
        return f;
    }

    public boolean isAlignmentAllowed(@NotNull MarkdownRenderer.MarkdownLineAlignment alignment) {
        if (alignment == MarkdownRenderer.MarkdownLineAlignment.LEFT) {
            return true;
        }
        return !this.containsMultilineCodeBlockFragments;
    }

    public static class SingleLineCodeBlockPart {
        MarkdownTextFragment start;
        MarkdownTextFragment end;
    }
}

