/*
 * Decompiled with CFR 0.152.
 */
package net.kenddie.fantasyarmor.client.render;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import net.kenddie.fantasyarmor.client.render.FAArmorRenderer;
import net.kenddie.fantasyarmor.item.armor.FAArmorItem;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_918;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;

public class FADyeableGeoLayer<T extends FAArmorItem>
extends GeoRenderLayer<T> {
    protected static final Map<String, class_2960> ARMOR_PATH_CACHE = new Object2ObjectOpenHashMap();

    public FADyeableGeoLayer(FAArmorRenderer<T> renderer) {
        super(renderer);
    }

    public void render(class_4587 poseStack, T animatable, BakedGeoModel bakedModel, class_1921 baseRenderType, class_4597 bufferSource, class_4588 buffer, float partialTick, int packedLight, int packedOverlay) {
        if (animatable == null) {
            return;
        }
        class_2960 textureResLoc = this.getArmorResource((FAArmorItem)((Object)animatable));
        FAArmorRenderer armorRenderer = (FAArmorRenderer)this.renderer;
        class_1799 armorItemStack = armorRenderer.getCurrentStack();
        if (!animatable.method_7801(armorItemStack)) {
            return;
        }
        int color = animatable.method_7800(armorItemStack);
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        class_4588 vertexConsumer = this.getArmorBuffer(bufferSource, null, textureResLoc, armorItemStack.method_7958());
        this.renderer.reRender(bakedModel, poseStack, bufferSource, animatable, baseRenderType, vertexConsumer, partialTick, packedLight, packedOverlay, r, g, b, 1.0f);
    }

    public class_2960 getArmorResource(FAArmorItem armorItem) {
        String texture = "fantasy_armor:" + armorItem.getArmorSet().getOverlayPath();
        return ARMOR_PATH_CACHE.computeIfAbsent(texture, class_2960::new);
    }

    protected class_4588 getArmorBuffer(class_4597 bufferSource, @Nullable class_1921 renderType, @Nullable class_2960 texturePath, boolean enchanted) {
        if (renderType == null) {
            renderType = class_1921.method_25448((class_2960)texturePath);
        }
        return class_918.method_27952((class_4597)bufferSource, (class_1921)renderType, (boolean)false, (boolean)enchanted);
    }
}

