/*
 * Decompiled with CFR 0.152.
 */
package net.kenddie.fantasyarmor.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.annotation.ConfigEntry;
import net.kenddie.fantasyarmor.item.armor.FAArmorSet;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

@Config(name="fantasy_armor-effects")
public class FAArmorEffectsConfig
implements ConfigData {
    @ConfigEntry.Gui.Tooltip
    public Map<String, List<EffectEntry>> effects = new HashMap<String, List<EffectEntry>>();

    public static Map<String, List<EffectEntry>> defaults() {
        HashMap<String, List<EffectEntry>> map = new HashMap<String, List<EffectEntry>>();
        map.put(FAArmorSet.WIND_WORSHIPPER.getName(), List.of(new EffectEntry("minecraft:jump_boost", 259, 0)));
        map.put(FAArmorSet.WANDERING_WIZARD.getName(), List.of(new EffectEntry("minecraft:water_breathing", 259, 0), new EffectEntry("minecraft:night_vision", 259, 0), new EffectEntry("minecraft:fire_resistance", 259, 0)));
        map.put(FAArmorSet.TWINNED.getName(), List.of(new EffectEntry("minecraft:regeneration", 259, 0), new EffectEntry("minecraft:haste", 259, 1)));
        map.put(FAArmorSet.THIEF.getName(), List.of(new EffectEntry("minecraft:jump_boost", 259, 0)));
        map.put(FAArmorSet.SUNSET_WINGS.getName(), List.of(new EffectEntry("minecraft:jump_boost", 259, 0)));
        map.put(FAArmorSet.RONIN.getName(), List.of(new EffectEntry("minecraft:jump_boost", 259, 0)));
        map.put(FAArmorSet.SPARK_OF_DAWN.getName(), List.of(new EffectEntry("minecraft:night_vision", 259, 0), new EffectEntry("minecraft:fire_resistance", 259, 0)));
        map.put(FAArmorSet.SILVER_KNIGHT.getName(), List.of(new EffectEntry("minecraft:luck", 259, 0), new EffectEntry("minecraft:strength", 259, 0)));
        map.put(FAArmorSet.REDEEMER.getName(), List.of(new EffectEntry("minecraft:strength", 259, 0), new EffectEntry("minecraft:fire_resistance", 259, 0)));
        map.put(FAArmorSet.GRAVE_SENTINEL.getName(), List.of(new EffectEntry("minecraft:strength", 259, 0), new EffectEntry("minecraft:fire_resistance", 259, 0)));
        map.put(FAArmorSet.DRAGONSLAYER.getName(), List.of(new EffectEntry("minecraft:strength", 259, 0), new EffectEntry("minecraft:fire_resistance", 259, 0)));
        map.put(FAArmorSet.OLD_KNIGHT.getName(), List.of(new EffectEntry("minecraft:strength", 259, 0), new EffectEntry("minecraft:resistance", 259, 0)));
        map.put(FAArmorSet.ECLIPSE_SOLDIER.getName(), List.of(new EffectEntry("minecraft:strength", 259, 0), new EffectEntry("minecraft:resistance", 259, 0)));
        map.put(FAArmorSet.MALENIA.getName(), List.of(new EffectEntry("minecraft:regeneration", 259, 0)));
        map.put(FAArmorSet.HERO.getName(), List.of(new EffectEntry("minecraft:regeneration", 259, 0)));
        map.put(FAArmorSet.DEAD_GLADIATOR.getName(), List.of(new EffectEntry("minecraft:regeneration", 259, 0)));
        map.put(FAArmorSet.LADY_MARIA.getName(), List.of(new EffectEntry("minecraft:strength", 259, 0), new EffectEntry("minecraft:regeneration", 259, 0)));
        map.put(FAArmorSet.GOLDEN_HORNS.getName(), List.of(new EffectEntry("minecraft:haste", 259, 1)));
        map.put(FAArmorSet.GOLDEN_EXECUTION.getName(), List.of(new EffectEntry("minecraft:strength", 259, 0)));
        map.put(FAArmorSet.GILDED_HUNT.getName(), List.of(new EffectEntry("minecraft:jump_boost", 259, 0), new EffectEntry("minecraft:strength", 259, 0)));
        map.put(FAArmorSet.FORGOTTEN_TRACE.getName(), List.of(new EffectEntry("minecraft:haste", 259, 0), new EffectEntry("minecraft:regeneration", 259, 0)));
        map.put(FAArmorSet.FOG_GUARD.getName(), List.of(new EffectEntry("minecraft:fire_resistance", 259, 0), new EffectEntry("minecraft:resistance", 259, 0)));
        map.put(FAArmorSet.FLESH_OF_THE_FEASTER.getName(), List.of(new EffectEntry("minecraft:resistance", 259, 0)));
        map.put(FAArmorSet.EVENING_GHOST.getName(), List.of(new EffectEntry("minecraft:regeneration", 259, 0), new EffectEntry("minecraft:night_vision", 259, 0)));
        map.put(FAArmorSet.DARK_LORD.getName(), List.of(new EffectEntry("minecraft:strength", 259, 0), new EffectEntry("minecraft:night_vision", 259, 0), new EffectEntry("minecraft:fire_resistance", 259, 0)));
        map.put(FAArmorSet.DARK_COVER.getName(), List.of(new EffectEntry("minecraft:regeneration", 259, 0), new EffectEntry("minecraft:strength", 259, 0)));
        map.put(FAArmorSet.CRUCIBLE_KNIGHT.getName(), List.of(new EffectEntry("minecraft:fire_resistance", 259, 0), new EffectEntry("minecraft:regeneration", 259, 0)));
        map.put(FAArmorSet.CHESS_BOARD_KNIGHT.getName(), List.of(new EffectEntry("minecraft:haste", 259, 0), new EffectEntry("minecraft:regeneration", 259, 0), new EffectEntry("minecraft:strength", 259, 0)));
        map.put(FAArmorSet.ORNSTEIN.getName(), List.of(new EffectEntry("minecraft:regeneration", 259, 0), new EffectEntry("minecraft:resistance", 259, 0)));
        return map;
    }

    public void validatePostLoad() {
        if (this.effects == null) {
            this.effects = new HashMap<String, List<EffectEntry>>();
        }
        Map<String, List<EffectEntry>> def = FAArmorEffectsConfig.defaults();
        for (Map.Entry<String, List<EffectEntry>> e : def.entrySet()) {
            this.effects.putIfAbsent(e.getKey(), e.getValue());
        }
    }

    public static List<class_1293> getEffectsFor(String armorSetName, boolean showParticles, boolean showIcon) {
        FAArmorEffectsConfig cfg = (FAArmorEffectsConfig)AutoConfig.getConfigHolder(FAArmorEffectsConfig.class).getConfig();
        List list = cfg.effects.getOrDefault(armorSetName, Collections.emptyList());
        ArrayList<class_1293> out = new ArrayList<class_1293>(list.size());
        for (EffectEntry e : list) {
            class_2960 id = new class_2960(e.id);
            class_1291 effect = (class_1291)class_7923.field_41174.method_10223(id);
            if (effect == null) continue;
            out.add(new class_1293(effect, e.duration, e.amplifier, true, showParticles, showIcon));
        }
        return out;
    }

    public static final class EffectEntry {
        public String id = "minecraft:regeneration";
        public int duration = 200;
        public int amplifier = 0;

        public EffectEntry() {
        }

        public EffectEntry(String id, int duration, int amplifier) {
            this.id = id;
            this.duration = duration;
            this.amplifier = amplifier;
        }
    }
}

