/*
 * Decompiled with CFR 0.152.
 */
package net.kenddie.fantasyarmor.item.armor;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.kenddie.fantasyarmor.client.model.FAArmorModel;
import net.kenddie.fantasyarmor.client.render.FAArmorRenderer;
import net.kenddie.fantasyarmor.config.FAArmorEffectsConfig;
import net.kenddie.fantasyarmor.config.FAConfigs;
import net.kenddie.fantasyarmor.item.armor.FAArmorAttributes;
import net.kenddie.fantasyarmor.item.armor.FAArmorSet;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_156;
import net.minecraft.class_1738;
import net.minecraft.class_1740;
import net.minecraft.class_1741;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3300;
import net.minecraft.class_4057;
import net.minecraft.class_5134;
import net.minecraft.class_572;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.client.RenderProvider;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.renderer.GeoArmorRenderer;

public abstract class FAArmorItem
extends class_4057
implements GeoItem {
    private static final Map<class_1738.class_8051, UUID> ARMOR_MODIFIER_UUID_PER_TYPE = (Map)class_156.method_654(new EnumMap(class_1738.class_8051.class), map -> {
        map.put(class_1738.class_8051.field_41937, UUID.fromString("845DB27C-C624-495F-8C9F-6020A9A58B6B"));
        map.put(class_1738.class_8051.field_41936, UUID.fromString("D8499B04-0E66-4726-AB29-64469D734E0D"));
        map.put(class_1738.class_8051.field_41935, UUID.fromString("9F3D476D-C118-4544-8365-64846904B48E"));
        map.put(class_1738.class_8051.field_41934, UUID.fromString("2AD3F246-FEE1-4E67-B886-69FD380BB150"));
    });
    private final AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    private final FAArmorSet armorSet;
    private final Supplier<FAArmorAttributes> attributesSupplier;
    private Multimap<class_1320, class_1322> cachedModifiers;
    private final Supplier<Object> renderProvider = GeoItem.makeRenderer((GeoItem)this);

    protected FAArmorItem(FAArmorSet armorSet, class_1738.class_8051 type, Supplier<FAArmorAttributes> attributesSupplier) {
        super((class_1741)class_1740.field_21977, type, new class_1792.class_1793().method_7889(1).method_24359());
        this.armorSet = armorSet;
        this.attributesSupplier = attributesSupplier;
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 flag) {
        if (FAConfigs.getMainConfig().showDescriptions) {
            String[] lines;
            super.method_7851(stack, world, tooltip, flag);
            String translationKey = this.method_7876() + ".tooltip";
            String translatedText = class_2561.method_43471((String)translationKey).getString();
            class_327 font = class_310.method_1551().field_1772;
            for (String line : lines = translatedText.split("\n")) {
                String[] words;
                StringBuilder currentLine = new StringBuilder();
                for (String word : words = line.split(" ")) {
                    if (font.method_1727(String.valueOf(currentLine) + word) > FAConfigs.getMainConfig().descriptionsLength) {
                        tooltip.add((class_2561)class_2561.method_43470((String)currentLine.toString()));
                        currentLine = new StringBuilder();
                        currentLine.append("\u00a77");
                    }
                    if (currentLine.length() > 2) {
                        currentLine.append(" ");
                        currentLine.append("\u00a77");
                    }
                    currentLine.append(word);
                }
                if (currentLine.length() <= 0) continue;
                tooltip.add((class_2561)class_2561.method_43470((String)currentLine.toString()));
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    public void createRenderer(Consumer<Object> consumer) {
        consumer.accept(new RenderProvider(){
            private GeoArmorRenderer<? extends FAArmorItem> renderer;

            public class_572<class_1309> getHumanoidArmorModel(class_1309 livingEntity, class_1799 itemStack, class_1304 equipmentSlot, class_572<class_1309> original) {
                if (this.renderer == null) {
                    this.renderer = FAArmorItem.this.createArmorRenderer();
                }
                this.renderer.prepForRender((class_1297)livingEntity, itemStack, equipmentSlot, original);
                return this.renderer;
            }
        });
    }

    public Multimap<class_1320, class_1322> getAttributeModifiers(class_1799 stack, class_1304 slot) {
        if (slot != this.field_41933.method_48399() || !FAConfigs.getMainConfig().applyModifiers) {
            return super.getAttributeModifiers(stack, slot);
        }
        if (this.cachedModifiers == null) {
            this.cachedModifiers = this.buildModifiers();
        }
        return this.cachedModifiers;
    }

    private Multimap<class_1320, class_1322> buildModifiers() {
        FAArmorAttributes armorAttributes = this.attributesSupplier.get();
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        UUID uuid = ARMOR_MODIFIER_UUID_PER_TYPE.get(this.field_41933);
        if (armorAttributes.armor() != 0.0) {
            builder.put((Object)class_5134.field_23724, (Object)new class_1322(uuid, "Armor", armorAttributes.armor(), class_1322.class_1323.field_6328));
        }
        if (armorAttributes.armorToughness() != 0.0) {
            builder.put((Object)class_5134.field_23725, (Object)new class_1322(uuid, "Armor toughness", armorAttributes.armorToughness(), class_1322.class_1323.field_6328));
        }
        if (armorAttributes.knockbackResistance() != 0.0) {
            builder.put((Object)class_5134.field_23718, (Object)new class_1322(uuid, "Armor knockback resistance", armorAttributes.knockbackResistance(), class_1322.class_1323.field_6328));
        }
        if (armorAttributes.movementSpeed() != 0.0) {
            builder.put((Object)class_5134.field_23719, (Object)new class_1322(uuid, "Armor movement speed", armorAttributes.movementSpeed(), class_1322.class_1323.field_6331));
        }
        if (armorAttributes.maxHealth() != 0.0) {
            builder.put((Object)class_5134.field_23716, (Object)new class_1322(uuid, "Armor health gain", armorAttributes.maxHealth(), class_1322.class_1323.field_6328));
        }
        if (armorAttributes.attackDamage() != 0.0) {
            builder.put((Object)class_5134.field_23721, (Object)new class_1322(uuid, "Armor attack damage", armorAttributes.attackDamage(), class_1322.class_1323.field_6331));
        }
        if (armorAttributes.attackSpeed() != 0.0) {
            builder.put((Object)class_5134.field_23723, (Object)new class_1322(uuid, "Armor attack speed", armorAttributes.attackSpeed(), class_1322.class_1323.field_6331));
        }
        if (armorAttributes.luck() != 0.0) {
            builder.put((Object)class_5134.field_23726, (Object)new class_1322(uuid, "Armor luck", armorAttributes.luck(), class_1322.class_1323.field_6328));
        }
        return builder.build();
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public Supplier<Object> getRenderProvider() {
        return this.renderProvider;
    }

    @Environment(value=EnvType.CLIENT)
    protected GeoArmorRenderer<? extends FAArmorItem> createArmorRenderer() {
        boolean dyeable = FAArmorItem.resourceExists(new class_2960("fantasy_armor", this.armorSet.getOverlayPath()));
        return new FAArmorRenderer(new FAArmorModel(this.armorSet.getGeoPath(), this.armorSet.getTexturePath()), dyeable);
    }

    public List<class_1293> getFullSetEffects() {
        return FAArmorEffectsConfig.getEffectsFor(this.armorSet.getName(), FAConfigs.getMainConfig().showParticles, FAConfigs.getMainConfig().showEffectIcon);
    }

    public FAArmorSet getArmorSet() {
        return this.armorSet;
    }

    public static boolean resourceExists(class_2960 location) {
        class_3300 resourceManager = class_310.method_1551().method_1478();
        try {
            return resourceManager.method_14486(location).isPresent();
        }
        catch (Exception e) {
            return false;
        }
    }
}

