/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.fragmentum.util.color;

import com.mojang.serialization.Codec;
import dev.obscuria.fragmentum.extension.CodecExtension;
import dev.obscuria.fragmentum.util.color.Colors;
import dev.obscuria.fragmentum.util.color.HSV;
import dev.obscuria.fragmentum.util.color.RGB;
import java.util.List;
import lombok.Generated;
import net.minecraft.class_3532;

public record ARGB(float alpha, float red, float green, float blue) {
    public static final Codec<ARGB> DECIMAL_CODEC = Codec.INT.xmap(Colors::argbOf, ARGB::decimal);
    public static final Codec<ARGB> HEXADECIMAL_CODEC = Codec.STRING.xmap(Colors::argbOf, ARGB::hexadecimal);
    public static final Codec<ARGB> NORMALIZED_CODEC = Codec.FLOAT.listOf().xmap(Colors::argbOf, ARGB::normalized);
    public static final Codec<ARGB> CODEC = CodecExtension.withAlternative(DECIMAL_CODEC, HEXADECIMAL_CODEC, NORMALIZED_CODEC);

    public int decimal() {
        int a = class_3532.method_15340((int)Math.round(this.alpha * 255.0f), (int)0, (int)255);
        int r = class_3532.method_15340((int)Math.round(this.red * 255.0f), (int)0, (int)255);
        int g = class_3532.method_15340((int)Math.round(this.green * 255.0f), (int)0, (int)255);
        int b = class_3532.method_15340((int)Math.round(this.blue * 255.0f), (int)0, (int)255);
        return a << 24 | r << 16 | g << 8 | b;
    }

    public String hexadecimal() {
        return String.format("#%08X", this.decimal());
    }

    public List<Float> normalized() {
        return List.of(Float.valueOf(this.alpha), Float.valueOf(this.red), Float.valueOf(this.green), Float.valueOf(this.blue));
    }

    public ARGB lerp(ARGB to, float delta) {
        return new ARGB(class_3532.method_16439((float)delta, (float)this.alpha, (float)to.alpha), class_3532.method_16439((float)delta, (float)this.red, (float)to.red), class_3532.method_16439((float)delta, (float)this.green, (float)to.green), class_3532.method_16439((float)delta, (float)this.blue, (float)to.blue));
    }

    public RGB toRGB() {
        return new RGB(this.red, this.green, this.blue);
    }

    public HSV toHSV() {
        return this.toRGB().toHSV();
    }

    @Generated
    public ARGB withAlpha(float alpha) {
        return this.alpha == alpha ? this : new ARGB(alpha, this.red, this.green, this.blue);
    }

    @Generated
    public ARGB withRed(float red) {
        return this.red == red ? this : new ARGB(this.alpha, red, this.green, this.blue);
    }

    @Generated
    public ARGB withGreen(float green) {
        return this.green == green ? this : new ARGB(this.alpha, this.red, green, this.blue);
    }

    @Generated
    public ARGB withBlue(float blue) {
        return this.blue == blue ? this : new ARGB(this.alpha, this.red, this.green, blue);
    }
}

