/*
 * Decompiled with CFR 0.152.
 */
package com.github.thedeathlycow.frostiful.item.attribute;

import com.github.thedeathlycow.frostiful.Frostiful;
import com.github.thedeathlycow.frostiful.item.attribute.ItemAttributeModifier;
import com.google.common.collect.Multimap;
import com.google.gson.JsonParseException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.fabric.api.item.v1.ModifyItemAttributeModifiersCallback;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.minecraft.class_1304;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;

public class ItemAttributeLoader
implements SimpleSynchronousResourceReloadListener,
ModifyItemAttributeModifiersCallback {
    public static final ItemAttributeLoader INSTANCE = new ItemAttributeLoader(Frostiful.id("item_attribute_modifiers"));
    private final class_2960 identifier;
    private final Map<class_2960, ItemAttributeModifier> values = new HashMap<class_2960, ItemAttributeModifier>();

    public ItemAttributeLoader(class_2960 identifier) {
        this.identifier = identifier;
    }

    public class_2960 getFabricId() {
        return this.identifier;
    }

    public void method_14491(class_3300 manager) {
        HashMap<class_2960, ItemAttributeModifier> newValues = new HashMap<class_2960, ItemAttributeModifier>();
        for (Map.Entry entry : manager.method_14488("frostiful/item_attribute_modifiers", id -> id.method_12832().endsWith(".json")).entrySet()) {
            try {
                BufferedReader reader = ((class_3298)entry.getValue()).method_43039();
                try {
                    ItemAttributeModifier modifier = (ItemAttributeModifier)ItemAttributeModifier.Serializer.GSON.fromJson((Reader)reader, ItemAttributeModifier.class);
                    if (modifier.isItemPresent()) {
                        newValues.put((class_2960)entry.getKey(), modifier);
                        continue;
                    }
                    Frostiful.LOGGER.trace("Skipping item attribute modifier {}, as item is not present", entry.getKey());
                }
                finally {
                    if (reader == null) continue;
                    reader.close();
                }
            }
            catch (JsonParseException | IOException e) {
                Frostiful.LOGGER.error("An error occurred while loading item attribute modifier {}: {}", entry.getKey(), (Object)e);
            }
        }
        this.values.clear();
        this.values.putAll(newValues);
        int numModifiers = this.values.size();
        Frostiful.LOGGER.info("Loaded {} item attribute modifier{}", (Object)numModifiers, (Object)(numModifiers == 1 ? "" : "s"));
        if (numModifiers > 0) {
            Frostiful.LOGGER.warn("Using deprecated item attribute modifiers from Frostiful! Use the item tags #frostiful:very_warm_armor or #frostiful:warm_armor for adding Frost Resistance to armors instead.");
        }
    }

    public void modifyAttributeModifiers(class_1799 stack, class_1304 slot, Multimap<class_1320, class_1322> attributeModifiers) {
        for (ItemAttributeModifier value : this.values.values()) {
            value.apply(stack, slot, attributeModifiers);
        }
    }
}

