/*
 * Decompiled with CFR 0.152.
 */
package net.fryc.frycmobvariants.util;

import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import net.fryc.frycmobvariants.MobVariants;
import net.fryc.frycmobvariants.mobs.ModMobs;
import net.fryc.frycmobvariants.mobs.biome.CorsairEntity;
import net.fryc.frycmobvariants.mobs.biome.ToxicSlimeEntity;
import net.fryc.frycmobvariants.mobs.cave.UndeadWarriorEntity;
import net.fryc.frycmobvariants.mobs.nether.ExecutionerEntity;
import net.fryc.frycmobvariants.mobs.nether.LavaSlimeEntity;
import net.fryc.frycmobvariants.mobs.nether.SoulStealerEntity;
import net.fryc.frycmobvariants.tags.ModBiomeTags;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1547;
import net.minecraft.class_1548;
import net.minecraft.class_1571;
import net.minecraft.class_1589;
import net.minecraft.class_1590;
import net.minecraft.class_1613;
import net.minecraft.class_1621;
import net.minecraft.class_1628;
import net.minecraft.class_1639;
import net.minecraft.class_1642;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1811;
import net.minecraft.class_1935;
import net.minecraft.class_4836;
import net.minecraft.class_5418;
import net.minecraft.class_5419;
import oshi.util.tuples.Pair;

public class MobConvertingHelper {
    public static void tryToConvertZombie(class_1642 zombie, Random random) {
        if (zombie.getClass() == class_1642.class) {
            int i = (int)zombie.method_23318();
            if (zombie.method_37908().method_23753(zombie.method_24515()).method_40220(ModBiomeTags.FROZEN_ZOMBIE_SPAWN_BIOMES) && MobConvertingHelper.isAtProperYLevel(i, (class_1309)zombie)) {
                if (MobConvertingHelper.shouldConvertToVariant(random, MobVariants.config.zombieToFrozenZombieConvertChance)) {
                    zombie.method_29243(ModMobs.FROZEN_ZOMBIE, true);
                }
            } else if (zombie.method_37908().method_23753(zombie.method_24515()).method_40220(ModBiomeTags.BLOATED_CORPSE_SPAWN_BIOMES) && MobConvertingHelper.isAtProperYLevel(i, (class_1309)zombie)) {
                if (MobConvertingHelper.shouldConvertToVariant(random, MobVariants.config.zombieToBloatedCorpseConvertChance)) {
                    zombie.method_29243(ModMobs.BLOATED_CORPSE, true);
                }
            } else if (zombie.method_37908().method_23753(zombie.method_24515()).method_40220(ModBiomeTags.EXPLORER_SPAWN_BIOMES) && MobConvertingHelper.isAtProperYLevel(i, (class_1309)zombie)) {
                if (MobConvertingHelper.shouldConvertToVariant(random, MobVariants.config.zombieToExplorerConvertChance)) {
                    zombie.method_29243(ModMobs.EXPLORER, true);
                }
            } else if (MobConvertingHelper.shouldConvertToCaveVariant(random, i, MobVariants.config.fixedChanceToConvertZombieUnderSelectedYLevel, MobVariants.config.zombieToForgottenConvertLevelY)) {
                zombie.method_29243(ModMobs.FORGOTTEN, true);
            }
        } else if (zombie.getClass() == class_1590.class && MobConvertingHelper.shouldConvertToVariant(random, MobVariants.config.zombifiedPiglinConvertChance)) {
            zombie.method_5673(class_1304.field_6173, new class_1799((class_1935)class_1802.field_8825));
            zombie.method_29243(ModMobs.ZOMBIFIED_PIGLIN_BRUTE, true);
        }
    }

    public static void tryToConvertSkeleton(class_1547 skeleton, Random random) {
        if (skeleton.getClass() == class_1613.class) {
            if (!skeleton.method_37908().method_8597().comp_644()) {
                int i = (int)skeleton.method_23318();
                if (skeleton.method_37908().method_23753(skeleton.method_24515()).method_40220(ModBiomeTags.CORSAIR_SPAWN_BIOMES) && MobConvertingHelper.isAtProperYLevel(i, (class_1309)skeleton)) {
                    if (MobConvertingHelper.shouldConvertToVariant(random, MobVariants.config.skeletonToCorsairConvertChance)) {
                        skeleton.method_5673(class_1304.field_6173, CorsairEntity.getCorsairSword());
                        skeleton.method_29243(ModMobs.CORSAIR, true);
                    }
                } else if (MobConvertingHelper.shouldConvertToCaveVariant(random, i, MobVariants.config.fixedChanceToConvertSkeletonUnderSelectedYLevel, MobVariants.config.skeletonToUndeadWarriorConvertLevelY)) {
                    if (skeleton.method_6047().method_7942() && MobVariants.config.undeadWarriorAttributes.alwaysKeepEnchantedBow) {
                        skeleton.method_29243(ModMobs.UNDEAD_WARRIOR, true);
                    } else {
                        skeleton.method_5673(class_1304.field_6173, UndeadWarriorEntity.getUndeadWarriorWeapon());
                        UndeadWarriorEntity uw = (UndeadWarriorEntity)skeleton.method_29243(ModMobs.UNDEAD_WARRIOR, true);
                        if (uw != null && !(uw.method_6047().method_7909() instanceof class_1811)) {
                            uw.tippedArrowsAmount = -1;
                        }
                    }
                }
            } else if (MobConvertingHelper.shouldConvertToVariant(random, MobVariants.config.skeletonToSoulStealerConvertChance)) {
                skeleton.method_5673(class_1304.field_6173, SoulStealerEntity.getSoulsStealerWeapon());
                skeleton.method_29243(ModMobs.SOUL_STEALER, true);
            }
        } else if (skeleton.getClass() == class_1639.class && MobConvertingHelper.shouldConvertToVariant(random, MobVariants.config.witherSkeletonConvertChance)) {
            ExecutionerEntity.initExecutionerEquipment(skeleton);
            skeleton.method_29243(ModMobs.EXECUTIONER, true);
        }
    }

    public static void tryToConvertSpider(class_1628 spider, Random random) {
        if (spider.getClass() == class_1628.class) {
            int i = (int)spider.method_23318();
            if (spider.method_37908().method_23753(spider.method_24515()).method_40220(ModBiomeTags.TROPICAL_SPIDER_SPAWN_BIOMES) && MobConvertingHelper.isAtProperYLevel(i, (class_1309)spider)) {
                if (MobConvertingHelper.shouldConvertToVariant(random, MobVariants.config.spiderToTropicalSpiderConvertChance)) {
                    spider.method_29243(ModMobs.TROPICAL_SPIDER, false);
                }
            } else if (MobConvertingHelper.shouldConvertToCaveVariant(random, i, MobVariants.config.fixedChanceToConvertSpiderUnderSelectedYLevel, MobVariants.config.spiderToArmoredSpiderConvertLevelY)) {
                spider.method_29243(ModMobs.ARMORED_SPIDER, false);
            }
        }
    }

    public static void tryToConvertSlime(class_1621 slime, Random random) {
        LavaSlimeEntity lavaSlime;
        int size = slime.method_7152();
        if (slime.getClass() == class_1621.class) {
            ToxicSlimeEntity toxicSlime;
            int i = (int)slime.method_23318();
            if (slime.method_37908().method_23753(slime.method_24515()).method_40220(ModBiomeTags.TOXIC_SLIME_SPAWN_BIOMES) && MobConvertingHelper.isAtProperYLevel(i, (class_1309)slime) && MobConvertingHelper.shouldConvertToVariant(random, MobVariants.config.slimeToToxicSlimeConvertChance) && (toxicSlime = (ToxicSlimeEntity)slime.method_29243(ModMobs.TOXIC_SLIME, false)) != null) {
                toxicSlime.method_7161(size, true);
            }
        } else if (slime.getClass() == class_1589.class && MobConvertingHelper.shouldConvertToVariant(random, MobVariants.config.magmaCubeToLavaSlimeConvertChance) && (lavaSlime = (LavaSlimeEntity)slime.method_29243(ModMobs.LAVA_SLIME, false)) != null) {
            lavaSlime.method_7161(size, true);
        }
    }

    public static void tryToConvertGhast(class_1571 ghast, Random random) {
        if (ghast.getClass() == class_1571.class && MobConvertingHelper.shouldConvertToVariant(random, MobVariants.config.ghastConvertChance)) {
            ghast.method_29243(ModMobs.NIGHTMARE, false);
        }
    }

    public static void tryToConvertCreeper(class_1548 creeper, Random random) {
        int i;
        if (creeper.getClass() == class_1548.class && MobConvertingHelper.shouldConvertToCaveVariant(random, i = (int)creeper.method_23318(), MobVariants.config.fixedChanceToConvertCreeperUnderSelectedYLevel, MobVariants.config.creeperToCaveCreeperConvertLevelY)) {
            creeper.method_29243(ModMobs.CAVE_CREEPER, false);
        }
    }

    public static void tryToConvertPiglin(class_5418 piglin, Random random) {
        if (piglin.getClass() == class_4836.class) {
            if (MobConvertingHelper.shouldConvertToVariant(random, MobVariants.config.piglinConvertChance)) {
                piglin.method_29243(ModMobs.INFECTED_PIGLIN, true);
            }
        } else if (piglin.getClass() == class_5419.class && MobConvertingHelper.shouldConvertToVariant(random, MobVariants.config.piglinBruteConvertChance)) {
            piglin.method_29243(ModMobs.INFECTED_PIGLIN_BRUTE, true);
        }
    }

    public static boolean isAtProperYLevel(int y, class_1309 mob) {
        return y >= MobVariants.config.minYLevelForBiomeVariants || mob.method_37908().method_23753(mob.method_24515()).method_40220(ModBiomeTags.UNDERGROUND_BIOMES);
    }

    public static boolean shouldConvertToVariant(Random random, int chance) {
        return random.nextInt(0, 100) < chance;
    }

    public static boolean shouldConvertToCaveVariant(Random random, int y, int fixedChance, int convertLevelY) {
        if (y < convertLevelY) {
            if (fixedChance > -1) {
                return MobConvertingHelper.shouldConvertToVariant(random, fixedChance);
            }
            return random.nextInt(y, 100 + y) < convertLevelY;
        }
        return false;
    }

    public static class_1799 getRandomItemStack(Map<class_1792, Pair<Float, Float>> map) {
        float chance = ThreadLocalRandom.current().nextFloat();
        Optional<Map.Entry> optional = map.entrySet().stream().filter(entry -> chance >= ((Float)((Pair)entry.getValue()).getA()).floatValue() && chance < ((Float)((Pair)entry.getValue()).getB()).floatValue()).findAny();
        return optional.isPresent() ? new class_1799((class_1935)optional.get().getKey()) : class_1799.field_8037;
    }
}

