/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.client.gui;

import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.ui.BaseScreen;
import dev.ftb.mods.ftblibrary.ui.GuiHelper;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.SimpleTextButton;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.ui.WidgetLayout;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftblibrary.util.TimeUtils;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import dev.ftb.mods.ftblibrary.util.client.PositionedIngredient;
import dev.ftb.mods.ftbquests.client.ClientQuestFile;
import dev.ftb.mods.ftbquests.client.gui.FTBQuestsTheme;
import dev.ftb.mods.ftbquests.net.GetEmergencyItemsMessage;
import dev.ftb.mods.ftbquests.quest.QuestShape;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.class_1074;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_4587;

public class EmergencyItemsScreen
extends BaseScreen {
    private final long endTime = System.currentTimeMillis() + (long)ClientQuestFile.INSTANCE.getEmergencyItemsCooldown() * 1000L;
    private boolean done = false;
    private final SimpleTextButton cancelButton = new SimpleTextButton((Panel)this, (class_2561)class_2561.method_43471((String)"gui.cancel"), (Icon)Color4I.empty()){

        public void onClicked(MouseButton button) {
            this.playClickSound();
            this.getGui().closeGui();
        }
    };
    private final Panel itemPanel = new Panel((Panel)this){

        public void addWidgets() {
            ClientQuestFile.INSTANCE.getEmergencyItems().forEach(stack -> this.add(new EmergencyItemWidget(this, (class_1799)stack)));
        }

        public void alignWidgets() {
            this.setWidth(this.align((WidgetLayout)new WidgetLayout.Horizontal(3, 7, 3)));
            this.setHeight(22);
            this.setPos((EmergencyItemsScreen.this.width - EmergencyItemsScreen.this.itemPanel.width) / 2, EmergencyItemsScreen.this.height * 2 / 3 - 10);
        }
    };

    public void addWidgets() {
        this.add((Widget)this.itemPanel);
        this.add((Widget)this.cancelButton);
        this.cancelButton.setPos((this.width - this.cancelButton.width) / 2, this.height * 2 / 3 + 16);
    }

    public boolean onInit() {
        return this.setFullscreen();
    }

    public void drawBackground(class_332 graphics, Theme theme, int x, int y, int w, int h) {
        long timeLeft = this.endTime - System.currentTimeMillis();
        if (timeLeft <= 0L) {
            if (!this.done) {
                this.done = true;
                this.cancelButton.setTitle((class_2561)class_2561.method_43471((String)"gui.close"));
                new GetEmergencyItemsMessage().sendToServer();
            }
            timeLeft = 0L;
        }
        class_4587 poseStack = graphics.method_51448();
        poseStack.method_22903();
        poseStack.method_46416((float)((int)((double)w / 2.0)), (float)((int)((double)h / 5.0)), 0.0f);
        poseStack.method_22905(2.0f, 2.0f, 1.0f);
        String s = class_1074.method_4662((String)"ftbquests.file.emergency_items", (Object[])new Object[0]);
        theme.drawString(graphics, (Object)s, -theme.getStringWidth(s) / 2, 0, Color4I.WHITE, 0);
        poseStack.method_22909();
        poseStack.method_22903();
        poseStack.method_46416((float)((int)((double)w / 2.0)), (float)((int)((double)h / 2.5)), 0.0f);
        poseStack.method_22905(4.0f, 4.0f, 1.0f);
        s = timeLeft <= 0L ? "00:00" : TimeUtils.getTimeString((long)(timeLeft / 1000L * 1000L + 1000L));
        int x1 = -theme.getStringWidth(s) / 2;
        theme.drawString(graphics, (Object)s, x1 - 1, 0, Color4I.BLACK, 0);
        theme.drawString(graphics, (Object)s, x1 + 1, 0, Color4I.BLACK, 0);
        theme.drawString(graphics, (Object)s, x1, 1, Color4I.BLACK, 0);
        theme.drawString(graphics, (Object)s, x1, -1, Color4I.BLACK, 0);
        theme.drawString(graphics, (Object)s, x1, 0, Color4I.WHITE, 0);
        poseStack.method_22909();
    }

    public Theme getTheme() {
        return FTBQuestsTheme.INSTANCE;
    }

    private static class EmergencyItemWidget
    extends Widget {
        private final class_1799 stack;

        public EmergencyItemWidget(Panel panel, class_1799 stack) {
            super(panel);
            this.stack = stack;
            this.setY(3);
            this.setSize(16, 16);
        }

        public void addMouseOverText(TooltipList list) {
            ArrayList l = new ArrayList();
            GuiHelper.addStackTooltip((class_1799)this.stack, l);
            l.forEach(arg_0 -> ((TooltipList)list).add(arg_0));
        }

        public void draw(class_332 graphics, Theme theme, int x, int y, int w, int h) {
            GuiHelper.setupDrawing();
            QuestShape.get("rsquare").getOutline().draw(graphics, x - 3, y - 3, w + 6, h + 6);
            graphics.method_51448().method_22903();
            graphics.method_51448().method_22904((double)x + (double)w / 2.0, (double)y + (double)h / 2.0, 100.0);
            GuiHelper.drawItem((class_332)graphics, (class_1799)this.stack, (int)0, (boolean)true, null);
            graphics.method_51448().method_22909();
        }

        public Optional<PositionedIngredient> getIngredientUnderMouse() {
            return PositionedIngredient.of((Object)this.stack, (Widget)this);
        }
    }
}

