/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import dev.architectury.registry.registries.RegistrarManager;
import dev.ftb.mods.ftblibrary.config.Tristate;
import dev.ftb.mods.ftbquests.FTBQuests;
import dev.ftb.mods.ftbquests.integration.PermissionsHelper;
import dev.ftb.mods.ftbquests.net.ClearDisplayCacheMessage;
import dev.ftb.mods.ftbquests.net.CreateObjectResponseMessage;
import dev.ftb.mods.ftbquests.net.OpenQuestBookMessage;
import dev.ftb.mods.ftbquests.net.SyncEditorPermissionMessage;
import dev.ftb.mods.ftbquests.net.SyncQuestsMessage;
import dev.ftb.mods.ftbquests.quest.Chapter;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.QuestLink;
import dev.ftb.mods.ftbquests.quest.QuestObject;
import dev.ftb.mods.ftbquests.quest.QuestObjectBase;
import dev.ftb.mods.ftbquests.quest.ServerQuestFile;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.loot.RewardTable;
import dev.ftb.mods.ftbquests.quest.loot.WeightedReward;
import dev.ftb.mods.ftbquests.quest.reward.ItemReward;
import dev.ftb.mods.ftbquests.quest.reward.Reward;
import dev.ftb.mods.ftbquests.quest.task.ItemTask;
import dev.ftb.mods.ftbquests.quest.task.Task;
import dev.ftb.mods.ftbquests.util.ProgressChange;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2262;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2624;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_7225;
import net.minecraft.class_7699;
import net.minecraft.class_7701;
import net.minecraft.class_7706;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;

public class FTBQuestsCommands {
    public static final SimpleCommandExceptionType NO_FILE = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"commands.ftbquests.command.error.no_file"));
    public static final DynamicCommandExceptionType NO_OBJECT = new DynamicCommandExceptionType(object -> class_2561.method_43469((String)"commands.ftbquests.command.error.no_object", (Object[])new Object[]{object}));
    public static final DynamicCommandExceptionType INVALID_ID = new DynamicCommandExceptionType(id -> class_2561.method_43469((String)"commands.ftbquests.command.error.invalid_id", (Object[])new Object[]{id}));
    private static final SimpleCommandExceptionType NO_INVENTORY = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"commands.ftbquests.command.error.no_inventory"));
    private static final Set<UUID> warnedPlayers = new HashSet<UUID>();

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"ftbquests").requires(s -> s.method_9211() != null && s.method_9211().method_3724() || FTBQuestsCommands.hasEditorPermission(s))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"editing_mode").executes(c -> FTBQuestsCommands.editingMode((class_2168)c.getSource(), ((class_2168)c.getSource()).method_9207(), null))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"enabled", (ArgumentType)BoolArgumentType.bool()).executes(c -> FTBQuestsCommands.editingMode((class_2168)c.getSource(), ((class_2168)c.getSource()).method_9207(), BoolArgumentType.getBool((CommandContext)c, (String)"enabled")))).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(c -> FTBQuestsCommands.editingMode((class_2168)c.getSource(), class_2186.method_9315((CommandContext)c, (String)"player"), BoolArgumentType.getBool((CommandContext)c, (String)"enabled"))))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"locked").executes(c -> FTBQuestsCommands.locked((class_2168)c.getSource(), ((class_2168)c.getSource()).method_9207(), null))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"enabled", (ArgumentType)BoolArgumentType.bool()).executes(c -> FTBQuestsCommands.locked((class_2168)c.getSource(), ((class_2168)c.getSource()).method_9207(), BoolArgumentType.getBool((CommandContext)c, (String)"enabled")))).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(c -> FTBQuestsCommands.locked((class_2168)c.getSource(), class_2186.method_9315((CommandContext)c, (String)"player"), BoolArgumentType.getBool((CommandContext)c, (String)"enabled"))))))).then(class_2170.method_9247((String)"delete_empty_reward_tables").executes(context -> FTBQuestsCommands.deleteEmptyRewardTables((class_2168)context.getSource())))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"change_progress").requires(FTBQuestsCommands::hasEditorPermission)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"players", (ArgumentType)class_2186.method_9308()).then(class_2170.method_9247((String)"reset").then(class_2170.method_9244((String)"quest_object", (ArgumentType)StringArgumentType.string()).executes(ctx -> {
            Collection players = class_2186.method_9312((CommandContext)ctx, (String)"players");
            return FTBQuestsCommands.changeProgress((class_2168)ctx.getSource(), players, true, StringArgumentType.getString((CommandContext)ctx, (String)"quest_object"));
        })))).then(class_2170.method_9247((String)"complete").then(class_2170.method_9244((String)"quest_object", (ArgumentType)StringArgumentType.string()).executes(ctx -> {
            Collection players = class_2186.method_9312((CommandContext)ctx, (String)"players");
            return FTBQuestsCommands.changeProgress((class_2168)ctx.getSource(), players, false, StringArgumentType.getString((CommandContext)ctx, (String)"quest_object"));
        })))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"export_reward_table_to_chest").requires(FTBQuestsCommands::hasEditorPermission)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"reward_table", (ArgumentType)StringArgumentType.string()).executes(ctx -> FTBQuestsCommands.exportRewards((class_2168)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"reward_table"), null))).then(class_2170.method_9244((String)"pos", (ArgumentType)class_2262.method_9698()).executes(ctx -> {
            class_2338 pos = class_2262.method_9697((CommandContext)ctx, (String)"pos");
            return FTBQuestsCommands.exportRewards((class_2168)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"reward_table"), pos);
        }))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"import_reward_table_from_chest").requires(FTBQuestsCommands::hasEditorPermission)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).executes(ctx -> {
            String name = StringArgumentType.getString((CommandContext)ctx, (String)"name");
            return FTBQuestsCommands.importRewards((class_2168)ctx.getSource(), name, null);
        })).then(class_2170.method_9244((String)"pos", (ArgumentType)class_2262.method_9698()).executes(ctx -> {
            String name = StringArgumentType.getString((CommandContext)ctx, (String)"name");
            class_2338 pos = class_2262.method_9697((CommandContext)ctx, (String)"pos");
            return FTBQuestsCommands.importRewards((class_2168)ctx.getSource(), name, pos);
        }))))).then(class_2170.method_9247((String)"generate_chapter_with_all_items_in_game").executes(context -> FTBQuestsCommands.generateAllItemChapter((class_2168)context.getSource())))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"reload").requires(FTBQuestsCommands::hasEditorPermission)).executes(context -> FTBQuestsCommands.doReload((class_2168)context.getSource())))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"block_rewards").executes(c -> FTBQuestsCommands.toggleRewardBlocking((class_2168)c.getSource(), ((class_2168)c.getSource()).method_9207(), null))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"enabled", (ArgumentType)BoolArgumentType.bool()).executes(c -> FTBQuestsCommands.toggleRewardBlocking((class_2168)c.getSource(), ((class_2168)c.getSource()).method_9207(), BoolArgumentType.getBool((CommandContext)c, (String)"enabled")))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).requires(FTBQuestsCommands::hasEditorPermission)).executes(c -> FTBQuestsCommands.toggleRewardBlocking((class_2168)c.getSource(), class_2186.method_9315((CommandContext)c, (String)"player"), BoolArgumentType.getBool((CommandContext)c, (String)"enabled"))))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"open_book").executes(c -> FTBQuestsCommands.openQuest(((class_2168)c.getSource()).method_9207(), null))).then(class_2170.method_9244((String)"quest_object", (ArgumentType)StringArgumentType.string()).executes(c -> FTBQuestsCommands.openQuest(((class_2168)c.getSource()).method_9207(), StringArgumentType.getString((CommandContext)c, (String)"quest_object")))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"clear_item_display_cache").requires(FTBQuestsCommands::hasEditorPermission)).executes(c -> FTBQuestsCommands.clearDisplayCache((class_2168)c.getSource()))));
    }

    private static boolean hasEditorPermission(class_2168 stack) {
        return stack.method_9259(2) || stack.method_43737() && PermissionsHelper.hasEditorPermission(stack.method_44023(), false);
    }

    private static QuestObjectBase getQuestObjectForString(String idStr) throws CommandSyntaxException {
        ServerQuestFile file = ServerQuestFile.INSTANCE;
        if (file == null) {
            throw NO_FILE.create();
        }
        if (idStr.startsWith("#")) {
            String val = idStr.substring(1);
            for (QuestObjectBase qob : file.getAllObjects()) {
                if (!qob.hasTag(val)) continue;
                return qob;
            }
            throw NO_OBJECT.create((Object)idStr);
        }
        long id = QuestObjectBase.parseHexId(idStr).orElseThrow(() -> INVALID_ID.create((Object)idStr));
        QuestObjectBase qob = file.getBase(id);
        if (qob == null) {
            throw NO_OBJECT.create((Object)idStr);
        }
        return qob;
    }

    private static boolean playerCanSeeQuestObject(class_3222 player, QuestObject qo) {
        if (qo instanceof Chapter) {
            return true;
        }
        TeamData data = TeamData.get((class_1657)player);
        Quest quest = null;
        if (qo instanceof QuestLink) {
            QuestLink link = (QuestLink)qo;
            quest = link.getQuest().orElse(null);
        } else if (qo instanceof Task) {
            Task task = (Task)qo;
            quest = task.getQuest();
        } else if (qo instanceof Quest) {
            Quest q;
            quest = q = (Quest)qo;
        }
        return quest != null && (data.getCanEdit((class_1657)player) || !quest.hideDetailsUntilStartable() || data.canStartTasks(quest));
    }

    private static int openQuest(class_3222 player, String qobId) throws CommandSyntaxException {
        Quest quest;
        if (qobId == null) {
            new OpenQuestBookMessage(0L).sendTo(player);
            return 1;
        }
        QuestObjectBase questObjectBase = FTBQuestsCommands.getQuestObjectForString(qobId);
        if (questObjectBase instanceof Quest && FTBQuestsCommands.playerCanSeeQuestObject(player, quest = (Quest)questObjectBase)) {
            new OpenQuestBookMessage(quest.id).sendTo(player);
            return 1;
        }
        return 0;
    }

    private static int exportRewards(class_2168 source, String idStr, @Nullable class_2338 pos) throws CommandSyntaxException {
        class_3222 player = source.method_9207();
        class_3218 level = source.method_9225();
        QuestObjectBase questObjectBase = FTBQuestsCommands.getQuestObjectForString(idStr);
        if (!(questObjectBase instanceof RewardTable)) {
            throw NO_OBJECT.create((Object)idStr);
        }
        RewardTable table = (RewardTable)questObjectBase;
        pos = Objects.requireNonNullElse(pos, class_2338.method_49638((class_2374)player.method_5745(10.0, 1.0f, false).method_17784()));
        class_2586 class_25862 = level.method_8321(pos);
        if (!(class_25862 instanceof class_2624)) {
            throw NO_INVENTORY.create();
        }
        class_2624 container = (class_2624)class_25862;
        container.method_5448();
        int slot = 0;
        for (WeightedReward wr : table.getWeightedRewards()) {
            if (slot >= container.method_5439()) {
                source.method_9213((class_2561)class_2561.method_43469((String)"commands.ftbquests.command.feedback.table_too_many_items", (Object[])new Object[]{table.getTitle()}));
                return 0;
            }
            Reward reward = wr.getReward();
            if (!(reward instanceof ItemReward)) continue;
            ItemReward itemReward = (ItemReward)reward;
            container.method_5447(slot++, itemReward.getItem());
        }
        source.method_9226(() -> class_2561.method_43469((String)"commands.ftbquests.command.feedback.table_exported", (Object[])new Object[]{table.getTitle(), table.getWeightedRewards().size()}), false);
        return 1;
    }

    private static int importRewards(class_2168 source, String name, class_2338 pos) throws CommandSyntaxException {
        class_2586 be;
        class_3222 player = source.method_9207();
        class_3218 level = source.method_9225();
        ServerQuestFile file = ServerQuestFile.INSTANCE;
        if (pos == null) {
            pos = class_2338.method_49638((class_2374)player.method_5745(10.0, 1.0f, false).method_17784());
        }
        if (!((be = level.method_8321(pos)) instanceof class_2624)) {
            throw NO_INVENTORY.create();
        }
        class_2624 container = (class_2624)be;
        RewardTable table = new RewardTable(file.newID(), file);
        table.setRawTitle(name);
        table.setRawIcon(class_1802.field_8106.method_7854());
        for (int i = 0; i < container.method_5439(); ++i) {
            class_1799 stack = container.method_5438(i);
            if (stack.method_7960()) continue;
            table.addReward(table.makeWeightedItemReward(stack, 1.0f));
        }
        file.addRewardTable(table);
        file.refreshIDMap();
        file.clearCachedData();
        file.markDirty();
        new CreateObjectResponseMessage(table, null).sendToAll(level.method_8503());
        source.method_9226(() -> class_2561.method_43469((String)"commands.ftbquests.command.feedback.table_imported", (Object[])new Object[]{name, table.getWeightedRewards().size()}), false);
        return 1;
    }

    private static int editingMode(class_2168 source, class_3222 player, @Nullable Boolean canEdit) {
        TeamData data = ServerQuestFile.INSTANCE.getOrCreateTeamData((class_1297)player);
        if (canEdit == null) {
            canEdit = !data.getCanEdit((class_1657)player);
        }
        data.setCanEdit((class_1657)player, canEdit);
        if (canEdit.booleanValue()) {
            source.method_9226(() -> class_2561.method_43469((String)"commands.ftbquests.editing_mode.enabled", (Object[])new Object[]{player.method_5476()}), true);
        } else {
            source.method_9226(() -> class_2561.method_43469((String)"commands.ftbquests.editing_mode.disabled", (Object[])new Object[]{player.method_5476()}), true);
        }
        return 1;
    }

    private static int locked(class_2168 source, class_3222 player, @Nullable Boolean locked) {
        TeamData data = ServerQuestFile.INSTANCE.getOrCreateTeamData((class_1297)player);
        if (locked == null) {
            locked = !data.isLocked();
        }
        data.setLocked(locked);
        if (locked.booleanValue()) {
            source.method_9226(() -> class_2561.method_43469((String)"commands.ftbquests.locked.enabled", (Object[])new Object[]{player.method_5476()}), true);
        } else {
            source.method_9226(() -> class_2561.method_43469((String)"commands.ftbquests.locked.disabled", (Object[])new Object[]{player.method_5476()}), true);
        }
        return 1;
    }

    private static int changeProgress(class_2168 source, Collection<class_3222> players, boolean reset, String idStr) throws CommandSyntaxException {
        QuestObjectBase questObject = FTBQuestsCommands.getQuestObjectForString(idStr);
        for (class_3222 player : players) {
            ProgressChange progressChange = new ProgressChange(ServerQuestFile.INSTANCE, questObject, player.method_5667()).setReset(reset);
            questObject.forceProgress(ServerQuestFile.INSTANCE.getOrCreateTeamData((class_1297)player), progressChange);
        }
        source.method_9226(() -> class_2561.method_43471((String)"commands.ftbquests.change_progress.text"), false);
        return 1;
    }

    private static int deleteEmptyRewardTables(class_2168 source) {
        int removed = ServerQuestFile.INSTANCE.removeEmptyRewardTables(source);
        source.method_9226(() -> class_2561.method_43469((String)"commands.ftbquests.command.delete_empty_reward_tables.text", (Object[])new Object[]{removed}), false);
        return 1;
    }

    private static int generateAllItemChapter(class_2168 source) {
        if (!class_7706.method_47344().method_47310()) {
            class_7706.method_47330((class_7699)class_7701.field_40183, (boolean)true, (class_7225.class_7874)source.method_9225().method_30349());
        }
        Collection allItems = class_7706.method_47344().method_45414();
        long newId = ServerQuestFile.INSTANCE.newID();
        Chapter chapter = new Chapter(newId, ServerQuestFile.INSTANCE, ServerQuestFile.INSTANCE.getDefaultChapterGroup());
        chapter.onCreated();
        chapter.setRawTitle("Generated chapter of all items in search creative tab [" + allItems.size() + "]");
        chapter.setRawIcon(new class_1799((class_1935)class_1802.field_8251));
        chapter.setDefaultQuestShape("rsquare");
        new CreateObjectResponseMessage(chapter, null).sendToAll(source.method_9211());
        List<class_1799> list = allItems.stream().filter(stack -> !stack.method_7960() && RegistrarManager.getId((Object)stack.method_7909(), (class_5321)class_7924.field_41197) != null).sorted(Comparator.comparing(a -> RegistrarManager.getId((Object)a.method_7909(), (class_5321)class_7924.field_41197))).toList();
        FTBQuests.LOGGER.info("Found {} items in total, chapter ID: {}", (Object)allItems.size(), (Object)chapter);
        if (list.isEmpty()) {
            return 0;
        }
        int col = 0;
        int row = 0;
        String modid = RegistrarManager.getId((Object)list.get(0).method_7909(), (class_5321)class_7924.field_41197).method_12836();
        for (class_1799 stack2 : list) {
            class_2960 id = RegistrarManager.getId((Object)stack2.method_7909(), (class_5321)class_7924.field_41197);
            if (!modid.equals(id.method_12836())) {
                modid = id.method_12836();
                col = 0;
                row += 2;
            } else if (col >= 40) {
                col = 0;
                ++row;
            }
            Quest quest = new Quest(chapter.file.newID(), chapter);
            quest.onCreated();
            quest.setX(col);
            quest.setY(row);
            quest.setRawSubtitle(stack2.method_7953(new class_2487()).toString());
            new CreateObjectResponseMessage(quest, null).sendToAll(source.method_9211());
            ItemTask task = new ItemTask(chapter.file.newID(), quest);
            task.onCreated();
            task.setStackAndCount(stack2, 1).setConsumeItems(Tristate.TRUE);
            class_2487 extra = new class_2487();
            extra.method_10582("type", task.getType().getTypeForNBT());
            new CreateObjectResponseMessage(task, extra).sendToAll(source.method_9211());
            ++col;
        }
        ServerQuestFile.INSTANCE.markDirty();
        ServerQuestFile.INSTANCE.saveNow();
        source.method_9226(() -> class_2561.method_43470((String)"Done!"), false);
        return 1;
    }

    private static int doReload(class_2168 source) {
        UUID id;
        ServerQuestFile instance = ServerQuestFile.INSTANCE;
        class_3222 sender = source.method_44023();
        if (sender != null && !instance.getOrCreateTeamData((class_1297)sender).getCanEdit((class_1657)sender)) {
            source.method_9213((class_2561)class_2561.method_43471((String)"commands.ftbquests.command.error.not_editing"));
            return 0;
        }
        instance.load();
        new SyncQuestsMessage(instance).sendToAll(source.method_9211());
        source.method_9211().method_3760().method_14571().forEach(p -> new SyncEditorPermissionMessage(PermissionsHelper.hasEditorPermission(p, false)).sendTo((class_3222)p));
        source.method_9226(() -> class_2561.method_43471((String)"commands.ftbquests.command.feedback.reloaded"), false);
        UUID uUID = id = sender == null ? class_156.field_25140 : sender.method_5667();
        if (!warnedPlayers.contains(id)) {
            source.method_9226(() -> class_2561.method_43471((String)"commands.ftbquests.command.feedback.reloaded.disclaimer").method_27692(class_124.field_1065), false);
            warnedPlayers.add(id);
        }
        return 1;
    }

    private static int toggleRewardBlocking(class_2168 source, class_3222 player, Boolean doBlocking) {
        TeamData data = ServerQuestFile.INSTANCE.getOrCreateTeamData((class_1297)player);
        if (doBlocking == null) {
            doBlocking = !data.areRewardsBlocked();
        }
        data.setRewardsBlocked(doBlocking);
        source.method_9226(() -> class_2561.method_43469((String)"commands.ftbquests.command.feedback.rewards_blocked", (Object[])new Object[]{data, data.areRewardsBlocked()}), false);
        return 1;
    }

    private static int clearDisplayCache(class_2168 source) {
        ClearDisplayCacheMessage.clearForAll(source.method_9211());
        source.method_9226(() -> class_2561.method_43471((String)"commands.ftbquests.command.feedback.clear_display_cache"), false);
        return 1;
    }
}

