/*
 * Decompiled with CFR 0.152.
 */
package com.teamabode.guarding.core.init;

import com.teamabode.guarding.Guarding;
import com.teamabode.guarding.core.access.ProjectileAccessor;
import com.teamabode.guarding.core.api.GuardingEvents;
import com.teamabode.guarding.core.init.GuardingEnchantments;
import com.teamabode.guarding.core.init.GuardingItems;
import com.teamabode.guarding.core.init.GuardingParticles;
import com.teamabode.guarding.core.init.GuardingSounds;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1676;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_5819;

public class GuardingCallbacks {
    public static void init() {
        GuardingEvents.SHIELD_BLOCKED.register(GuardingCallbacks::onShieldBlock);
    }

    private static void onShieldBlock(class_1657 user, class_1282 source, float amount) {
        boolean isParry;
        class_1297 sourceEntity = source.method_5526();
        boolean bl = isParry = user.method_6030().method_7935() - user.method_6014() <= 3;
        if (sourceEntity instanceof class_1309) {
            class_1309 attacker = (class_1309)sourceEntity;
            GuardingCallbacks.blockLivingEntity(user, attacker, isParry);
        }
        if (sourceEntity instanceof class_1676) {
            class_1676 projectile = (class_1676)sourceEntity;
            GuardingCallbacks.blockProjectile(user, source.method_5529(), projectile, isParry);
        }
        GuardingCallbacks.tryParryEffects(user, sourceEntity, isParry);
    }

    private static void blockLivingEntity(class_1657 user, class_1309 attacker, boolean isParry) {
        if (isParry) {
            float exhaustion = Guarding.CONFIG.getGroup("parry").getFloatProperty("exhaustion_cost");
            float strength = GuardingCallbacks.getKnockbackStrength(user.method_6030());
            user.method_7322(exhaustion);
            attacker.method_6005((double)strength, user.method_23317() - attacker.method_23317(), user.method_23321() - attacker.method_23321());
            attacker.field_6037 = true;
        }
        GuardingCallbacks.handleBarbed(user, attacker, isParry);
    }

    private static void blockProjectile(class_1657 user, class_1297 damageCauser, class_1676 projectile, boolean isParry) {
        if (!isParry || damageCauser == null) {
            return;
        }
        float projectileLaunchStrength = Guarding.CONFIG.getGroup("parry").getFloatProperty("projectile_launch_strength");
        if (projectile instanceof ProjectileAccessor) {
            ProjectileAccessor accessor = (ProjectileAccessor)projectile;
            accessor.setParrier((class_1297)user);
        }
        class_243 motion = new class_243(user.method_23317() - damageCauser.method_23317(), 0.0, user.method_23321() - damageCauser.method_23321()).method_1021((double)projectileLaunchStrength);
        projectile.method_18800(motion.method_10216(), -1.5, motion.method_10215());
        projectile.field_6037 = true;
    }

    private static void handleBarbed(class_1657 user, class_1309 attacker, boolean isParry) {
        class_5819 random = user.method_6051();
        float damage = Guarding.CONFIG.getGroup("barbed").getFloatProperty("damage_amount");
        float chance = Guarding.CONFIG.getGroup("barbed").getFloatProperty("damage_chance");
        int barbedLevel = class_1890.method_8225((class_1887)GuardingEnchantments.BARBED, (class_1799)user.method_6030());
        if (barbedLevel <= 0) {
            return;
        }
        damage += isParry ? 1.0f : 0.0f;
        if (random.method_43057() <= chance && chance > 0.0f || isParry || chance >= 1.0f) {
            attacker.method_5643(attacker.method_48923().method_48818((class_1297)user), damage);
            user.method_6056(2.0f);
        }
    }

    private static float getKnockbackStrength(class_1799 stack) {
        float baseStrength = Guarding.CONFIG.getGroup("parry").getFloatProperty("knockback_strength");
        float additionalStrength = Guarding.CONFIG.getGroup("pummeling").getFloatProperty("additional_knockback_strength_per_level");
        int pummelingLevel = class_1890.method_8225((class_1887)GuardingEnchantments.PUMMELING, (class_1799)stack);
        float pummelStrength = pummelingLevel > 0 ? (float)pummelingLevel * additionalStrength : 0.0f;
        return baseStrength + pummelStrength;
    }

    private static void tryParryEffects(class_1657 user, class_1297 sourceEntity, boolean isParry) {
        if (!isParry) {
            return;
        }
        class_1937 level = user.method_37908();
        class_3414 breakSound = user.method_6030().method_31574(GuardingItems.NETHERITE_SHIELD) ? GuardingSounds.ITEM_NETHERITE_SHIELD_PARRY : GuardingSounds.ITEM_SHIELD_PARRY;
        level.method_45447(null, user.method_24515(), breakSound, class_3419.field_15248);
        if (level instanceof class_3218) {
            class_3218 server = (class_3218)level;
            if (sourceEntity != null) {
                server.method_14199((class_2394)GuardingParticles.PARRY, sourceEntity.method_23317(), sourceEntity.method_23320(), sourceEntity.method_23321(), 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }

    private static void onShieldDisabled(class_1657 user, class_1309 attacker) {
    }

    private static boolean isEnemy(class_1657 user, class_1309 other) {
        if (other == user) {
            return false;
        }
        if (other instanceof class_1657) {
            class_1657 otherPlayer = (class_1657)other;
            return user.method_7256(otherPlayer);
        }
        return other.method_33190();
    }
}

