/*
 * Decompiled with CFR 0.152.
 */
package com.dannyboythomas.hole_filler_mod.config;

import com.dannyboythomas.hole_filler_mod.util.H;
import com.dannyboythomas.hole_filler_mod.util.HoleUtil;

public class ConfigHoleFiller {
    public static ConfigHoleFiller Instance;
    public int max_hole_diameter = 12;
    public int max_hole_volume = 500;
    public int undo_timer = 15;
    public int fill_speed = 5;
    public boolean is_dirt_free = true;
    public boolean smart_preserve = false;
    public static HoleUtil.FillBlock smart_preserve_fill_block_enum;
    public String smart_preserve_fill_block = "cobblestone";
    public int max_water_diameter = 18;
    public int max_water_volume = 800;
    public int torch_places_n_light_sources = 6;
    public float torch_return_rate = 0.7f;
    public String __max_hole_diameter = "Maximum diameter that the hole filler will consider a hole. If hole is larger than this value, it will not fill on that axis.  Default is 12. Min is 3. Max is 32";
    public String __max_hole_volume = "Maximum number of blocks that can be placed per hole. Default is 500. Min is 1. Max is 5000";
    public String __undo_timer = "How long before Curing Blocks are converted to dirt, in seconds. This is an approximation as some randomness is involved. Default is 15. Min is 1. Max is 120";
    public String __fill_speed = "How many Curing Blocks placed per tick. Default is 5. Min is 1. Max is 120";
    public String __is_dirt_free = "If true, dirt isnt required in the players getInventory()";
    public String __smart_preserve = "If true, will fill majority of hole with dirt, leaving only surface blocks to match the environment";
    public String __smart_preserve_ = "Recommended to set is_dirt_free to true";
    public String __smart_preserve_fill_block = "The block the smart_preserve uses from your getInventory()";
    public String __smart_preserve_fill_block_ = "This is ignored if is_dirt_free is true";
    public String __smart_preserve_fill_block__ = "Options: cobblestone, stone, dirt. Default is cobblestone";
    public String __max_water_diameter = "Maximum diameter that the hole filler will consider a hole. If hole is larger than this value, it will not fill on that axis.  Default is 18. Min is 3. Max is 32";
    public String __max_water_volume = "Maximum number of blocks that can be placed per hole. Default is 800. Min is 1. Max is 5000";
    public String __torch_places_n_light_sources = "How many light sources can the Light Hole Filler place per torch in the players inventory.  Default = 6";
    public String __torch_return_rate = "What percentage of the light sources placed by the Light Hole Filler will the player get back.  Default = 70%";

    public ConfigHoleFiller() {
        Instance = this;
        this.Limit();
    }

    public void Limit() {
        this.max_hole_diameter = H.Clamp(this.max_hole_diameter, 3, 32);
        this.max_hole_volume = H.Clamp(this.max_hole_volume, 1, 5000);
        this.undo_timer = H.Clamp(this.undo_timer, 1, 120);
        this.fill_speed = H.Clamp(this.fill_speed, 1, 120);
        this.max_water_diameter = H.Clamp(this.max_water_diameter, 3, 32);
        this.max_water_volume = H.Clamp(this.max_water_volume, 1, 5000);
        try {
            smart_preserve_fill_block_enum = HoleUtil.FillBlock.valueOf(this.smart_preserve_fill_block);
        }
        catch (IllegalArgumentException e) {
            smart_preserve_fill_block_enum = HoleUtil.FillBlock.cobblestone;
        }
        this.smart_preserve_fill_block = smart_preserve_fill_block_enum.name();
        this.torch_places_n_light_sources = H.Clamp(this.torch_places_n_light_sources, 1, 128);
        this.torch_return_rate = H.Clamp(this.torch_return_rate, 0.0f, 1.0f);
    }

    static {
        smart_preserve_fill_block_enum = HoleUtil.FillBlock.cobblestone;
    }
}

