/*
 * Decompiled with CFR 0.152.
 */
package com.dannyboythomas.hole_filler_mod.tiles;

import com.dannyboythomas.hole_filler_mod.config.ConfigHoleFiller;
import com.dannyboythomas.hole_filler_mod.init.ModBlocks;
import com.dannyboythomas.hole_filler_mod.init.ModItems;
import com.dannyboythomas.hole_filler_mod.init.ModTiles;
import com.dannyboythomas.hole_filler_mod.util.H;
import com.dannyboythomas.hole_filler_mod.util.HoleData;
import com.dannyboythomas.hole_filler_mod.util.HoleUtil;
import com.dannyboythomas.hole_filler_mod.util.IH;
import com.dannyboythomas.hole_filler_mod.util.smart.CuringState;
import java.util.UUID;
import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2346;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3965;

public class TileHoleFillerBase
extends class_2586 {
    public int timer = 0;
    public class_2248 blockToPlace;
    public boolean creativeMode;
    public class_1657 thrower;
    public HoleData holedata;
    public class_3965 blockHitResult;
    public boolean running = false;

    public TileHoleFillerBase(class_2338 pos, class_2680 state) {
        super(ModTiles.HOLE_FILLER_BASE, pos, state);
    }

    public TileHoleFillerBase(class_2591<?> entityType, class_2338 pos, class_2680 state) {
        super(entityType, pos, state);
    }

    public void method_11014(class_2487 nbt) {
        class_2680 state = this.field_11863.method_8320(this.field_11867);
        this.holedata = HoleData.Read(state, nbt, (class_2382)this.field_11867);
        this.blockToPlace = H.BlockFromName(nbt.method_10558("block_to_place"));
        try {
            UUID playerID = UUID.fromString(nbt.method_10558("thrower"));
            this.thrower = H.GetPlayerFromID(this.field_11863, playerID);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.creativeMode = nbt.method_10577("creative");
        this.running = nbt.method_10577("running");
        this.timer = nbt.method_10550("timer");
        super.method_11014(nbt);
    }

    protected void method_11007(class_2487 nbt) {
        if (this.holedata != null) {
            nbt = this.holedata.Write(nbt);
        }
        if (this.blockToPlace != null) {
            String blockName = H.GetBlockName(this.blockToPlace);
            nbt.method_10582("block_to_place", blockName);
        }
        nbt.method_10582("thrower", H.GetPlayerIDString(this.thrower));
        nbt.method_10556("creative", this.creativeMode);
        nbt.method_10556("running", this.running);
        nbt.method_10569("timer", this.timer);
        super.method_11007(nbt);
    }

    public static <T extends class_2586> void tick(class_1937 world, class_2338 pos, class_2680 state, T blockEntity) {
        boolean canRunOnServer;
        if (world.field_9236) {
            return;
        }
        TileHoleFillerBase te = (TileHoleFillerBase)world.method_8321(pos);
        ++te.timer;
        boolean throwerOnline = te.thrower != null && te.thrower.method_5682().method_3760().method_14571().contains(te.thrower);
        boolean bl = canRunOnServer = te.creativeMode || throwerOnline;
        if (te.running && canRunOnServer) {
            te.Fill();
        }
        if (te.timer > 4800) {
            world.method_8501(pos, te.GetBlockToPlace(pos).method_9564());
        }
        te.TickCuringStates();
        te.method_5431();
    }

    void TickCuringStates() {
        class_2248 block;
        if (this.holedata == null) {
            return;
        }
        boolean allConverted = this.holedata.TickCuringStates(this.field_11863, this.thrower);
        if (allConverted && (block = this.GetBlockToPlace(this.field_11867)) != null) {
            this.field_11863.method_8501(this.field_11867, this.GetBlockToPlace(this.field_11867).method_9564());
        }
    }

    HoleUtil.FillerType GetFillerType() {
        return HoleUtil.FillerType.simple;
    }

    class_1792 GetThrowableItem() {
        if (this.GetFillerType() == HoleUtil.FillerType.balanced) {
            return ModItems.throwable_hole_filler_balanced;
        }
        if (this.GetFillerType() == HoleUtil.FillerType.smart) {
            return ModItems.throwable_hole_filler_smart;
        }
        if (this.GetFillerType() == HoleUtil.FillerType.water) {
            return ModItems.throwable_hole_filler_water;
        }
        if (this.GetFillerType() == HoleUtil.FillerType.lava) {
            return ModItems.throwable_hole_filler_lava;
        }
        if (this.GetFillerType() == HoleUtil.FillerType.light) {
            return ModItems.throwable_hole_filler_light;
        }
        if (this.GetFillerType() == HoleUtil.FillerType.dark) {
            return ModItems.throwable_hole_filler_dark;
        }
        return ModItems.throwable_hole_filler;
    }

    public void Start() {
        if (this.thrower == null) {
            return;
        }
        class_1661 inv = this.thrower.method_31548();
        if (this.creativeMode || inv != null && IH.HasStack((class_1263)inv, H.Single(this.GetBlockToPlace(this.field_11867)), true)) {
            boolean useGravity = this.GetBlockToPlace(this.field_11867) != null && this.GetBlockToPlace(this.field_11867) instanceof class_2346;
            this.thrower.method_7353(H.Text("Calculating...."), true);
            this.holedata = new HoleData(this.field_11863, (class_2382)this.field_11867, this.GetFillerType(), useGravity);
            if (IH.Take((class_1263)inv, H.Single(this.GetBlockToPlace(this.field_11867)), this.creativeMode, true)) {
                this.running = true;
            }
        } else {
            if (!this.thrower.method_31549().field_7477) {
                class_1542 entity = new class_1542(this.field_11863, this.thrower.method_23317(), this.thrower.method_23318(), this.thrower.method_23321(), new class_1799((class_1935)this.GetThrowableItem(), 1));
                this.field_11863.method_8649((class_1297)entity);
            }
            this.field_11863.method_8501(this.field_11867, class_2246.field_10124.method_9564());
            this.EndPlacement("Missing Resources");
        }
    }

    void EndPlacement(String message) {
        this.running = false;
        if (this.thrower != null & message != null) {
            this.thrower.method_7353(H.Text(message), true);
        }
    }

    public void Fill() {
        if (this.holedata == null || this.thrower == null) {
            return;
        }
        class_1661 inv = this.thrower.method_31548();
        int blocksPerTick = ConfigHoleFiller.Instance.fill_speed;
        int min = Math.min(blocksPerTick, this.holedata.emptyVolume.size());
        for (int i = 0; i < min; ++i) {
            class_2382 vec = this.holedata.emptyVolume.firstElement();
            if (!this.TakeAndPlace((class_1263)inv, this.GetBlockToPlace(vec))) {
                this.EndPlacement("Missing Resources: " + H.Single(this.GetBlockToPlace(vec)).method_7964().getString());
            }
            class_2338 vecPos = new class_2338(vec);
            this.field_11863.method_8408(vecPos, this.field_11863.method_8320(vecPos).method_26204());
            this.TellListeners();
        }
        if (min > 0) {
            this.field_11863.method_8408(this.field_11867, this.field_11863.method_8320(this.field_11867).method_26204());
            this.TellListeners();
        }
    }

    public boolean TakeAndPlace(class_1263 inv, class_2248 block) {
        if (block == null) {
            return false;
        }
        class_2382 vec = this.holedata.emptyVolume.firstElement();
        if ((this.creativeMode || inv != null && IH.HasStack(inv, H.Single(block), true)) && HoleUtil.IsReplaceableBlock(this.field_11863, new class_2338(vec)) && (this.creativeMode || IH.Take(inv, H.Single(block), this.creativeMode, true))) {
            this.holedata.filledVolume.put(vec, new CuringState(vec, block));
            this.field_11863.method_8501(new class_2338(vec), ModBlocks.curing_block.method_9564());
            this.holedata.emptyVolume.remove(0);
            return true;
        }
        this.holedata.emptyVolume.remove(0);
        return false;
    }

    public void DropInventory(class_1657 player, boolean includeSelf) {
        if (this.creativeMode || player.method_31549().field_7477 || this.holedata == null) {
            return;
        }
        int count = this.holedata.filledVolume.size() + (includeSelf ? 1 : 0);
        for (int i = 0; i < count; ++i) {
            H.Drop(this.field_11863, this.creativeMode, this.GetBlockToPlace(H.Vec3iFromDouble(player.method_23317(), player.method_23318(), player.method_23321())), player.method_23317(), player.method_23318(), player.method_23321());
        }
    }

    void TellListeners() {
        class_2680 state = this.field_11863.method_8320(this.field_11867);
        this.field_11863.method_8413(this.field_11867, state, state, 2);
    }

    public class_2248 GetBlockToPlace(class_2338 pos) {
        return class_2246.field_10566;
    }

    public class_2248 GetBlockToPlace(class_2382 pos) {
        return this.GetBlockToPlace(new class_2338(pos.method_10263(), pos.method_10264(), pos.method_10260()));
    }

    public class_2622 toUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887() {
        class_2487 nbt = new class_2487();
        this.writeClientNbt(nbt);
        return nbt;
    }

    private void writeClientNbt(class_2487 nbt) {
        this.method_11007(nbt);
    }
}

