/*
 * Decompiled with CFR 0.152.
 */
package com.dannyboythomas.hole_filler_mod.tiles;

import com.dannyboythomas.hole_filler_mod.config.ConfigHoleFiller;
import com.dannyboythomas.hole_filler_mod.init.ModBlocks;
import com.dannyboythomas.hole_filler_mod.init.ModTiles;
import com.dannyboythomas.hole_filler_mod.tiles.TileHoleFillerBase;
import com.dannyboythomas.hole_filler_mod.util.HoleData;
import com.dannyboythomas.hole_filler_mod.util.HoleUtil;
import com.dannyboythomas.hole_filler_mod.util.IH;
import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;

public class TileHoleFillerLight
extends TileHoleFillerBase {
    public static int minLightLevel = 8;
    public static int lightsPerTorch = 6;
    boolean actuallyTake = false;

    public TileHoleFillerLight(class_2338 pos, class_2680 state) {
        super(ModTiles.HOLE_FILLER_LIGHT, pos, state);
    }

    @Override
    HoleUtil.FillerType GetFillerType() {
        return HoleUtil.FillerType.light;
    }

    @Override
    public class_2248 GetBlockToPlace(class_2338 vec) {
        return ModBlocks.light_block;
    }

    @Override
    public void method_11014(class_2487 nbt) {
        nbt.method_10569("min_light_level", minLightLevel);
        nbt.method_10556("taken", this.actuallyTake);
        super.method_11014(nbt);
    }

    @Override
    public void method_11007(class_2487 nbt) {
        minLightLevel = nbt.method_10550("min_light_level");
        this.actuallyTake = nbt.method_10577("taken");
        super.method_11007(nbt);
    }

    @Override
    public void DropInventory(class_1657 player, boolean includeSelf) {
    }

    public void SetMinLightLevel(int level) {
        minLightLevel = level < 8 ? 8 : level;
    }

    public static <T extends class_2586> void tick(class_1937 world, class_2338 pos, class_2680 state, T blockEntity) {
        boolean canRunOnServer;
        if (world.field_9236) {
            return;
        }
        TileHoleFillerBase te = (TileHoleFillerBase)world.method_8321(pos);
        ++te.timer;
        boolean throwerOnline = te.thrower != null && te.thrower.method_5682().method_3760().method_14571().contains(te.thrower);
        boolean bl = canRunOnServer = te.creativeMode || throwerOnline;
        if (te.running && canRunOnServer & te.timer % 1 == 0) {
            te.Fill();
            if (te.holedata.emptyVolume.size() <= 0) {
                world.method_8501(pos, class_2246.field_10124.method_9564());
            }
        }
        if (te.timer > 4800) {
            world.method_8501(pos, te.GetBlockToPlace(pos).method_9564());
        }
    }

    @Override
    public void Start() {
        if (this.thrower == null) {
            return;
        }
        class_1661 inv = this.thrower.method_31548();
        class_1799 toTake = new class_1799((class_1935)class_1802.field_8810, 1);
        if (this.creativeMode || inv != null && IH.HasStack((class_1263)inv, toTake, true)) {
            boolean useGravity = false;
            this.holedata = new HoleData(this.field_11863, (class_2382)this.field_11867, minLightLevel);
            this.running = true;
        } else {
            if (!this.thrower.method_31549().field_7477) {
                class_1542 entity = new class_1542(this.field_11863, this.thrower.method_23317(), this.thrower.method_23318(), this.thrower.method_23321(), new class_1799((class_1935)this.GetThrowableItem(), 1));
                this.field_11863.method_8649((class_1297)entity);
            }
            this.field_11863.method_8501(this.field_11867, class_2246.field_10124.method_9564());
            this.EndPlacement("Missing Resources");
        }
    }

    @Override
    public void Fill() {
        if (this.holedata == null || this.thrower == null) {
            return;
        }
        class_1661 inv = this.thrower.method_31548();
        int blocksPerTick = ConfigHoleFiller.Instance.fill_speed;
        int min = Math.min(blocksPerTick, this.holedata.emptyVolume.size());
        int prevVolume = this.holedata.emptyVolume.size();
        int tpl = ConfigHoleFiller.Instance.torch_places_n_light_sources;
        for (int i = 0; i < min; ++i) {
            class_2382 vec = this.holedata.emptyVolume.firstElement();
            boolean bl = this.actuallyTake = (prevVolume + i) % tpl == 0;
            if (this.TakeAndPlace((class_1263)inv, this.GetBlockToPlace(vec))) continue;
            this.EndPlacement("Missing Resources: Torch");
        }
        if (min > 0) {
            this.field_11863.method_8408(this.field_11867, this.field_11863.method_8320(this.field_11867).method_26204());
            this.TellListeners();
        }
    }

    @Override
    public boolean TakeAndPlace(class_1263 inv, class_2248 block) {
        class_1799 toTake = new class_1799((class_1935)class_1802.field_8810, 1);
        class_2382 vec = this.holedata.emptyVolume.firstElement();
        if ((this.creativeMode || !this.actuallyTake || inv != null && IH.HasStack(inv, toTake, true)) && this.field_11863.method_22347(new class_2338(vec)) && (this.creativeMode || !this.actuallyTake || IH.Take(inv, toTake, this.creativeMode, true))) {
            this.field_11863.method_8501(new class_2338(vec), ModBlocks.light_block.method_9564());
            this.field_11863.method_8408(this.field_11867, this.field_11863.method_8320(this.field_11867).method_26204());
            this.holedata.emptyVolume.remove(0);
            return true;
        }
        this.holedata.emptyVolume.remove(0);
        return false;
    }
}

