/*
 * Decompiled with CFR 0.152.
 */
package com.dannyboythomas.hole_filler_mod.util;

import com.dannyboythomas.hole_filler_mod.config.ConfigHoleFiller;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.UUID;
import java.util.Vector;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public class H {
    public static ArrayList<class_2382> DirectionVectors = new ArrayList<class_2382>(Arrays.asList(new class_2382(-1, 0, 0), new class_2382(1, 0, 0), new class_2382(0, 0, -1), new class_2382(0, 0, 1), new class_2382(0, -1, 0), new class_2382(0, 1, 0)));

    public static class_2382 Vec3iFromDouble(double x, double y, double z) {
        return new class_2382((int)x, (int)y, (int)z);
    }

    public static class_2338 BlockPosFromDouble(double x, double y, double z) {
        return new class_2338((int)x, (int)y, (int)z);
    }

    public static class_2382 GetDirection(Directions dir) {
        int index = dir.ordinal();
        return DirectionVectors.get(index);
    }

    public static class_2382 Multiply(class_2382 vec, float a) {
        float x = (float)vec.method_10263() * a;
        float y = (float)vec.method_10264() * a;
        float z = (float)vec.method_10260() * a;
        return H.Vec3iFromDouble(x, y, z);
    }

    public static class_243 Divide(class_2382 vec, float a) {
        float x = (float)vec.method_10263() / a;
        float y = (float)vec.method_10264() / a;
        float z = (float)vec.method_10260() / a;
        return new class_243((double)x, (double)y, (double)z);
    }

    public static class_2382 DivideAndRound(class_2382 vec, float a) {
        float x = (float)vec.method_10263() / a;
        float y = (float)vec.method_10264() / a;
        float z = (float)vec.method_10260() / a;
        return new class_2382(Math.round(x), Math.round(y), Math.round(z));
    }

    public static class_2382 Opposite(class_2382 vec) {
        return H.Multiply(vec, -1.0f);
    }

    public static class_2382 Add(class_2382 vec, class_2382 vec2) {
        float x = vec.method_10263() + vec2.method_10263();
        float y = vec.method_10264() + vec2.method_10264();
        float z = vec.method_10260() + vec2.method_10260();
        return H.Vec3iFromDouble(x, y, z);
    }

    public static class_2382 Subtract(class_2382 vec, class_2382 vec2) {
        float x = vec.method_10263() - vec2.method_10263();
        float y = vec.method_10264() - vec2.method_10264();
        float z = vec.method_10260() - vec2.method_10260();
        return H.Vec3iFromDouble(x, y, z);
    }

    public static double Magnitude(class_2382 vec) {
        double total = Math.pow(vec.method_10263(), 2.0) + Math.pow(vec.method_10264(), 2.0) + Math.pow(vec.method_10260(), 2.0);
        double ans = Math.sqrt(total);
        return ans;
    }

    public static ArrayList<class_2382> RandomDirectionOrder() {
        ArrayList copy = (ArrayList)DirectionVectors.clone();
        Collections.shuffle(copy);
        return copy;
    }

    public static class_2382 GetCentreFromBounds(Vector<class_2382> vecs) {
        int minX = H.MinVecValue(vecs, 0);
        int minY = H.MinVecValue(vecs, 1);
        int minZ = H.MinVecValue(vecs, 2);
        int maxX = H.MaxVecValue(vecs, 0);
        int maxY = H.MaxVecValue(vecs, 1);
        int maxZ = H.MaxVecValue(vecs, 2);
        int centreX = Math.round((float)(minX + maxX) * 0.5f);
        int centreY = Math.round((float)(minY + maxY) * 0.5f);
        int centreZ = Math.round((float)(minZ + maxZ) * 0.5f);
        return new class_2382(centreX, centreY, centreZ);
    }

    public static int MinVecValue(Vector<class_2382> vecs, int index) {
        int min = 999999999;
        for (int i = 0; i < vecs.size(); ++i) {
            class_2382 vec = vecs.get(i);
            int[] array = H.ToArray(vec);
            int value = array[index];
            if (value >= min) continue;
            min = value;
        }
        return min;
    }

    public static int MaxVecValue(Vector<class_2382> vecs, int index) {
        int max = -999999999;
        for (int i = 0; i < vecs.size(); ++i) {
            class_2382 vec = vecs.get(i);
            int[] array = H.ToArray(vec);
            int value = array[index];
            if (value <= max) continue;
            max = value;
        }
        return max;
    }

    public static String ToString(class_2338 pos) {
        String s = "[x: " + pos.method_10263() + ", y: " + pos.method_10264() + ", z: " + pos.method_10260() + "]";
        return s;
    }

    public static class_2338 Convert(int[] array) {
        return new class_2338(array[0], array[1], array[2]);
    }

    public static int[] ToArray(class_2382 vec) {
        return new int[]{vec.method_10263(), vec.method_10264(), vec.method_10260()};
    }

    public static int Map(int n, int a, int b, int x, int y) {
        return x + (n - a) * (y - x) / (b - a);
    }

    public static double GetDistance(class_243 vec1, class_243 vec2) {
        if (vec1 == null || vec2 == null) {
            return 0.0;
        }
        double xDif = Math.abs(vec1.field_1352 - vec2.field_1352);
        double yDif = Math.abs(vec1.field_1351 - vec2.field_1351);
        double zDif = Math.abs(vec1.field_1350 - vec2.field_1350);
        double total = Math.pow(xDif, 2.0) + Math.pow(yDif, 2.0) + Math.pow(zDif, 2.0);
        double ans = Math.sqrt(total);
        return ans;
    }

    public static double GetDistance(class_2382 vec1, class_2382 vec2) {
        return H.GetDistance(H.Vec3d(vec1), H.Vec3d(vec2));
    }

    public static class_243 Vec3d(class_2338 pos) {
        return new class_243((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260());
    }

    public static class_243 Vec3d(class_2382 pos) {
        if (pos == null) {
            return null;
        }
        return new class_243((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260());
    }

    public static class_2382 Convert(class_2338 pos) {
        return new class_2382(pos.method_10263(), pos.method_10264(), pos.method_10260());
    }

    public static Vector<class_2382> GetNeighbourPositions(class_2382 vec) {
        ArrayList<class_2382> dirs = DirectionVectors;
        Vector<class_2382> list = new Vector<class_2382>();
        for (int i = 0; i < dirs.size(); ++i) {
            class_2382 dir = dirs.get(i);
            list.add(H.Add(vec, dir));
        }
        return list;
    }

    public static Vector<class_2382> GetSameBlockNeighbours(class_1937 world, class_2382 vec) {
        class_2248 thisBlock = world.method_8320(new class_2338(vec)).method_26204();
        ArrayList<class_2382> dirs = DirectionVectors;
        Vector<class_2382> list = new Vector<class_2382>();
        for (int i = 0; i < dirs.size(); ++i) {
            class_2382 dir = dirs.get(i);
            class_2382 pos = H.Add(vec, dir);
            if (world.method_8320(new class_2338(pos)).method_26204() != thisBlock) continue;
            list.add(pos);
        }
        return list;
    }

    public static Vector<class_2382> GetSameBlockVein(class_1937 world, class_2382 vec) {
        Vector<class_2382> list = new Vector<class_2382>();
        class_2248 thisBlock = world.method_8320(new class_2338(vec)).method_26204();
        list.add(vec);
        int size = list.size();
        int maxLoop = 100;
        int loop = 0;
        while (loop++ < maxLoop) {
            for (int i = 0; i < size; ++i) {
                Vector<class_2382> neighbours = H.GetSameBlockNeighbours(world, list.get(i));
                for (int j = 0; j < neighbours.size(); ++j) {
                    if (list.contains(neighbours.get(j))) continue;
                    list.add(neighbours.get(j));
                }
            }
            if (size == list.size()) break;
            size = list.size();
        }
        return list;
    }

    public static class_2382 WorldPosToBlockPos(double x, double y, double z) {
        int x1 = (int)Math.round(x + 0.5);
        int y1 = (int)Math.round(y + 0.5);
        int z1 = (int)Math.round(z + 0.5);
        return new class_2382(x1, y1, z1);
    }

    public static class_2382 WorldPosToBlockPos(class_243 vec) {
        int x1 = (int)Math.round(vec.field_1352);
        int y1 = (int)Math.round(vec.field_1351 - 0.5);
        int z1 = (int)Math.round(vec.field_1350);
        return new class_2382(x1, y1, z1);
    }

    public static float Clamp(float value, float min, float max) {
        return Math.max(min, Math.min(max, value));
    }

    public static int Clamp(int value, int min, int max) {
        return Math.max(min, Math.min(max, value));
    }

    public static UUID GetPlayerID(class_1657 player) {
        if (player == null) {
            return null;
        }
        return player.method_7334().getId();
    }

    public static String GetPlayerIDString(class_1657 player) {
        if (player == null) {
            return "";
        }
        return player.method_7334().getId().toString();
    }

    public static class_1657 GetPlayerFromID(class_1937 world, UUID id) {
        if (world == null || world.field_9236 || id == null) {
            return null;
        }
        return world.method_8503().method_3760().method_14602(id);
    }

    public static class_1657 GetPlayerFromIDString(class_1937 world, String id) {
        if (world.field_9236 || id.isEmpty()) {
            return null;
        }
        return world.method_8503().method_3760().method_14602(UUID.fromString(id));
    }

    public static class_2248 BlockFromName(String name) {
        class_2960 id = new class_2960(name);
        class_2248 block = (class_2248)class_7923.field_41175.method_10223(id);
        return block;
    }

    public static String GetBlockName(class_2248 block) {
        class_2960 id = class_7923.field_41175.method_10221((Object)block);
        return id.toString();
    }

    public static class_1792 ItemFromName(String name) {
        class_2960 id = new class_2960(name);
        class_1792 item = (class_1792)class_7923.field_41178.method_10223(id);
        return item;
    }

    public static String GetItemName(class_1792 item) {
        class_2960 id = class_7923.field_41178.method_10221((Object)item);
        return id.toString();
    }

    public static class_1799 Single(class_2248 block) {
        if (block == null) {
            return class_1799.field_8037;
        }
        return new class_1799((class_1935)block.method_8389(), 1);
    }

    public static void Drop(class_1937 world, boolean creative, class_2248 block, double x, double y, double z) {
        if (block == null) {
            return;
        }
        class_1799 stack = H.Single(block);
        if (creative) {
            return;
        }
        if (world.field_9236) {
            return;
        }
        if (block == class_2246.field_10566 && ConfigHoleFiller.Instance.is_dirt_free) {
            return;
        }
        world.method_8649((class_1297)new class_1542(world, x, y, z, stack));
    }

    public static void Drop(class_1937 world, boolean creative, class_2248 block, int count, double x, double y, double z) {
        if (block == null) {
            return;
        }
        class_1799 stack = new class_1799((class_1935)block.method_8389(), count);
        if (creative) {
            return;
        }
        if (world.field_9236) {
            return;
        }
        if (block == class_2246.field_10566 && ConfigHoleFiller.Instance.is_dirt_free) {
            return;
        }
        world.method_8649((class_1297)new class_1542(world, x, y, z, stack));
    }

    public static class_2561 Text(String s) {
        return class_2561.method_43470((String)s);
    }

    public static enum Directions {
        down,
        up,
        xMinus,
        xPlus,
        zMinus,
        zPlus;

    }
}

