/*
 * Decompiled with CFR 0.152.
 */
package com.dannyboythomas.hole_filler_mod.util;

import com.dannyboythomas.hole_filler_mod.blocks.BlockHoleFillerLight;
import com.dannyboythomas.hole_filler_mod.blocks.BlockLight;
import com.dannyboythomas.hole_filler_mod.blocks.BlockVeinBreakable;
import com.dannyboythomas.hole_filler_mod.config.ConfigHoleFiller;
import com.dannyboythomas.hole_filler_mod.util.H;
import com.dannyboythomas.hole_filler_mod.util.HoleUtil;
import com.dannyboythomas.hole_filler_mod.util.OrderByDistance;
import com.dannyboythomas.hole_filler_mod.util.OrderByHeight;
import com.dannyboythomas.hole_filler_mod.util.smart.CuringState;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.Vector;
import java.util.stream.Collectors;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2680;

public class HoleData {
    public class_2382 source;
    public Vector<class_2382> preVolume;
    public HashMap<class_2382, CuringState> filledVolume;
    public HashMap<class_2382, class_2248> volume;
    public Vector<class_2382> emptyVolume;

    public HoleData(class_1937 world, class_2382 _source, HoleUtil.FillerType fillerType, boolean gravity) {
        this.source = _source;
        this.preVolume = new Vector();
        this.volume = new HashMap();
        if (fillerType == HoleUtil.FillerType.water || fillerType == HoleUtil.FillerType.lava) {
            this.preVolume = HoleUtil.GetWaterHole(world, this.source);
        } else if (fillerType == HoleUtil.FillerType.dark) {
            Vector tiles = new Vector();
            this.preVolume = HoleUtil.GetHole(world, this.source);
            this.preVolume = this.preVolume.stream().filter(vec -> {
                class_2338 pos = new class_2338(vec);
                class_2248 block = world.method_8320(pos).method_26204();
                return block instanceof BlockLight || block instanceof BlockHoleFillerLight;
            }).collect(Collectors.toCollection(() -> new Vector()));
        } else {
            this.preVolume = HoleUtil.GetHole(world, this.source);
            this.ApplyBlockTypesToPositions(world, fillerType);
            this.Order(gravity);
        }
        this.filledVolume = new HashMap();
        this.emptyVolume = this.preVolume;
        this.emptyVolume.remove(this.source);
    }

    public HoleData(class_1937 world, class_2382 _source, int minLightLevel) {
        this.source = _source;
        this.preVolume = new Vector();
        this.volume = new HashMap();
        this.preVolume = HoleUtil.GetLightPositions(world, this.source, minLightLevel);
        this.filledVolume = new HashMap();
        this.emptyVolume = this.preVolume;
        this.emptyVolume.remove(this.source);
    }

    public HoleData(class_2382 _source) {
        this.source = _source;
        this.preVolume = new Vector();
        this.volume = new HashMap();
        this.filledVolume = new HashMap();
        this.emptyVolume = this.preVolume;
        this.emptyVolume.remove(this.source);
    }

    public void Order(boolean gravity) {
        if (gravity) {
            this.preVolume.sort(new OrderByHeight(H.Vec3d(this.source)));
        } else {
            this.preVolume.sort(new OrderByDistance(H.Vec3d(this.source)));
        }
    }

    public void ApplyBlockTypesToPositions(class_1937 world, HoleUtil.FillerType fillerType) {
        if (fillerType == HoleUtil.FillerType.smart) {
            this.volume = HoleUtil.EstimateHoleBlockTypes(world, this.preVolume, 5);
        }
    }

    public boolean TickCuringStates(class_1937 world, class_1657 player) {
        int seconds = ConfigHoleFiller.Instance.undo_timer;
        int ticks = seconds * 20;
        float incr = 1.0f / (float)ticks;
        Vector<class_2382> toRemove = new Vector<class_2382>();
        boolean markForRemoval = false;
        for (Map.Entry<class_2382, CuringState> entry : this.filledVolume.entrySet()) {
            CuringState state = entry.getValue();
            float progressBefore = state.progress;
            float p = state.IncreaseProgress(incr);
            if (p == 1.0f && progressBefore != p && world.method_8320(new class_2338(state.pos)).method_26204() instanceof BlockVeinBreakable) {
                HoleData.spawnParticles(world, new class_2338(state.pos));
                world.method_8501(new class_2338(state.pos), state.block.method_9564());
                toRemove.add(entry.getKey());
                continue;
            }
            if (world.method_8320(new class_2338(state.pos)).method_26204() instanceof BlockVeinBreakable) continue;
            markForRemoval = true;
            toRemove.add(entry.getKey());
            if (player.method_31549().field_7477) continue;
            class_243 dropPos = player != null ? player.method_19538() : H.Vec3d(state.pos);
            class_1542 drop = new class_1542(world, dropPos.method_10216(), dropPos.method_10214(), dropPos.method_10215(), new class_1799((class_1935)state.block.method_8389(), 1));
            world.method_8649((class_1297)drop);
        }
        for (int i = 0; i < toRemove.size(); ++i) {
            this.filledVolume.remove(toRemove.get(i));
        }
        return this.filledVolume.size() == 0 || markForRemoval;
    }

    private static void spawnParticles(class_1937 world, class_2338 blockPos) {
        double d0 = 0.5625;
        Random random = new Random();
        for (class_2350 direction : class_2350.values()) {
            class_2338 blockpos = blockPos.method_10093(direction);
            if (world.method_8320(blockpos).method_26225()) continue;
            class_2350.class_2351 direction$axis = direction.method_10166();
            double d1 = direction$axis == class_2350.class_2351.field_11048 ? 0.5 + 0.5625 * (double)direction.method_10148() : (double)random.nextFloat();
            double d2 = direction$axis == class_2350.class_2351.field_11052 ? 0.5 + 0.5625 * (double)direction.method_10164() : (double)random.nextFloat();
            double d = direction$axis == class_2350.class_2351.field_11051 ? 0.5 + 0.5625 * (double)direction.method_10165() : (double)random.nextFloat();
        }
    }

    /*
     * WARNING - void declaration
     */
    public class_2487 Write(class_2487 nbt) {
        void var5_8;
        ArrayList<Integer> volumeList = new ArrayList<Integer>();
        for (int i = 0; i < this.preVolume.size(); ++i) {
            class_2382 vec = this.preVolume.get(i);
            volumeList.add(vec.method_10263());
            volumeList.add(vec.method_10264());
            volumeList.add(vec.method_10260());
        }
        class_2499 filledList = new class_2499();
        for (Map.Entry entry : this.filledVolume.entrySet()) {
            CuringState curingState = (CuringState)entry.getValue();
            class_2487 stateNBT = curingState.Write();
            filledList.add((Object)stateNBT);
        }
        ArrayList<Integer> emptyList = new ArrayList<Integer>();
        boolean bl = false;
        while (var5_8 < this.emptyVolume.size()) {
            class_2382 vec = this.emptyVolume.get((int)var5_8);
            emptyList.add(vec.method_10263());
            emptyList.add(vec.method_10264());
            emptyList.add(vec.method_10260());
            ++var5_8;
        }
        nbt.method_10572("volume_list", volumeList);
        nbt.method_10566("filled_list", (class_2520)filledList);
        nbt.method_10572("empty_list", emptyList);
        class_2499 class_24992 = new class_2499();
        for (Map.Entry<class_2382, class_2248> entry : this.volume.entrySet()) {
            if (entry.getValue() == null) continue;
            class_2487 listItem = new class_2487();
            listItem.method_10539("pos", H.ToArray(entry.getKey()));
            listItem.method_10582("block_name", H.GetBlockName(entry.getValue()));
            class_24992.add((Object)listItem);
        }
        nbt.method_10566("block_list", (class_2520)class_24992);
        return nbt;
    }

    public static HoleData Read(class_2680 state, class_2487 nbt, class_2382 pos) {
        int i;
        HoleData data = new HoleData(pos);
        int[] volumeArray = nbt.method_10561("volume_list");
        data.preVolume = new Vector();
        if (volumeArray != null) {
            int posCount = volumeArray.length / 3;
            for (i = 0; i < posCount; ++i) {
                int o = i * 3;
                class_2382 newVec = new class_2382(volumeArray[o], volumeArray[o + 1], volumeArray[o + 2]);
                data.preVolume.add(newVec);
            }
        }
        class_2499 filledArray = nbt.method_10554("filled_list", 10);
        data.filledVolume = new HashMap();
        if (filledArray != null) {
            for (i = 0; i < filledArray.size(); ++i) {
                class_2487 tag = filledArray.method_10602(i);
                CuringState curingState = new CuringState(tag);
                data.filledVolume.put(curingState.pos, curingState);
            }
        }
        int[] emptyArray = nbt.method_10561("empty_list");
        data.emptyVolume = new Vector();
        if (emptyArray != null) {
            int posCount = emptyArray.length / 3;
            for (int i2 = 0; i2 < posCount; ++i2) {
                int o = i2 * 3;
                class_2382 newVec = new class_2382(emptyArray[o], emptyArray[o + 1], emptyArray[o + 2]);
                data.emptyVolume.add(newVec);
            }
        }
        data.volume = new HashMap();
        class_2499 allBlocks = nbt.method_10554("block_list", 10);
        for (int i3 = 0; i3 < allBlocks.size(); ++i3) {
            class_2487 listItem = allBlocks.method_10602(i3);
            class_2338 v = H.Convert(listItem.method_10561("pos"));
            String blockName = listItem.method_10558("block_name");
            class_2248 block = H.BlockFromName(blockName);
            data.volume.put((class_2382)v, block);
        }
        return data;
    }
}

