/*
 * Decompiled with CFR 0.152.
 */
package com.dannyboythomas.hole_filler_mod.util;

import com.dannyboythomas.hole_filler_mod.blocks.BlockCuring;
import com.dannyboythomas.hole_filler_mod.blocks.BlockHoleFillerBase;
import com.dannyboythomas.hole_filler_mod.blocks.BlockLight;
import com.dannyboythomas.hole_filler_mod.blocks.BlockVeinBreakable;
import com.dannyboythomas.hole_filler_mod.config.ConfigHoleFiller;
import com.dannyboythomas.hole_filler_mod.util.H;
import com.dannyboythomas.hole_filler_mod.util.smart.BlurredBlock;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2397;
import net.minecraft.class_2465;
import net.minecraft.class_2680;
import net.minecraft.class_2766;
import net.minecraft.class_3965;

public class HoleUtil {
    public static class_2248 GetSmartFillBlock() {
        FillBlock type = ConfigHoleFiller.smart_preserve_fill_block_enum;
        if (type == FillBlock.cobblestone) {
            return class_2246.field_10445;
        }
        if (type == FillBlock.stone) {
            return class_2246.field_10340;
        }
        return class_2246.field_10566;
    }

    public static boolean IsReplaceableBlock(class_1937 world, class_2338 posi) {
        class_2680 state = world.method_8320(posi);
        class_2248 block = state.method_26204();
        return world.method_22347(posi) || state.method_45474() && !(block instanceof BlockVeinBreakable) || block instanceof BlockLight;
    }

    public static boolean IsValidBoundaryBlock(class_1937 world, class_2338 posi) {
        class_2680 state = world.method_8320(posi);
        class_2248 block = state.method_26204();
        boolean res = !world.method_22347(posi) && state.method_26225() && state.method_26212((class_1922)world, posi) && !(block instanceof class_2397) && !HoleUtil.DoesMimicLog(world, state, posi);
        boolean isHFM = block instanceof BlockHoleFillerBase || block instanceof BlockCuring;
        return res || isHFM;
    }

    public static boolean DoesMimicLog(class_1937 world, class_2680 state, class_2338 pos) {
        boolean isPillar = state.method_26204() instanceof class_2465;
        boolean isBass = state.method_51364() == class_2766.field_12651;
        boolean isIgnited = state.method_50011();
        boolean str2 = state.method_26214((class_1922)world, pos) == 2.0f;
        return isPillar && isBass && isIgnited && str2;
    }

    public static boolean IsValidSelectableBlock(class_1937 world, class_2338 pos) {
        class_2680 state = world.method_8320(pos);
        class_2248 block = state.method_26204();
        return state.method_26225() && state.method_26212((class_1922)world, pos) && !state.method_31709();
    }

    public static class_2248 GetSimilarBlockFast(class_1937 world, class_2382 centre) {
        HashMap<class_2248, Float> blockScores = new HashMap<class_2248, Float>();
        class_2382 zero = new class_2382(0, 0, 0);
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                for (int k = -1; k <= 1; ++k) {
                    class_2382 offset = new class_2382(i, j, k);
                    if (offset == zero) continue;
                    int m = Math.abs(i) + Math.abs(j) + Math.abs(k);
                    boolean isCorner = m == 3;
                    boolean isAdjacent = m == 1;
                    boolean isBelow = j == -1;
                    boolean isFlat = j == 0;
                    float multiplier = 0.0f;
                    multiplier += isFlat ? 13.1f : 0.0f;
                    multiplier += isAdjacent ? 6.1f : 0.0f;
                    multiplier += isCorner ? 1.0f : 0.0f;
                    float multi = multiplier += isBelow ? 1.2f : 0.0f;
                    class_2382 pos = H.Add(centre, offset);
                    class_2338 bPos = new class_2338(pos);
                    class_2680 state = world.method_8320(bPos);
                    if (!HoleUtil.IsValidSelectableBlock(world, bPos)) continue;
                    class_2248 block = state.method_26204();
                    blockScores.computeIfPresent(block, (a, b) -> Float.valueOf(b.floatValue() + multi));
                    blockScores.putIfAbsent(block, Float.valueOf(multiplier));
                }
            }
        }
        class_2248 targetBlock = class_2246.field_10566;
        Map.Entry maxEntry = null;
        for (Map.Entry entry : blockScores.entrySet()) {
            if (maxEntry != null && ((Float)entry.getValue()).compareTo((Float)maxEntry.getValue()) <= 0) continue;
            maxEntry = entry;
        }
        return maxEntry != null ? (class_2248)maxEntry.getKey() : targetBlock;
    }

    public static HashMap<class_2382, class_2248> EstimateHoleBlockTypes(class_1937 world, Vector<class_2382> vecs, int kernelSize) {
        HashMap<class_2382, BlurredBlock> blockMap = new HashMap<class_2382, BlurredBlock>();
        for (int i = 0; i < vecs.size(); ++i) {
            class_2382 vec = vecs.get(i);
            BlurredBlock newBlock = new BlurredBlock(vec);
            blockMap.put(vec, newBlock);
        }
        int passNum = 6;
        for (int n = 0; n < passNum; ++n) {
            for (Map.Entry entry : blockMap.entrySet()) {
                ((BlurredBlock)entry.getValue()).GetNewSurroundingsPopularity(world, kernelSize, blockMap, n);
            }
            for (Map.Entry entry : blockMap.entrySet()) {
                ((BlurredBlock)entry.getValue()).UpdateScores();
            }
        }
        HashMap<class_2382, class_2248> blocksToPlace = new HashMap<class_2382, class_2248>();
        for (Map.Entry entry : blockMap.entrySet()) {
            ((BlurredBlock)entry.getValue()).UpdateScores();
            blocksToPlace.put((class_2382)entry.getKey(), ((BlurredBlock)entry.getValue()).Best());
        }
        return blocksToPlace;
    }

    public static boolean CanOverrideBlockTypePriority(class_1937 world, class_2382 vec, class_2248 block, HashMap<class_2382, class_2248> volume) {
        if (block == class_2246.field_10219) {
            class_2338 pos = new class_2338(vec);
            class_2382 dir = new class_2382(0, 1, 0);
            class_2338 check = pos.method_10081(dir);
            boolean res = !volume.containsKey(check) && !HoleUtil.IsValidBoundaryBlock(world, check);
            return res;
        }
        return false;
    }

    public static boolean IsSurfaceBlock(class_1937 world, class_2382 vec, HashMap<class_2382, class_2248> volume) {
        Vector<class_2382> neighs = H.GetNeighbourPositions(vec);
        int count = 0;
        for (int i = 0; i < neighs.size(); ++i) {
            class_2338 pos = new class_2338(neighs.get(i));
            if (!HoleUtil.IsValidBoundaryBlock(world, pos) && !volume.containsKey(pos)) continue;
            ++count;
        }
        return count <= 5;
    }

    public static Vector<class_2382> GetHole(class_1937 world, class_2382 source) {
        long start = System.nanoTime();
        HashMap<class_2382, Boolean> foundCheckMap = new HashMap<class_2382, Boolean>();
        Vector<class_2382> found = new Vector<class_2382>();
        found.add(source);
        Vector<class_2382> volumeToCheck = (Vector<class_2382>)found.clone();
        ArrayList<class_2382> dirs = H.DirectionVectors;
        int foundCount = found.size();
        int maxLoop = 3000;
        int loop = 0;
        int maxVolume = ConfigHoleFiller.Instance.max_hole_volume;
        while (loop++ < maxLoop) {
            Vector<class_2382> checkNext = new Vector<class_2382>();
            for (int i = 0; i < volumeToCheck.size(); ++i) {
                class_2382 centre = (class_2382)volumeToCheck.get(i);
                for (int j = 0; j < dirs.size(); ++j) {
                    class_2382 dir = dirs.get(j);
                    for (int k = 1; k < 2; ++k) {
                        class_2382 test = H.Add(centre, H.Multiply(dir, k));
                        if (!HoleUtil.IsValidHole(world, foundCheckMap, test, false) || foundCheckMap.getOrDefault(test, false).booleanValue()) continue;
                        foundCheckMap.put(test, true);
                        found.add(test);
                        checkNext.add(test);
                        if (found.size() < maxVolume) continue;
                        long endTime = System.nanoTime();
                        long time = endTime - start;
                        time /= 1000000L;
                        return found;
                    }
                }
            }
            if (foundCount == found.size()) break;
            volumeToCheck = checkNext;
        }
        long endTime = System.nanoTime();
        long time = endTime - start;
        time /= 1000000L;
        return found;
    }

    public static boolean IsValidHole(class_1937 world, HashMap<class_2382, Boolean> foundMap, class_2382 pos, boolean isLiquid) {
        int configMaxDiameter = isLiquid ? ConfigHoleFiller.Instance.max_water_diameter : ConfigHoleFiller.Instance.max_hole_diameter;
        int maxDimension = configMaxDiameter / 2;
        int maxCount = 4;
        int count = 0;
        ArrayList<class_2382> dirs = H.DirectionVectors;
        block0: for (int i = 0; i < dirs.size(); ++i) {
            class_2382 dir = dirs.get(i);
            for (int j = 1; j < maxDimension; ++j) {
                class_2382 spot = H.Add(pos, H.Multiply(dir, j));
                if (!HoleUtil.IsValidBoundaryBlock(world, new class_2338(spot)) && !foundMap.getOrDefault(spot, false).booleanValue()) continue;
                ++count;
                continue block0;
            }
        }
        return count >= maxCount && HoleUtil.IsReplaceableBlock(world, new class_2338(pos));
    }

    public static Vector<class_2382> GetWaterHole(class_1937 world, class_2382 source) {
        long start = System.nanoTime();
        HashMap<class_2382, Boolean> foundCheckMap = new HashMap<class_2382, Boolean>();
        Vector<class_2382> found = new Vector<class_2382>();
        found.add(source);
        Vector<class_2382> volumeToCheck = (Vector<class_2382>)found.clone();
        ArrayList dirs = (ArrayList)H.DirectionVectors.clone();
        dirs.remove(dirs.size() - 1);
        int foundCount = found.size();
        int maxLoop = 3000;
        int loop = 0;
        int maxVolume = ConfigHoleFiller.Instance.max_water_volume;
        while (loop++ < maxLoop) {
            Vector<class_2382> checkNext = new Vector<class_2382>();
            for (int i = 0; i < volumeToCheck.size(); ++i) {
                class_2382 centre = (class_2382)volumeToCheck.get(i);
                for (int j = 0; j < dirs.size(); ++j) {
                    class_2382 dir = (class_2382)dirs.get(j);
                    for (int k = 1; k < 2; ++k) {
                        boolean isLava;
                        class_2382 test = H.Add(centre, H.Multiply(dir, k));
                        class_2248 block = world.method_8320(new class_2338(test)).method_26204();
                        boolean isWater = block == class_2246.field_10382;
                        boolean bl = isLava = block == class_2246.field_10164;
                        if (isLava || isWater || !HoleUtil.IsValidHole(world, foundCheckMap, test, true) || foundCheckMap.getOrDefault(test, false).booleanValue()) continue;
                        foundCheckMap.put(test, true);
                        found.add(test);
                        checkNext.add(test);
                        if (found.size() < maxVolume) continue;
                        long endTime = System.nanoTime();
                        long time = endTime - start;
                        time /= 1000000L;
                        return found;
                    }
                }
            }
            if (foundCount == found.size()) break;
            volumeToCheck = checkNext;
        }
        long endTime = System.nanoTime();
        long time = endTime - start;
        time /= 1000000L;
        return found;
    }

    public static Vector<class_2382> GetLightPositions(class_1937 world, class_2382 source, int minLightLevel) {
        Vector<class_2382> placedLightPos = new Vector<class_2382>();
        Vector<class_2382> hole = HoleUtil.GetHole(world, source);
        for (int i = 0; i < hole.size(); ++i) {
            boolean worldIsBrightEnough;
            class_2382 vec = hole.get(i);
            class_2338 pos = new class_2338(vec);
            if (!world.method_22347(pos)) continue;
            int worldLight = world.method_8314(class_1944.field_9282, pos);
            boolean bl = worldIsBrightEnough = worldLight >= minLightLevel;
            if (worldIsBrightEnough || HoleUtil.GetPotentialLightValue(placedLightPos, vec) >= minLightLevel) continue;
            placedLightPos.add(vec);
        }
        float p = (float)(placedLightPos.size() * 100) / (float)hole.size();
        return placedLightPos;
    }

    public static int GetPotentialLightValue(Vector<class_2382> vecs, class_2382 pos) {
        int highest = 0;
        for (int i = 0; i < vecs.size(); ++i) {
            class_2382 vec = vecs.get(i);
            class_2382 offset = H.Subtract(vec, pos);
            int offsetMag = Math.abs(offset.method_10263()) + Math.abs(offset.method_10264()) + Math.abs(offset.method_10260());
            int lightLevel = 15 - offsetMag;
            if (lightLevel <= highest) continue;
            highest = lightLevel;
        }
        return highest;
    }

    public static class_2338 BlockPosFromImpact(class_3965 result) {
        class_2338 bPos = result.method_17777();
        class_2350 normal = result.method_17780();
        class_2338 target = bPos.method_10093(normal);
        return target;
    }

    public static enum FillBlock {
        cobblestone,
        dirt,
        stone;

    }

    public static enum FillerType {
        simple,
        balanced,
        smart,
        water,
        lava,
        light,
        dark;

    }
}

