/*
 * Decompiled with CFR 0.152.
 */
package net.fryc.imbleeding.mixin;

import net.fryc.imbleeding.ImBleeding;
import net.fryc.imbleeding.util.BleedingHelper;
import net.minecraft.class_1282;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1657.class})
abstract class PlayerEntityMixin
extends class_1309 {
    protected PlayerEntityMixin(class_1299<? extends class_1309> entityType, class_1937 world) {
        super(entityType, world);
    }

    @Inject(method={"applyDamage(Lnet/minecraft/entity/damage/DamageSource;F)V"}, at={@At(value="TAIL")})
    public void applyDamageEffectsOnPlayer(class_1282 source, float amount, CallbackInfo ci) {
        if (BleedingHelper.shouldApplyDarkness(this)) {
            BleedingHelper.applyDarkness(this);
        }
        if (BleedingHelper.canGetBleeding(this) && BleedingHelper.canApplyBleeding(source, amount)) {
            BleedingHelper.applyBleeding(this, source, amount);
        }
        if (BleedingHelper.canGetHealthLoss(this) && BleedingHelper.canApplyHealthLoss(source)) {
            BleedingHelper.applyHealthLoss(this, source, amount);
        }
        if (BleedingHelper.shouldReduceBleedingWithFire(source, this.method_37908())) {
            BleedingHelper.reduceBleedingWithFire(this);
        }
        if (BleedingHelper.shouldApplyBrokenEffect(source, amount, this)) {
            BleedingHelper.applyBrokenEffect(this, amount);
        }
    }

    @Inject(method={"canFoodHeal()Z"}, at={@At(value="RETURN")}, cancellable=true)
    public void noHealing(CallbackInfoReturnable<Boolean> ret) {
        class_1657 player = (class_1657)this;
        if (ImBleeding.config.bleedingStopsFoodHealing && BleedingHelper.shouldStopFoodHealing(player)) {
            ret.setReturnValue((Object)false);
        }
    }

    @Inject(method={"tick()V"}, at={@At(value="TAIL")})
    public void setBlindness(CallbackInfo info) {
        BleedingHelper.applyBlindness(this);
    }
}

