/*
 * Decompiled with CFR 0.152.
 */
package net.fryc.imbleeding.util;

import java.util.concurrent.ThreadLocalRandom;
import net.fryc.imbleeding.ImBleeding;
import net.fryc.imbleeding.effects.ModEffects;
import net.fryc.imbleeding.tags.ModDamageTypeTags;
import net.fryc.imbleeding.tags.ModEntityTypeTags;
import net.minecraft.class_1282;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_5134;
import net.minecraft.class_8103;

public class BleedingHelper {
    public static boolean shouldApplyDarkness(class_1309 entity) {
        return entity instanceof class_1657;
    }

    public static void applyDarkness(class_1309 entity) {
        if (entity.method_6032() < 6.0f && ImBleeding.config.enableDarknessAtLowHp) {
            if (entity.method_6059(class_1294.field_38092)) {
                if (((class_1293)entity.method_6088().get(class_1294.field_38092)).method_5584() < 34) {
                    entity.method_6092(new class_1293(class_1294.field_38092, 33, 0, false, false, false));
                }
            } else {
                entity.method_6092(new class_1293(class_1294.field_38092, 33, 0, false, false, false));
            }
        }
    }

    public static void applyBlindness(class_1309 entity) {
        if (entity.method_6032() <= 1.0f && ImBleeding.config.enableBlindnessAtLowHp) {
            if (entity.method_6059(class_1294.field_5919)) {
                if (((class_1293)entity.method_6088().get(class_1294.field_5919)).method_5584() < 25) {
                    entity.method_6092(new class_1293(class_1294.field_5919, 60, 0, false, false, false));
                }
            } else {
                entity.method_6092(new class_1293(class_1294.field_5919, 60, 0, false, false, false));
            }
        }
    }

    public static void applyBleeding(class_1309 entity, class_1282 source, float amount) {
        BleedingHelper.applyBleedingOrHealthLoss(entity, source, amount, false);
    }

    public static void applyHealthLoss(class_1309 entity, class_1282 source, float amount) {
        BleedingHelper.applyBleedingOrHealthLoss(entity, source, amount, true);
    }

    public static void applyBleedingOrHealthLoss(class_1309 entity, class_1282 source, float amount, boolean healthLoss) {
        float toughness = (int)entity.method_6127().method_26852(class_5134.field_23725);
        int armor = (int)entity.method_6127().method_26852(class_5134.field_23724);
        float reduction = (ImBleeding.config.armorBleedingProtection * (float)armor + ImBleeding.config.toughnessBleedingProtection * toughness) / 100.0f;
        if (reduction < 1.0f) {
            int duration;
            if (healthLoss) {
                duration = (int)((float)ImBleeding.config.healthLossLength * amount);
            } else if (source.method_48789(class_8103.field_42247)) {
                duration = (int)((float)ImBleeding.config.arrowBleedLength * amount);
            } else {
                class_1309 livingEntity;
                class_1297 class_12972;
                duration = (int)((float)ImBleeding.config.meleeBleedLength * amount);
                if (source.method_5529() != null && (class_12972 = source.method_5529()) instanceof class_1309 && (livingEntity = (class_1309)class_12972).method_6047().method_7963()) {
                    duration = (int)((double)duration + (double)duration * 0.17);
                }
            }
            duration = (int)((float)duration - (float)duration * reduction);
            if (duration > 19) {
                class_1291 effect = healthLoss ? ModEffects.HEALTH_LOSS : ModEffects.BLEED_EFFECT;
                BleedingHelper.applyOrExtendEffect(entity, duration, effect, source, amount);
            }
        }
    }

    public static void applyOrExtendEffect(class_1309 entity, int duration, class_1291 effect, class_1282 source, float amount) {
        if (!entity.method_6059(effect)) {
            entity.method_6092(new class_1293(effect, duration, 0, false, false, true));
        } else {
            int amp = ((class_1293)entity.method_6088().get(effect)).method_5578();
            int bleedingUpgradeChance = amp == 0 ? (int)((float)ImBleeding.config.baseChanceToUpgradeBleedingOrHealthLoss * (amount + 1.0f)) : (int)((float)(1 + ImBleeding.config.baseChanceToUpgradeBleedingOrHealthLoss / 10) * (amount + 1.0f));
            if (amp < 3 && BleedingHelper.checkIfBleedingCanBeUpgraded(source) && ThreadLocalRandom.current().nextInt(100) >= 100 - bleedingUpgradeChance) {
                ++amp;
            }
            duration = ((class_1293)entity.method_6088().get(effect)).method_5584() > duration ? (int)((double)duration - (double)duration * 0.75) : (int)((double)duration - (double)((class_1293)entity.method_6088().get(effect)).method_5584() * 0.75);
            entity.method_6092(new class_1293(effect, duration += ((class_1293)entity.method_6088().get(effect)).method_5584(), amp, false, false, true));
        }
    }

    private static boolean checkIfBleedingCanBeUpgraded(class_1282 source) {
        if (source.method_48789(class_8103.field_42247)) {
            return ImBleeding.config.enableArrowEffectUpgrading;
        }
        return ImBleeding.config.enableMeleeEffectUpgrading;
    }

    public static void reduceBleedingWithFire(class_1309 entity) {
        if (entity.method_6059(ModEffects.BLEED_EFFECT)) {
            int amp = ((class_1293)entity.method_6088().get(ModEffects.BLEED_EFFECT)).method_5578();
            int dur = ((class_1293)entity.method_6088().get(ModEffects.BLEED_EFFECT)).method_5584();
            dur = amp == 0 ? (dur -= 280) : (amp == 1 ? (dur -= 120) : (dur -= 50));
            if (!entity.method_37908().method_8608() && amp > 0 && ThreadLocalRandom.current().nextInt(100) >= 100 - ImBleeding.config.chanceToLowerBleedingAmplifierWithFire) {
                --amp;
            }
            entity.method_6016(((class_1293)entity.method_6088().get(ModEffects.BLEED_EFFECT)).method_5579());
            if (dur > 0) {
                entity.method_6092(new class_1293(ModEffects.BLEED_EFFECT, dur, amp, false, false, true));
            }
        }
    }

    public static boolean shouldReduceBleedingWithFire(class_1282 source, class_1937 world) {
        if (!world.method_8608()) {
            return source.method_48789(class_8103.field_42246) && ImBleeding.config.fireDamageLowersBleedingDuration;
        }
        return false;
    }

    public static boolean shouldStopFoodHealing(class_1657 player) {
        return player.method_6059(ModEffects.BLEED_EFFECT);
    }

    public static void applyBrokenEffect(class_1309 entity, float damage) {
        int duration = entity.method_6059(ModEffects.BROKEN) ? ((class_1293)entity.method_6088().get(ModEffects.BROKEN)).method_5584() + (int)((float)ImBleeding.config.brokenLengthPerHealthPointLost * damage) : ImBleeding.config.baseBrokenLength + (int)((float)ImBleeding.config.brokenLengthPerHealthPointLost * (damage - ImBleeding.config.minFallDamageTakenToGetBroken));
        entity.method_6092(new class_1293(ModEffects.BROKEN, duration, 0, false, false, true));
    }

    public static boolean shouldApplyBrokenEffect(class_1282 source, float damage, class_1309 entity) {
        return source.method_48789(class_8103.field_42250) && (damage > ImBleeding.config.minFallDamageTakenToGetBroken || entity.method_6059(ModEffects.BROKEN));
    }

    public static boolean canGetBleeding(class_1309 entity) {
        return entity.method_5864().method_20210(ModEntityTypeTags.CAN_BLEED) && !entity.method_5864().method_20210(ModEntityTypeTags.BLEED_RESISTANT_TO);
    }

    public static boolean canGetHealthLoss(class_1309 entity) {
        return !entity.method_5864().method_20210(ModEntityTypeTags.HEALTH_LOSS_RESISTANT_TO);
    }

    public static boolean canApplyBleeding(class_1282 source, float amount) {
        if (amount >= 1.0f && source.method_48789(ModDamageTypeTags.DAMAGE_APPLY_BLEED)) {
            if (source.method_48789(class_8103.field_42247)) {
                if (source.method_5526() != null) {
                    return source.method_5526().method_5864().method_20210(ModEntityTypeTags.BLEEDING_PROJECTILES);
                }
                return false;
            }
            if (source.method_5529() != null) {
                return !source.method_5529().method_5864().method_20210(ModEntityTypeTags.NO_BLEEDING_APPLY_MOBS);
            }
            return true;
        }
        return false;
    }

    public static boolean canApplyHealthLoss(class_1282 source) {
        if (source.method_48789(ModDamageTypeTags.DAMAGE_APPLY_HEALTH_LOSS)) {
            if (source.method_5529() != null) {
                return source.method_5529().method_5864().method_20210(ModEntityTypeTags.MOBS_CAUSING_HEALTH_LOSS);
            }
            return false;
        }
        return false;
    }
}

