/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.knightquest.common.entity.entities;

import com.google.common.collect.Sets;
import dev.xylonity.knightquest.common.entity.entities.AbstractSwampmanAxeEntity;
import dev.xylonity.knightquest.registry.KnightQuestEntities;
import java.util.Collection;
import java.util.Set;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1842;
import net.minecraft.class_1844;
import net.minecraft.class_1847;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class SwampmanAxeEntity
extends AbstractSwampmanAxeEntity
implements GeoEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final class_2940<Integer> ID_EFFECT_COLOR = class_2945.method_12791(SwampmanAxeEntity.class, (class_2941)class_2943.field_13327);
    private class_1842 potion = class_1847.field_8984;
    private final Set<class_1293> effects = Sets.newHashSet();
    private boolean fixedColor;

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public SwampmanAxeEntity(class_1299<? extends AbstractSwampmanAxeEntity> pEntityType, class_1937 pLevel) {
        super(pEntityType, pLevel);
    }

    public SwampmanAxeEntity(class_1937 pLevel, class_1309 pShooter) {
        super(KnightQuestEntities.SWAMPMAN_AXE, pShooter, pLevel);
    }

    private void updateColor() {
        this.fixedColor = false;
        if (this.potion == class_1847.field_8984 && this.effects.isEmpty()) {
            this.field_6011.method_12778(ID_EFFECT_COLOR, (Object)-1);
        } else {
            this.field_6011.method_12778(ID_EFFECT_COLOR, (Object)class_1844.method_8055((Collection)class_1844.method_8059((class_1842)this.potion, this.effects)));
        }
    }

    public void addEffect(class_1293 pEffectInstance) {
        this.effects.add(pEffectInstance);
        this.method_5841().method_12778(ID_EFFECT_COLOR, (Object)class_1844.method_8055((Collection)class_1844.method_8059((class_1842)this.potion, this.effects)));
    }

    @Override
    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(ID_EFFECT_COLOR, (Object)-1);
    }

    @Override
    public void method_5773() {
        super.method_5773();
        if (this.method_37908().field_9236) {
            if (this.inGround) {
                if (this.inGroundTime % 5 == 0) {
                    this.makeParticle(1);
                }
            } else {
                this.makeParticle(2);
            }
        } else if (this.inGround && this.inGroundTime != 0 && !this.effects.isEmpty() && this.inGroundTime >= 600) {
            this.method_37908().method_8421((class_1297)this, (byte)0);
            this.potion = class_1847.field_8984;
            this.effects.clear();
            this.field_6011.method_12778(ID_EFFECT_COLOR, (Object)-1);
        }
    }

    private void makeParticle(int pParticleAmount) {
        int i = this.getColor();
        if (i != -1 && pParticleAmount > 0) {
            double d0 = (double)(i >> 16 & 0xFF) / 255.0;
            double d1 = (double)(i >> 8 & 0xFF) / 255.0;
            double d2 = (double)(i & 0xFF) / 255.0;
            for (int j = 0; j < pParticleAmount; ++j) {
                this.method_37908().method_8406((class_2394)class_2398.field_11226, this.method_23322(0.5), this.method_23319(), this.method_23325(0.5), d0, d1, d2);
            }
        }
    }

    public int getColor() {
        return (Integer)this.field_6011.method_12789(ID_EFFECT_COLOR);
    }

    private void setFixedColor(int pFixedColor) {
        this.fixedColor = true;
        this.field_6011.method_12778(ID_EFFECT_COLOR, (Object)pFixedColor);
    }

    @Override
    public void method_5652(@NotNull class_2487 pCompound) {
        super.method_5652(pCompound);
        if (this.potion != class_1847.field_8984) {
            pCompound.method_10582("Potion", class_7923.field_41179.method_10221((Object)this.potion).toString());
        }
        if (this.fixedColor) {
            pCompound.method_10569("Color", this.getColor());
        }
        if (!this.effects.isEmpty()) {
            class_2499 listtag = new class_2499();
            for (class_1293 mobeffectinstance : this.effects) {
                listtag.add((Object)mobeffectinstance.method_5582(new class_2487()));
            }
            pCompound.method_10566("CustomPotionEffects", (class_2520)listtag);
        }
    }

    @Override
    public void method_5749(@NotNull class_2487 pCompound) {
        super.method_5749(pCompound);
        if (pCompound.method_10573("Potion", 8)) {
            this.potion = class_1844.method_8057((class_2487)pCompound);
        }
        for (class_1293 mobeffectinstance : class_1844.method_8060((class_2487)pCompound)) {
            this.addEffect(mobeffectinstance);
        }
        if (pCompound.method_10573("Color", 99)) {
            this.setFixedColor(pCompound.method_10550("Color"));
        } else {
            this.updateColor();
        }
    }

    @Override
    protected void doPostHurtEffects(class_1309 pLiving) {
        super.doPostHurtEffects(pLiving);
        class_1297 entity = this.method_37225();
        for (class_1293 mobeffectinstance : this.potion.method_8049()) {
            pLiving.method_37222(new class_1293(mobeffectinstance.method_5579(), Math.max(mobeffectinstance.method_48558(x -> x / 8), 1), mobeffectinstance.method_5578(), mobeffectinstance.method_5591(), mobeffectinstance.method_5581()), entity);
        }
        if (!this.effects.isEmpty()) {
            for (class_1293 mobeffectinstance : this.effects) {
                pLiving.method_37222(mobeffectinstance, entity);
            }
        }
    }

    public void method_5711(byte pId) {
        if (pId == 0) {
            int i = this.getColor();
            if (i != -1) {
                double d0 = (double)(i >> 16 & 0xFF) / 255.0;
                double d1 = (double)(i >> 8 & 0xFF) / 255.0;
                double d2 = (double)(i & 0xFF) / 255.0;
                for (int j = 0; j < 20; ++j) {
                    this.method_37908().method_8406((class_2394)class_2398.field_11226, this.method_23322(0.5), this.method_23319(), this.method_23325(0.5), d0, d1, d2);
                }
            }
        } else {
            super.method_5711(pId);
        }
    }
}

