/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.knightquest.common.item;

import dev.xylonity.knightquest.common.item.KQFullSetChecker;
import dev.xylonity.knightquest.common.item.weapons.PaladinWeapon;
import dev.xylonity.knightquest.common.material.KQArmorMaterials;
import dev.xylonity.knightquest.config.values.KQConfigValues;
import dev.xylonity.knightquest.registry.KnightQuestItems;
import dev.xylonity.knightquest.registry.KnightQuestWeapons;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.entity.event.v1.ServerLivingEntityEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerEntityEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1738;
import net.minecraft.class_1741;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1811;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_1972;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2675;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_746;
import net.minecraft.class_8111;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KQArmorItem
extends class_1738 {
    private static final Map<UUID, Map<KQArmorMaterials, Boolean>> effectAppliedByArmorMap = new ConcurrentHashMap<UUID, Map<KQArmorMaterials, Boolean>>();
    private final String bonusTooltip;
    private final boolean hasTooltip;
    private static final class_1293 SHIELD_ARMOR = new class_1293(class_1294.field_5907, -1, 0, false, false, true);
    private static final class_1293 BAT_ARMOR = new class_1293(class_1294.field_5925, -1, 0, false, false, true);
    private static final class_1293 PATH_ARMOR = new class_1293(class_1294.field_5904, -1, 1, false, true, true);
    private static final class_1293 BOW_ARMOR = new class_1293(class_1294.field_5904, -1, 1, false, false, true);
    private static final class_1293 HORN_ARMOR = new class_1293(class_1294.field_5910, 400, 1, false, false, true);
    private static final class_1293 SEA_ARMOR = new class_1293(class_1294.field_5900, -1, 0, false, false, true);
    private static final class_1293 PIRATE_ARMOR = new class_1293(class_1294.field_5926, -1, 0, false, false, true);
    private static final class_1293 SPIDER_ARMOR = new class_1293(class_1294.field_5913, -1, 1, false, false, false);
    private static final class_1293 PHANTOM_ARMOR = new class_1293(class_1294.field_5904, -1, 0, false, false, true);
    private static final class_1293 NETHER_ARMOR = new class_1293(class_1294.field_5918, -1, 0, false, false, true);
    private static final class_1293 HUSK_ARMOR = new class_1293(class_1294.field_5907, -1, 1, false, false, true);
    private static final class_1293 BAMBOO_BLUE = new class_1293(class_1294.field_5904, -1, 1, false, false, true);
    private static final class_1293 SILVERFISH_ARMOR = new class_1293(class_1294.field_5917, -1, 0, false, false, true);
    private static final class_1293 SKULK_ARMOR = new class_1293(class_1294.field_5907, -1, 1, false, false, true);
    private static final class_1293 STRAWHAT_ARMOR = new class_1293(class_1294.field_5923, -1, 0, false, false, true);

    public KQArmorItem(KQArmorMaterials material, class_1738.class_8051 type, class_1792.class_1793 settings, boolean hasTooltip) {
        super((class_1741)material, type, settings);
        this.bonusTooltip = material.getKeyName();
        this.hasTooltip = hasTooltip;
    }

    private boolean isArmorSetConfigEnabled(String bonusTooltip) {
        try {
            ArmorSet armorSet = ArmorSet.valueOf(bonusTooltip.toUpperCase());
            return armorSet.isEnabled();
        }
        catch (Exception e) {
            return false;
        }
    }

    public void method_7851(@NotNull class_1799 pStack, @Nullable class_1937 pLevel, @NotNull List<class_2561> pTooltipComponents, @NotNull class_1836 pIsAdvanced) {
        if (this.hasTooltip && this.isArmorSetConfigEnabled(this.bonusTooltip)) {
            if (!Objects.equals(this.bonusTooltip, "chainmail") && !Objects.equals(this.bonusTooltip, "tengu")) {
                if (KQConfigValues.REQUIRED_ARMOR_PIECES < 4) {
                    pTooltipComponents.add((class_2561)class_2561.method_43471((String)"tooltip.item.knightquest.set_bonus"));
                } else {
                    pTooltipComponents.add((class_2561)class_2561.method_43471((String)"tooltip.item.knightquest.full_set_bonus"));
                }
                pTooltipComponents.add((class_2561)class_2561.method_43469((String)("tooltip.item.knightquest." + this.bonusTooltip + "_helmet.bonus"), (Object[])new Object[]{"\u00a77\u00a7o-" + (int)Math.floor(KQConfigValues.EVOKER_DARKNESS_CHANCE * 100.0) + "%", "\u00a77\u00a7o-" + (int)Math.floor(KQConfigValues.BLAZE_FIRE_CHANCE * 100.0) + "%", "\u00a77\u00a7o-" + (int)Math.floor(KQConfigValues.DRAGONSET_DAMAGE_MULTIPLIER * 100.0 - 100.0) + "%", "\u00a77\u00a7o" + KQConfigValues.SKULK_MAX_LIGHT_LEVEL, "\u00a77\u00a7o-" + (int)Math.floor(KQConfigValues.CHANCE_ENDERMANSET * 100.0) + "%", "\u00a77\u00a7o" + KQConfigValues.TELEPORT_RADIUS_ENDERMANSET, "\u00a77\u00a7o-" + (int)Math.floor(KQConfigValues.FORZESET_DEFLECT_CHANCE * 100.0) + "%", "\u00a77\u00a7o" + (100.0 - KQConfigValues.CREEPER_EXPLOSION_DAMAGE_MULTIPLIER * 100.0) + "%", "\u00a77\u00a7o-" + (int)Math.floor(KQConfigValues.SILVERSET_BURN_CHANCE * 100.0) + "%", "\u00a77\u00a7o" + (int)Math.floor(KQConfigValues.HOLLOWSET_HEALING_MULTIPLIER * 100.0) + "%", "\u00a77\u00a7o-" + (int)Math.floor(KQConfigValues.WITHERSET_WITHER_CHANCE * 100.0) + "%", "\u00a77\u00a7o" + Math.floor(KQConfigValues.ZOMBIESET_HEALING_AMOUNT), "\u00a77\u00a7o" + KQConfigValues.ZOMBIESET_HEALING_TICKS / 20, "\u00a77\u00a7o" + KQConfigValues.SILVERFISH_EFFECT_MAX_HEIGHT}));
            } else if (Objects.equals(this.bonusTooltip, "tengu")) {
                pTooltipComponents.add((class_2561)class_2561.method_43471((String)"tooltip.item.knightquest.full_helmet_bonus"));
                pTooltipComponents.add((class_2561)class_2561.method_43471((String)("tooltip.item.knightquest." + this.bonusTooltip + "_helmet.bonus")));
            }
        }
        super.method_7851(pStack, pLevel, pTooltipComponents, pIsAdvanced);
    }

    public void method_7888(@NotNull class_1799 stack, class_1937 level, @NotNull class_1297 entity, int slotId, boolean isSelected) {
        if (!level.method_8608() && entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            UUID playerUUID = player.method_5667();
            if (KQConfigValues.PATHSET) {
                if (KQFullSetChecker.hasFullSetOn(player, KQArmorMaterials.PATHSET) && level.method_8530()) {
                    if (!Boolean.TRUE.equals(effectAppliedByArmorMap.computeIfAbsent(playerUUID, k -> new ConcurrentHashMap()).getOrDefault((Object)KQArmorMaterials.PATHSET, false))) {
                        player.method_6092(PATH_ARMOR);
                        effectAppliedByArmorMap.get(playerUUID).put(KQArmorMaterials.PATHSET, true);
                    }
                } else if (Boolean.TRUE.equals(effectAppliedByArmorMap.computeIfAbsent(playerUUID, k -> new ConcurrentHashMap()).getOrDefault((Object)KQArmorMaterials.PATHSET, false))) {
                    player.method_6016(class_1294.field_5904);
                    effectAppliedByArmorMap.get(playerUUID).put(KQArmorMaterials.PATHSET, false);
                }
            }
            if (KQConfigValues.BOWSET) {
                if (KQFullSetChecker.hasFullSetOn(player, KQArmorMaterials.BOWSET) && player.method_6047().method_7909() instanceof class_1811) {
                    if (!Boolean.TRUE.equals(effectAppliedByArmorMap.computeIfAbsent(playerUUID, k -> new ConcurrentHashMap()).getOrDefault((Object)KQArmorMaterials.BOWSET, false))) {
                        player.method_6092(BOW_ARMOR);
                        effectAppliedByArmorMap.get(playerUUID).put(KQArmorMaterials.BOWSET, true);
                    }
                } else if (Boolean.TRUE.equals(effectAppliedByArmorMap.computeIfAbsent(playerUUID, k -> new ConcurrentHashMap()).getOrDefault((Object)KQArmorMaterials.BOWSET, false))) {
                    player.method_6016(class_1294.field_5904);
                    effectAppliedByArmorMap.get(playerUUID).put(KQArmorMaterials.BOWSET, false);
                }
            }
            if (KQConfigValues.BATSET) {
                if (KQFullSetChecker.hasFullSetOn(player, KQArmorMaterials.BATSET) && level.method_23886()) {
                    if (!Boolean.TRUE.equals(effectAppliedByArmorMap.computeIfAbsent(playerUUID, k -> new ConcurrentHashMap()).getOrDefault((Object)KQArmorMaterials.BATSET, false))) {
                        player.method_6092(BAT_ARMOR);
                        effectAppliedByArmorMap.get(playerUUID).put(KQArmorMaterials.BATSET, true);
                    }
                } else if (Boolean.TRUE.equals(effectAppliedByArmorMap.computeIfAbsent(playerUUID, k -> new ConcurrentHashMap()).getOrDefault((Object)KQArmorMaterials.BATSET, false))) {
                    player.method_6016(class_1294.field_5925);
                    effectAppliedByArmorMap.get(playerUUID).put(KQArmorMaterials.BATSET, false);
                }
            }
            if (KQConfigValues.SHIELDSET) {
                if (KQFullSetChecker.hasFullSetOn(player, KQArmorMaterials.SHIELDSET)) {
                    if (!Boolean.TRUE.equals(effectAppliedByArmorMap.computeIfAbsent(playerUUID, k -> new ConcurrentHashMap()).getOrDefault((Object)KQArmorMaterials.SHIELDSET, false))) {
                        player.method_6092(SHIELD_ARMOR);
                        effectAppliedByArmorMap.get(playerUUID).put(KQArmorMaterials.SHIELDSET, true);
                    }
                } else if (Boolean.TRUE.equals(effectAppliedByArmorMap.computeIfAbsent(playerUUID, k -> new ConcurrentHashMap()).getOrDefault((Object)KQArmorMaterials.SHIELDSET, false))) {
                    player.method_6016(class_1294.field_5907);
                    effectAppliedByArmorMap.get(playerUUID).put(KQArmorMaterials.SHIELDSET, false);
                }
            }
            if (KQConfigValues.PHANTOMSET) {
                if (KQFullSetChecker.hasFullSetOn(player, KQArmorMaterials.PHANTOMSET) && level.method_23886()) {
                    if (!Boolean.TRUE.equals(effectAppliedByArmorMap.computeIfAbsent(playerUUID, k -> new ConcurrentHashMap()).getOrDefault((Object)KQArmorMaterials.PHANTOMSET, false))) {
                        player.method_6092(PHANTOM_ARMOR);
                        effectAppliedByArmorMap.get(playerUUID).put(KQArmorMaterials.PHANTOMSET, true);
                    }
                } else if (Boolean.TRUE.equals(effectAppliedByArmorMap.computeIfAbsent(playerUUID, k -> new ConcurrentHashMap()).getOrDefault((Object)KQArmorMaterials.PHANTOMSET, false))) {
                    player.method_6016(class_1294.field_5904);
                    effectAppliedByArmorMap.get(playerUUID).put(KQArmorMaterials.PHANTOMSET, false);
                }
            }
            if (KQConfigValues.HORNSET) {
                if (KQFullSetChecker.hasFullSetOn(player, KQArmorMaterials.HORNSET) && player.method_49107() != null) {
                    if (!Boolean.TRUE.equals(effectAppliedByArmorMap.computeIfAbsent(playerUUID, k -> new ConcurrentHashMap()).getOrDefault((Object)KQArmorMaterials.HORNSET, false))) {
                        player.method_6092(HORN_ARMOR);
                        effectAppliedByArmorMap.get(playerUUID).put(KQArmorMaterials.HORNSET, true);
                    }
                } else if (Boolean.TRUE.equals(effectAppliedByArmorMap.computeIfAbsent(playerUUID, k -> new ConcurrentHashMap()).getOrDefault((Object)KQArmorMaterials.HORNSET, false))) {
                    player.method_6016(class_1294.field_5910);
                    effectAppliedByArmorMap.get(playerUUID).put(KQArmorMaterials.HORNSET, false);
                }
            }
            if (KQConfigValues.SEASET) {
                if (KQFullSetChecker.hasFullSetOn(player, KQArmorMaterials.SEASET) && player.method_5869()) {
                    if (!Boolean.TRUE.equals(effectAppliedByArmorMap.computeIfAbsent(playerUUID, k -> new ConcurrentHashMap()).getOrDefault((Object)KQArmorMaterials.SEASET, false))) {
                        player.method_6092(SEA_ARMOR);
                        effectAppliedByArmorMap.get(playerUUID).put(KQArmorMaterials.SEASET, true);
                    }
                } else if (Boolean.TRUE.equals(effectAppliedByArmorMap.computeIfAbsent(playerUUID, k -> new ConcurrentHashMap()).getOrDefault((Object)KQArmorMaterials.SEASET, false))) {
                    player.method_6016(class_1294.field_5900);
                    effectAppliedByArmorMap.get(playerUUID).put(KQArmorMaterials.SEASET, false);
                }
            }
            if (KQConfigValues.PIRATESET) {
                if (KQFullSetChecker.hasFullSetOn(player, KQArmorMaterials.PIRATESET)) {
                    if (!Boolean.TRUE.equals(effectAppliedByArmorMap.computeIfAbsent(playerUUID, k -> new ConcurrentHashMap()).getOrDefault((Object)KQArmorMaterials.PIRATESET, false))) {
                        player.method_6092(PIRATE_ARMOR);
                        effectAppliedByArmorMap.get(playerUUID).put(KQArmorMaterials.PIRATESET, true);
                    }
                } else if (Boolean.TRUE.equals(effectAppliedByArmorMap.computeIfAbsent(playerUUID, k -> new ConcurrentHashMap()).getOrDefault((Object)KQArmorMaterials.PIRATESET, false))) {
                    player.method_6016(class_1294.field_5926);
                    effectAppliedByArmorMap.get(playerUUID).put(KQArmorMaterials.PIRATESET, false);
                }
            }
            if (KQConfigValues.SPIDERSET) {
                if (KQFullSetChecker.hasFullSetOn(player, KQArmorMaterials.SPIDERSET) && player.method_5715()) {
                    if (!Boolean.TRUE.equals(effectAppliedByArmorMap.computeIfAbsent(playerUUID, k -> new ConcurrentHashMap()).getOrDefault((Object)KQArmorMaterials.SPIDERSET, false))) {
                        player.method_6092(SPIDER_ARMOR);
                        effectAppliedByArmorMap.get(playerUUID).put(KQArmorMaterials.SPIDERSET, true);
                    }
                } else if (Boolean.TRUE.equals(effectAppliedByArmorMap.computeIfAbsent(playerUUID, k -> new ConcurrentHashMap()).getOrDefault((Object)KQArmorMaterials.SPIDERSET, false))) {
                    player.method_6016(class_1294.field_5913);
                    effectAppliedByArmorMap.get(playerUUID).put(KQArmorMaterials.SPIDERSET, false);
                }
            }
            if (KQConfigValues.NETHERSET) {
                if (KQFullSetChecker.hasFullSetOn(player, KQArmorMaterials.NETHERSET)) {
                    if (!Boolean.TRUE.equals(effectAppliedByArmorMap.computeIfAbsent(playerUUID, k -> new ConcurrentHashMap()).getOrDefault((Object)KQArmorMaterials.NETHERSET, false))) {
                        player.method_6092(NETHER_ARMOR);
                        effectAppliedByArmorMap.get(playerUUID).put(KQArmorMaterials.NETHERSET, true);
                    }
                } else if (Boolean.TRUE.equals(effectAppliedByArmorMap.computeIfAbsent(playerUUID, k -> new ConcurrentHashMap()).getOrDefault((Object)KQArmorMaterials.NETHERSET, false))) {
                    player.method_6016(class_1294.field_5918);
                    effectAppliedByArmorMap.get(playerUUID).put(KQArmorMaterials.NETHERSET, false);
                }
            }
            if (KQConfigValues.SKULK) {
                if (KQFullSetChecker.hasFullSetOn(player, KQArmorMaterials.SKULK) && player.method_37908().method_22339(player.method_24515()) <= KQConfigValues.SKULK_MAX_LIGHT_LEVEL) {
                    if (!Boolean.TRUE.equals(effectAppliedByArmorMap.computeIfAbsent(playerUUID, k -> new ConcurrentHashMap()).getOrDefault((Object)KQArmorMaterials.SKULK, false))) {
                        player.method_6092(SKULK_ARMOR);
                        effectAppliedByArmorMap.get(playerUUID).put(KQArmorMaterials.SKULK, true);
                    }
                } else if (Boolean.TRUE.equals(effectAppliedByArmorMap.computeIfAbsent(playerUUID, k -> new ConcurrentHashMap()).getOrDefault((Object)KQArmorMaterials.SKULK, false))) {
                    player.method_6016(class_1294.field_5907);
                    effectAppliedByArmorMap.get(playerUUID).put(KQArmorMaterials.SKULK, false);
                }
            }
            if (KQConfigValues.STRAWHATSET) {
                if (KQFullSetChecker.hasFullSetOn(player, KQArmorMaterials.STRAWHATSET)) {
                    if (!Boolean.TRUE.equals(effectAppliedByArmorMap.computeIfAbsent(playerUUID, k -> new ConcurrentHashMap()).getOrDefault((Object)KQArmorMaterials.STRAWHATSET, false))) {
                        player.method_6092(STRAWHAT_ARMOR);
                        effectAppliedByArmorMap.get(playerUUID).put(KQArmorMaterials.STRAWHATSET, true);
                    }
                } else if (Boolean.TRUE.equals(effectAppliedByArmorMap.computeIfAbsent(playerUUID, k -> new ConcurrentHashMap()).getOrDefault((Object)KQArmorMaterials.STRAWHATSET, false))) {
                    player.method_6016(class_1294.field_5923);
                    effectAppliedByArmorMap.get(playerUUID).put(KQArmorMaterials.STRAWHATSET, false);
                }
            }
        }
        super.method_7888(stack, level, entity, slotId, isSelected);
    }

    private static boolean isTeleportPositionValid(class_1937 level, class_2338 pos) {
        return !level.method_8320(pos.method_10074()).method_26215() && level.method_8320(pos).method_26215() && level.method_8320(pos.method_10084()).method_26215();
    }

    public static enum ArmorSet {
        DEEPSLATE(KQConfigValues.DEEPSLATESET),
        EVOKER(KQConfigValues.EVOKERSET),
        SQUIRE(KQConfigValues.SQUIRESET),
        BLAZE(KQConfigValues.BLAZESET),
        DRAGON(KQConfigValues.DRAGONSET),
        BAMBOO_GREEN(KQConfigValues.BAMBOOSET_GREEN),
        SHINOBI(KQConfigValues.SHINOBI),
        BAMBOO(KQConfigValues.BAMBOOSET),
        PATH(KQConfigValues.PATHSET),
        BOW(KQConfigValues.BOWSET),
        BAT(KQConfigValues.BATSET),
        SHIELD(KQConfigValues.SHIELDSET),
        PHANTOM(KQConfigValues.PHANTOMSET),
        HORN(KQConfigValues.HORNSET),
        SEA(KQConfigValues.SEASET),
        PIRATE(KQConfigValues.PIRATESET),
        SPIDER(KQConfigValues.SPIDERSET),
        NETHER(KQConfigValues.NETHERSET),
        SKULK(KQConfigValues.SKULK),
        STRAWHAT(KQConfigValues.STRAWHATSET),
        ENDERMAN(KQConfigValues.ENDERMANSET),
        VETERAN(KQConfigValues.VETERANSET),
        FORZE(KQConfigValues.FORZESET),
        CREEPER(KQConfigValues.CREEPERSET),
        POLAR(KQConfigValues.POLAR),
        SILVER(KQConfigValues.SILVERSET),
        HOLLOW(KQConfigValues.HOLLOWSET),
        WITHER(KQConfigValues.WITHERSET),
        APPLE(KQConfigValues.APPLE_SET),
        CONQUISTADOR(KQConfigValues.CONQUISTADORSET),
        WITCH(KQConfigValues.WITCH),
        TENGU(KQConfigValues.TENGU_HELMET),
        HUSK(KQConfigValues.HUSKSET),
        BAMBOO_BLUE(KQConfigValues.BAMBOOSET_BLUE),
        WARLORD(KQConfigValues.WARLORDSET),
        ZOMBIE(KQConfigValues.ZOMBIESET),
        SILVERFISH(KQConfigValues.SILVERFISHSET),
        SKELETON(KQConfigValues.SKELETONSET);

        private final Boolean configValue;

        private ArmorSet(Boolean configValue) {
            this.configValue = configValue;
        }

        public boolean isEnabled() {
            return this.configValue;
        }
    }

    public static class OnEntityTickEvent
    implements ServerTickEvents.EndTick {
        public void onEndTick(MinecraftServer server) {
            for (class_3222 player : server.method_3760().method_14571()) {
                class_1799 stack = player.method_6047();
                if (stack.method_7909() instanceof PaladinWeapon && KQConfigValues.PALADIN && player.field_6012 % KQConfigValues.REGEN_TICKS_PALADIN == 0 && (double)player.method_6032() < (double)player.method_6063() * KQConfigValues.REGEN_MAX_PALADIN && stack.method_7948().method_10577("Activated")) {
                    player.method_6025((float)KQConfigValues.REGEN_HP_PALADIN);
                }
                if (KQConfigValues.HUSKSET) {
                    if (KQFullSetChecker.hasFullSetOn((class_1657)player, KQArmorMaterials.HUSKSET) && (player.method_37908().method_23753(player.method_24515()).method_40225(class_1972.field_9424) || player.method_37908().method_23753(player.method_24515()).method_40225(class_1972.field_9415) || player.method_37908().method_23753(player.method_24515()).method_40225(class_1972.field_9434))) {
                        if (!Boolean.TRUE.equals(effectAppliedByArmorMap.computeIfAbsent(player.method_5667(), k -> new HashMap()).getOrDefault((Object)KQArmorMaterials.HUSKSET, false))) {
                            player.method_6092(HUSK_ARMOR);
                            effectAppliedByArmorMap.get(player.method_5667()).put(KQArmorMaterials.HUSKSET, true);
                        }
                    } else if (Boolean.TRUE.equals(effectAppliedByArmorMap.computeIfAbsent(player.method_5667(), k -> new HashMap()).getOrDefault((Object)KQArmorMaterials.HUSKSET, false))) {
                        player.method_6016(class_1294.field_5907);
                        effectAppliedByArmorMap.get(player.method_5667()).put(KQArmorMaterials.HUSKSET, false);
                    }
                }
                if (KQConfigValues.BAMBOOSET_BLUE) {
                    if (KQFullSetChecker.hasFullSetOn((class_1657)player, KQArmorMaterials.BAMBOOSET_BLUE) && (player.method_37908().method_23753(player.method_24515()).method_40225(class_1972.field_9417) || player.method_37908().method_23753(player.method_24515()).method_40225(class_1972.field_9440) || player.method_37908().method_23753(player.method_24515()).method_40225(class_1972.field_35118))) {
                        if (!Boolean.TRUE.equals(effectAppliedByArmorMap.computeIfAbsent(player.method_5667(), k -> new HashMap()).getOrDefault((Object)KQArmorMaterials.BAMBOOSET_BLUE, false))) {
                            player.method_6092(BAMBOO_BLUE);
                            effectAppliedByArmorMap.get(player.method_5667()).put(KQArmorMaterials.BAMBOOSET_BLUE, true);
                        }
                    } else if (Boolean.TRUE.equals(effectAppliedByArmorMap.computeIfAbsent(player.method_5667(), k -> new HashMap()).getOrDefault((Object)KQArmorMaterials.BAMBOOSET_BLUE, false))) {
                        player.method_6016(class_1294.field_5904);
                        effectAppliedByArmorMap.get(player.method_5667()).put(KQArmorMaterials.BAMBOOSET_BLUE, false);
                    }
                }
                if (KQConfigValues.WARLORDSET && KQFullSetChecker.hasFullSetOn((class_1657)player, KQArmorMaterials.WARLORDSET)) {
                    for (class_1297 entity : player.method_37908().method_18467(class_1657.class, player.method_5829().method_1014((double)KQConfigValues.WARLORD_SET_EFFECT_RADIUS))) {
                        class_1657 nearbyPlayer;
                        if (KQConfigValues.SHOULD_WARLORD_SET_EFFECT_APPLY_TO_ITSELF) {
                            if (!(entity instanceof class_1657)) continue;
                            nearbyPlayer = (class_1657)entity;
                            nearbyPlayer.method_6092(new class_1293(class_1294.field_5907, 100, 0, false, false, true));
                            continue;
                        }
                        if (!(entity instanceof class_1657)) continue;
                        nearbyPlayer = (class_1657)entity;
                        if (entity == player) continue;
                        nearbyPlayer.method_6092(new class_1293(class_1294.field_5907, 100, 0, false, false, true));
                    }
                }
                if (!player.method_37908().method_8608()) {
                    if (KQConfigValues.ZOMBIESET && KQFullSetChecker.hasFullSetOn((class_1657)player, KQArmorMaterials.ZOMBIESET) && player.method_37908().method_23886() && player.field_6012 % KQConfigValues.ZOMBIESET_HEALING_TICKS == 0) {
                        player.method_6025((float)KQConfigValues.ZOMBIESET_HEALING_AMOUNT);
                    }
                    if (KQConfigValues.APPLE_SET && KQFullSetChecker.hasFullSetOn((class_1657)player, KQArmorMaterials.APPLE_SET) && player.field_6012 % 400 == 0) {
                        player.method_6025(1.0f);
                    }
                }
                if (KQConfigValues.POLAR && KQFullSetChecker.hasFullSetOn((class_1657)player, KQArmorMaterials.POLAR)) {
                    player.method_32317(0);
                }
                if (!KQConfigValues.SILVERFISHSET) continue;
                if (KQFullSetChecker.hasFullSetOn((class_1657)player, KQArmorMaterials.SILVERFISHSET) && player.method_23318() < (double)KQConfigValues.SILVERFISH_EFFECT_MAX_HEIGHT) {
                    if (Boolean.TRUE.equals(effectAppliedByArmorMap.computeIfAbsent(player.method_5667(), k -> new HashMap()).getOrDefault((Object)KQArmorMaterials.SILVERFISHSET, false))) continue;
                    player.method_6092(SILVERFISH_ARMOR);
                    effectAppliedByArmorMap.get(player.method_5667()).put(KQArmorMaterials.SILVERFISHSET, true);
                    continue;
                }
                if (!Boolean.TRUE.equals(effectAppliedByArmorMap.computeIfAbsent(player.method_5667(), k -> new HashMap()).getOrDefault((Object)KQArmorMaterials.SILVERFISHSET, false))) continue;
                player.method_6016(class_1294.field_5917);
                effectAppliedByArmorMap.get(player.method_5667()).put(KQArmorMaterials.SILVERFISHSET, false);
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class ClientEventHandlers {
        private static final Map<UUID, Boolean> doubleJumpStates = new HashMap<UUID, Boolean>();

        public static void registerClientEvents() {
            ClientTickEvents.END_CLIENT_TICK.register(ClientEventHandlers::onClientTick);
        }

        private static void onClientTick(class_310 client) {
            class_746 player = client.field_1724;
            if (player == null) {
                return;
            }
            class_1799 stack = player.method_6047();
            if (KQConfigValues.TENGU_HELMET && player.method_31548().method_7372(3).method_7909() == KnightQuestItems.TENGU_HELMET.get() || KQConfigValues.NAIL && stack.method_7909() == KnightQuestWeapons.NAIL && stack.method_7948().method_10577("Activated")) {
                boolean canDoubleJump = doubleJumpStates.getOrDefault(player.method_5667(), true);
                if (!player.method_24828() && player.method_18798().field_1351 < 0.0 && canDoubleJump && client.field_1690.field_1903.method_1434()) {
                    ClientEventHandlers.handleClientSideDoubleJump(player);
                }
                if (player.method_24828()) {
                    doubleJumpStates.put(player.method_5667(), true);
                }
            }
        }

        private static void handleClientSideDoubleJump(class_746 player) {
            UUID playerUUID = player.method_5667();
            boolean canDoubleJump = doubleJumpStates.getOrDefault(playerUUID, true);
            if (canDoubleJump) {
                doubleJumpStates.put(playerUUID, false);
                for (int i = 0; i < 360; i += 60) {
                    double angleRadians = Math.toRadians(i);
                    double particleX = player.method_23317() + 0.4 * Math.cos(angleRadians);
                    double particleZ = player.method_23321() + 0.4 * Math.sin(angleRadians);
                    player.method_37908().method_8406((class_2394)class_2398.field_11204, particleX, player.method_23318(), particleZ, 0.0, 0.35, 0.0);
                }
                player.method_6043();
            }
        }
    }

    public static class OnEntityDeathWorldEvent
    implements ServerLivingEntityEvents.AfterDeath {
        public void afterDeath(class_1309 entity, class_1282 damageSource) {
            class_1297 class_12972;
            if (entity != null && (class_12972 = damageSource.method_5529()) instanceof class_1657) {
                class_1657 player = (class_1657)class_12972;
                if (KQConfigValues.CONQUISTADORSET && KQFullSetChecker.hasFullSetOn(player, KQArmorMaterials.CONQUISTADORSET)) {
                    player.method_6092(new class_1293(class_1294.field_5910, 200, 1, false, true, true));
                }
                if (KQConfigValues.WITCH && KQFullSetChecker.hasFullSetOn(player, KQArmorMaterials.WITCH)) {
                    player.method_6092(new class_1293(class_1294.field_5924, 80, 0, false, true, true));
                }
            }
        }
    }

    public static class OnEntityJoinWorldEvent
    implements ServerEntityEvents.Load {
        public void onLoad(class_1297 entity, class_3218 world) {
            class_1657 player;
            class_1665 arrow;
            class_1297 class_12972;
            if (KQConfigValues.SKELETONSET && entity instanceof class_1665 && (class_12972 = (arrow = (class_1665)entity).method_24921()) instanceof class_1657 && KQFullSetChecker.hasFullSetOn(player = (class_1657)class_12972, KQArmorMaterials.SKELETONSET)) {
                arrow.method_7451((byte)5);
            }
        }
    }

    public static class OnHurtPlayerHandler
    implements ServerLivingEntityEvents.AllowDamage {
        private static final ThreadLocal<Boolean> isProcessingDamage = ThreadLocal.withInitial(() -> false);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean allowDamage(class_1309 entity, class_1282 source, float amount) {
            class_1297 random;
            class_1657 player;
            class_1309 livingEntity;
            if (isProcessingDamage.get().booleanValue()) {
                return true;
            }
            class_1297 class_12972 = source.method_5529();
            if (class_12972 instanceof class_1309 && (livingEntity = (class_1309)class_12972).method_6047().method_7909() == KnightQuestWeapons.KUKRI && KQConfigValues.KUKRI) {
                entity.method_32317(entity.method_32312() + KQConfigValues.FREEZE_TICKS_KUKRI);
            }
            if ((class_12972 = source.method_5529()) instanceof class_1309 && (livingEntity = (class_1309)class_12972).method_6047().method_7909() == KnightQuestWeapons.KHOPESH && KQConfigValues.KHOPESH && (double)livingEntity.method_6051().method_43057() <= KQConfigValues.CHANCE_BURN_KHOPESH) {
                entity.method_5639(livingEntity.method_6051().method_43048(7) + 1);
            }
            if (entity instanceof class_1657) {
                player = (class_1657)entity;
                if (KQConfigValues.EVOKERSET && KQFullSetChecker.hasFullSetOn(player, KQArmorMaterials.EVOKERSET)) {
                    random = entity.method_37908().method_8409();
                    if (source.method_5529() instanceof class_1309 && (double)random.method_43057() < KQConfigValues.EVOKER_DARKNESS_CHANCE) {
                        entity.method_6092(new class_1293(class_1294.field_38092, 120, 0, false, false, true));
                    }
                }
                if (KQConfigValues.DRAGONSET && KQFullSetChecker.hasFullSetOn(player, KQArmorMaterials.DRAGONSET) && source.method_49708(class_8111.field_42351)) {
                    return false;
                }
                if (KQConfigValues.BAMBOOSET_GREEN && KQFullSetChecker.hasFullSetOn(player, KQArmorMaterials.BAMBOOSET_GREEN) && player.method_6059(class_1294.field_5899) && (source.method_49708(class_8111.field_42349) || source.method_49708(class_8111.field_42329))) {
                    player.method_6016(class_1294.field_5899);
                    return false;
                }
                if (KQConfigValues.SHINOBI && KQFullSetChecker.hasFullSetOn(player, KQArmorMaterials.SHINOBI) && source.method_5529() != null) {
                    player.method_6092(new class_1293(class_1294.field_5904, 120, 1, false, false, true));
                }
                if (KQConfigValues.BAMBOOSET && KQFullSetChecker.hasFullSetOn(player, KQArmorMaterials.BAMBOOSET) && source.method_49708(class_8111.field_42345)) {
                    class_3222 serverPlayer = (class_3222)player;
                    int particleCount = 80;
                    double particleRadius = 1.2;
                    for (int i = 0; i < particleCount; ++i) {
                        double angleOffset = Math.PI * 2 / (double)particleCount * (double)i;
                        double xParticleOffset = particleRadius * Math.cos(angleOffset);
                        double zParticleOffset = particleRadius * Math.sin(angleOffset);
                        serverPlayer.field_13987.method_14364((class_2596)new class_2675((class_2394)class_2398.field_17430, true, player.method_23317() + xParticleOffset, player.method_23318() + 0.1, player.method_23321() + zParticleOffset, 0.2f, 0.05f, 0.2f, 0.0f, 1));
                    }
                    Class classToPush = KQConfigValues.BAMBOOSET_PUSH_PLAYERS ? class_1297.class : class_1657.class;
                    player.method_37908().method_18467(classToPush, player.method_5829().method_1014(3.5)).forEach(entity1 -> {
                        class_243 direction = entity1.method_19538().method_1020(player.method_19538()).method_1029().method_1021((double)amount * 0.5);
                        entity1.method_5762(direction.field_1352, direction.field_1351 + 0.5, direction.field_1350);
                    });
                }
                if (KQConfigValues.ENDERMANSET && KQFullSetChecker.hasFullSetOn(player, KQArmorMaterials.ENDERMANSET) && source.method_5529() != null && (double)(random = entity.method_37908().method_8409()).method_43057() < KQConfigValues.CHANCE_ENDERMANSET) {
                    int radius = KQConfigValues.TELEPORT_RADIUS_ENDERMANSET;
                    class_2338 playerPos = player.method_24515();
                    ArrayList<class_2338> validPositions = new ArrayList<class_2338>();
                    for (int x = -radius; x <= radius; ++x) {
                        for (int y = -radius; y <= radius; ++y) {
                            for (int z = -radius; z <= radius; ++z) {
                                class_2338 targetPos = playerPos.method_10069(x, y, z);
                                if (!KQArmorItem.isTeleportPositionValid(player.method_37908(), targetPos)) continue;
                                validPositions.add(targetPos);
                            }
                        }
                    }
                    if (!validPositions.isEmpty()) {
                        class_2338 randomPos = (class_2338)validPositions.get(random.method_43048(validPositions.size()));
                        player.method_37908().method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_14879, class_3419.field_15248, 1.0f, 1.0f);
                        player.method_5859((double)randomPos.method_10263(), (double)randomPos.method_10264(), (double)randomPos.method_10260());
                        return false;
                    }
                }
                if (KQConfigValues.VETERANSET && KQFullSetChecker.hasFullSetOn(player, KQArmorMaterials.VETERANSET) && (double)player.method_6032() < (double)player.method_6063() * 0.5) {
                    player.method_6092(new class_1293(class_1294.field_5910, 200, 0, false, false, true));
                    player.method_6092(new class_1293(class_1294.field_5907, 200, 1, false, false, true));
                }
                if (KQConfigValues.FORZESET && KQFullSetChecker.hasFullSetOn(player, KQArmorMaterials.FORZESET)) {
                    random = entity.method_37908().method_8409();
                    if (source.method_5529() != null && (double)random.method_43057() < KQConfigValues.FORZESET_DEFLECT_CHANCE) {
                        isProcessingDamage.set(true);
                        try {
                            source.method_5529().method_5643(source, amount * (float)KQConfigValues.FORZESET_DEFLECT_DAMAGE);
                        }
                        finally {
                            isProcessingDamage.set(false);
                        }
                    }
                }
                if (KQConfigValues.POLAR && KQFullSetChecker.hasFullSetOn(player, KQArmorMaterials.POLAR) && source.method_5529() != null && source.method_49708(class_8111.field_42354)) {
                    return false;
                }
            }
            if ((random = source.method_5529()) instanceof class_1657) {
                class_1297 class_12973;
                player = (class_1657)random;
                if (KQConfigValues.SILVERSET && KQFullSetChecker.hasFullSetOn(player, KQArmorMaterials.SILVERSET) && player.method_37908().method_23886() && (double)(random = entity.method_37908().method_8409()).method_43057() < KQConfigValues.SILVERSET_BURN_CHANCE) {
                    entity.method_5639(random.method_39332(2, 8));
                }
                if (KQConfigValues.HOLLOWSET && KQFullSetChecker.hasFullSetOn(player, KQArmorMaterials.HOLLOWSET) && (class_12973 = source.method_5529()) instanceof class_1309) {
                    class_1309 livingEntity2 = (class_1309)class_12973;
                    isProcessingDamage.set(true);
                    try {
                        player.method_6025(Math.min((float)((double)amount * KQConfigValues.HOLLOWSET_HEALING_MULTIPLIER), livingEntity2.method_6032()));
                    }
                    finally {
                        isProcessingDamage.set(false);
                    }
                }
                if (KQConfigValues.WITHERSET && source.method_49708(class_8111.field_42321) && KQFullSetChecker.hasFullSetOn(player, KQArmorMaterials.WITHERSET) && (double)(random = entity.method_37908().method_8409()).method_43057() < KQConfigValues.WITHERSET_WITHER_CHANCE) {
                    entity.method_6092(new class_1293(class_1294.field_5920, 120, 0, false, false, false));
                }
            }
            return true;
        }
    }
}

