/*
 * Decompiled with CFR 0.152.
 */
package com.github.mim1q.minecells.entity.ai.goal;

import com.github.mim1q.minecells.entity.ai.goal.TimedActionGoal;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1352;
import net.minecraft.class_1588;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import org.joml.Math;

public class TimedDashGoal<E extends class_1588>
extends TimedActionGoal<E> {
    protected final TimedDashSettings settings;
    protected class_1297 target;
    protected class_243 direction;
    protected double targetDistance;
    protected double distanceTravelled;
    protected class_243 targetPos;
    private final List<Integer> attackedIds = new ArrayList<Integer>();
    private boolean hasLanded = false;

    public TimedDashGoal(E entity, TimedDashSettings settings, Predicate<E> predicate) {
        super(entity, settings, predicate);
        this.settings = settings;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
    }

    public TimedDashGoal(E entity, Consumer<TimedDashSettings> settingsConsumer, Predicate<E> predicate) {
        this(entity, TimedActionGoal.TimedActionSettings.edit(new TimedDashSettings(), settingsConsumer), predicate);
    }

    @Override
    public boolean method_6264() {
        this.target = ((class_1588)this.entity).method_5968();
        return this.target != null && super.method_6264() && (!this.settings.onGround || ((class_1588)this.entity).method_23318() >= this.target.method_23318());
    }

    @Override
    public void method_6269() {
        super.method_6269();
        this.distanceTravelled = 0.0;
        this.targetDistance = 0.0;
        this.targetPos = this.target.method_19538();
        this.attackedIds.clear();
        this.hasLanded = false;
    }

    @Override
    public boolean method_6266() {
        return super.method_6266() && this.target != null;
    }

    @Override
    protected void charge() {
        if (this.ticks() <= this.settings.alignTick) {
            this.targetPos = this.target.method_19538().method_1031(0.0, (double)this.target.method_17682() * 0.5, 0.0);
            class_243 diff = this.targetPos.method_1020(((class_1588)this.entity).method_19538()).method_18805(1.0, this.settings.onGround ? 0.0 : 1.0, 1.0);
            this.direction = diff.method_1029();
            this.targetDistance = Math.clamp((double)this.settings.minDistance, (double)this.settings.maxDistance, (double)(diff.method_1033() + this.settings.overshoot));
            if (this.settings.rotate) {
                this.lookAtTarget();
            }
        }
        if (this.settings.particle != null) {
            this.spawnParticles();
        }
    }

    protected void lookAtTarget() {
        ((class_1588)this.entity).method_5962().method_6239(this.target.method_23317(), this.target.method_23318(), this.target.method_23321(), (double)0.01f);
        ((class_1588)this.entity).method_5784(class_1313.field_6308, this.direction.method_1021((double)0.01f));
        ((class_1588)this.entity).method_5988().method_6226(this.target, 360.0f, 360.0f);
        ((class_1588)this.entity).method_5942().method_6340();
    }

    protected void spawnParticles() {
        super.charge();
        class_243 entityPos = ((class_1588)this.entity).method_19538().method_1031(0.0, (double)(((class_1588)this.entity).method_17682() * 0.75f), 0.0);
        class_243 diff = this.targetPos.method_1020(entityPos);
        class_243 norm = diff.method_1029();
        float i = 0.0f;
        while ((double)i < diff.method_1033()) {
            class_243 particlePos = entityPos.method_1019(norm.method_1021((double)i));
            class_1937 class_19372 = ((class_1588)this.entity).method_37908();
            if (class_19372 instanceof class_3218) {
                class_3218 serverWorld = (class_3218)class_19372;
                if (((class_1588)this.entity).method_6051().method_43057() < 0.1f) {
                    serverWorld.method_14199(this.settings.particle, particlePos.field_1352, particlePos.field_1351, particlePos.field_1350, 1, 0.1, 0.1, 0.1, 0.01);
                }
            }
            i += 0.1f;
        }
    }

    @Override
    protected void runAction() {
        if (this.settings.onGround) {
            double velY = java.lang.Math.max(this.settings.jumpHeight, this.targetDistance * this.settings.jumpHeight * 0.01);
            ((class_1588)this.entity).method_5762(0.0, velY, 0.0);
        }
    }

    @Override
    protected void release() {
        if (this.shouldSlowDown()) {
            if (this.settings.landSound != null && !this.hasLanded) {
                this.playSound(this.settings.landSound);
                this.settings.onLand.run();
                this.hasLanded = true;
            }
            ((class_1588)this.entity).method_18799(((class_1588)this.entity).method_18798().method_18805(0.8, 1.0, 0.8));
            return;
        }
        ((class_1588)this.entity).method_18799(((class_1588)this.entity).method_18798().method_18805(0.0, this.settings.onGround ? 1.0 : 0.0, 0.0).method_1019(this.direction.method_1021((double)this.settings.speed)));
        this.distanceTravelled += (double)this.settings.speed;
        List entitiesInRange = ((class_1588)this.entity).method_37908().method_8335((class_1297)this.entity, ((class_1588)this.entity).method_5829().method_1014(this.settings.margin));
        for (class_1297 e : entitiesInRange) {
            if (!(e instanceof class_1309) || e instanceof class_1588 || this.attackedIds.contains(e.method_5628())) continue;
            e.method_5643(((class_1588)this.entity).method_48923().method_48812(this.entity), this.settings.damage);
            this.attackedIds.add(e.method_5628());
        }
    }

    @Override
    public void method_6270() {
        super.method_6270();
        if (!this.hasLanded) {
            this.settings.onLand.run();
            this.playSound(this.settings.landSound);
        }
    }

    protected boolean shouldSlowDown() {
        return this.distanceTravelled > this.targetDistance;
    }

    public static class TimedDashSettings
    extends TimedActionGoal.TimedActionSettings {
        public float speed = 1.0f;
        public float damage = 10.0f;
        public boolean rotate = true;
        public double margin = 0.0;
        public boolean onGround = false;
        public double jumpHeight = 0.0;
        public int alignTick = 0;
        public double minDistance = 0.0;
        public double overshoot = 0.0;
        public double maxDistance = 128.0;
        public class_2394 particle = null;
        public class_3414 landSound = null;
        public Runnable onLand = () -> {};
    }
}

