/*
 * Decompiled with CFR 0.152.
 */
package com.github.mim1q.minecells.item;

import com.github.mim1q.minecells.block.portal.DoorwayPortalBlock;
import com.github.mim1q.minecells.block.portal.DoorwayPortalBlockEntity;
import com.github.mim1q.minecells.dimension.MineCellsDimension;
import com.github.mim1q.minecells.registry.MineCellsParticles;
import com.github.mim1q.minecells.registry.MineCellsSounds;
import com.github.mim1q.minecells.util.MathUtils;
import com.github.mim1q.minecells.util.TextUtils;
import com.github.mim1q.minecells.world.state.MineCellsData;
import java.util.List;
import net.minecraft.class_1269;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import org.jetbrains.annotations.Nullable;

public class DimensionalRuneItem
extends class_1792 {
    private static final String ONLY_USABLE_IN_OVERWORLD_KEY = "item.minecells.dimensional_rune.only_usable_in_overworld";
    private static final String NOT_VISITED_KEY = "item.minecells.dimensional_rune.not_visited";
    private static final String TOOLTIP_KEY = "item.minecells.dimensional_rune.tooltip";
    public final DoorwayPortalBlock portalBlock;

    public DimensionalRuneItem(class_1792.class_1793 settings, DoorwayPortalBlock portalBlock) {
        super(settings);
        this.portalBlock = portalBlock;
    }

    public class_1269 method_7884(class_1838 context) {
        class_1937 world = context.method_8045();
        if (context.method_8036() == null) {
            return class_1269.field_5811;
        }
        class_2680 state = world.method_8320(context.method_8037());
        if (!(state.method_26204() instanceof DoorwayPortalBlock)) {
            return class_1269.field_5811;
        }
        if (state.method_27852((class_2248)this.portalBlock)) {
            return class_1269.field_5811;
        }
        if (!world.method_27983().method_29177().method_12832().equals("overworld")) {
            context.method_8036().method_7353((class_2561)class_2561.method_43471((String)ONLY_USABLE_IN_OVERWORLD_KEY), true);
            return class_1269.field_5811;
        }
        if (world.field_9236) {
            return class_1269.field_5812;
        }
        class_2586 doorway = world.method_8321(context.method_8037());
        if (!(doorway instanceof DoorwayPortalBlockEntity)) {
            return class_1269.field_5811;
        }
        class_2338 posOverride = ((DoorwayPortalBlockEntity)doorway).getPosOverride();
        if (posOverride == null) {
            posOverride = new class_2338(MathUtils.getClosestMultiplePosition((class_2382)context.method_8037(), 1024));
        }
        MineCellsData.PlayerData playerData = MineCellsData.getPlayerData((class_3222)context.method_8036(), (class_3218)world, posOverride);
        if (this.portalBlock.type.dimension != MineCellsDimension.PRISONERS_QUARTERS && !playerData.hasVisitedDimension(this.portalBlock.type.dimension)) {
            context.method_8036().method_7353((class_2561)class_2561.method_43471((String)NOT_VISITED_KEY), true);
            return class_1269.field_5811;
        }
        class_243 pos = class_243.method_24953((class_2382)context.method_8037());
        ((class_3218)world).method_14199(MineCellsParticles.SPECKLE.get(this.portalBlock.type.color), pos.method_10216(), pos.method_10214(), pos.method_10215(), 50, 0.5, (double)0.1f, 0.5, (double)0.1f);
        ((class_3218)world).method_14199((class_2394)class_2398.field_11236, pos.method_10216(), pos.method_10214(), pos.method_10215(), 3, 0.5, (double)0.1f, 0.5, (double)0.1f);
        world.method_8501(context.method_8037(), (class_2680)this.portalBlock.method_9564().method_11657((class_2769)DoorwayPortalBlock.FACING, (Comparable)((class_2350)state.method_11654((class_2769)DoorwayPortalBlock.FACING))));
        class_2586 newDoorwayEntity = world.method_8321(context.method_8037());
        if (newDoorwayEntity instanceof DoorwayPortalBlockEntity) {
            DoorwayPortalBlockEntity newDoorway = (DoorwayPortalBlockEntity)newDoorwayEntity;
            newDoorway.setPosOverride(posOverride);
        }
        world.method_8396(null, context.method_8037(), MineCellsSounds.TELEPORT_RELEASE, class_3419.field_15245, 1.0f, 1.0f);
        context.method_8041().method_7934(1);
        return class_1269.field_33562;
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        super.method_7851(stack, world, tooltip, context);
        TextUtils.addDescription(tooltip, TOOLTIP_KEY, new Object[0]);
    }
}

