/*
 * Decompiled with CFR 0.152.
 */
package com.github.mim1q.minecells.item.weapon.melee;

import com.github.mim1q.minecells.item.weapon.interfaces.CrittingWeapon;
import com.github.mim1q.minecells.registry.MineCellsItems;
import com.github.mim1q.minecells.valuecalculators.ModValueCalculators;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import dev.mim1q.gimm1q.valuecalculators.ValueCalculator;
import dev.mim1q.gimm1q.valuecalculators.parameters.ValueCalculatorContext;
import dev.mim1q.gimm1q.valuecalculators.parameters.ValueCalculatorParameter;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1829;
import net.minecraft.class_5134;
import org.jetbrains.annotations.Nullable;

public class CustomMeleeWeapon
extends class_1829
implements CrittingWeapon {
    private static final Set<CustomMeleeWeapon> ALL_MELEE_WEAPONS = new HashSet<CustomMeleeWeapon>();
    private Multimap<class_1320, class_1322> attributeModifiers = ImmutableMultimap.of();
    private static final ValueCalculator GLOBAL_DAMAGE_MULTIPLIER = ModValueCalculators.of("melee/global", "global_damage_multiplier", 1.0);
    private static final ValueCalculator GLOBAL_SPEED_MULTIPLIER = ModValueCalculators.of("melee/global", "global_speed_multiplier", 1.0);
    private double damage = 0.0;
    private double speed = 0.0;
    private final ValueCalculator damageCalculator;
    private final ValueCalculator extraDamageCalculator;
    private final ValueCalculator critDamageCalculator;
    private final ValueCalculator speedCalculator;

    public CustomMeleeWeapon(String valueCalculatorName, class_1792.class_1793 settings) {
        super(MineCellsItems.CELL_INFUSED_STEEL_MATERIAL, 0, 0.0f, settings);
        ALL_MELEE_WEAPONS.add(this);
        this.damageCalculator = ModValueCalculators.of("melee/" + valueCalculatorName, "damage", 0.0);
        this.speedCalculator = ModValueCalculators.of("melee/" + valueCalculatorName, "speed", 0.0);
        this.extraDamageCalculator = ModValueCalculators.of("melee/" + valueCalculatorName, "extra_damage", 0.0);
        this.critDamageCalculator = ModValueCalculators.of("melee/" + valueCalculatorName, "crit_damage", 0.0);
    }

    public Multimap<class_1320, class_1322> method_7844(class_1304 slot) {
        return slot == class_1304.field_6173 ? this.attributeModifiers : super.method_7844(slot);
    }

    public float method_8020() {
        return (float)this.damage;
    }

    @Override
    public float getExtraDamage(class_1799 stack, @Nullable class_1309 target, class_1309 attacker) {
        return (float)this.extraDamageCalculator.calculate(ValueCalculatorContext.create().with(ValueCalculatorParameter.HOLDER, (Object)attacker).with(ValueCalculatorParameter.TARGET, (Object)target).with(ValueCalculatorParameter.HOLDER_STACK, (Object)stack));
    }

    @Override
    public boolean canCrit(class_1799 stack, @Nullable class_1309 target, class_1309 attacker) {
        return false;
    }

    @Override
    public float getAdditionalCritDamage(class_1799 stack, @Nullable class_1309 target, @Nullable class_1309 attacker) {
        return (float)this.critDamageCalculator.calculate(ValueCalculatorContext.create().with(ValueCalculatorParameter.HOLDER, (Object)attacker).with(ValueCalculatorParameter.TARGET, (Object)target).with(ValueCalculatorParameter.HOLDER_STACK, (Object)stack));
    }

    public static void updateAttributes() {
        ALL_MELEE_WEAPONS.forEach(it -> {
            it.damage = (it.damageCalculator.calculate() - 1.0) * GLOBAL_DAMAGE_MULTIPLIER.calculate();
            it.speed = (it.speedCalculator.calculate() - 4.0) * GLOBAL_SPEED_MULTIPLIER.calculate();
            it.attributeModifiers = ImmutableMultimap.builder().put((Object)class_5134.field_23721, (Object)new class_1322(field_8006, "Tool modifier", it.damage, class_1322.class_1323.field_6328)).put((Object)class_5134.field_23723, (Object)new class_1322(field_8001, "Tool modifier", it.speed, class_1322.class_1323.field_6328)).build();
        });
    }

    public static Set<class_1792> getAllMeleeWeapons() {
        return Set.copyOf(ALL_MELEE_WEAPONS);
    }
}

