/*
 * Decompiled with CFR 0.152.
 */
package com.github.mim1q.minecells.structure.grid;

import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_247;
import net.minecraft.class_2470;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2794;
import net.minecraft.class_2902;
import net.minecraft.class_2919;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3341;
import net.minecraft.class_3443;
import net.minecraft.class_3485;
import net.minecraft.class_3499;
import net.minecraft.class_3748;
import net.minecraft.class_3777;
import net.minecraft.class_3780;
import net.minecraft.class_3784;
import net.minecraft.class_3785;
import net.minecraft.class_3790;
import net.minecraft.class_5138;
import net.minecraft.class_5281;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_5468;
import net.minecraft.class_5539;
import net.minecraft.class_5819;
import net.minecraft.class_6626;
import net.minecraft.class_6880;
import net.minecraft.class_7138;
import net.minecraft.class_7924;
import org.apache.commons.lang3.mutable.MutableObject;
import org.slf4j.Logger;

public class MineCellsStructurePoolBasedGenerator {
    static final Logger LOGGER = LogUtils.getLogger();

    public static Optional<class_3195.class_7150> generate(class_3195.class_7149 context, class_6880<class_3785> structurePool, Optional<class_2960> id, int size, class_2338 pos, Optional<class_2902.class_2903> projectStartToHeightmap, class_2470 rotation) {
        class_2338 blockPos;
        class_5455 dynamicRegistryManager = context.comp_561();
        class_2794 chunkGenerator = context.comp_562();
        class_3485 structureTemplateManager = context.comp_565();
        class_5539 heightLimitView = context.comp_569();
        class_2919 random = context.comp_566();
        class_2378 registry = dynamicRegistryManager.method_30530(class_7924.field_41249);
        class_3785 structurePool2 = (class_3785)structurePool.comp_349();
        class_3784 structurePoolElement = structurePool2.method_16631((class_5819)random);
        if (structurePoolElement == class_3777.field_16663) {
            return Optional.empty();
        }
        if (id.isPresent()) {
            class_2960 identifier = id.get();
            Optional<class_2338> optional = MineCellsStructurePoolBasedGenerator.findStartingJigsawPos(structurePoolElement, identifier, pos, rotation, structureTemplateManager, (class_5819)random);
            if (optional.isEmpty()) {
                LOGGER.error("No starting jigsaw {} found in start pool {}", (Object)identifier, (Object)((class_5321)structurePool.method_40230().orElseThrow()).method_29177());
                return Optional.empty();
            }
            blockPos = optional.get();
        } else {
            blockPos = pos;
        }
        class_2338 vec3i = blockPos.method_10059((class_2382)pos);
        class_2338 blockPos2 = pos.method_10059((class_2382)vec3i);
        class_3790 poolStructurePiece = new class_3790(structureTemplateManager, structurePoolElement, blockPos2, structurePoolElement.method_19308(), rotation, structurePoolElement.method_16628(structureTemplateManager, blockPos2, rotation));
        class_3341 blockBox = poolStructurePiece.method_14935();
        int i = (blockBox.method_35418() + blockBox.method_35415()) / 2;
        int j = (blockBox.method_35420() + blockBox.method_35417()) / 2;
        int k = projectStartToHeightmap.map(type -> pos.method_10264() + chunkGenerator.method_20402(i, j, type, heightLimitView, context.comp_564())).orElseGet(() -> ((class_2338)blockPos2).method_10264());
        int l = blockBox.method_35416() + poolStructurePiece.method_16646();
        poolStructurePiece.method_14922(0, k - l, 0);
        int m = k + vec3i.method_10264();
        return Optional.of(new class_3195.class_7150(new class_2338(i, m, j), arg_0 -> MineCellsStructurePoolBasedGenerator.lambda$generate$1(poolStructurePiece, size, i, m, j, blockBox, context, chunkGenerator, structureTemplateManager, heightLimitView, (class_5819)random, registry, arg_0)));
    }

    private static Optional<class_2338> findStartingJigsawPos(class_3784 pool, class_2960 id, class_2338 pos, class_2470 rotation, class_3485 structureManager, class_5819 random) {
        List list = pool.method_16627(structureManager, pos, rotation, random);
        Optional<class_2338> optional = Optional.empty();
        for (class_3499.class_3501 structureBlockInfo : list) {
            class_2960 identifier = class_2960.method_12829((String)structureBlockInfo.comp_1343().method_10558("name"));
            if (!id.equals((Object)identifier)) continue;
            optional = Optional.of(structureBlockInfo.comp_1341());
            break;
        }
        return optional;
    }

    private static void generate(class_7138 noiseConfig, int maxSize, class_2794 chunkGenerator, class_3485 structureTemplateManager, class_5539 heightLimitView, class_5819 random, class_2378<class_3785> structurePoolRegistry, class_3790 firstPiece, List<class_3790> pieces, class_265 pieceShape) {
        StructurePoolGenerator structurePoolGenerator = new StructurePoolGenerator(structurePoolRegistry, maxSize, chunkGenerator, structureTemplateManager, pieces, random);
        structurePoolGenerator.structurePieces.addLast(new ShapedPoolStructurePiece(firstPiece, (MutableObject<class_265>)new MutableObject((Object)pieceShape), 0));
        while (!structurePoolGenerator.structurePieces.isEmpty()) {
            ShapedPoolStructurePiece shapedPoolStructurePiece = structurePoolGenerator.structurePieces.removeFirst();
            structurePoolGenerator.generatePiece(shapedPoolStructurePiece.piece, shapedPoolStructurePiece.pieceShape, shapedPoolStructurePiece.currentSize, heightLimitView, noiseConfig);
        }
    }

    public static void generate(class_5281 world, class_2794 chunkGenerator, class_5455 registryManager, class_3485 structureTemplateManager, class_5138 structureAccessor, class_7138 noiseConfig, class_5819 random, int seed, class_6880<class_3785> structurePool, int i, class_2338 pos, class_2470 rotation) {
        class_3195.class_7149 context = new class_3195.class_7149(registryManager, chunkGenerator, chunkGenerator.method_12098(), noiseConfig, structureTemplateManager, (long)seed, new class_1923(pos), (class_5539)world, registryEntry -> true);
        Optional<class_3195.class_7150> optional = MineCellsStructurePoolBasedGenerator.generate(context, structurePool, Optional.empty(), i, pos, Optional.empty(), rotation);
        if (optional.isPresent()) {
            class_6626 structurePiecesCollector = optional.get().method_44019();
            for (class_3443 structurePiece : structurePiecesCollector.method_38714().comp_132()) {
                if (!(structurePiece instanceof class_3790)) continue;
                class_3790 poolStructurePiece = (class_3790)structurePiece;
                poolStructurePiece.method_27236(world, structureAccessor, chunkGenerator, random, class_3341.method_14665(), pos, false);
            }
        }
    }

    private static /* synthetic */ void lambda$generate$1(class_3790 poolStructurePiece, int size, int i, int m, int j, class_3341 blockBox, class_3195.class_7149 context, class_2794 chunkGenerator, class_3485 structureTemplateManager, class_5539 heightLimitView, class_5819 random, class_2378 registry, class_6626 collector) {
        ArrayList list = Lists.newArrayList();
        list.add(poolStructurePiece);
        if (size > 0) {
            class_238 box = new class_238((double)(i - 128), (double)(m - 128), (double)(j - 128), (double)(i + 128 + 1), (double)(m + 128 + 1), (double)(j + 128 + 1));
            class_265 voxelShape = class_259.method_1072((class_265)class_259.method_1078((class_238)box), (class_265)class_259.method_1078((class_238)class_238.method_19316((class_3341)blockBox)), (class_247)class_247.field_16886);
            MineCellsStructurePoolBasedGenerator.generate(context.comp_564(), size, chunkGenerator, structureTemplateManager, heightLimitView, random, (class_2378<class_3785>)registry, poolStructurePiece, list, voxelShape);
            Objects.requireNonNull(collector);
            list.forEach(arg_0 -> ((class_6626)collector).method_35462(arg_0));
        }
    }

    static final class StructurePoolGenerator {
        private final class_2378<class_3785> registry;
        private final int maxSize;
        private final class_2794 chunkGenerator;
        private final class_3485 structureTemplateManager;
        private final List<? super class_3790> children;
        private final class_5819 random;
        final Deque<ShapedPoolStructurePiece> structurePieces = Queues.newArrayDeque();

        StructurePoolGenerator(class_2378<class_3785> registry, int maxSize, class_2794 chunkGenerator, class_3485 structureTemplateManager, List<? super class_3790> children, class_5819 random) {
            this.registry = registry;
            this.maxSize = maxSize;
            this.chunkGenerator = chunkGenerator;
            this.structureTemplateManager = structureTemplateManager;
            this.children = children;
            this.random = random;
        }

        void generatePiece(class_3790 piece, MutableObject<class_265> pieceShape, int minY, class_5539 world, class_7138 noiseConfig) {
            class_3784 structurePoolElement = piece.method_16644();
            class_2338 blockPos = piece.method_16648();
            class_2470 blockRotation = piece.method_16888();
            class_3785.class_3786 projection = structurePoolElement.method_16624();
            boolean bl = projection == class_3785.class_3786.field_16687;
            MutableObject<class_265> mutableObject = new MutableObject<class_265>();
            class_3341 blockBox = piece.method_14935();
            int i = blockBox.method_35416();
            block0: for (class_3499.class_3501 structureBlockInfo : structurePoolElement.method_16627(this.structureTemplateManager, blockPos, blockRotation, this.random)) {
                class_2350 direction = class_3748.method_26378((class_2680)structureBlockInfo.comp_1342());
                class_2338 blockPos2 = structureBlockInfo.comp_1341();
                class_2338 blockPos3 = blockPos2.method_10093(direction);
                int j = blockPos2.method_10264() - i;
                int k = -1;
                class_2960 identifier = new class_2960(structureBlockInfo.comp_1343().method_10558("pool"));
                Optional optional = this.registry.method_17966(identifier);
                if (optional.isPresent() && (((class_3785)optional.get()).method_16632() != 0 || Objects.equals(identifier, class_5468.field_26254.method_29177()))) {
                    class_6880 fallback = ((class_3785)optional.get()).method_46736();
                    if (((class_3785)fallback.comp_349()).method_16632() != 0 || Objects.equals(((class_5321)fallback.method_40230().get()).method_29177(), class_5468.field_26254.method_29177())) {
                        class_3784 structurePoolElement2;
                        MutableObject<class_265> mutableObject2;
                        boolean bl2 = blockBox.method_14662((class_2382)blockPos3);
                        if (bl2) {
                            mutableObject2 = mutableObject;
                            if (mutableObject.getValue() == null) {
                                mutableObject.setValue((Object)class_259.method_1078((class_238)class_238.method_19316((class_3341)blockBox)));
                            }
                        } else {
                            mutableObject2 = pieceShape;
                        }
                        ArrayList list = Lists.newArrayList();
                        if (minY != this.maxSize) {
                            list.addAll(((class_3785)optional.get()).method_16633(this.random));
                        }
                        list.addAll(((class_3785)fallback.comp_349()).method_16633(this.random));
                        Iterator iterator = list.iterator();
                        while (iterator.hasNext() && (structurePoolElement2 = (class_3784)iterator.next()) != class_3777.field_16663) {
                            for (class_2470 blockRotation2 : class_2470.method_16547((class_5819)this.random)) {
                                List list2 = structurePoolElement2.method_16627(this.structureTemplateManager, class_2338.field_10980, blockRotation2, this.random);
                                structurePoolElement2.method_16628(this.structureTemplateManager, class_2338.field_10980, blockRotation2);
                                for (class_3499.class_3501 structureBlockInfo2 : list2) {
                                    int t;
                                    int p;
                                    if (!class_3748.method_16546((class_3499.class_3501)structureBlockInfo, (class_3499.class_3501)structureBlockInfo2)) continue;
                                    class_2338 blockPos4 = structureBlockInfo2.comp_1341();
                                    class_2338 blockPos5 = blockPos3.method_10059((class_2382)blockPos4);
                                    class_3341 blockBox3 = structurePoolElement2.method_16628(this.structureTemplateManager, blockPos5, blockRotation2);
                                    int m = blockBox3.method_35416();
                                    class_3785.class_3786 projection2 = structurePoolElement2.method_16624();
                                    boolean bl3 = projection2 == class_3785.class_3786.field_16687;
                                    int n = blockPos4.method_10264();
                                    int o = j - n + class_3748.method_26378((class_2680)structureBlockInfo.comp_1342()).method_10164();
                                    if (bl && bl3) {
                                        p = i + o;
                                    } else {
                                        if (k == -1) {
                                            k = this.chunkGenerator.method_20402(blockPos2.method_10263(), blockPos2.method_10260(), class_2902.class_2903.field_13194, world, noiseConfig);
                                        }
                                        p = k - n;
                                    }
                                    int q = p - m;
                                    class_3341 blockBox4 = blockBox3.method_19311(0, q, 0);
                                    class_2338 blockPos6 = blockPos5.method_10069(0, q, 0);
                                    if (class_259.method_1074((class_265)((class_265)mutableObject2.getValue()), (class_265)class_259.method_1078((class_238)class_238.method_19316((class_3341)blockBox4).method_1011(0.25)), (class_247)class_247.field_16893)) continue;
                                    mutableObject2.setValue((Object)class_259.method_1082((class_265)((class_265)mutableObject2.getValue()), (class_265)class_259.method_1078((class_238)class_238.method_19316((class_3341)blockBox4)), (class_247)class_247.field_16886));
                                    int r = piece.method_16646();
                                    int s = bl3 ? r - o : structurePoolElement2.method_19308();
                                    class_3790 poolStructurePiece = new class_3790(this.structureTemplateManager, structurePoolElement2, blockPos6, s, blockRotation2, blockBox4);
                                    if (bl) {
                                        t = i + j;
                                    } else if (bl3) {
                                        t = p + n;
                                    } else {
                                        if (k == -1) {
                                            k = this.chunkGenerator.method_20402(blockPos2.method_10263(), blockPos2.method_10260(), class_2902.class_2903.field_13194, world, noiseConfig);
                                        }
                                        t = k + o / 2;
                                    }
                                    piece.method_16647(new class_3780(blockPos3.method_10263(), t - j + r, blockPos3.method_10260(), o, projection2));
                                    poolStructurePiece.method_16647(new class_3780(blockPos2.method_10263(), t - n + s, blockPos2.method_10260(), -o, projection));
                                    this.children.add((class_3790)poolStructurePiece);
                                    if (minY + 1 > this.maxSize) continue block0;
                                    this.structurePieces.addLast(new ShapedPoolStructurePiece(poolStructurePiece, mutableObject2, minY + 1));
                                    continue block0;
                                }
                            }
                        }
                        continue;
                    }
                    LOGGER.warn("Empty or non-existent fallback pool: {}", fallback.method_40230().get());
                    continue;
                }
                LOGGER.warn("Empty or non-existent pool: {}", (Object)identifier);
            }
        }
    }

    private record ShapedPoolStructurePiece(class_3790 piece, MutableObject<class_265> pieceShape, int currentSize) {
    }
}

