/*
 * Decompiled with CFR 0.152.
 */
package com.github.mim1q.minecells.structure.grid.generator;

import com.github.mim1q.minecells.structure.grid.GridPiecesGenerator;
import com.github.mim1q.minecells.util.MathUtils;
import java.util.List;
import net.minecraft.class_2382;
import net.minecraft.class_3195;

public abstract class MultipartGridGenerator
extends GridPiecesGenerator.RoomGridGenerator {
    private final int xPart;
    private final int zPart;

    public MultipartGridGenerator(int xPart, int zPart) {
        this.xPart = xPart;
        this.zPart = zPart;
    }

    @Override
    public List<GridPiecesGenerator.RoomData> generate(class_3195.class_7149 context) {
        long seed = (long)MathUtils.getClosestMultiplePosition((class_2382)context.comp_568().method_8323(), 1024).hashCode() + context.comp_567();
        context.comp_566().method_43052(seed);
        return super.generate(context);
    }

    @Override
    protected void addRoom(GridPiecesGenerator.RoomData data) {
        this.usedPositions.add(data.pos);
        int x = data.pos.method_10263() - 16 * this.xPart;
        int z = data.pos.method_10260() - 16 * this.zPart;
        int terrainSampleX = data.terrainSamplePos.method_10263() - 16 * this.xPart;
        int terrainSampleZ = data.terrainSamplePos.method_10260() - 16 * this.zPart;
        if (x < 0 || z < 0 || x >= 16 || z >= 16) {
            return;
        }
        GridPiecesGenerator.RoomData newData = GridPiecesGenerator.RoomData.create(x - 8, data.pos.method_10264(), z - 8, data.poolId).rotation(data.rotation).offset(data.offset);
        if (data.terrainFit) {
            newData.terrainFit();
            newData.terrainSamplePos = new class_2382(terrainSampleX - 8, data.terrainSamplePos.method_10264(), terrainSampleZ - 8);
        }
        this.rooms.add(newData);
    }
}

