/*
 * Decompiled with CFR 0.152.
 */
package fabric.net.mca.entity;

import com.google.common.base.Strings;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import fabric.net.mca.Config;
import fabric.net.mca.MCA;
import fabric.net.mca.entity.EntitiesMCA;
import fabric.net.mca.entity.Infectable;
import fabric.net.mca.entity.VillagerEntityMCA;
import fabric.net.mca.entity.ai.DialogueType;
import fabric.net.mca.entity.ai.Genetics;
import fabric.net.mca.entity.ai.Messenger;
import fabric.net.mca.entity.ai.Traits;
import fabric.net.mca.entity.ai.brain.VillagerBrain;
import fabric.net.mca.entity.ai.relationship.AgeState;
import fabric.net.mca.entity.ai.relationship.EntityRelationship;
import fabric.net.mca.entity.ai.relationship.Gender;
import fabric.net.mca.entity.ai.relationship.VillagerDimensions;
import fabric.net.mca.entity.interaction.EntityCommandHandler;
import fabric.net.mca.resources.ClothingList;
import fabric.net.mca.resources.HairList;
import fabric.net.mca.resources.Names;
import fabric.net.mca.server.world.data.FamilyTreeNode;
import fabric.net.mca.server.world.data.PlayerSaveData;
import fabric.net.mca.util.network.datasync.CDataManager;
import fabric.net.mca.util.network.datasync.CDataParameter;
import fabric.net.mca.util.network.datasync.CEnumParameter;
import fabric.net.mca.util.network.datasync.CParameter;
import fabric.net.mca.util.network.datasync.CTrackedEntity;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1472;
import net.minecraft.class_1657;
import net.minecraft.class_1767;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_3730;
import net.minecraft.class_3851;
import net.minecraft.class_5134;
import net.minecraft.class_5250;
import net.minecraft.class_5819;

public interface VillagerLike<E extends class_1297>
extends CTrackedEntity<E>,
class_3851,
Infectable,
Messenger {
    public static final CDataParameter<String> VILLAGER_NAME;
    public static final CDataParameter<String> CUSTOM_SKIN;
    public static final CDataParameter<String> CLOTHES;
    public static final CDataParameter<String> HAIR;
    public static final CDataParameter<Float> HAIR_COLOR_RED;
    public static final CDataParameter<Float> HAIR_COLOR_GREEN;
    public static final CDataParameter<Float> HAIR_COLOR_BLUE;
    public static final CEnumParameter<AgeState> AGE_STATE;
    public static final UUID SPEED_ID;

    public static <E extends class_1297> CDataManager.Builder<E> createTrackedData(Class<E> type) {
        return new CDataManager.Builder<E>(type).addAll(VILLAGER_NAME, CUSTOM_SKIN, CLOTHES, HAIR, HAIR_COLOR_RED, HAIR_COLOR_GREEN, HAIR_COLOR_BLUE, AGE_STATE).add(Genetics::createTrackedData).add(Traits::createTrackedData).add(VillagerBrain::createTrackedData);
    }

    public Genetics getGenetics();

    public Traits getTraits();

    public VillagerBrain<?> getVillagerBrain();

    public EntityCommandHandler<?> getInteractions();

    default public void initialize(class_3730 spawnReason) {
        if (spawnReason != class_3730.field_16468) {
            if (spawnReason != class_3730.field_16466) {
                this.getGenetics().randomize();
                this.getTraits().randomize();
            }
            this.initializeSkin(false);
            this.getVillagerBrain().randomize();
        }
        if (this.getGenetics().getGender() == Gender.UNASSIGNED) {
            this.getGenetics().setGender(Gender.getRandom());
        }
        if (Strings.isNullOrEmpty((String)((String)this.getTrackedValue(VILLAGER_NAME)))) {
            this.setName(Names.pickCitizenName(this.getGenetics().getGender(), (class_1297)this.asEntity()));
        }
        this.validateClothes();
        this.asEntity().method_18382();
    }

    @Override
    default public boolean isSpeechImpaired() {
        return this.getInfectionProgress() > 0.6f;
    }

    @Override
    default public boolean isToYoungToSpeak() {
        return this.getAgeState() == AgeState.BABY;
    }

    default public void setName(String name) {
        this.setTrackedValue(VILLAGER_NAME, name);
        if (!this.asEntity().method_37908().field_9236) {
            EntityRelationship.of((class_1297)this.asEntity()).ifPresent(relationship -> relationship.getFamilyEntry().setName(name));
        }
    }

    default public void setCustomSkin(String name) {
        this.setTrackedValue(CUSTOM_SKIN, name);
    }

    default public void updateCustomSkin() {
    }

    default public GameProfile getGameProfile() {
        return null;
    }

    default public boolean hasCustomSkin() {
        if (!MCA.isBlankString((String)this.getTrackedValue(CUSTOM_SKIN)) && this.getGameProfile() != null) {
            class_310 minecraftClient = class_310.method_1551();
            Map map = minecraftClient.method_1582().method_4654(this.getGameProfile());
            return map.containsKey(MinecraftProfileTexture.Type.SKIN);
        }
        return false;
    }

    default public Set<Gender> getAttractedGenderSet(VillagerLike<?> villager) {
        if (villager.getTraits().hasTrait(Traits.BISEXUAL)) {
            return Set.of(Gender.MALE, Gender.FEMALE, Gender.NEUTRAL);
        }
        if (villager.getTraits().hasTrait(Traits.HOMOSEXUAL)) {
            return Set.of(villager.getGenetics().getGender(), Gender.NEUTRAL);
        }
        if (villager.getTraits().hasTrait(Traits.ASEXUAL)) {
            return Set.of(Gender.NEUTRAL);
        }
        return Set.of(villager.getGenetics().getGender().opposite(), Gender.NEUTRAL);
    }

    default public boolean canBeAttractedTo(VillagerLike<?> other) {
        return this.getAttractedGenderSet(this).contains((Object)other.getGenetics().getGender()) && this.getAttractedGenderSet(other).contains((Object)this.getGenetics().getGender());
    }

    default public boolean canBeAttractedTo(PlayerSaveData other) {
        return !Config.getInstance().enableGenderCheckForPlayers || this.canBeAttractedTo(VillagerLike.toVillager(other));
    }

    default public class_1268 getDominantHand() {
        return this.getTraits().hasTrait(Traits.LEFT_HANDED) ? class_1268.field_5810 : class_1268.field_5808;
    }

    default public class_1268 getOpposingHand() {
        return this.getDominantHand() == class_1268.field_5810 ? class_1268.field_5808 : class_1268.field_5810;
    }

    default public class_1304 getSlotForHand(class_1268 hand) {
        return hand == class_1268.field_5810 ? class_1304.field_6171 : class_1304.field_6173;
    }

    default public class_1304 getDominantSlot() {
        return this.getSlotForHand(this.getDominantHand());
    }

    default public class_1304 getOpposingSlot() {
        return this.getSlotForHand(this.getOpposingHand());
    }

    default public class_2960 getProfessionId() {
        return MCA.locate("none");
    }

    default public String getProfessionName() {
        String professionName = (this.getProfessionId().method_12836().equalsIgnoreCase("minecraft") ? (this.getProfessionId().method_12832().equals("none") ? "mca.none" : this.getProfessionId().method_12832()) : this.getProfessionId().toString()).replace(":", ".");
        return MCA.isBlankString(professionName) ? "mca.none" : professionName;
    }

    default public class_5250 getProfessionText() {
        return class_2561.method_43471((String)("entity.minecraft.villager." + this.getProfessionName()));
    }

    default public boolean isProfessionImportant() {
        return false;
    }

    default public boolean requiresHome() {
        return false;
    }

    default public boolean canTradeWithProfession() {
        return false;
    }

    default public String getClothes() {
        return (String)this.getTrackedValue(CLOTHES);
    }

    default public void setClothes(class_2960 clothes) {
        this.setClothes(clothes.toString());
    }

    default public void setClothes(String clothes) {
        this.setTrackedValue(CLOTHES, clothes);
    }

    default public String getHair() {
        return (String)this.getTrackedValue(HAIR);
    }

    default public void setHair(class_2960 hair) {
        this.setHair(hair.toString());
    }

    default public void setHair(String hair) {
        this.setTrackedValue(HAIR, hair);
    }

    default public void setHairDye(class_1767 color) {
        float[] components = (float[])color.method_7787().clone();
        float[] dye = this.getHairDye();
        if (dye[0] > 0.0f) {
            components[0] = components[0] * 0.5f + dye[0] * 0.5f;
            components[1] = components[1] * 0.5f + dye[1] * 0.5f;
            components[2] = components[2] * 0.5f + dye[2] * 0.5f;
        }
        this.setTrackedValue(HAIR_COLOR_RED, Float.valueOf(components[0]));
        this.setTrackedValue(HAIR_COLOR_GREEN, Float.valueOf(components[1]));
        this.setTrackedValue(HAIR_COLOR_BLUE, Float.valueOf(components[2]));
    }

    default public void setHairDye(float r, float g, float b) {
        this.setTrackedValue(HAIR_COLOR_RED, Float.valueOf(r));
        this.setTrackedValue(HAIR_COLOR_GREEN, Float.valueOf(g));
        this.setTrackedValue(HAIR_COLOR_BLUE, Float.valueOf(b));
    }

    default public void clearHairDye() {
        this.setHairDye(0.0f, 0.0f, 0.0f);
    }

    default public float[] getHairDye() {
        return new float[]{((Float)this.getTrackedValue(HAIR_COLOR_RED)).floatValue(), ((Float)this.getTrackedValue(HAIR_COLOR_GREEN)).floatValue(), ((Float)this.getTrackedValue(HAIR_COLOR_BLUE)).floatValue()};
    }

    default public AgeState getAgeState() {
        return (AgeState)this.getTrackedValue(AGE_STATE);
    }

    default public VillagerDimensions getVillagerDimensions() {
        return this.getAgeState();
    }

    default public void updateSpeed() {
        float speed = this.getVillagerBrain().getPersonality().getSpeedModifier();
        speed /= 0.9f + this.getGenetics().getGene(Genetics.WIDTH) * 0.2f;
        speed *= 0.9f + this.getGenetics().getGene(Genetics.SIZE) * 0.2f;
        speed *= this.getAgeState().getSpeed();
        class_1324 entityAttributeInstance = this.asEntity().method_5996(class_5134.field_23719);
        if (entityAttributeInstance != null) {
            if (entityAttributeInstance.method_6199(SPEED_ID) != null) {
                entityAttributeInstance.method_6200(SPEED_ID);
            }
            class_1322 speedModifier = new class_1322(SPEED_ID, "Speed", (double)(speed - 1.0f), class_1322.class_1323.field_6330);
            entityAttributeInstance.method_26835(speedModifier);
        }
    }

    default public boolean setAgeState(AgeState state) {
        AgeState old = this.getAgeState();
        if (state == old) {
            return false;
        }
        this.setTrackedValue(AGE_STATE, state);
        this.asEntity().method_18382();
        this.updateSpeed();
        return old != AgeState.UNASSIGNED;
    }

    default public float getHorizontalScaleFactor() {
        if (this.getGenetics() == null || Config.getInstance().useSquidwardModels) {
            return this.asEntity().method_6109() ? 0.5f : 1.0f;
        }
        return Math.min(0.999f, this.getGenetics().getHorizontalScaleFactor() * this.getTraits().getHorizontalScaleFactor() * this.getVillagerDimensions().getWidth() * this.getGenetics().getGender().getHorizontalScaleFactor());
    }

    default public float getRawScaleFactor() {
        if (this.getGenetics() == null || Config.getInstance().useSquidwardModels) {
            return this.asEntity().method_6109() ? 0.5f : 1.0f;
        }
        return this.getGenetics().getVerticalScaleFactor() * this.getTraits().getVerticalScaleFactor() * this.getVillagerDimensions().getHeight() * this.getGenetics().getGender().getScaleFactor();
    }

    @Override
    default public DialogueType getDialogueType(class_1657 receiver) {
        if (!receiver.method_37908().field_9236) {
            Optional<EntityRelationship> r;
            DialogueType type = DialogueType.fromAge(this.getAgeState());
            if (!receiver.method_37908().field_9236 && (r = EntityRelationship.of((class_1297)this.asEntity())).isPresent()) {
                FamilyTreeNode relationship = r.get().getFamilyEntry();
                if (r.get().isMarriedTo(receiver.method_5667())) {
                    return DialogueType.SPOUSE;
                }
                if (r.get().isEngagedWith(receiver.method_5667())) {
                    return DialogueType.ENGAGED;
                }
                if (relationship.isParent(receiver.method_5667())) {
                    return type.toChild();
                }
            }
            this.getVillagerBrain().getMemoriesForPlayer(receiver).setDialogueType(type);
        }
        return this.getVillagerBrain().getMemoriesForPlayer(receiver).getDialogueType();
    }

    default public void initializeSkin(boolean isPlayer) {
        class_1308 entity;
        this.randomizeClothes();
        this.randomizeHair();
        if (!isPlayer && (entity = this.asEntity()).method_6051().method_43057() < Config.getInstance().coloredHairChance) {
            int n = entity.method_6051().method_43048(25);
            int o = class_1767.values().length;
            int p = n % o;
            int q = (n + 1) % o;
            float r = entity.method_6051().method_43057();
            float[] fs = class_1472.method_6634((class_1767)class_1767.method_7791((int)p));
            float[] gs = class_1472.method_6634((class_1767)class_1767.method_7791((int)q));
            this.setTrackedValue(HAIR_COLOR_RED, Float.valueOf(fs[0] * (1.0f - r) + gs[0] * r));
            this.setTrackedValue(HAIR_COLOR_GREEN, Float.valueOf(fs[1] * (1.0f - r) + gs[1] * r));
            this.setTrackedValue(HAIR_COLOR_BLUE, Float.valueOf(fs[2] * (1.0f - r) + gs[2] * r));
        }
    }

    default public void randomizeClothes() {
        this.setClothes(ClothingList.getInstance().getPool(this).pickOne());
    }

    default public void randomizeHair() {
        this.setHair(HairList.getInstance().getPool(this.getGenetics().getGender()).pickOne());
    }

    default public void validateClothes() {
        if (!this.asEntity().method_37908().method_8608()) {
            if (!this.getClothes().startsWith("immersive_library") && !ClothingList.getInstance().clothing.containsKey(this.getClothes())) {
                if (this.getClothes() != null) {
                    class_2960 identifier = new class_2960(this.getClothes());
                    String id = identifier.method_12836() + ":skins/clothing/normal/" + identifier.method_12832();
                    if (ClothingList.getInstance().clothing.containsKey(id)) {
                        this.setClothes(id);
                    } else {
                        MCA.LOGGER.info(String.format(Locale.ROOT, "Villagers clothing %s does not exist!", this.getClothes()));
                        this.randomizeClothes();
                    }
                } else {
                    MCA.LOGGER.info(String.format(Locale.ROOT, "Villagers clothing %s does not exist!", this.getClothes()));
                    this.randomizeClothes();
                }
            }
            if (!this.getHair().startsWith("immersive_library") && !HairList.getInstance().hair.containsKey(this.getHair())) {
                MCA.LOGGER.info(String.format(Locale.ROOT, "Villagers hair %s does not exist!", this.getHair()));
                this.randomizeHair();
            }
        }
    }

    default public class_2487 toNbtForConversion(class_1299<?> convertingTo) {
        class_2487 output = new class_2487();
        this.getTypeDataManager().save(this.asEntity(), output);
        return output;
    }

    default public void readNbtForConversion(class_1299<?> convertingFrom, class_2487 input) {
        this.getTypeDataManager().load(this.asEntity(), input);
    }

    default public void copyVillagerAttributesFrom(VillagerLike<?> other) {
        this.readNbtForConversion(other.asEntity().method_5864(), other.toNbtForConversion(this.asEntity().method_5864()));
    }

    public static VillagerLike<?> toVillager(PlayerSaveData player) {
        class_2487 villagerData = player.getEntityData();
        VillagerEntityMCA villager = (VillagerEntityMCA)((class_1299)EntitiesMCA.MALE_VILLAGER.get()).method_5883((class_1937)player.getWorld());
        if (!1.$assertionsDisabled && villager == null) {
            throw new AssertionError();
        }
        villager.method_5749(villagerData);
        return villager;
    }

    public static VillagerLike<?> toVillager(class_1297 entity) {
        if (entity instanceof VillagerLike) {
            return (VillagerLike)entity;
        }
        if (entity instanceof class_3222) {
            class_3222 playerEntity = (class_3222)entity;
            return VillagerLike.toVillager(PlayerSaveData.get(playerEntity));
        }
        return null;
    }

    default public boolean isHostile() {
        return false;
    }

    default public PlayerModel getPlayerModel() {
        return PlayerModel.VILLAGER;
    }

    public boolean isBurned();

    default public void spawnBurntParticles() {
        class_5819 random = this.asEntity().method_6051();
        if (random.method_43048(4) == 0) {
            double d = random.method_43059() * 0.02;
            double e = random.method_43059() * 0.02;
            double f = random.method_43059() * 0.02;
            this.asEntity().method_37908().method_8406((class_2394)class_2398.field_11251, this.asEntity().method_23322(1.0), this.asEntity().method_23319() + 1.0, this.asEntity().method_23325(1.0), d, e, f);
        }
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
        VILLAGER_NAME = CParameter.create("villagerName", "");
        CUSTOM_SKIN = CParameter.create("custom_skin", "");
        CLOTHES = CParameter.create("clothes", "");
        HAIR = CParameter.create("hair", "");
        HAIR_COLOR_RED = CParameter.create("hair_color_red", 0.0f);
        HAIR_COLOR_GREEN = CParameter.create("hair_color_green", 0.0f);
        HAIR_COLOR_BLUE = CParameter.create("hair_color_blue", 0.0f);
        AGE_STATE = CParameter.create("ageState", AgeState.UNASSIGNED);
        SPEED_ID = UUID.fromString("1eaf83ff-7207-5596-c37a-d7a07b3ec4ce");
    }

    public static enum PlayerModel {
        VILLAGER,
        PLAYER,
        VANILLA;

        static final PlayerModel[] VALUES;

        static {
            VALUES = PlayerModel.values();
        }
    }
}

