/*
 * Decompiled with CFR 0.152.
 */
package fabric.net.mca.server.world.data.villageComponents;

import fabric.net.mca.Config;
import fabric.net.mca.ProfessionsMCA;
import fabric.net.mca.entity.VillagerEntityMCA;
import fabric.net.mca.entity.ai.relationship.Gender;
import fabric.net.mca.server.world.data.Village;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import net.minecraft.class_1299;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_3730;
import net.minecraft.class_3852;
import net.minecraft.class_3989;

public class VillageInnManager {
    private final Village village;

    public VillageInnManager(Village village) {
        this.village = village;
    }

    public void updateInn(class_3218 world) {
        this.village.getBuildingsOfType("inn").forEach(b -> {
            block1: {
                class_2338 p;
                if (!(world.field_9229.method_43057() < Config.getInstance().adventurerAtInnChancePerMinute)) break block1;
                ArrayList values = new ArrayList(b.getBlocks().values().stream().flatMap(Collection::stream).toList());
                Collections.shuffle(values);
                Iterator iterator = values.iterator();
                while (iterator.hasNext() && !this.trySpawnAdventurer(world, (p = (class_2338)iterator.next()).method_10084())) {
                }
            }
        });
    }

    private boolean doesNotSuffocateAt(class_1922 world, class_2338 pos) {
        for (class_2338 blockPos : class_2338.method_10097((class_2338)pos, (class_2338)pos.method_10084())) {
            if (world.method_8320(blockPos).method_26220(world, blockPos).method_1110()) continue;
            return false;
        }
        return true;
    }

    private boolean trySpawnAdventurer(class_3218 world, class_2338 blockPos) {
        if (!world.method_37118(blockPos)) {
            return true;
        }
        String name = null;
        if (this.doesNotSuffocateAt((class_1922)world, blockPos)) {
            VillagerEntityMCA adventurer;
            int i = world.field_9229.method_43048(10);
            if (i == 0 && Config.getInstance().innSpawnsWanderingTraders) {
                class_3989 trader = (class_3989)class_1299.field_17713.method_47821(world, blockPos, class_3730.field_16467);
                if (trader != null) {
                    name = trader.method_5477().getString();
                    trader.method_18013(Config.getInstance().adventurerStayTime);
                }
            } else if (i == 1 && Config.getInstance().innSpawnsCultists) {
                VillagerEntityMCA adventurer2 = (VillagerEntityMCA)Gender.getRandom().getVillagerType().method_47821(world, blockPos, class_3730.field_16467);
                if (adventurer2 != null) {
                    name = adventurer2.method_5477().getString();
                    adventurer2.setProfession((class_3852)ProfessionsMCA.CULTIST.get());
                    adventurer2.setDespawnDelay(Config.getInstance().adventurerStayTime);
                }
            } else if (Config.getInstance().innSpawnsAdventurers && (adventurer = (VillagerEntityMCA)Gender.getRandom().getVillagerType().method_47821(world, blockPos, class_3730.field_16467)) != null) {
                name = adventurer.method_5477().getString();
                adventurer.setProfession((class_3852)ProfessionsMCA.ADVENTURER.get());
                adventurer.setDespawnDelay(Config.getInstance().adventurerStayTime);
            }
            if (name != null) {
                if (Config.getInstance().innArrivalNotification) {
                    this.village.broadCastMessage(world, "events.arrival.inn", name);
                }
                return true;
            }
        }
        return false;
    }
}

