/*
 * Decompiled with CFR 0.152.
 */
package quilt.net.mca.resources.data.dialogue;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.class_3222;
import quilt.net.mca.entity.VillagerEntityMCA;
import quilt.net.mca.entity.interaction.Constraint;
import quilt.net.mca.entity.interaction.InteractionPredicate;
import quilt.net.mca.resources.data.dialogue.Answer;

public class Question {
    private final String name;
    private final List<Answer> answers;
    private final boolean auto;
    private final boolean silent;
    private final Random random = new Random();

    public Question(String id, List<Answer> answers, boolean auto, boolean silent) {
        this.name = id;
        this.answers = answers;
        this.auto = auto;
        this.silent = silent;
    }

    public static Question fromJson(String id, JsonObject json) {
        boolean auto = json.has("auto") && json.get("auto").getAsBoolean();
        boolean silent = json.has("silent") && json.get("silent").getAsBoolean();
        LinkedList<Answer> answers = new LinkedList<Answer>();
        for (JsonElement e : json.getAsJsonArray("answers")) {
            answers.add(Answer.fromJson(e.getAsJsonObject()));
        }
        if (json.has("baseConditions")) {
            int r = 0;
            for (JsonElement conditions : json.getAsJsonArray("baseConditions")) {
                for (JsonElement e : conditions.getAsJsonArray()) {
                    InteractionPredicate predicate = InteractionPredicate.fromJson(e.getAsJsonObject());
                    int finalR = r;
                    answers.forEach(a -> a.getResults().get(finalR).getConditions().add(predicate));
                }
                ++r;
            }
        }
        return new Question(id, answers, auto, silent);
    }

    public String getName() {
        return this.name;
    }

    public List<Answer> getAnswers() {
        return this.answers;
    }

    public boolean isCloseScreen() {
        return this.answers == null;
    }

    public Answer getAnswer(String answer) {
        for (Answer a : this.answers) {
            if (!a.getName().equals(answer)) continue;
            return a;
        }
        return null;
    }

    public static String getTranslationKey(String question) {
        return "dialogue." + question;
    }

    public static String getTranslationKey(String question, String answer) {
        return "dialogue." + question + "." + answer;
    }

    public boolean isAuto() {
        return this.auto;
    }

    public List<String> getValidAnswers(class_3222 player, VillagerEntityMCA villager) {
        Set<Constraint> constraints = Constraint.allMatching(villager, player);
        LinkedList<String> ans = new LinkedList<String>();
        for (Answer a : this.answers) {
            if (!a.isValidForConstraint(constraints)) continue;
            ans.add(a.getName());
        }
        return ans;
    }

    public boolean isSilent() {
        return this.silent;
    }

    public void merge(Question question) {
        this.answers.addAll(question.getAnswers());
    }

    public Answer getRandomAnswer() {
        return this.answers.get(this.random.nextInt(this.answers.size()));
    }
}

