/*
 * Decompiled with CFR 0.152.
 */
package net.mobz.client.renderer.model;

import java.util.EnumSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.class_2350;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5601;
import net.minecraft.class_5603;
import net.minecraft.class_5606;
import net.minecraft.class_5607;
import net.minecraft.class_5609;
import net.minecraft.class_5610;
import net.minecraft.class_583;
import net.minecraft.class_630;
import net.minecraft.class_7833;
import net.mobz.MathUtils;
import net.mobz.entity.ToadEntity;

public class ToadEntityModel
extends class_583<ToadEntity> {
    private static final Set<class_2350> ALL_VISIBLE = EnumSet.allOf(class_2350.class);
    public static final Random random = new Random();
    private final float bodyScale;
    private final class_630 body;
    private final class_630 backlege;
    private final class_630 backlegw;
    private final class_630 eyeballw;
    private final class_630 eyeballe;
    private final class_630 lips;
    private final class_630 lipBottom;
    private final class_630 lipTop;
    private final class_630 frontlegw;
    private final class_630 frontlege;
    private float tongue_xRot;
    private float tongue_yRot;
    private float tongueDistance;
    private float targetTongueDistance;
    private float eyeHeight;
    public static final class_5601 modelResLoc = new class_5601(new class_2960("mobz", "toad_model"), "main");

    public static class_5607 createBodyLayer() {
        class_5609 meshdefinition = new class_5609();
        class_5610 root = meshdefinition.method_32111();
        class_5610 body = root.method_32117("body", class_5606.method_32108().method_32101(0, 0).method_32097(-4.0f, -8.0f, -2.0f, 8.0f, 8.0f, 8.0f).method_32101(10, 24).method_32097(1.0f, -10.0f, -1.0f, 2.0f, 2.0f, 3.0f).method_32101(0, 24).method_32097(-3.0f, -10.0f, -1.0f, 2.0f, 2.0f, 3.0f), class_5603.method_32090((float)0.0f, (float)24.0f, (float)-0.2727f));
        body.method_32117("backlege", class_5606.method_32108().method_32101(8, 16).method_32097(-2.0f, 2.0f, -4.0f, 2.0f, 1.0f, 2.0f).method_32101(12, 16).method_32097(-2.0f, -1.0f, -2.0f, 2.0f, 4.0f, 4.0f), class_5603.method_32090((float)-4.0f, (float)-3.0f, (float)5.0f));
        body.method_32117("backlegw", class_5606.method_32108().method_32101(0, 16).method_32097(0.0f, -1.0f, -2.0f, 2.0f, 4.0f, 4.0f).method_32101(24, 16).method_32097(0.0f, 2.0f, -4.0f, 2.0f, 1.0f, 2.0f), class_5603.method_32090((float)4.0f, (float)-3.0f, (float)5.0f));
        body.method_32117("eyeballw", class_5606.method_32108().method_32101(18, 28).method_32097(0.0f, 0.0f, -1.0f, 1.0f, 2.0f, 2.0f), class_5603.method_32090((float)2.5f, (float)-9.5f, (float)0.5f));
        body.method_32117("eyeballe", class_5606.method_32108().method_32101(24, 3).method_32097(-1.0f, 0.0f, -1.0f, 1.0f, 2.0f, 2.0f), class_5603.method_32090((float)-2.5f, (float)-9.5f, (float)0.5f));
        class_5610 lips = body.method_32117("lips", class_5606.method_32108(), class_5603.method_32090((float)0.0f, (float)-4.0f, (float)-2.0f));
        lips.method_32117("lip_bottom", class_5606.method_32108().method_32101(20, 18).method_32097(-3.0f, 1.0f, -1.0f, 6.0f, 1.0f, 1.0f), class_5603.method_32090((float)0.0f, (float)0.0f, (float)0.0f));
        lips.method_32117("lip_top", class_5606.method_32108().method_32101(20, 16).method_32097(-3.0f, 0.0f, -1.0f, 6.0f, 1.0f, 1.0f), class_5603.method_32090((float)0.0f, (float)0.0f, (float)0.0f));
        class_5610 frontlegw = body.method_32117("frontlegw", class_5606.method_32108(), class_5603.method_32090((float)4.0f, (float)-5.0f, (float)-1.0f));
        frontlegw.method_32117("cube_r1", class_5606.method_32108().method_32101(22, 22).method_32097(0.0f, 0.684f, -1.3794f, 2.0f, 6.0f, 2.0f), class_5603.method_32091((float)0.0f, (float)-1.0f, (float)1.0f, (float)-0.3491f, (float)0.0f, (float)0.0f));
        class_5610 frontlege = body.method_32117("frontlege", class_5606.method_32108(), class_5603.method_32090((float)-4.0f, (float)-5.0f, (float)-1.0f));
        frontlege.method_32117("cube_r2", class_5606.method_32108().method_32101(0, 0).method_32097(-2.0f, -6.0f, 0.0f, 2.0f, 6.0f, 2.0f), class_5603.method_32091((float)0.0f, (float)5.0f, (float)-2.0f, (float)-0.3491f, (float)0.0f, (float)0.0f));
        return class_5607.method_32110((class_5609)meshdefinition, (int)64, (int)64);
    }

    public ToadEntityModel(class_630 modelPart, float bodyScale) {
        this.bodyScale = bodyScale;
        this.body = modelPart.method_32086("body");
        this.backlege = this.body.method_32086("backlege");
        this.backlegw = this.body.method_32086("backlegw");
        this.eyeballw = this.body.method_32086("eyeballw");
        this.eyeballe = this.body.method_32086("eyeballe");
        this.lips = this.body.method_32086("lips");
        this.lipBottom = this.lips.method_32086("lip_bottom");
        this.lipTop = this.lips.method_32086("lip_top");
        this.frontlegw = this.body.method_32086("frontlegw");
        this.frontlege = this.body.method_32086("frontlege");
    }

    public void setupAnim(ToadEntity entity, float limbAngle, float limbDistance, float animationProgress, float headYaw, float headPitch) {
        float pi = (float)Math.PI;
        float legAmount = 1.4f;
        this.frontlege.field_3654 = class_3532.method_15362((float)(limbAngle * 1.0f + pi)) * 1.4f * limbDistance;
        this.backlege.field_3654 = class_3532.method_15362((float)(limbAngle * 1.0f)) * legAmount * limbDistance;
        this.frontlegw.field_3654 = class_3532.method_15362((float)(limbAngle * 1.0f)) * 1.4f * limbDistance;
        this.backlegw.field_3654 = class_3532.method_15362((float)(limbAngle * 1.0f + pi)) * legAmount * limbDistance;
        if (!entity.method_24828()) {
            this.backlegw.field_3654 = 2.0f;
            this.backlege.field_3654 = 2.0f;
        }
        entity.mouthDistance = entity.hasTongueEntity() ? MathUtils.approachValue(entity.mouthDistance, 1.0f, 0.5f) : MathUtils.approachValue(entity.mouthDistance, 0.0f, 0.1f);
        this.lipTop.field_3656 = -entity.mouthDistance;
        this.lipBottom.field_3656 = entity.mouthDistance;
        this.tongue_xRot = headPitch * 0.0175f;
        this.tongue_yRot = headYaw * 0.0175f;
        this.tongueDistance = entity.tongueDistance;
        this.targetTongueDistance = entity.targetTongueDistance;
        this.eyeHeight = entity.method_5751();
    }

    public void method_2828(class_4587 poseStack, class_4588 vertexConsumer, int packedLight, int overlay, float r, float g, float b, float alpha) {
        this.body.method_22699(poseStack, vertexConsumer, packedLight, overlay, r, g, b, alpha);
        if (this.tongueDistance <= 0.01f) {
            return;
        }
        poseStack.method_22903();
        this.body.method_22703(poseStack);
        this.renderTongue(poseStack, vertexConsumer, packedLight, overlay, r, g, b, alpha);
        poseStack.method_22909();
    }

    public void renderTongue(class_4587 matrices, class_4588 vertexConsumer, int light, int overlay, float red, float green, float blue, float alpha) {
        matrices.method_22903();
        float mouthHeightRelative = 0.1875f;
        float mouthHorizontalOffsetRelative = 0.125f;
        float tongueDistance = this.targetTongueDistance;
        float mouthHeight = mouthHeightRelative * this.bodyScale;
        float mouthHorizontalOffset = mouthHorizontalOffsetRelative * this.bodyScale;
        float mouthVerticalOffset = this.eyeHeight - mouthHeight;
        float mouthEyeDistanceSqr = mouthVerticalOffset * mouthVerticalOffset + mouthHorizontalOffset * mouthHorizontalOffset;
        float mouthEyeDistance = class_3532.method_15355((float)mouthEyeDistanceSqr);
        float angleMouthEye = (float)class_3532.method_15349((double)mouthHorizontalOffset, (double)mouthVerticalOffset);
        float cosEM_ET = class_3532.method_15374((float)(angleMouthEye + this.tongue_xRot));
        float lenSqr = mouthEyeDistanceSqr + tongueDistance * tongueDistance - 2.0f * mouthEyeDistance * tongueDistance * cosEM_ET;
        float len = class_3532.method_15355((float)lenSqr);
        float cosME_MT = (mouthEyeDistanceSqr + lenSqr - tongueDistance * tongueDistance) / (2.0f * mouthEyeDistance * len);
        float xRot = (float)(Math.acos(cosME_MT) - 1.5707963705062866 - (double)angleMouthEye);
        len *= this.tongueDistance / this.targetTongueDistance;
        matrices.method_46416(0.0f, -mouthHeightRelative, -mouthHorizontalOffsetRelative);
        if (xRot != 0.0f) {
            matrices.method_22907(class_7833.field_40714.rotation(xRot));
        }
        if (this.tongue_yRot != 0.0f) {
            matrices.method_22907(class_7833.field_40716.rotation(this.tongue_yRot));
        }
        matrices.method_22905(1.0f, 1.0f, len / this.bodyScale * 16.0f);
        class_630.class_628 cuboid = new class_630.class_628(16, 0, -1.0f, 0.0f, -1.0f, 2.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f, false, 64.0f, 64.0f, ALL_VISIBLE);
        cuboid.method_32089(matrices.method_23760(), vertexConsumer, light, overlay, 1.0f, 0.0f, 0.0f, 0.0f);
        matrices.method_22909();
    }
}

