/*
 * Decompiled with CFR 0.152.
 */
package net.mobz.data;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.class_1792;
import net.minecraft.class_1826;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2405;
import net.minecraft.class_2960;
import net.minecraft.class_4917;
import net.minecraft.class_4925;
import net.minecraft.class_4935;
import net.minecraft.class_4936;
import net.minecraft.class_4941;
import net.minecraft.class_4942;
import net.minecraft.class_4943;
import net.minecraft.class_4944;
import net.minecraft.class_4945;
import net.minecraft.class_4946;
import net.minecraft.class_7403;
import net.minecraft.class_7784;
import net.mobz.init.MobZArmors;
import net.mobz.init.MobZBlocks;
import net.mobz.init.MobZIcons;
import net.mobz.init.MobZItems;
import net.mobz.init.MobZWeapons;

public class ModelDataProvider
implements class_2405 {
    public static final class_4942 BOW_PULLING = new class_4942(Optional.of(class_2960.method_43902((String)"minecraft", (String)"item/bow")), Optional.empty(), new class_4945[]{class_4945.field_23006});
    private final class_7784.class_7489 blockStatePathProvider;
    private final class_7784.class_7489 modelPathProvider;
    private final class_2378<class_1792> itemRegistry;
    private final Predicate<class_2960> existenceChecker;

    public ModelDataProvider(class_7784 packOutput, class_2378<class_1792> itemRegistry, @Nullable Predicate<class_2960> existenceChecker) {
        this.blockStatePathProvider = packOutput.method_45973(class_7784.class_7490.field_39368, "blockstates");
        this.modelPathProvider = packOutput.method_45973(class_7784.class_7490.field_39368, "models");
        this.itemRegistry = itemRegistry;
        this.existenceChecker = existenceChecker == null ? resLoc -> true : existenceChecker;
    }

    public String method_10321() {
        return "Item models for mobz";
    }

    private void collect(Builder builder) {
        this.itemRegistry.method_10220().filter(item -> this.itemRegistry.method_10221(item).method_12836().equals("mobz")).filter(item -> item instanceof class_1826).forEach(item -> builder.spawnEgg((class_1826)item));
        for (String headName : MobZIcons.headNames) {
            builder.simpleItem(headName);
        }
        builder.simpleItem(MobZItems.AMAT_INGOT.get());
        builder.simpleItem(MobZItems.BEAR_LEATHER.get());
        builder.simpleItem(MobZItems.BOSS_INGOT.get());
        builder.simpleItem(MobZItems.FROZEN_POWDER.get());
        builder.simpleItem(MobZItems.HARDENEDMETAL_INGOT.get());
        builder.simpleItem(MobZItems.IMMUNITY_ORB.get());
        builder.simpleItem(MobZItems.LEVITATION_ORB.get());
        builder.simpleItem(MobZItems.ROTTEN_FLESH.get());
        for (int i = 1; i <= 4; ++i) {
            builder.simpleItem("sacrifice_knife_blood" + i);
            builder.simpleItem("sacrifice_knife_blood" + i + "dry1");
            builder.simpleItem("sacrifice_knife_blood" + i + "dry2");
        }
        builder.bowPulling("lilith_bow_pulling", 3);
        builder.simpleItem(MobZItems.SEAL_KEY.get());
        builder.simpleItem(MobZItems.SPAWN_EGG.get());
        builder.simpleItem(MobZItems.WHITE_BAG.get());
        builder.simpleItem(MobZItems.WITHER_POWDER.get());
        builder.simpleItem((class_1792)MobZItems.MEDIVEAL_DISC.get());
        builder.simpleItem((class_1792)MobZItems.MEDIVEAL_DISC_2.get());
        builder.handheldItem(MobZWeapons.ARMORED_SWORD.get());
        builder.handheldItem(MobZWeapons.BOSS_SWORD.get());
        builder.handheldItem(MobZWeapons.POISON_SWORD.get());
        builder.handheldItem(MobZWeapons.RAINBOW_SWORD.get());
        builder.handheldItem(MobZWeapons.STONE_TOMAHAWK.get());
        builder.simpleItem((class_1792)MobZArmors.AMAT_HELMET.get());
        builder.simpleItem((class_1792)MobZArmors.AMAT_CHESTPLATE.get());
        builder.simpleItem((class_1792)MobZArmors.AMAT_LEGGINGS.get());
        builder.simpleItem((class_1792)MobZArmors.AMAT_BOOTS.get());
        builder.simpleItem((class_1792)MobZArmors.BOSS_HELMET.get());
        builder.simpleItem((class_1792)MobZArmors.BOSS_CHESTPLATE.get());
        builder.simpleItem((class_1792)MobZArmors.BOSS_LEGGINGS.get());
        builder.simpleItem((class_1792)MobZArmors.BOSS_BOOTS.get());
        builder.simpleItem((class_1792)MobZArmors.LIFE_HELMET.get());
        builder.simpleItem((class_1792)MobZArmors.LIFE_CHESTPLATE.get());
        builder.simpleItem((class_1792)MobZArmors.LIFE_LEGGINGS.get());
        builder.simpleItem((class_1792)MobZArmors.LIFE_BOOTS.get());
        builder.simpleItem((class_1792)MobZArmors.SPEED_BOOTS.get());
        builder.simpleItem((class_1792)MobZArmors.SPEED2_BOOTS.get());
        builder.cubeAll(MobZBlocks.AMAT_BLOCK.get());
        builder.cubeAll(MobZBlocks.BOSS_BLOCK.get());
        builder.blockItem(MobZBlocks.BOSS_TROPHY.get());
        builder.blockItem(MobZBlocks.ENDER_HEADER.get());
        builder.cubeAll(MobZBlocks.HARDENED_METAL_BLOCK.get());
        builder.blockItem(MobZBlocks.TOTEM_BASE.get());
        builder.blockItem(MobZBlocks.TOTEM_MIDDLE.get());
        builder.blockItem(MobZBlocks.TOTEM_TOP.get());
    }

    public CompletableFuture<?> method_10319(class_7403 pOutput) {
        HashMap modelMap = Maps.newHashMap();
        BiConsumer<class_2960, Supplier<JsonElement>> outputConsumer = (resourceLocation, supplier) -> {
            Supplier supplier2 = modelMap.put(resourceLocation, supplier);
            if (supplier2 != null) {
                throw new IllegalStateException("Duplicate model definition for " + resourceLocation);
            }
        };
        HashMap blockStateMap = Maps.newHashMap();
        Consumer<class_4917> blockStateOutput = blockgen -> {
            class_2248 block = blockgen.method_25743();
            class_4917 blockstateGenerator = blockStateMap.put(block, blockgen);
            if (blockstateGenerator != null) {
                throw new IllegalStateException("Duplicate blockstate definition for " + block);
            }
        };
        Builder builder = new Builder(outputConsumer, blockStateOutput, this.existenceChecker);
        this.collect(builder);
        CompletableFuture[] completableFutureArray = new CompletableFuture[2];
        completableFutureArray[0] = this.saveCollection(pOutput, blockStateMap, block -> this.blockStatePathProvider.method_44107(block.method_40142().method_40237().method_29177()));
        completableFutureArray[1] = this.saveCollection(pOutput, modelMap, arg_0 -> ((class_7784.class_7489)this.modelPathProvider).method_44107(arg_0));
        return CompletableFuture.allOf(completableFutureArray);
    }

    private <T> CompletableFuture<?> saveCollection(class_7403 cachedOutput, Map<T, ? extends Supplier<JsonElement>> map, Function<T, Path> function) {
        return CompletableFuture.allOf((CompletableFuture[])map.entrySet().stream().map(entry -> {
            Path path = (Path)function.apply(entry.getKey());
            JsonElement jsonElement = (JsonElement)((Supplier)entry.getValue()).get();
            return class_2405.method_10320((class_7403)cachedOutput, (JsonElement)jsonElement, (Path)path);
        }).toArray(CompletableFuture[]::new));
    }

    public static class Builder {
        private final BiConsumer<class_2960, Supplier<JsonElement>> outputConsumer;
        private final Consumer<class_4917> blockStateOutput;
        private final Predicate<class_2960> existenceChecker;

        public Builder(BiConsumer<class_2960, Supplier<JsonElement>> outputConsumer, Consumer<class_4917> blockStateOutput, Predicate<class_2960> existenceChecker) {
            this.outputConsumer = outputConsumer;
            this.blockStateOutput = blockStateOutput;
            this.existenceChecker = existenceChecker;
        }

        public static class_2960 getRealTextureLoc(class_2960 resLoc) {
            return class_2960.method_43902((String)resLoc.method_12836(), (String)("textures/" + resLoc.method_12832() + ".png"));
        }

        public class_2960 getRealTextureLocWithCheck(class_2960 resLoc) {
            class_2960 realLoc = Builder.getRealTextureLoc(resLoc);
            if (!this.existenceChecker.test(realLoc)) {
                System.out.println("MobZ ItemModelDataProvider cannot find texture: " + realLoc);
            }
            return realLoc;
        }

        public void generateFlatItem(class_1792 item, class_4942 modelTemplate) {
            class_2960 textureResLoc = class_4941.method_25840((class_1792)item);
            this.getRealTextureLocWithCheck(textureResLoc);
            modelTemplate.method_25852(textureResLoc, class_4944.method_25871((class_1792)item), this.outputConsumer);
        }

        public void simpleItem(String string) {
            class_2960 textureResLoc = class_2960.method_43902((String)"mobz", (String)("item/" + string));
            this.getRealTextureLocWithCheck(textureResLoc);
            class_4944 textureMapping = class_4944.method_25895((class_2960)textureResLoc);
            class_4943.field_22938.method_25852(textureResLoc, textureMapping, this.outputConsumer);
        }

        public void bowPulling(String baseName, int count) {
            for (int i = 0; i < count; ++i) {
                class_2960 textureResLoc = class_2960.method_43902((String)"mobz", (String)("item/" + baseName + "_" + i));
                this.getRealTextureLocWithCheck(textureResLoc);
                BOW_PULLING.method_25852(textureResLoc, class_4944.method_25895((class_2960)textureResLoc), this.outputConsumer);
            }
        }

        public void simpleItem(class_1792 item) {
            this.generateFlatItem(item, class_4943.field_22938);
        }

        public void blockItem(class_2248 block) {
            class_2960 textureResLoc = class_4941.method_25840((class_1792)block.method_8389());
            class_4942 template = new class_4942(Optional.of(class_4941.method_25842((class_2248)block)), null, new class_4945[0]);
            template.method_25852(textureResLoc, new class_4944(), this.outputConsumer);
        }

        public void handheldItem(class_1792 item) {
            this.generateFlatItem(item, class_4943.field_22939);
        }

        public void spawnEgg(class_1826 egg) {
            JsonObject root = new JsonObject();
            root.addProperty("parent", "minecraft:item/template_spawn_egg");
            this.outputConsumer.accept(class_4941.method_25840((class_1792)egg), () -> root);
        }

        public void cubeAll(class_2248 block) {
            this.blockStateOutput.accept((class_4917)Builder.createSimpleBlock(block, class_4946.field_23036.method_25923(block, this.outputConsumer)));
            this.blockItem(block);
        }

        static class_4925 createSimpleBlock(class_2248 block, class_2960 resLoc) {
            return class_4925.method_25770((class_2248)block, (class_4935)class_4935.method_25824().method_25828(class_4936.field_22887, (Object)resLoc));
        }
    }
}

