/*
 * Decompiled with CFR 0.152.
 */
package net.mobz.entity;

import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1303;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1341;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1367;
import net.minecraft.class_1374;
import net.minecraft.class_1376;
import net.minecraft.class_1391;
import net.minecraft.class_1394;
import net.minecraft.class_1429;
import net.minecraft.class_1657;
import net.minecraft.class_174;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_4051;
import net.minecraft.class_4538;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5575;
import net.minecraft.class_6862;
import net.minecraft.class_7;
import net.mobz.MathUtils;
import net.mobz.MobZ;
import net.mobz.entity.TadpoleEntity;
import net.mobz.init.MobZEntities;
import net.mobz.init.MobZSounds;

public class ToadEntity
extends class_1429 {
    private static Set<class_1297> targetedEntities = new HashSet<class_1297>();
    private static final UUID JUMP_SPEED_BOOST = UUID.fromString("0fa7caca-4f09-11eb-ae93-0242ac130002");
    private static final class_1322 JUMP_SPEED_BOOST_MOD = new class_1322(JUMP_SPEED_BOOST, "Jump Speed Boost", (double)0.6f, class_1322.class_1323.field_6328);
    private static final class_2940<Integer> TONGUE_ENTITY = class_2945.method_12791(ToadEntity.class, (class_2941)class_2943.field_13327);
    private boolean onGroundPrev;
    private int ticksUntilJump;
    public float tongueDistance;
    public float targetTongueDistance;
    public float mouthDistance = 0.0f;
    public int eatCooldown = 0;
    public boolean hasBaby;
    private final class_4051 predicate = class_4051.method_36626().method_18420(e -> e.method_5739((class_1297)e) < 10.0f);

    public ToadEntity(class_1299<? extends ToadEntity> entityType, class_1937 world) {
        super(entityType, world);
        this.method_5941(class_7.field_18, 0.0f);
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(TONGUE_ENTITY, (Object)-1);
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new LookAtTongueTarget(this));
        this.field_6201.method_6277(0, (class_1352)new MakeTadpoleGoal(this, 1.0, 10));
        this.field_6201.method_6277(2, (class_1352)new class_1341((class_1429)this, 0.8));
        this.field_6201.method_6277(3, (class_1352)new class_1374((class_1314)this, 1.25));
        this.field_6201.method_6277(6, (class_1352)new class_1394((class_1314)this, 0.6));
        this.field_6201.method_6277(3, (class_1352)new class_1391((class_1314)this, 1.0, class_1856.method_8106(ToadEntity.getToadFoodTag()), false));
        this.field_6201.method_6277(11, (class_1352)new class_1361((class_1308)this, class_1657.class, 10.0f));
        this.field_6201.method_6277(12, (class_1352)new class_1376((class_1308)this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setTongueEntity(class_1309 e) {
        this.field_6011.method_12778(TONGUE_ENTITY, (Object)e.method_5628());
        if (this.method_37908().method_8608()) return;
        this.method_5783(MobZSounds.TOAD_MOUTH.get(), 1.0f, 1.0f + (float)this.field_5974.method_43059() / 5.0f);
        Class<ToadEntity> clazz = ToadEntity.class;
        synchronized (ToadEntity.class) {
            targetedEntities.add((class_1297)e);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public boolean hasTongueEntity() {
        return (Integer)this.field_6011.method_12789(TONGUE_ENTITY) != -1;
    }

    @Nullable
    public class_1297 getTongueEntity() {
        return this.method_37908().method_8469(((Integer)this.field_6011.method_12789(TONGUE_ENTITY)).intValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void clearTongueEntity() {
        class_1297 e;
        if (!this.method_37908().method_8608() && (e = this.getTongueEntity()) != null) {
            Class<ToadEntity> clazz = ToadEntity.class;
            // MONITORENTER : net.mobz.entity.ToadEntity.class
            targetedEntities.remove(e);
            // MONITOREXIT : clazz
        }
        this.field_6011.method_12778(TONGUE_ENTITY, (Object)-1);
    }

    public float method_6144(class_2338 pos, class_4538 world) {
        if (world.method_8320(pos).method_27852(class_2246.field_10588)) {
            return 100.0f;
        }
        return super.method_6144(pos, world);
    }

    private void dragVictim(class_1309 victim) {
        if (this.method_29504() || this.method_31481() || !this.method_6057((class_1297)victim) || victim.method_31481() || this.method_5739((class_1297)victim) > (float)(this.getSpotRange() * 2)) {
            this.clearTongueEntity();
            return;
        }
        if (this.isTongueReady()) {
            if (victim.method_5829().method_994(this.method_5829())) {
                this.attackVictim(victim);
            } else {
                double speed = this.getTongueSpeed2();
                double xx = MathUtils.approachValue(victim.method_19538().field_1352, this.method_23317(), speed);
                double yy = MathUtils.approachValue(victim.method_19538().field_1351, this.method_23318() + (double)0.2f, speed / 2.0);
                double zz = MathUtils.approachValue(victim.method_19538().field_1350, this.method_23321(), speed);
                victim.method_30634(xx, yy, zz);
                victim.method_18800(0.0, 0.0, 0.0);
            }
        }
    }

    public void method_5773() {
        super.method_5773();
        if (this.hasBaby && this.method_5618() == 0) {
            this.hasBaby = false;
        }
        if (this.hasTongueEntity()) {
            class_1297 e = this.getTongueEntity();
            if (e != null && !e.method_5765()) {
                class_243 victimCenter = e.method_5829().method_1005();
                this.method_5988().method_6230(victimCenter.field_1352, e.method_23318(), victimCenter.field_1350, 100.0f, 100.0f);
                this.field_6283 = this.getTargetYaw();
                this.field_6241 = this.getTargetYaw();
                this.method_36457(this.getTargetPitch());
                float speed = this.getTongueSpeed();
                this.targetTongueDistance = this.method_5739(e) - (float)(e.method_5829().field_1320 - e.method_5829().field_1323);
                this.targetTongueDistance = (float)this.method_33571().method_1022(victimCenter);
                if (this.tongueDistance > this.targetTongueDistance) {
                    speed *= 2.0f;
                }
                this.tongueDistance = MathUtils.approachValue(this.tongueDistance, this.targetTongueDistance, speed);
                if ((double)Math.abs(this.tongueDistance - this.targetTongueDistance) < 0.001) {
                    this.dragVictim((class_1309)e);
                }
            } else {
                this.targetTongueDistance = 0.0f;
                this.tongueDistance = MathUtils.approachValue(this.tongueDistance, 0.0f, 20.0f);
            }
        } else {
            this.targetTongueDistance = 0.0f;
            this.tongueDistance = MathUtils.approachValue(this.tongueDistance, 0.0f, 20.0f);
        }
    }

    public boolean isTongueReady() {
        float yaw = Math.abs((this.field_6283 + 1.0f) % 360.0f - this.getTargetYaw());
        boolean dis = Math.abs(this.tongueDistance - this.targetTongueDistance) < 5.0f;
        return dis && (yaw < 4.0f || yaw >= 360.0f);
    }

    public float getTargetYaw() {
        double xx = this.field_6206.method_6225() - this.method_23317();
        double zz = this.field_6206.method_6228() - this.method_23321();
        return (float)(class_3532.method_15349((double)zz, (double)xx) * 57.2957763671875) - 90.0f;
    }

    public float getTargetPitch() {
        double xx = this.field_6206.method_6225() - this.method_23317();
        double yy = this.field_6206.method_6227() - this.method_23320();
        double zz = this.field_6206.method_6228() - this.method_23321();
        double sqrt = Math.sqrt(xx * xx + zz * zz);
        return (float)(-(class_3532.method_15349((double)yy, (double)sqrt) * 57.2957763671875));
    }

    public boolean canUseTongue() {
        return !this.method_5765();
    }

    public boolean method_6481(class_1799 stack) {
        return stack.method_31573(ToadEntity.getToadFoodTag());
    }

    public void method_5958() {
        --this.eatCooldown;
        if (this.eatCooldown <= 0 && !this.hasTongueEntity()) {
            double spotRange = this.getSpotRange();
            List targets = this.method_37908().method_18023(class_5575.method_31795(class_1309.class), this.method_5829().method_1009(spotRange, spotRange, spotRange), this::isToadTarget);
            class_1309 closest = this.method_37908().method_18468(targets, this.predicate, (class_1309)this, this.method_23317(), this.method_23318(), this.method_23321());
            if (!this.canUseTongue() || closest == null || closest.method_5765() || targets.isEmpty()) {
                this.clearTongueEntity();
            } else {
                this.eatCooldown = 100;
                this.setTongueEntity(closest);
            }
        } else {
            class_1297 e = this.getTongueEntity();
            if (!this.canUseTongue() || e == null || !e.method_5805()) {
                this.clearTongueEntity();
            }
        }
        if (this.ticksUntilJump > 0) {
            --this.ticksUntilJump;
        }
        if (this.ticksUntilJump <= 0 && this.field_6207.method_6241()) {
            this.ticksUntilJump = this.field_5974.method_43048(80) + 20;
            this.method_6043();
            class_1324 entityAttributeInstance = this.method_5996(class_5134.field_23719);
            entityAttributeInstance.method_6200(JUMP_SPEED_BOOST);
            entityAttributeInstance.method_26835(JUMP_SPEED_BOOST_MOD);
            this.method_5783(this.getJumpSound(), this.method_6107(), ((this.field_5974.method_43057() - this.field_5974.method_43057()) * 0.2f + 1.0f) * 0.8f);
        }
        if (this.method_24828() && !this.onGroundPrev) {
            this.method_5996(class_5134.field_23719).method_6200(JUMP_SPEED_BOOST_MOD.method_6189());
        }
        this.onGroundPrev = this.method_24828();
    }

    protected class_3414 getJumpSound() {
        return MobZSounds.TOAD_JUMP.get();
    }

    public static class_5132.class_5133 createEntityAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, MobZ.configs.toad.life).method_26868(class_5134.field_23719, 0.25);
    }

    public void method_5652(class_2487 tag) {
        super.method_5652(tag);
        tag.method_10556("HasBaby", this.hasBaby);
    }

    public void method_5749(class_2487 tag) {
        super.method_5749(tag);
        this.hasBaby = tag.method_10577("HasBaby");
    }

    public void setHasBaby(boolean hasBaby) {
        this.hasBaby = hasBaby;
    }

    public void method_24650(class_3218 serverWorld, class_1429 other) {
        class_3222 player = this.method_6478();
        if (player == null && other.method_6478() != null) {
            player = other.method_6478();
        }
        if (player != null) {
            player.method_7281(class_3468.field_15410);
            class_174.field_1190.method_855(player, (class_1429)this, other, null);
        }
        this.setHasBaby(true);
        this.method_5614(6000);
        other.method_5614(6000);
        this.method_6477();
        other.method_6477();
        serverWorld.method_8421((class_1297)this, (byte)18);
        if (serverWorld.method_8450().method_8355(class_1928.field_19391)) {
            serverWorld.method_8649((class_1297)new class_1303((class_1937)serverWorld, this.method_23317(), this.method_23318(), this.method_23321(), this.method_6051().method_43048(7) + 1));
        }
    }

    public class_1296 method_5613(class_3218 world, class_1296 entity) {
        return null;
    }

    protected class_3414 method_5994() {
        return MobZSounds.TOAD_CROAK.get();
    }

    protected class_3414 method_6002() {
        return MobZSounds.TOAD_DEATH.get();
    }

    protected class_3414 method_6011(class_1282 source) {
        return MobZSounds.TOAD_HURT.get();
    }

    public float method_6017() {
        return super.method_6017() + (float)this.field_5974.method_43059() / 8.0f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isToadTarget(class_1297 entity) {
        if (!this.canToadTarget((class_1309)entity) || !this.method_6057(entity)) {
            return false;
        }
        Class<ToadEntity> clazz = ToadEntity.class;
        synchronized (ToadEntity.class) {
            double FOV;
            double diff;
            double dz;
            double dx;
            double dir;
            if (targetedEntities.contains(entity)) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return false;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            double headingAngle = this.method_5791() + 90.0f;
            if (headingAngle > 360.0) {
                headingAngle -= 360.0;
            }
            if (headingAngle < 0.0) {
                headingAngle += 360.0;
            }
            if ((dir = 90.0 - class_3532.method_15349((double)(dx = entity.method_23317() - this.method_23317()), (double)(dz = entity.method_23321() - this.method_23321())) / 3.1415927410125732 * 180.0) > 360.0) {
                dir -= 360.0;
            }
            if (dir < 0.0) {
                dir += 360.0;
            }
            return (diff = dir - headingAngle) < (FOV = 90.0) / 2.0 && diff > -FOV / 2.0;
        }
    }

    public static class_6862<class_1792> getToadFoodTag() {
        return MobZ.TOAD_FOOD_TAG;
    }

    public boolean canToadTarget(class_1309 entity) {
        return entity.method_5864().method_20210(MobZ.TOAD_TARGET_TAG);
    }

    public void attackVictim(class_1309 victim) {
        if (victim instanceof class_1657) {
            victim.method_5643(this.method_48923().method_48800((class_1297)this, null), 1.0f);
        } else {
            victim.method_5643(this.method_48923().method_48800((class_1297)this, null), Float.MAX_VALUE);
        }
    }

    public int getSpotRange() {
        return 5;
    }

    protected float getTongueSpeed() {
        return 0.8f;
    }

    protected float getTongueSpeed2() {
        return 0.4f;
    }

    private class LookAtTongueTarget
    extends class_1352 {
        private final ToadEntity toad;

        public LookAtTongueTarget(ToadEntity entity) {
            this.toad = entity;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
        }

        public boolean method_6264() {
            return this.toad.hasTongueEntity();
        }

        public boolean method_6266() {
            return this.toad.hasTongueEntity();
        }
    }

    public class MakeTadpoleGoal
    extends class_1367 {
        private final ToadEntity toad;

        public MakeTadpoleGoal(ToadEntity toad, double speed, int range) {
            super((class_1314)toad, speed, range, 5);
            this.toad = toad;
        }

        public boolean method_6264() {
            return this.toad.hasBaby && super.method_6264();
        }

        public boolean method_6266() {
            return super.method_6266() && this.toad.hasBaby;
        }

        public void method_6268() {
            super.method_6268();
            class_2338 blockPos = this.field_6516.method_24515();
            if (this.method_30953().method_19769((class_2374)this.toad.method_19538(), 2.0)) {
                ToadEntity.this.method_5942().method_6337((double)((float)blockPos.method_10263() + 0.5f), (double)blockPos.method_10264(), (double)((float)blockPos.method_10260() + 0.5f), 1.0);
            }
            if (this.toad.method_5799()) {
                class_3218 world = (class_3218)this.toad.method_37908();
                this.toad.setHasBaby(false);
                TadpoleEntity tadpole = (TadpoleEntity)MobZEntities.TADPOLE.get().method_5883((class_1937)world);
                if (tadpole != null) {
                    world.method_8396(null, blockPos, MobZSounds.TOAD_HAVE_BABY.get(), class_3419.field_15245, 0.3f, 0.9f + world.field_9229.method_43057() * 0.2f);
                    tadpole.method_7217(true);
                    tadpole.method_5808(this.toad.method_23317(), this.toad.method_23318(), this.toad.method_23321(), 0.0f, 0.0f);
                    world.method_30771((class_1297)tadpole);
                }
            }
        }

        public double method_6291() {
            return 0.0;
        }

        protected boolean method_6296(class_4538 world, class_2338 pos) {
            class_3610 state = world.method_8316(pos);
            return state.method_15771() && state.method_15767(class_3486.field_15517) && world.method_8320(pos.method_10084()).method_26215();
        }
    }
}

