/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.modelfix.moonlight_configs.fabric;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.mehvahdjukaar.modelfix.moonlight_configs.ConfigSpec;
import net.mehvahdjukaar.modelfix.moonlight_configs.ConfigType;
import net.mehvahdjukaar.modelfix.moonlight_configs.fabric.ConfigBuilderImpl;
import net.mehvahdjukaar.modelfix.moonlight_configs.fabric.ConfigSubCategory;
import net.mehvahdjukaar.modelfix.moonlight_configs.yacl.YACLCompat;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3244;
import net.minecraft.class_437;
import net.minecraft.server.MinecraftServer;

public class FabricConfigSpec
extends ConfigSpec {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final class_2960 res;
    private final ConfigSubCategory mainEntry;
    private final File file = this.getFullPath().toFile();
    private static final boolean YACL = FabricLoader.getInstance().isModLoaded("yet-another-config-lib");
    private static final boolean CLOTH_CONFIG = FabricLoader.getInstance().isModLoaded("cloth-config");

    public FabricConfigSpec(class_2960 name, ConfigSubCategory mainEntry, ConfigType type, boolean synced, Runnable changeCallback) {
        super(name, FabricLoader.getInstance().getConfigDir(), type, synced, changeCallback);
        this.mainEntry = mainEntry;
        this.res = name;
        if (this.isSynced()) {
            ServerPlayConnectionEvents.JOIN.register(this::onPlayerLoggedIn);
        }
    }

    public ConfigSubCategory getMainEntry() {
        return this.mainEntry;
    }

    @Override
    public void register() {
        FabricConfigSpec.addTrackedSpec(this);
    }

    @Override
    public void loadFromFile() {
        JsonElement config = null;
        if (this.file.exists() && this.file.isFile()) {
            try (FileInputStream fileInputStream = new FileInputStream(this.file);
                 InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, StandardCharsets.UTF_8);
                 BufferedReader bufferedReader = new BufferedReader(inputStreamReader);){
                config = (JsonElement)GSON.fromJson((Reader)bufferedReader, JsonElement.class);
            }
            catch (IOException e2) {
                throw new RuntimeException("Failed to load config", e2);
            }
        }
        if (config instanceof JsonObject) {
            JsonObject jo = (JsonObject)config;
            this.mainEntry.getEntries().forEach(e -> e.loadFromJson(jo));
        }
    }

    public void saveConfig() {
        try (FileOutputStream stream = new FileOutputStream(this.file);
             OutputStreamWriter writer = new OutputStreamWriter((OutputStream)stream, StandardCharsets.UTF_8);){
            JsonObject jo = new JsonObject();
            this.mainEntry.getEntries().forEach(e -> e.saveToJson(jo));
            GSON.toJson((JsonElement)jo, (Appendable)writer);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.onRefresh();
    }

    public class_2561 getName() {
        return class_2561.method_43470((String)ConfigBuilderImpl.getReadableName(this.res.method_12832() + "_configs"));
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public class_437 makeScreen(class_437 parent, class_2960 background) {
        if (CLOTH_CONFIG) {
            // empty if block
        }
        if (YACL) {
            return YACLCompat.makeScreen(parent, this, background);
        }
        return null;
    }

    @Override
    public boolean hasConfigScreen() {
        return CLOTH_CONFIG || YACL;
    }

    @Override
    public void loadFromBytes(InputStream stream) {
        InputStreamReader inputStreamReader = new InputStreamReader(stream, StandardCharsets.UTF_8);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        JsonElement config = (JsonElement)GSON.fromJson((Reader)bufferedReader, JsonElement.class);
        if (config instanceof JsonObject) {
            JsonObject jo = (JsonObject)config;
            this.mainEntry.getEntries().forEach(e -> e.loadFromJson(jo));
        }
        this.onRefresh();
    }

    private void onPlayerLoggedIn(class_3244 listener, PacketSender sender, MinecraftServer minecraftServer) {
        this.syncConfigsToPlayer(listener.field_14140);
    }
}

