/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.naturalist.common.entity;

import com.starfish_studios.naturalist.common.entity.core.NaturalistGeoEntity;
import com.starfish_studios.naturalist.common.entity.core.ai.goal.FlyingWanderGoal;
import com.starfish_studios.naturalist.common.entity.core.ai.navigation.SmartBodyHelper;
import com.starfish_studios.naturalist.core.registry.NaturalistSoundEvents;
import com.starfish_studios.naturalist.core.registry.NaturalistTags;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1310;
import net.minecraft.class_1314;
import net.minecraft.class_1330;
import net.minecraft.class_1331;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1366;
import net.minecraft.class_1376;
import net.minecraft.class_1400;
import net.minecraft.class_1407;
import net.minecraft.class_1408;
import net.minecraft.class_1432;
import net.minecraft.class_1542;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1890;
import net.minecraft.class_1928;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2392;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2902;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5819;
import net.minecraft.class_7;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class Vulture
extends class_1314
implements NaturalistGeoEntity,
class_1432 {
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final class_1856 FOOD_ITEMS = class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8511});
    private int ticksSinceEaten;
    protected static final RawAnimation FLY = RawAnimation.begin().thenLoop("animation.sf_nba.vulture.fly");

    public Vulture(class_1299<? extends class_1314> entityType, class_1937 level) {
        super(entityType, level);
        this.field_6207 = new class_1331((class_1308)this, 20, true);
        this.method_5952(true);
        this.method_5941(class_7.field_9, -1.0f);
        this.method_5941(class_7.field_18, -1.0f);
        this.method_5941(class_7.field_4, 16.0f);
        this.method_5941(class_7.field_21516, -1.0f);
        this.method_5941(class_7.field_10, -1.0f);
        this.method_5941(class_7.field_5, 0.0f);
        this.method_5941(class_7.field_17, 0.0f);
    }

    @NotNull
    protected class_1330 method_5963() {
        return new SmartBodyHelper((class_1308)this);
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 10.0).method_26868(class_5134.field_23720, (double)0.6f).method_26868(class_5134.field_23719, (double)0.3f).method_26868(class_5134.field_23721, 4.0);
    }

    protected void method_5959() {
        super.method_5959();
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new VultureAttackGoal(this, 1.2f, true));
        this.field_6201.method_6277(2, (class_1352)new VultureSearchForFoodGoal(this, 1.2f, FOOD_ITEMS, 12.0, 24.0));
        this.field_6201.method_6277(3, (class_1352)new HighAltitudeFlyingWanderGoal(this));
        this.field_6201.method_6277(4, (class_1352)new class_1361((class_1308)this, class_1657.class, 8.0f));
        this.field_6201.method_6277(5, (class_1352)new class_1376((class_1308)this));
        this.field_6185.method_6277(1, (class_1352)new class_1400((class_1308)this, class_1588.class, 10, false, false, entity -> entity.method_5864().method_20210(NaturalistTags.EntityTypes.VULTURE_HOSTILES) && !FOOD_ITEMS.method_8093(this.method_6047())));
        this.field_6185.method_6277(2, (class_1352)new class_1400((class_1308)this, class_1657.class, 10, false, false, entity -> entity.method_6032() <= 6.0f && !entity.method_6047().method_7960() && !FOOD_ITEMS.method_8093(this.method_6047())));
    }

    public static boolean checkVultureSpawnRules(class_1299<Vulture> entityType, class_1936 state, class_3730 type, @NotNull class_2338 pos, class_5819 random) {
        return state.method_8320(pos.method_10074()).method_26164(NaturalistTags.BlockTags.VULTURES_SPAWNABLE_ON) && state.method_22335(pos, 0) > 8;
    }

    protected void method_16080(@NotNull class_1282 damageSource) {
        super.method_16080(damageSource);
        if (!this.method_37908().method_8608()) {
            for (class_1304 slot : class_1304.values()) {
                class_1799 itemStack = this.method_6118(slot);
                if (itemStack.method_7960()) continue;
                this.method_5775(itemStack);
                this.method_5673(slot, class_1799.field_8037);
            }
        }
    }

    public boolean method_6581() {
        return !this.method_24828();
    }

    public boolean method_5747(float fallDistance, float multiplier, class_1282 source) {
        return false;
    }

    protected void method_5623(double y, boolean onGround, class_2680 state, class_2338 pos) {
    }

    public boolean method_6049(@NotNull class_1293 effectInstance) {
        if (effectInstance.method_5579() == class_1294.field_5903) {
            return false;
        }
        return super.method_6049(effectInstance);
    }

    protected void method_5712(class_2338 pos, class_2680 state) {
    }

    @Nullable
    protected class_3414 method_6011(class_1282 damageSource) {
        return NaturalistSoundEvents.VULTURE_HURT.get();
    }

    @Nullable
    protected class_3414 method_6002() {
        return NaturalistSoundEvents.VULTURE_DEATH.get();
    }

    @Nullable
    protected class_3414 method_5994() {
        return NaturalistSoundEvents.VULTURE_AMBIENT.get();
    }

    public boolean method_6101() {
        return false;
    }

    public boolean method_5679(class_1282 pSource) {
        return pSource.equals(this.method_48923().method_48826()) || super.method_5679(pSource);
    }

    public boolean method_6121(class_1297 target) {
        boolean shouldHurt;
        float damage = (float)this.method_26825(class_5134.field_23721);
        float knockback = (float)this.method_26825(class_5134.field_23722);
        if (target instanceof class_1309) {
            class_1309 livingEntity = (class_1309)target;
            damage += livingEntity.method_6046().equals(class_1310.field_6289) ? damage : 0.0f;
            knockback += (float)class_1890.method_8205((class_1309)this);
        }
        if (shouldHurt = target.method_5643(target.method_48923().method_48812((class_1309)this), damage)) {
            if (knockback > 0.0f && target instanceof class_1309) {
                ((class_1309)target).method_6005((double)(knockback * 0.5f), (double)class_3532.method_15374((float)(this.method_36454() * ((float)Math.PI / 180))), (double)(-class_3532.method_15362((float)(this.method_36454() * ((float)Math.PI / 180)))));
                this.method_18799(this.method_18798().method_18805(0.6, 1.0, 0.6));
            }
            this.method_5723((class_1309)this, target);
            this.method_6114(target);
        }
        return shouldHurt;
    }

    public void method_6007() {
        super.method_6007();
        this.method_37908().method_16107().method_15396("looting");
        if (!this.method_37908().field_9236 && this.method_5936() && this.method_5805() && !this.field_6272 && this.method_37908().method_8450().method_8355(class_1928.field_19388)) {
            for (class_1542 itementity : this.method_37908().method_18467(class_1542.class, this.method_5829().method_1009(1.0, 1.0, 1.0))) {
                if (itementity.method_31481() || itementity.method_6983().method_7960() || !this.method_20820(itementity.method_6983())) continue;
                this.method_5949(itementity);
            }
        }
        this.method_37908().method_16107().method_15407();
        if (!this.method_37908().field_9236 && this.method_5805() && this.method_6034()) {
            ++this.ticksSinceEaten;
            class_1799 stack = this.method_6118(class_1304.field_6173);
            if (stack.method_7909().method_19263()) {
                if (this.ticksSinceEaten > 600) {
                    class_1799 finishedStack = stack.method_7910(this.method_37908(), (class_1309)this);
                    if (!finishedStack.method_7960()) {
                        this.method_5673(class_1304.field_6173, finishedStack);
                    }
                    this.ticksSinceEaten = 0;
                } else if (this.ticksSinceEaten > 560 && this.field_5974.method_43057() < 0.1f) {
                    this.method_5783(this.method_18869(stack), 1.0f, 1.0f);
                    this.method_37908().method_8421((class_1297)this, (byte)45);
                }
            }
        }
    }

    public void method_5711(byte id) {
        class_1799 itemStack;
        super.method_5711(id);
        if (id == 45 && !(itemStack = this.method_6118(class_1304.field_6173)).method_7960()) {
            for (int i = 0; i < 8; ++i) {
                class_243 vec3 = new class_243(((double)this.field_5974.method_43057() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0).method_1037(-this.method_36455() * ((float)Math.PI / 180)).method_1024(-this.method_36454() * ((float)Math.PI / 180));
                this.method_37908().method_8406((class_2394)new class_2392(class_2398.field_11218, itemStack), this.method_23317() + this.method_5720().field_1352 / 2.0, this.method_23318(), this.method_23321() + this.method_5720().field_1350 / 2.0, vec3.field_1352, vec3.field_1351 + 0.05, vec3.field_1350);
            }
        }
    }

    public boolean method_18397(class_1799 pItemstack) {
        return !FOOD_ITEMS.method_8093(this.method_6047());
    }

    public boolean method_5939(class_1799 pStack) {
        return FOOD_ITEMS.method_8093(pStack) && !FOOD_ITEMS.method_8093(this.method_6047());
    }

    protected void method_5949(class_1542 pItemEntity) {
        class_1799 itemstack = pItemEntity.method_6983();
        if (this.method_5939(itemstack)) {
            if (!this.method_6047().method_7960() && !FOOD_ITEMS.method_8093(this.method_6047())) {
                this.dropItemStack(this.method_6047());
            }
            this.method_29499(pItemEntity);
            this.method_5673(class_1304.field_6173, itemstack);
            this.method_6103((class_1297)pItemEntity, itemstack.method_7947());
            pItemEntity.method_31472();
            this.ticksSinceEaten = 0;
        }
    }

    private void dropItemStack(class_1799 pStack) {
        class_1542 itementity = new class_1542(this.method_37908(), this.method_23317(), this.method_23318(), this.method_23321(), pStack);
        this.method_37908().method_8649((class_1297)itementity);
    }

    protected class_1408 method_5965(class_1937 pLevel) {
        VulturePathNavigation navigation = new VulturePathNavigation((class_1308)this, pLevel);
        navigation.method_6332(false);
        navigation.method_6354(true);
        navigation.method_6331(true);
        return navigation;
    }

    public boolean method_6109() {
        return false;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }

    private <E extends Vulture> PlayState predicate(AnimationState<E> event) {
        event.getController().setAnimation(FLY);
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 5, this::predicate)});
    }

    static class VultureAttackGoal
    extends class_1366 {
        public VultureAttackGoal(@NotNull class_1314 mob, double speedModifier, boolean followingTargetEvenIfNotSeen) {
            super(mob, speedModifier, followingTargetEvenIfNotSeen);
        }

        public boolean method_6264() {
            class_1657 player;
            class_1309 target = this.field_6503.method_5968();
            if (target instanceof class_1657 && ((player = (class_1657)target).method_6032() > 6.0f || player.method_6047().method_7960())) {
                return false;
            }
            return this.field_6503.method_6047().method_7960() && super.method_6264();
        }

        public boolean method_6266() {
            class_1657 player;
            class_1309 target = this.field_6503.method_5968();
            if (target instanceof class_1657 && ((player = (class_1657)target).method_6032() > 6.0f || player.method_6047().method_7960())) {
                return false;
            }
            return this.field_6503.method_6047().method_7960() && super.method_6266();
        }

        protected void method_6288(class_1309 enemy, double distToEnemySqr) {
            double reach = this.method_6289(enemy);
            if (distToEnemySqr <= reach && this.method_28348() <= 0) {
                this.method_28346();
                this.field_6503.method_6104(class_1268.field_5808);
                if (!(enemy instanceof class_1657)) {
                    this.field_6503.method_6121((class_1297)enemy);
                }
                if (enemy instanceof class_1657 && this.field_6503.method_6047().method_7960() && !enemy.method_6047().method_7960()) {
                    this.field_6503.method_5673(class_1304.field_6173, enemy.method_6047().method_7971(1));
                    class_1937 level = this.field_6503.method_37908();
                    level.method_43128(null, this.field_6503.method_23317(), this.field_6503.method_23318(), this.field_6503.method_23321(), class_3417.field_15197, class_3419.field_15254, 0.2f, ((level.field_9229.method_43057() - level.field_9229.method_43057()) * 0.7f + 1.0f) * 2.0f);
                    this.field_6503.method_5980(null);
                    this.field_6503.method_19540(false);
                }
            }
        }
    }

    static class VultureSearchForFoodGoal
    extends class_1352 {
        private final Vulture mob;
        private final double speedModifier;
        private final double horizontalSearchRange;
        private final double verticalSearchRange;
        private final class_1856 ingredient;

        public VultureSearchForFoodGoal(Vulture mob, double speedModifier, class_1856 ingredient, double horizontalSearchRange, double verticalSearchRange) {
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
            this.mob = mob;
            this.speedModifier = speedModifier;
            this.ingredient = ingredient;
            this.horizontalSearchRange = horizontalSearchRange;
            this.verticalSearchRange = verticalSearchRange;
        }

        public boolean method_6264() {
            if (!FOOD_ITEMS.method_8093(this.mob.method_6047())) {
                List list = this.mob.method_37908().method_8390(class_1542.class, this.mob.method_5829().method_1009(this.horizontalSearchRange, this.verticalSearchRange, this.horizontalSearchRange), itemEntity -> this.ingredient.method_8093(itemEntity.method_6983()));
                return !list.isEmpty() && !FOOD_ITEMS.method_8093(this.mob.method_6047());
            }
            return false;
        }

        public void method_6268() {
            List list = this.mob.method_37908().method_8390(class_1542.class, this.mob.method_5829().method_1009(this.horizontalSearchRange, this.verticalSearchRange, this.horizontalSearchRange), itemEntity -> this.ingredient.method_8093(itemEntity.method_6983()));
            if (!FOOD_ITEMS.method_8093(this.mob.method_6047()) && !list.isEmpty()) {
                this.mob.method_5942().method_6335((class_1297)list.get(0), this.speedModifier);
            }
        }

        public void method_6269() {
            List list = this.mob.method_37908().method_8390(class_1542.class, this.mob.method_5829().method_1009(this.horizontalSearchRange, this.verticalSearchRange, this.horizontalSearchRange), itemEntity -> this.ingredient.method_8093(itemEntity.method_6983()));
            if (!list.isEmpty()) {
                this.mob.method_5942().method_6335((class_1297)list.get(0), this.speedModifier);
            }
        }
    }

    static class HighAltitudeFlyingWanderGoal
    extends FlyingWanderGoal {
        private int preferredAltitude = -1;
        private static final int MIN_ALTITUDE_ABOVE_GROUND = 8;
        private static final int MAX_ALTITUDE_ABOVE_GROUND = 20;
        private static final int ALTITUDE_MARGIN_FROM_BUILD_LIMIT = 32;
        private int wanderAttemptsUntilAltitudeChange = 0;
        private static final int ALTITUDE_CHANGE_INTERVAL_MIN = 16;
        private static final int ALTITUDE_CHANGE_INTERVAL_RANGE = 16;

        public HighAltitudeFlyingWanderGoal(Vulture mob) {
            super(mob);
        }

        @Override
        public class_243 findPos() {
            class_243 lookVec = this.mob.method_5828(0.0f);
            if (this.preferredAltitude < 0 || this.wanderAttemptsUntilAltitudeChange <= 0) {
                class_2338 mobPos = this.mob.method_24515();
                class_1937 level = this.mob.method_37908();
                int groundY = level.method_8624(class_2902.class_2903.field_13202, mobPos.method_10263(), mobPos.method_10260());
                int maxY = level.method_31600();
                int minAltitude = groundY + 8;
                int maxAltitude = Math.min(groundY + 20, maxY - 32);
                this.preferredAltitude = class_3532.method_15395((class_5819)this.mob.method_6051(), (int)minAltitude, (int)maxAltitude);
                this.wanderAttemptsUntilAltitudeChange = 16 + this.mob.method_6051().method_43048(16);
            } else {
                --this.wanderAttemptsUntilAltitudeChange;
            }
            double offsetX = lookVec.field_1352 * 8.0 + (double)this.mob.method_6051().method_43048(5) - 2.0;
            double offsetZ = lookVec.field_1350 * 8.0 + (double)this.mob.method_6051().method_43048(5) - 2.0;
            return new class_243(this.mob.method_23317() + offsetX, (double)this.preferredAltitude, this.mob.method_23321() + offsetZ);
        }
    }

    static class VulturePathNavigation
    extends class_1407 {
        public VulturePathNavigation(@NotNull class_1308 mob, class_1937 level) {
            super(mob, level);
        }

        public boolean method_6333(@NotNull class_2338 pos) {
            return super.method_6333(pos) && this.field_6684.method_37908().method_8320(pos).method_26164(NaturalistTags.BlockTags.VULTURE_PERCH_BLOCKS);
        }
    }
}

