/*
 * Decompiled with CFR 0.152.
 */
package com.glisco.numismaticoverhaul.client.gui;

import com.glisco.numismaticoverhaul.ModComponents;
import com.glisco.numismaticoverhaul.NumismaticOverhaul;
import com.glisco.numismaticoverhaul.client.gui.CurrencyTooltipComponent;
import com.glisco.numismaticoverhaul.currency.Currency;
import com.glisco.numismaticoverhaul.currency.CurrencyComponent;
import com.glisco.numismaticoverhaul.currency.CurrencyResolver;
import com.glisco.numismaticoverhaul.item.CurrencyTooltipData;
import com.glisco.numismaticoverhaul.network.RequestPurseActionC2SPacket;
import io.wispforest.owo.ui.component.ButtonComponent;
import io.wispforest.owo.ui.component.LabelComponent;
import io.wispforest.owo.ui.container.StackLayout;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.layers.Layer;
import io.wispforest.owo.ui.parsing.UIModelLoader;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.LongSupplier;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import net.minecraft.class_5251;
import net.minecraft.class_5481;
import net.minecraft.class_5684;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.mutable.MutableObject;

public class PurseLayerElement<S extends class_437>
implements Consumer<Layer.Instance> {
    private final AlignmentFunction<S> alignmentFunction;

    public PurseLayerElement(AlignmentFunction<S> alignmentFunction) {
        this.alignmentFunction = alignmentFunction;
    }

    @Override
    public void accept(Layer.Instance instance) {
        StackLayout popup = (StackLayout)UIModelLoader.get((class_2960)NumismaticOverhaul.id("purse")).expandTemplate(StackLayout.class, "popup", Map.of());
        this.alignmentFunction.align(instance, (Component)popup);
        MutableObject total = new MutableObject();
        MutableInt goldCount = PurseLayerElement.configureSelector((LabelComponent)popup.childById(LabelComponent.class, "gold-count"), (ButtonComponent)popup.childById(ButtonComponent.class, "gold-increment"), (ButtonComponent)popup.childById(ButtonComponent.class, "gold-decrement"), Currency.GOLD, (MutableObject<LongSupplier>)total);
        MutableInt silverCount = PurseLayerElement.configureSelector((LabelComponent)popup.childById(LabelComponent.class, "silver-count"), (ButtonComponent)popup.childById(ButtonComponent.class, "silver-increment"), (ButtonComponent)popup.childById(ButtonComponent.class, "silver-decrement"), Currency.SILVER, (MutableObject<LongSupplier>)total);
        MutableInt bronzeCount = PurseLayerElement.configureSelector((LabelComponent)popup.childById(LabelComponent.class, "bronze-count"), (ButtonComponent)popup.childById(ButtonComponent.class, "bronze-increment"), (ButtonComponent)popup.childById(ButtonComponent.class, "bronze-decrement"), Currency.BRONZE, (MutableObject<LongSupplier>)total);
        total.setValue(() -> PurseLayerElement.value(bronzeCount, silverCount, goldCount));
        ((ButtonComponent)popup.childById(ButtonComponent.class, "extract-button")).onPress($ -> {
            long value = PurseLayerElement.value(bronzeCount, silverCount, goldCount);
            if (class_437.method_25442() && class_437.method_25441()) {
                NumismaticOverhaul.CHANNEL.clientHandle().send((Record)RequestPurseActionC2SPacket.extractAll());
            } else if (value > 0L) {
                NumismaticOverhaul.CHANNEL.clientHandle().send((Record)RequestPurseActionC2SPacket.extract(value));
                ((CurrencyComponent)ModComponents.CURRENCY.get((Object)class_310.method_1551().field_1724)).silentModify(-value);
                PurseLayerElement.adjust(((LongSupplier)total.getValue()).getAsLong(), bronzeCount, Currency.BRONZE, 0, (LabelComponent)popup.childById(LabelComponent.class, "bronze-count"));
                PurseLayerElement.adjust(((LongSupplier)total.getValue()).getAsLong(), silverCount, Currency.SILVER, 0, (LabelComponent)popup.childById(LabelComponent.class, "silver-count"));
                PurseLayerElement.adjust(((LongSupplier)total.getValue()).getAsLong(), goldCount, Currency.GOLD, 0, (LabelComponent)popup.childById(LabelComponent.class, "gold-count"));
            }
        });
        ButtonComponent button = (ButtonComponent)UIModelLoader.get((class_2960)NumismaticOverhaul.id("purse")).expandTemplate(ButtonComponent.class, "button", Map.of());
        ((StackLayout)instance.adapter.rootComponent).child((Component)button);
        this.alignmentFunction.align(instance, (Component)button);
        button.onPress(buttonComponent -> {
            if (class_437.method_25442()) {
                NumismaticOverhaul.CHANNEL.clientHandle().send((Record)RequestPurseActionC2SPacket.storeAll());
            } else if (popup.hasParent()) {
                popup.remove();
            } else {
                ((StackLayout)instance.adapter.rootComponent).child((Component)popup);
            }
        });
        ScreenEvents.afterRender((class_437)instance.screen).register((screen, drawContext, mouseX, mouseY, tickDelta) -> {
            CurrencyComponent comp = (CurrencyComponent)ModComponents.CURRENCY.get((Object)class_310.method_1551().field_1724);
            button.tooltip(List.of(class_5684.method_32662((class_5481)class_2561.method_43471((String)"gui.numismatic-overhaul.purse_title").method_10862(class_2583.field_24360.method_27703(class_5251.method_27717((int)Currency.GOLD.getNameColor()))).method_30937()), new CurrencyTooltipComponent(new CurrencyTooltipData(comp.getValue(), -1L))));
        });
    }

    private static MutableInt configureSelector(LabelComponent display, ButtonComponent incrementButton, ButtonComponent decrementButton, Currency currency, MutableObject<LongSupplier> totalSupplier) {
        MutableInt value = new MutableInt();
        incrementButton.onPress($ -> PurseLayerElement.adjust(((LongSupplier)totalSupplier.getValue()).getAsLong(), value, currency, class_437.method_25442() ? 10 : 1, display));
        decrementButton.onPress($ -> PurseLayerElement.adjust(((LongSupplier)totalSupplier.getValue()).getAsLong(), value, currency, class_437.method_25442() ? -10 : -1, display));
        return value;
    }

    private static void adjust(long selectedTotal, MutableInt value, Currency currency, int adjustBy, LabelComponent display) {
        long total = ((CurrencyComponent)ModComponents.CURRENCY.get((Object)class_310.method_1551().field_1724)).getValue();
        long stepSize = currency.getRawValue(1L);
        long by = Math.min((long)adjustBy, (total - selectedTotal) / stepSize);
        value.setValue((Number)Float.valueOf(class_3532.method_15363((float)((long)value.intValue() + by), (float)0.0f, (float)Math.min(total / stepSize, 99L))));
        display.text((class_2561)class_2561.method_43470((String)String.valueOf(value.getValue())));
    }

    private static long value(MutableInt bronze, MutableInt silver, MutableInt gold) {
        return CurrencyResolver.combineValues(new long[]{bronze.intValue(), silver.intValue(), gold.intValue()});
    }

    @FunctionalInterface
    public static interface AlignmentFunction<S extends class_437> {
        public void align(Layer.Instance var1, Component var2);
    }
}

