/*
 * Decompiled with CFR 0.152.
 */
package net.nutritionz.data;

import com.google.common.collect.LinkedHashMultimap;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_7923;
import net.nutritionz.NutritionMain;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NutritionLoader
implements SimpleSynchronousResourceReloadListener {
    public static final Logger LOGGER = LogManager.getLogger((String)"NutritionZ");
    private final List<String> nutritionList = List.of("carbohydrates", "protein", "fat", "vitamins", "minerals");
    private List<Boolean> effectReplaceList = List.of(Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false));
    private HashMap<class_1792, Boolean> replaceList = new HashMap();

    public class_2960 getFabricId() {
        return new class_2960("nutritionz", "loader");
    }

    public void method_14491(class_3300 manager) {
        manager.method_14488("nutrition", id -> id.method_12832().endsWith(".json")).forEach((id, resourceRef) -> {
            try {
                InputStream stream = resourceRef.method_14482();
                JsonObject data = JsonParser.parseReader((Reader)new InputStreamReader(stream)).getAsJsonObject();
                for (String itemId : data.keySet()) {
                    if (((class_1792)class_7923.field_41178.method_10223(new class_2960(itemId))).toString().equals("air")) {
                        LOGGER.info("{} is not a valid item identifier", (Object)itemId);
                        continue;
                    }
                    JsonObject jsonObject = data.get(itemId).getAsJsonObject();
                    class_1792 item = (class_1792)class_7923.field_41178.method_10223(new class_2960(itemId));
                    if (this.replaceList.containsKey(item)) continue;
                    if (jsonObject.has("replace") && jsonObject.get("replace").getAsBoolean()) {
                        this.replaceList.put(item, true);
                    }
                    ArrayList<Integer> nutritionList = new ArrayList<Integer>();
                    if (jsonObject.has("carbohydrates")) {
                        nutritionList.add(jsonObject.get("carbohydrates").getAsInt());
                    } else {
                        nutritionList.add(0);
                    }
                    if (jsonObject.has("protein")) {
                        nutritionList.add(jsonObject.get("protein").getAsInt());
                    } else {
                        nutritionList.add(0);
                    }
                    if (jsonObject.has("fat")) {
                        nutritionList.add(jsonObject.get("fat").getAsInt());
                    } else {
                        nutritionList.add(0);
                    }
                    if (jsonObject.has("vitamins")) {
                        nutritionList.add(jsonObject.get("vitamins").getAsInt());
                    } else {
                        nutritionList.add(0);
                    }
                    if (jsonObject.has("minerals")) {
                        nutritionList.add(jsonObject.get("minerals").getAsInt());
                    } else {
                        nutritionList.add(0);
                    }
                    NutritionMain.NUTRITION_ITEM_MAP.put(item, nutritionList);
                }
            }
            catch (Exception e) {
                LOGGER.error("Error occurred while loading resource {}. {}", (Object)id.toString(), (Object)e.toString());
            }
        });
        manager.method_14488("nutrition_manager", id -> id.method_12832().endsWith(".json")).forEach((id, resourceRef) -> {
            try {
                InputStream stream = resourceRef.method_14482();
                JsonObject data = JsonParser.parseReader((Reader)new InputStreamReader(stream)).getAsJsonObject();
                for (int i = 0; i < this.nutritionList.size(); ++i) {
                    if (!data.has(this.nutritionList.get(i))) continue;
                    JsonObject jsonObject = data.getAsJsonObject(this.nutritionList.get(i));
                    if (this.effectReplaceList.get(i).booleanValue()) continue;
                    if (class_3518.method_15258((JsonObject)jsonObject, (String)"replace", (boolean)false)) {
                        this.effectReplaceList.set(i, true);
                    }
                    if (jsonObject.has("positive")) {
                        JsonObject positiveJsonObject = jsonObject.getAsJsonObject("positive");
                        NutritionLoader.processEffects(positiveJsonObject, NutritionMain.NUTRITION_POSITIVE_EFFECTS, i);
                    }
                    if (!jsonObject.has("negative")) continue;
                    JsonObject negativeJsonObject = jsonObject.getAsJsonObject("negative");
                    NutritionLoader.processEffects(negativeJsonObject, NutritionMain.NUTRITION_NEGATIVE_EFFECTS, i);
                }
            }
            catch (Exception e) {
                LOGGER.error("Error occurred while loading resource {}. {}", (Object)id.toString(), (Object)e.toString());
            }
        });
    }

    private static void processEffects(JsonObject effectsJsonObject, HashMap<Integer, List<Object>> nutritionEffectsMap, int i) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (String effectId : effectsJsonObject.keySet()) {
            class_2960 effectIdentifier = new class_2960(effectId);
            if (!class_7923.field_41174.method_10250(effectIdentifier) && !class_7923.field_41190.method_10250(effectIdentifier)) {
                LOGGER.info("{} is not a valid status effect identifier nor attribute identifier", (Object)effectIdentifier);
                continue;
            }
            JsonObject effectJsonObject = effectsJsonObject.get(effectId).getAsJsonObject();
            if (class_7923.field_41174.method_10250(effectIdentifier)) {
                list.add(new class_1293((class_1291)class_7923.field_41174.method_10223(effectIdentifier), effectJsonObject.get("duration").getAsInt(), effectJsonObject.has("amplifier") ? effectJsonObject.get("amplifier").getAsInt() : 0, false, false, true));
                continue;
            }
            LinkedHashMultimap attributeModifiers = LinkedHashMultimap.create();
            attributeModifiers.put((Object)((class_1320)class_7923.field_41190.method_10223(effectIdentifier)), (Object)new class_1322(((class_1320)class_7923.field_41190.method_10223(effectIdentifier)).method_26830(), (double)effectJsonObject.get("value").getAsFloat(), class_1322.class_1323.valueOf((String)effectJsonObject.get("operation").getAsString().toUpperCase())));
            list.add(attributeModifiers);
        }
        nutritionEffectsMap.put(i, list);
    }
}

