/*
 * Decompiled with CFR 0.152.
 */
package net.nutritionz.mixin;

import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1293;
import net.minecraft.class_1657;
import net.minecraft.class_1702;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2596;
import net.minecraft.class_2781;
import net.minecraft.class_3222;
import net.nutritionz.NutritionMain;
import net.nutritionz.access.HungerManagerAccess;
import net.nutritionz.init.ConfigInit;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1702.class})
public class HungerManagerMixin
implements HungerManagerAccess {
    private int carbohydrateLevel;
    private int proteinLevel;
    private int fatLevel;
    private int vitaminLevel;
    private int mineralLevel;
    private Map<Integer, Boolean> effectMap;
    private boolean shouldUpdateNutritions;
    @Shadow
    private int field_7755;

    public HungerManagerMixin() {
        this.carbohydrateLevel = ConfigInit.CONFIG.maxNutrition / 2;
        this.proteinLevel = ConfigInit.CONFIG.maxNutrition / 2;
        this.fatLevel = ConfigInit.CONFIG.maxNutrition / 2;
        this.vitaminLevel = ConfigInit.CONFIG.maxNutrition / 2;
        this.mineralLevel = ConfigInit.CONFIG.maxNutrition / 2;
        this.effectMap = new HashMap<Integer, Boolean>(){
            {
                this.put(0, false);
                this.put(1, false);
                this.put(2, false);
                this.put(3, false);
                this.put(4, false);
            }
        };
        this.shouldUpdateNutritions = false;
    }

    @Inject(method={"eat"}, at={@At(value="TAIL")})
    private void eatMixin(class_1792 item, class_1799 stack, CallbackInfo info) {
        if (NutritionMain.NUTRITION_ITEM_MAP.containsKey(item)) {
            for (int i = 0; i < NutritionMain.NUTRITION_ITEM_MAP.get(item).size(); ++i) {
                if (NutritionMain.NUTRITION_ITEM_MAP.get(item).get(i) <= 0) continue;
                this.addNutritionLevel(i, NutritionMain.NUTRITION_ITEM_MAP.get(item).get(i));
            }
        }
    }

    @Inject(method={"update"}, at={@At(value="INVOKE_ASSIGN", target="Ljava/lang/Math;max(II)I", ordinal=0)})
    private void updateNutritionMixin(class_1657 player, CallbackInfo info) {
        this.decrementNutritionLevel(0, 1);
        this.decrementNutritionLevel(1, 1);
        this.decrementNutritionLevel(2, 1);
        this.decrementNutritionLevel(3, 1);
        this.decrementNutritionLevel(4, 1);
    }

    @Inject(method={"update"}, at={@At(value="HEAD")})
    private void updateMixin(class_1657 player, CallbackInfo info) {
        if (this.field_7755 % 5 == 0 && this.shouldUpdateNutritions) {
            this.shouldUpdateNutritions = false;
        }
    }

    @Inject(method={"update"}, at={@At(value="TAIL")})
    private void updateNutritionEffectsMixin(class_1657 player, CallbackInfo info) {
        if (!player.method_7337() && player.method_37908().method_8510() % 20L == 0L) {
            Collection collection;
            boolean changedAttributes = false;
            List<Integer> list = List.of(Integer.valueOf(this.carbohydrateLevel), Integer.valueOf(this.proteinLevel), Integer.valueOf(this.fatLevel), Integer.valueOf(this.vitaminLevel), Integer.valueOf(this.mineralLevel));
            for (int i = 0; i < list.size(); ++i) {
                Object multimap;
                Object object;
                List<Object> positiveEffectList;
                if (list.get(i) <= ConfigInit.CONFIG.negativeNutrition) {
                    List<Object> negativeEffectList = NutritionMain.NUTRITION_NEGATIVE_EFFECTS.get(i);
                    if (negativeEffectList == null || negativeEffectList.isEmpty()) continue;
                    for (int u = 0; u < negativeEffectList.size(); ++u) {
                        Object object2 = negativeEffectList.get(u);
                        if (object2 instanceof class_1293) {
                            class_1293 statusEffectInstance = (class_1293)object2;
                            if (player.method_6059(statusEffectInstance.method_5579()) && player.method_6112(statusEffectInstance.method_5579()).method_5584() >= statusEffectInstance.method_5584() - 50) continue;
                            player.method_6092(new class_1293(statusEffectInstance));
                            continue;
                        }
                        if (this.effectMap.get(i).booleanValue() || !(negativeEffectList.get(u) instanceof Multimap)) continue;
                        player.method_6127().method_26854((Multimap)negativeEffectList.get(u));
                        changedAttributes = true;
                    }
                    this.effectMap.put(i, true);
                    continue;
                }
                if (list.get(i) >= ConfigInit.CONFIG.positiveNutrition) {
                    positiveEffectList = NutritionMain.NUTRITION_POSITIVE_EFFECTS.get(i);
                    if (positiveEffectList == null || positiveEffectList.isEmpty()) continue;
                    for (int u = 0; u < positiveEffectList.size(); ++u) {
                        object = positiveEffectList.get(u);
                        if (object instanceof class_1293) {
                            class_1293 statusEffectInstance = (class_1293)object;
                            if (player.method_6059(statusEffectInstance.method_5579()) && player.method_6112(statusEffectInstance.method_5579()).method_5584() >= statusEffectInstance.method_5584() - 50) continue;
                            player.method_6092(new class_1293(statusEffectInstance));
                            continue;
                        }
                        if (this.effectMap.get(i).booleanValue() || !((object = positiveEffectList.get(u)) instanceof Multimap)) continue;
                        multimap = (Multimap)object;
                        player.method_6127().method_26854((Multimap)multimap);
                        changedAttributes = true;
                    }
                    this.effectMap.put(i, true);
                    continue;
                }
                if (!this.effectMap.get(i).booleanValue()) continue;
                this.effectMap.put(i, false);
                positiveEffectList = NutritionMain.NUTRITION_POSITIVE_EFFECTS.get(i);
                for (int u = 0; u < positiveEffectList.size(); ++u) {
                    multimap = positiveEffectList.get(u);
                    if (!(multimap instanceof Multimap)) continue;
                    Multimap multimap2 = (Multimap)multimap;
                    player.method_6127().method_26847(multimap2);
                    changedAttributes = true;
                }
                List<Object> negativeEffectList = NutritionMain.NUTRITION_NEGATIVE_EFFECTS.get(i);
                for (int u = 0; u < negativeEffectList.size(); ++u) {
                    object = negativeEffectList.get(u);
                    if (!(object instanceof Multimap)) continue;
                    multimap = (Multimap)object;
                    player.method_6127().method_26847((Multimap)multimap);
                    changedAttributes = true;
                }
            }
            if (changedAttributes && !(collection = player.method_6127().method_26851()).isEmpty()) {
                ((class_3222)player).field_13987.method_14364((class_2596)new class_2781(player.method_5628(), collection));
            }
        }
    }

    @Inject(method={"addExhaustion"}, at={@At(value="TAIL")})
    private void addExhaustionMixin(float exhaustion, CallbackInfo info) {
    }

    @Inject(method={"readNbt"}, at={@At(value="TAIL")})
    private void readNbtMixin(class_2487 nbt, CallbackInfo info) {
        this.carbohydrateLevel = nbt.method_10550("CarbohydrateLevel");
        this.proteinLevel = nbt.method_10550("ProteinLevel");
        this.fatLevel = nbt.method_10550("FatLevel");
        this.vitaminLevel = nbt.method_10550("VitaminLevel");
        this.mineralLevel = nbt.method_10550("MineralLevel");
    }

    @Inject(method={"writeNbt"}, at={@At(value="TAIL")})
    private void writeNbtMixin(class_2487 nbt, CallbackInfo info) {
        nbt.method_10569("CarbohydrateLevel", this.carbohydrateLevel);
        nbt.method_10569("ProteinLevel", this.proteinLevel);
        nbt.method_10548("FatLevel", (float)this.fatLevel);
        nbt.method_10548("VitaminLevel", (float)this.vitaminLevel);
        nbt.method_10548("MineralLevel", (float)this.mineralLevel);
    }

    @Override
    public void addNutritionLevel(int type, int level) {
        if (type == 0) {
            this.carbohydrateLevel = this.carbohydrateLevel + level > ConfigInit.CONFIG.maxNutrition ? ConfigInit.CONFIG.maxNutrition : this.carbohydrateLevel + level;
        } else if (type == 1) {
            this.proteinLevel = this.proteinLevel + level > ConfigInit.CONFIG.maxNutrition ? ConfigInit.CONFIG.maxNutrition : this.proteinLevel + level;
        } else if (type == 2) {
            this.fatLevel = this.fatLevel + level > ConfigInit.CONFIG.maxNutrition ? ConfigInit.CONFIG.maxNutrition : this.fatLevel + level;
        } else if (type == 3) {
            this.vitaminLevel = this.vitaminLevel + level > ConfigInit.CONFIG.maxNutrition ? ConfigInit.CONFIG.maxNutrition : this.vitaminLevel + level;
        } else if (type == 4) {
            this.mineralLevel = this.mineralLevel + level > ConfigInit.CONFIG.maxNutrition ? ConfigInit.CONFIG.maxNutrition : this.mineralLevel + level;
        }
        this.shouldUpdateNutritions = true;
    }

    @Override
    public void decrementNutritionLevel(int type, int level) {
        if (type == 0) {
            this.carbohydrateLevel = this.carbohydrateLevel - level < 0 ? 0 : this.carbohydrateLevel - level;
        } else if (type == 1) {
            this.proteinLevel = this.proteinLevel - level < 0 ? 0 : this.proteinLevel - level;
        } else if (type == 2) {
            this.fatLevel = this.fatLevel - level < 0 ? 0 : this.fatLevel - level;
        } else if (type == 3) {
            this.vitaminLevel = this.vitaminLevel - level < 0 ? 0 : this.vitaminLevel - level;
        } else if (type == 4) {
            this.mineralLevel = this.mineralLevel - level < 0 ? 0 : this.mineralLevel - level;
        }
        this.shouldUpdateNutritions = true;
    }

    @Override
    public void setNutritionLevel(int type, int level) {
        if (type == 0) {
            this.carbohydrateLevel = level;
        } else if (type == 1) {
            this.proteinLevel = level;
        } else if (type == 2) {
            this.fatLevel = level;
        } else if (type == 3) {
            this.vitaminLevel = level;
        } else if (type == 4) {
            this.mineralLevel = level;
        }
        this.shouldUpdateNutritions = true;
    }

    @Override
    public int getNutritionLevel(int type) {
        switch (type) {
            case 0: {
                return this.carbohydrateLevel;
            }
            case 1: {
                return this.proteinLevel;
            }
            case 2: {
                return this.fatLevel;
            }
            case 3: {
                return this.vitaminLevel;
            }
            case 4: {
                return this.mineralLevel;
            }
        }
        return 0;
    }
}

